/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.SqlObjectBuilderImpl;
import com.intellij.database.dialects.mssql.model.MsArgument;
import com.intellij.database.dialects.mssql.model.MsDefaultConstraint;
import com.intellij.database.dialects.mssql.model.MsExtendedPropertiesHolder;
import com.intellij.database.dialects.mssql.model.MsLikeIndex;
import com.intellij.database.dialects.mssql.model.MsRoutine;
import com.intellij.database.dialects.mssql.model.MsStoredColumn;
import com.intellij.database.dialects.mssql.model.MsTableColumn;
import com.intellij.database.dialects.mssql.model.MsTrigger;
import com.intellij.database.dialects.mssql.model.properties.MsRoutineType;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DataType;
import com.intellij.database.model.NameValueType;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicArgument;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicLikeColumn;
import com.intellij.database.model.basic.BasicModColumniation;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModIndex;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.basic.BasicModSourceAware;
import com.intellij.database.model.basic.BasicModView;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.BasicReference;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.types.DasTableType;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.mssql.MsElementTypes;
import com.intellij.sql.dialects.mssql.MsTypes;
import com.intellij.sql.psi.SqlCallStatement;
import com.intellij.sql.psi.SqlCodeFragmentImpl;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlConstraintDefinition;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlCreateTriggerStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIndexDefinition;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.sql.psi.stubs.elementStubs.SqlDefinitionStub;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0002J&\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010\u00162\b\u0010#\u001a\u0004\u0018\u00010\u001eH\u0002J4\u0010$\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00160%0\u001c2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\u0006\u0010&\u001a\u00020 H\u0002J0\u0010'\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0018\u00010%2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001c2\u0006\u0010&\u001a\u00020 H\u0002J\u000e\u0010(\u001a\u0004\u0018\u00010\u0016*\u00020\u0018H\u0002J\u0010\u0010)\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010*\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020+H\u0002J$\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u0010\"\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102H\u0016J \u00103\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u0002042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u00105\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020+2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u00106\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u0002072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u00108\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u0002092\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010:\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020;2\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010<\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020=2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010>\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020?2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010@\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020\u0012H\u0014J\u0012\u0010C\u001a\u0004\u0018\u00010A2\u0006\u0010B\u001a\u00020\u0012H\u0014\u00a8\u0006D"}, d2={"Lcom/intellij/database/dialects/mssql/MsObjectBuilder;", "Lcom/intellij/database/dialects/base/SqlObjectBuilderImpl;", "<init>", "()V", "build", "", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "source", "Lcom/intellij/database/model/DasObject;", "context", "Lcom/intellij/database/model/SqlObjectBuilder$Context;", "Lcom/intellij/sql/psi/SqlElement;", "buildCall", "callStatement", "Lcom/intellij/sql/psi/SqlCallStatement;", "buildExtendedProperty", "add", "", "asExternalProp", "Lcom/intellij/database/model/NameValueType;", "name", "", "valueExpr", "Lcom/intellij/sql/psi/SqlExpression;", "buildExtendedPropertyObjRef", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "arguments", "", "getRefType", "Lcom/intellij/sql/psi/SqlReferenceElementType;", "level", "", "createReference", "text", "elementType", "epNames", "Lkotlin/Pair;", "o", "epName", "stringValue", "finalize", "finalizeDefaultConstraint", "Lcom/intellij/database/dialects/mssql/model/MsDefaultConstraint;", "getCompactDefinition", "Lcom/intellij/openapi/util/TextRange;", "path", "Lcom/intellij/database/util/ObjectPath;", "Lcom/intellij/database/model/properties/CompositeText;", "def", "Lcom/intellij/database/model/PsiObject;", "buildMsLikeIndex", "Lcom/intellij/database/dialects/mssql/model/MsLikeIndex;", "buildMsDefault", "buildTableColumn", "Lcom/intellij/database/dialects/mssql/model/MsTableColumn;", "buildRoutine", "Lcom/intellij/database/dialects/mssql/model/MsRoutine;", "buildRoutineKind", "Lcom/intellij/database/model/basic/BasicModRoutine;", "buildTrigger", "Lcom/intellij/database/dialects/mssql/model/MsTrigger;", "buildViewSource", "Lcom/intellij/database/model/basic/BasicModView;", "seqMinimumDefault", "", "isAsc", "seqMaximumDefault", "intellij.database.dialects.mssql"})
@SourceDebugExtension(value={"SMAP\nMsObjectBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MsObjectBuilder.kt\ncom/intellij/database/dialects/mssql/MsObjectBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SqlObjectBuilderImpl.kt\ncom/intellij/database/dialects/base/SqlObjectBuilderImpl\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,265:1\n391#2,7:266\n1586#2:293\n1661#2,3:294\n1#3:273\n624#4,5:274\n613#4,7:279\n643#4:286\n659#4,6:287\n620#4,3:297\n614#4:300\n624#4,5:301\n624#4,5:306\n613#4,7:312\n643#4:319\n659#4,6:320\n620#4,3:326\n614#4:329\n18#5:311\n18#5:330\n18#5:331\n*S KotlinDebug\n*F\n+ 1 MsObjectBuilder.kt\ncom/intellij/database/dialects/mssql/MsObjectBuilder\n*L\n89#1:266,7\n174#1:293\n174#1:294,3\n163#1:274,5\n168#1:279,7\n174#1:286\n174#1:287,6\n168#1:297,3\n168#1:300\n192#1:301,5\n205#1:306,5\n213#1:312,7\n216#1:319\n216#1:320,6\n213#1:326,3\n213#1:329\n213#1:311\n235#1:330\n245#1:331\n*E\n"})
public final class MsObjectBuilder
extends SqlObjectBuilderImpl {
    public void build(@NotNull BasicModElement obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicModElement basicModElement = obj;
        if (basicModElement instanceof MsTrigger) {
            this.buildTrigger((MsTrigger)obj, source, context);
        } else if (basicModElement instanceof MsRoutine) {
            this.buildRoutine((MsRoutine)obj, source, context);
        } else if (basicModElement instanceof MsTableColumn) {
            this.buildTableColumn((MsTableColumn)obj, source, context);
        } else if (basicModElement instanceof MsLikeIndex) {
            this.buildMsLikeIndex((MsLikeIndex)obj, source, context);
        } else if (basicModElement instanceof MsDefaultConstraint) {
            this.buildMsDefault((MsDefaultConstraint)obj, source, context);
        } else {
            super.build(obj, source, context);
        }
    }

    public void build(@NotNull SqlElement source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (source instanceof SqlCallStatement) {
            this.buildCall((SqlCallStatement)source, context);
        }
        super.build(source, context);
    }

    private final void buildCall(SqlCallStatement callStatement, SqlObjectBuilder.Context context) {
        Object object = callStatement.getCallableReference();
        if (object == null || (object = object.getName()) == null) {
            return;
        }
        Object name2 = object;
        if (StringsKt.equals((String)name2, (String)"sp_addextendedproperty", (boolean)true) || StringsKt.equals((String)name2, (String)"sp_updateextendedproperty", (boolean)true)) {
            this.buildExtendedProperty(callStatement, context, true);
        } else if (StringsKt.equals((String)name2, (String)"sp_dropextendedproperty", (boolean)true)) {
            this.buildExtendedProperty(callStatement, context, false);
        }
    }

    private final void buildExtendedProperty(SqlCallStatement callStatement, SqlObjectBuilder.Context context, boolean add) {
        SqlExpression valueExpr;
        List list = callStatement.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArguments(...)");
        List arguments = list;
        SqlReferenceExpression ref = this.buildExtendedPropertyObjRef(callStatement, arguments, add);
        BasicModElement basicModElement = this.resolve(context, ref);
        if (basicModElement == null) {
            return;
        }
        BasicModElement obj = basicModElement;
        SqlExpression sqlExpression = (SqlExpression)CollectionsKt.getOrNull((List)arguments, (int)0);
        String name2 = sqlExpression != null ? this.stringValue(sqlExpression) : null;
        SqlExpression sqlExpression2 = valueExpr = add ? (SqlExpression)CollectionsKt.getOrNull((List)arguments, (int)1) : null;
        if (Intrinsics.areEqual((Object)name2, (Object)"MS_Description")) {
            BasicModNamedElement basicModNamedElement = obj instanceof BasicModNamedElement ? (BasicModNamedElement)obj : null;
            if (basicModNamedElement != null) {
                SqlExpression sqlExpression3 = valueExpr;
                basicModNamedElement.setComment(sqlExpression3 != null ? this.stringValue(sqlExpression3) : null);
            }
        } else if (name2 != null && obj instanceof MsExtendedPropertiesHolder) {
            List<NameValueType> list2 = ((MsExtendedPropertiesHolder)obj).getExtendedProperties();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getExtendedProperties(...)");
            List props = CollectionsKt.toMutableList((Collection)list2);
            props.removeIf(arg_0 -> MsObjectBuilder.buildExtendedProperty$lambda$1(arg_0 -> MsObjectBuilder.buildExtendedProperty$lambda$0(name2, arg_0), arg_0));
            if (valueExpr != null) {
                props.add(this.asExternalProp(name2, valueExpr));
            }
            ((MsExtendedPropertiesHolder)obj).setExtendedProperties(props);
        }
    }

    private final NameValueType asExternalProp(String name2, SqlExpression valueExpr) {
        String string;
        if (valueExpr instanceof SqlStringLiteralExpression) {
            String string2 = ((SqlStringLiteralExpression)valueExpr).getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            string = StringsKt.startsWith((String)string2, (String)"N", (boolean)true) ? "nvarchar" : "varchar";
        } else {
            string = "bigint";
        }
        String type = string;
        String string3 = valueExpr instanceof SqlLiteralExpression ? ((SqlLiteralExpression)valueExpr).getText() : "invalid";
        Intrinsics.checkNotNull((Object)string3);
        return new NameValueType(name2, string3, type);
    }

    /*
     * WARNING - void declaration
     */
    private final SqlReferenceExpression buildExtendedPropertyObjRef(SqlCallStatement callStatement, List<? extends SqlExpression> arguments, boolean add) {
        SqlReferenceElementType sqlReferenceElementType;
        int n;
        Object iterator$iv;
        Object object;
        NamingService ns;
        List<Pair<String, String>> names;
        block3: {
            void $this$indexOfLast$iv;
            names = this.epNames(arguments, add ? 2 : 1);
            Dbms dbms = DbImplUtilCore.getDbms((PsiElement)((PsiElement)callStatement));
            Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
            ns = NamingServices.getNamingService$default((Dbms)dbms, null, null, (int)6, null);
            List<Pair<String, String>> list = names;
            object = CollectionsKt.asSequence((Iterable)names);
            boolean $i$f$indexOfLast = false;
            iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
            while (iterator$iv.hasPrevious()) {
                Pair it = (Pair)iterator$iv.previous();
                boolean bl = false;
                if (!(it.getSecond() == null)) continue;
                n = iterator$iv.nextIndex();
                break block3;
            }
            n = -1;
        }
        int n2 = n;
        String text = SequencesKt.joinToString$default((Sequence)SequencesKt.drop((Sequence)object, (int)(n2 + 1)), (CharSequence)".", null, null, (int)0, null, arg_0 -> MsObjectBuilder.buildExtendedPropertyObjRef$lambda$1(ns, arg_0), (int)30, null);
        MsObjectBuilder msObjectBuilder = this;
        SqlCallStatement sqlCallStatement = callStatement;
        String string = text;
        String string2 = (String)((Pair)CollectionsKt.last(names)).getFirst();
        if (string2 != null) {
            void it;
            iterator$iv = string2;
            String string3 = string;
            SqlCallStatement sqlCallStatement2 = sqlCallStatement;
            object = msObjectBuilder;
            boolean bl = false;
            SqlReferenceElementType sqlReferenceElementType2 = this.getRefType((String)it, CollectionsKt.getLastIndex(names));
            msObjectBuilder = object;
            sqlCallStatement = sqlCallStatement2;
            string = string3;
            sqlReferenceElementType = sqlReferenceElementType2;
        } else {
            sqlReferenceElementType = null;
        }
        return msObjectBuilder.createReference(sqlCallStatement, string, sqlReferenceElementType);
    }

    private final SqlReferenceElementType getRefType(String name2, int level) {
        return switch (name2) {
            case "USER", "SCHEMA" -> SqlCompositeElementTypes.SQL_SCHEMA_REFERENCE;
            case "TRIGGER" -> SqlCompositeElementTypes.SQL_TRIGGER_REFERENCE;
            case "TYPE" -> SqlCompositeElementTypes.SQL_TYPE_REFERENCE;
            case "AGGREGATE" -> SqlCompositeElementTypes.SQL_AGGREGATE_REFERENCE;
            case "DEFAULT" -> MsElementTypes.Extra.MSSQL_DEFAULT_REFERENCE;
            case "FUNCTION" -> SqlCompositeElementTypes.SQL_FUNCTION_REFERENCE;
            case "PROCEDURE" -> SqlCompositeElementTypes.SQL_PROCEDURE_REFERENCE;
            case "RULE" -> MsElementTypes.Extra.MSSQL_RULE_REFERENCE;
            case "SEQUENCE" -> SqlCompositeElementTypes.SQL_SEQUENCE_REFERENCE;
            case "SYNONYM" -> SqlCompositeElementTypes.SQL_SYNONYM_REFERENCE;
            case "TABLE" -> SqlCompositeElementTypes.SQL_TABLE_REFERENCE;
            case "TABLE_TYPE" -> SqlCompositeElementTypes.SQL_TABLE_TYPE_REFERENCE;
            case "VIEW" -> SqlCompositeElementTypes.SQL_VIEW_REFERENCE;
            case "COLUMN" -> SqlCompositeElementTypes.SQL_COLUMN_REFERENCE;
            case "CONSTRAINT" -> SqlCompositeElementTypes.SQL_CONSTRAINT_REFERENCE;
            case "INDEX" -> SqlCompositeElementTypes.SQL_INDEX_REFERENCE;
            case "PARAMETER" -> SqlCompositeElementTypes.SQL_ARGUMENT_REFERENCE;
            default -> null;
        };
    }

    private final SqlReferenceExpression createReference(SqlCallStatement callStatement, String text, SqlReferenceElementType elementType) {
        if (text == null || elementType == null) {
            return null;
        }
        SqlCodeFragmentImpl frag = new SqlCodeFragmentImpl(callStatement.getProject(), (SqlLanguageDialect)SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)callStatement)), (IElementType)elementType, "a.sql", (CharSequence)text, false);
        frag.setContext((PsiElement)callStatement);
        Class[] classArray = new Class[]{SqlReferenceExpression.class};
        return (SqlReferenceExpression)PsiTreeUtil.findChildOfAnyType((PsiElement)((PsiElement)frag), (Class[])classArray);
    }

    private final List<Pair<String, String>> epNames(List<? extends SqlExpression> arguments, int o) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)new IntRange(0, 2))), arg_0 -> MsObjectBuilder.epNames$lambda$0(this, arguments, o, arg_0)));
    }

    private final Pair<String, String> epName(List<? extends SqlExpression> arguments, int o) {
        Pair pair;
        if (arguments.size() > o) {
            SqlExpression sqlExpression = (SqlExpression)CollectionsKt.getOrNull(arguments, (int)o);
            SqlExpression sqlExpression2 = (SqlExpression)CollectionsKt.getOrNull(arguments, (int)(o + 1));
            pair = new Pair((Object)(sqlExpression != null ? this.stringValue(sqlExpression) : null), (Object)(sqlExpression2 != null ? this.stringValue(sqlExpression2) : null));
        } else {
            pair = null;
        }
        return pair;
    }

    private final String stringValue(SqlExpression $this$stringValue) {
        SqlStringLiteralExpression sqlStringLiteralExpression = $this$stringValue instanceof SqlStringLiteralExpression ? (SqlStringLiteralExpression)$this$stringValue : null;
        return sqlStringLiteralExpression != null ? sqlStringLiteralExpression.getValue() : null;
    }

    public void finalize(@NotNull BasicModElement obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        super.finalize(obj);
        if (obj instanceof MsDefaultConstraint) {
            this.finalizeDefaultConstraint((MsDefaultConstraint)obj);
        }
    }

    private final void finalizeDefaultConstraint(MsDefaultConstraint obj) {
        block1: {
            List list = obj.getCols();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCols(...)");
            Object object = (BasicLikeColumn)CollectionsKt.firstOrNull((List)list);
            if (object == null) break block1;
            BasicLikeColumn it = object;
            boolean bl = false;
            MsStoredColumn msStoredColumn = it instanceof MsStoredColumn ? (MsStoredColumn)it : null;
            object = msStoredColumn;
            if (msStoredColumn != null) {
                Object object2;
                Object $this$finalizeDefaultConstraint_u24lambda_u241 = object2 = object;
                boolean bl2 = false;
                $this$finalizeDefaultConstraint_u24lambda_u241.setDefaultConstraintRef(BasicMetaUtils.createPortableReference((BasicElement)((BasicElement)$this$finalizeDefaultConstraint_u24lambda_u241), (BasicElement)((BasicElement)obj), MsStoredColumn.DEFAULT_CONSTRAINT_REF));
            }
        }
    }

    @Nullable
    public TextRange getCompactDefinition(@NotNull ObjectPath path, @NotNull CompositeText text, @Nullable PsiObject def) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ObjectKind objectKind = path.kind;
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.VIEW) ? this.getViewQueryRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.ROUTINE) ? this.getRoutineBodyRange(def) : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TRIGGER) ? this.getTriggerBodyRange(def) : super.getCompactDefinition(path, text, def)));
    }

    /*
     * WARNING - void declaration
     */
    private final void buildMsLikeIndex(MsLikeIndex obj, DasObject source, SqlObjectBuilder.Context context) {
        MsLikeIndex stubbed;
        BasicElement basicElement;
        super.buildIndex((BasicModIndex)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof MsLikeIndex) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof MsLikeIndex)) {
                object = null;
            }
            basicElement = (BasicElement)((MsLikeIndex)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (MsLikeIndex)basicElement) == null) {
            void this_$iv;
            boolean fulltext = false;
            boolean clustered = false;
            Ref.ObjectRef includeColumns = new Ref.ObjectRef();
            includeColumns.element = CollectionsKt.emptyList();
            dasObject = this;
            PsiElement el$iv = (PsiElement)(source instanceof SqlIndexDefinition ? (SqlIndexDefinition)source : null);
            boolean $i$f$forEachChild = false;
            void var11_14 = this_$iv;
            PsiElement psiElement = el$iv;
            PsiElement first$iv$iv = psiElement != null ? psiElement.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                SqlReferenceList l;
                PsiElement psiElement2;
                PsiElement tmp$iv$iv2;
                block13: {
                    void this_$iv2;
                    PsiElement c = tmp$iv$iv;
                    boolean bl = false;
                    IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)c);
                    if (Intrinsics.areEqual((Object)iElementType, (Object)MsTypes.MSSQL_FULLTEXT)) {
                        fulltext = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)MsTypes.MSSQL_CLUSTERED)) {
                        clustered = true;
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)iElementType, (Object)MsTypes.MSSQL_NONCLUSTERED)) {
                        clustered = false;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)c.getFirstChild()), (Object)MsTypes.MSSQL_INCLUDE)) continue;
                    SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
                    PsiElement el$iv2 = c;
                    boolean $i$f$findChild = false;
                    void var21_24 = this_$iv2;
                    PsiElement element$iv$iv = el$iv2.getFirstChild();
                    boolean $i$f$findSibling = false;
                    for (tmp$iv$iv2 = element$iv$iv; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement it$iv = tmp$iv$iv2;
                        boolean bl2 = false;
                        if (!(it$iv instanceof SqlReferenceList)) continue;
                        psiElement2 = tmp$iv$iv2;
                        break block13;
                    }
                    psiElement2 = null;
                }
                if ((SqlReferenceList)psiElement2 == null) continue;
                boolean bl = false;
                List list = SqlImplUtil.getReferenceList((SqlReferenceList)l);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getReferenceList(...)");
                Iterable this_$iv$iv = list;
                Ref.ObjectRef objectRef = includeColumns;
                boolean $i$f$map = false;
                tmp$iv$iv2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SqlReferenceExpression sqlReferenceExpression = (SqlReferenceExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getName());
                }
                objectRef.element = (List)destination$iv$iv;
            }
            obj.setFulltext(fulltext);
            obj.setClustering(clustered);
            obj.setIncludedColNames((List)includeColumns.element);
        } else {
            obj.setFulltext(stubbed.isFulltext());
            obj.setClustering(stubbed.isClustering());
            obj.setIncludedColNames(stubbed.getIncludedColNames());
        }
    }

    private final void buildMsDefault(MsDefaultConstraint obj, DasObject source, SqlObjectBuilder.Context context) {
        MsDefaultConstraint stubbed;
        BasicElement basicElement;
        super.buildBasicElement((BasicModElement)obj, source, context);
        super.buildColumniation((BasicModColumniation)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof MsDefaultConstraint) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof MsDefaultConstraint)) {
                object = null;
            }
            basicElement = (BasicElement)((MsDefaultConstraint)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (MsDefaultConstraint)basicElement) == null) {
            SqlConstraintDefinition def = source instanceof SqlConstraintDefinition ? (SqlConstraintDefinition)source : null;
            SqlConstraintDefinition sqlConstraintDefinition = def;
            obj.setDefaultExpression(sqlConstraintDefinition != null && (sqlConstraintDefinition = (SqlExpression)sqlConstraintDefinition.getConstraintParameter(SqlConstraintDefinition.EXPRESSION)) != null ? sqlConstraintDefinition.getText() : null);
        } else {
            obj.setDefaultExpression(stubbed.getDefaultExpression());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTableColumn(MsTableColumn obj, DasObject source, SqlObjectBuilder.Context context) {
        MsTableColumn stubbed;
        BasicElement basicElement;
        this.buildBasicElement((BasicModElement)obj, source, context);
        SqlObjectBuilderImpl sqlObjectBuilderImpl = this;
        DasObject $this$stubbed$iv = source;
        boolean $i$f$stubbed2 = false;
        DasObject dasObject = $this$stubbed$iv;
        if (dasObject instanceof MsTableColumn) {
            basicElement = (BasicElement)$this$stubbed$iv;
        } else if (dasObject instanceof SqlStubbedElement) {
            StubElement stubElement = ((SqlStubbedElement)$this$stubbed$iv).getGreenStub();
            SqlDefinitionStub sqlDefinitionStub = stubElement instanceof SqlDefinitionStub ? (SqlDefinitionStub)stubElement : null;
            Object object = sqlDefinitionStub != null ? sqlDefinitionStub.getElement() : null;
            if (!(object instanceof MsTableColumn)) {
                object = null;
            }
            basicElement = (BasicElement)((MsTableColumn)object);
        } else {
            basicElement = null;
        }
        if ((stubbed = (MsTableColumn)basicElement) != null) {
            obj.setAutoInc(stubbed.isAutoInc());
            obj.setCollationRef(stubbed.getCollationRef());
        } else {
            void el$iv;
            void this_$iv;
            boolean autoInc = false;
            Ref.ObjectRef collation = new Ref.ObjectRef();
            SqlObjectBuilderImpl $i$f$stubbed2 = this;
            DasObject $this$asSafely$iv = source;
            boolean $i$f$asSafely = false;
            DasObject dasObject2 = $this$asSafely$iv;
            if (!(dasObject2 instanceof PsiElement)) {
                dasObject2 = null;
            }
            $this$asSafely$iv = (PsiElement)dasObject2;
            boolean $i$f$forEachChild = false;
            void var10_13 = this_$iv;
            void v4 = el$iv;
            PsiElement first$iv$iv = v4 != null ? v4.getFirstChild() : null;
            boolean $i$f$forEachSibling = false;
            for (PsiElement tmp$iv$iv = first$iv$iv; tmp$iv$iv != null; tmp$iv$iv = tmp$iv$iv.getNextSibling()) {
                SqlReferenceExpression sqlReferenceExpression;
                PsiElement psiElement;
                block15: {
                    void el$iv2;
                    void this_$iv2;
                    PsiElement it = tmp$iv$iv;
                    boolean bl = false;
                    IElementType iElementType = PsiTreeUtilKt.getElementType((PsiElement)it);
                    if (Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE)) {
                        autoInc = true;
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)SqlCompositeElementTypes.SQL_COLLATE_CLAUSE)) continue;
                    SqlObjectBuilderImpl sqlObjectBuilderImpl2 = this;
                    PsiElement psiElement2 = it;
                    Ref.ObjectRef objectRef = collation;
                    boolean $i$f$findChild = false;
                    void var21_24 = this_$iv2;
                    PsiElement element$iv$iv = el$iv2.getFirstChild();
                    boolean $i$f$findSibling = false;
                    for (PsiElement tmp$iv$iv2 = element$iv$iv; tmp$iv$iv2 != null; tmp$iv$iv2 = tmp$iv$iv2.getNextSibling()) {
                        PsiElement it$iv = tmp$iv$iv2;
                        boolean bl2 = false;
                        if (!(it$iv instanceof SqlReferenceExpression)) continue;
                        psiElement = tmp$iv$iv2;
                        break block15;
                    }
                    psiElement = null;
                }
                objectRef.element = (sqlReferenceExpression = (SqlReferenceExpression)psiElement) != null ? SqlObjectBuilderImpl.asBasic$default((SqlObjectBuilderImpl)this, (SqlReferenceExpression)sqlReferenceExpression, (boolean)false, (int)1, null) : null;
            }
            obj.setAutoInc(autoInc);
            obj.setCollationRef((BasicReference)collation.element);
        }
        if (obj.isAutoInc()) {
            obj.setNotNull(true);
        }
        if (StringsKt.equals((String)obj.getName(), (String)"timestamp", (boolean)true)) {
            DataType dataType = DataTypeFactory.of((String)obj.getName());
            Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
            obj.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
            obj.setComputed(true);
        } else if (StringsKt.equals((String)obj.getName(), (String)"rowversion", (boolean)true)) {
            obj.setComputed(true);
        }
    }

    private final void buildRoutine(MsRoutine obj, DasObject source, SqlObjectBuilder.Context context) {
        Object object;
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModRoutine");
        this.buildRoutine(obj, source, context);
        if (!context.isStubBuilder() && obj.getRoutineType() == MsRoutineType.TAB_FUN && (object = obj.getReturnArgument()) != null) {
            BasicArgument $this$asSafely$iv = object;
            boolean $i$f$asSafely = false;
            BasicArgument basicArgument = $this$asSafely$iv;
            if (!(basicArgument instanceof MsArgument)) {
                basicArgument = null;
            }
            if ((object = (MsArgument)basicArgument) != null) {
                object.drop();
            }
        }
        this.assignSources(obj, context, () -> MsObjectBuilder.buildRoutine$lambda$0(source, this));
    }

    public void buildRoutineKind(@NotNull BasicModRoutine obj, @NotNull DasObject source) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        MsRoutine cfr_ignored_0 = (MsRoutine)obj;
        DasRoutine.Kind k = this.extractRoutineKind(source);
        MsRoutine msRoutine = (MsRoutine)obj;
        msRoutine.setRoutineType(switch (WhenMappings.$EnumSwitchMapping$0[k.ordinal()]) {
            case 1 -> MsRoutineType.PROC;
            case 2 -> {
                DasRoutine v3;
                DasObject $this$asSafely$iv = source;
                boolean $i$f$asSafely = false;
                DasObject v2 = $this$asSafely$iv;
                if (!(v2 instanceof DasRoutine)) {
                    v2 = null;
                }
                if (((v3 = (DasRoutine)v2) != null && (v3 = v3.getReturnArgument()) != null ? v3.getDasType() : null) instanceof DasTableType) {
                    yield MsRoutineType.TAB_FUN;
                }
                yield MsRoutineType.SCALAR_FUN;
            }
            default -> MsRoutineType.CLR_PROC;
        });
    }

    private final void buildTrigger(MsTrigger obj, DasObject source, SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNull((Object)obj, (String)"null cannot be cast to non-null type com.intellij.database.model.basic.BasicModTrigger");
        this.buildTrigger(obj, source, context);
        this.assignSources(obj, context, () -> MsObjectBuilder.buildTrigger$lambda$0(source, this));
    }

    protected void buildViewSource(@NotNull BasicModView obj, @NotNull DasObject source, @NotNull SqlObjectBuilder.Context context) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.assignSources((BasicModSourceAware)obj, context, () -> MsObjectBuilder.buildViewSource$lambda$0(source, this));
    }

    @Nullable
    protected Void seqMinimumDefault(boolean isAsc) {
        return null;
    }

    @Nullable
    protected Void seqMaximumDefault(boolean isAsc) {
        return null;
    }

    private static final boolean buildExtendedProperty$lambda$0(String $name, NameValueType it) {
        return Intrinsics.areEqual((Object)it.getName(), (Object)$name);
    }

    private static final boolean buildExtendedProperty$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final CharSequence buildExtendedPropertyObjRef$lambda$1(NamingService $ns, Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getSecond();
        Intrinsics.checkNotNull((Object)object);
        return $ns.catToScript((String)object, null, true);
    }

    private static final Pair epNames$lambda$0(MsObjectBuilder this$0, List $arguments, int $o, int it) {
        return this$0.epName($arguments, $o + it * 2);
    }

    private static final CompositeText buildRoutine$lambda$0(DasObject $source, MsObjectBuilder this$0) {
        String string;
        SqlCreateProcedureStatement sqlCreateProcedureStatement = $source instanceof SqlCreateProcedureStatement ? (SqlCreateProcedureStatement)$source : null;
        return (CompositeText)(sqlCreateProcedureStatement != null && (string = this$0.wholeStatement((SqlRoutineDefinition)sqlCreateProcedureStatement)) != null ? SqlObjectBuilderImpl.asComposite$default((SqlObjectBuilderImpl)this$0, (String)string, null, (int)1, null) : null);
    }

    private static final CompositeText buildTrigger$lambda$0(DasObject $source, MsObjectBuilder this$0) {
        String string;
        SqlCreateTriggerStatement sqlCreateTriggerStatement = $source instanceof SqlCreateTriggerStatement ? (SqlCreateTriggerStatement)$source : null;
        return (CompositeText)(sqlCreateTriggerStatement != null && (string = sqlCreateTriggerStatement.getText()) != null ? SqlObjectBuilderImpl.asComposite$default((SqlObjectBuilderImpl)this$0, (String)string, null, (int)1, null) : null);
    }

    private static final CompositeText buildViewSource$lambda$0(DasObject $source, MsObjectBuilder this$0) {
        String string;
        SqlCreateViewStatement sqlCreateViewStatement = $source instanceof SqlCreateViewStatement ? (SqlCreateViewStatement)$source : null;
        return (CompositeText)(sqlCreateViewStatement != null && (string = this$0.wholeStatement((SqlTableDefinition)sqlCreateViewStatement)) != null ? SqlObjectBuilderImpl.asComposite$default((SqlObjectBuilderImpl)this$0, (String)string, null, (int)1, null) : null);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DasRoutine.Kind.values().length];
            try {
                nArray[DasRoutine.Kind.PROCEDURE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DasRoutine.Kind.FUNCTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

