/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.messaging.providers;

import com.intellij.microservices.jvm.mq.MQDestinationAnchor;
import com.intellij.microservices.jvm.mq.MQResolver;
import com.intellij.microservices.jvm.mq.MQResolverFactory;
import com.intellij.microservices.jvm.mq.MQTargetInfo;
import com.intellij.microservices.jvm.mq.MQType;
import com.intellij.microservices.jvm.mq.UnknownMQProviderType;
import com.intellij.openapi.project.Project;
import com.intellij.spring.messaging.jam.mq.SpringJmsListener;
import com.intellij.spring.messaging.providers.SpringMQUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/intellij/spring/messaging/providers/SpringJmsListenerMQResolver;", "Lcom/intellij/microservices/jvm/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "supportedTypes", "", "Lcom/intellij/microservices/jvm/mq/MQType;", "getSupportedTypes", "()Ljava/util/List;", "getVariants", "", "Lcom/intellij/microservices/jvm/mq/MQTargetInfo;", "typeHint", "Factory", "intellij.spring.messaging"})
public final class SpringJmsListenerMQResolver
implements MQResolver {
    @NotNull
    private final Project project;
    @NotNull
    private final List<MQType> supportedTypes;

    public SpringJmsListenerMQResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.supportedTypes = CollectionsKt.listOf((Object)UnknownMQProviderType.INSTANCE);
    }

    @NotNull
    public List<MQType> getSupportedTypes() {
        return this.supportedTypes;
    }

    @NotNull
    public Iterable<MQTargetInfo> getVariants(@NotNull MQType typeHint) {
        Intrinsics.checkNotNullParameter((Object)typeHint, (String)"typeHint");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filter(SpringMQUtils.INSTANCE.getJmsListeners(this.project), SpringJmsListenerMQResolver::getVariants$lambda$0), SpringJmsListenerMQResolver::getVariants$lambda$1));
    }

    private static final boolean getVariants$lambda$0(SpringJmsListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isValid();
    }

    private static final Sequence getVariants$lambda$1(SpringJmsListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List<MQDestinationAnchor> list = it.getMQDestinations();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getMQDestinations(...)");
        return CollectionsKt.asSequence((Iterable)list);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/spring/messaging/providers/SpringJmsListenerMQResolver$Factory;", "Lcom/intellij/microservices/jvm/mq/MQResolverFactory;", "<init>", "()V", "forProject", "", "Lcom/intellij/microservices/jvm/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.spring.messaging"})
    public static final class Factory
    implements MQResolverFactory {
        @NotNull
        public List<MQResolver> forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!SpringMQUtils.INSTANCE.hasSpringJmsLibrary(project)) {
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.listOf((Object)new SpringJmsListenerMQResolver(project));
        }
    }
}

