/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.byteCodeViewer.BytecodeLineMappingKt;
import com.intellij.byteCodeViewer.BytecodeViewerBundle;
import com.intellij.byteCodeViewer.BytecodeViewerSettings;
import com.intellij.byteCodeViewer.ShowBytecodeActionKt;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.content.Content;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceClassVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0014B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0013\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/intellij/byteCodeViewer/BytecodeToolWindowPanel;", "Lcom/intellij/ui/components/JBPanel;", "", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "psiClass", "Lcom/intellij/psi/PsiClass;", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiClass;Lcom/intellij/openapi/vfs/VirtualFile;)V", "bytecodeEditor", "Lcom/intellij/openapi/editor/Editor;", "updateTextInEditor", "", "selectedMatchingEditor", "getSelectedMatchingEditor", "()Lcom/intellij/openapi/editor/Editor;", "dispose", "Companion", "intellij.java.byteCodeViewer"})
public final class BytecodeToolWindowPanel
extends JBPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final PsiClass psiClass;
    @NotNull
    private final VirtualFile classFile;
    @NotNull
    private final Editor bytecodeEditor;
    @NotNull
    public static final String TOOL_WINDOW_ID = "Bytecode";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<String> BYTECODE_WITH_DEBUG_INFO;

    public BytecodeToolWindowPanel(@NotNull Project project, @Nullable PsiClass psiClass, @NotNull VirtualFile classFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)classFile, (String)"classFile");
        super((LayoutManager)new BorderLayout());
        this.project = project;
        this.psiClass = psiClass;
        this.classFile = classFile;
        Editor editor = EditorFactory.getInstance().createEditor(EditorFactory.getInstance().createDocument((CharSequence)""), this.project, (FileType)JavaClassFileType.INSTANCE, true);
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"createEditor(...)");
        this.bytecodeEditor = editor;
        this.add(this.bytecodeEditor.getComponent());
        this.updateTextInEditor();
        EditorFactory.getInstance().getEventMulticaster().addCaretListener(new CaretListener(){

            public void caretPositionChanged(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor sourceEditor = this.getSelectedMatchingEditor();
                if (!Intrinsics.areEqual((Object)event.getEditor(), (Object)sourceEditor)) {
                    return;
                }
                Companion.updateBytecodeSelection(sourceEditor, bytecodeEditor);
            }

            public void caretAdded(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor sourceEditor = this.getSelectedMatchingEditor();
                if (!Intrinsics.areEqual((Object)event.getEditor(), (Object)sourceEditor)) {
                    return;
                }
                Companion.updateBytecodeSelection(sourceEditor, bytecodeEditor);
            }

            public void caretRemoved(CaretEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Editor sourceEditor = this.getSelectedMatchingEditor();
                if (!Intrinsics.areEqual((Object)event.getEditor(), (Object)sourceEditor)) {
                    return;
                }
                Companion.updateBytecodeSelection(sourceEditor, bytecodeEditor);
            }
        }, (Disposable)this);
        EditorFactory.getInstance().getEventMulticaster().addSelectionListener(new SelectionListener(){

            public void selectionChanged(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Editor sourceEditor = this.getSelectedMatchingEditor();
                if (!Intrinsics.areEqual((Object)e.getEditor(), (Object)sourceEditor)) {
                    return;
                }
                Companion.updateBytecodeSelection(sourceEditor, bytecodeEditor);
            }
        }, (Disposable)this);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBusConnection.subscribe(topic, (Object)new BulkFileListener(){

            public void after(List<? extends VFileEvent> events) {
                Intrinsics.checkNotNullParameter(events, (String)"events");
                ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow(BytecodeToolWindowPanel.TOOL_WINDOW_ID);
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                for (VFileEvent vFileEvent : events) {
                    Content content;
                    Object object;
                    block4: {
                        VirtualFile file;
                        if (vFileEvent.getFile() == null || !(file.getFileType() instanceof JavaClassFileType)) continue;
                        Content[] contentArray = toolWindow2.getContentManager().getContents();
                        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
                        Object[] $this$firstOrNull$iv = contentArray;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Content it = (Content)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getUserData(ShowBytecodeActionKt.getJAVA_CLASS_FILE()), (Object)file)) continue;
                            object = element$iv;
                            break block4;
                        }
                        object = null;
                    }
                    if ((Content)object == null) continue;
                    VFileEvent vFileEvent2 = vFileEvent;
                    if (vFileEvent2 instanceof VFileContentChangeEvent) {
                        classFile.refresh(true, false, () -> 3.after$lambda$1(this));
                        continue;
                    }
                    if (!(vFileEvent2 instanceof VFileDeleteEvent)) continue;
                    toolWindow2.getContentManager().removeContent(content, true);
                }
            }

            private static final void after$lambda$1(BytecodeToolWindowPanel this$0) {
                this$0.updateTextInEditor();
            }
        });
    }

    public final void updateTextInEditor() {
        String byteCodeText = BytecodeToolWindowPanel.Companion.deserializeBytecode(this.classFile);
        this.bytecodeEditor.getDocument().putUserData(BYTECODE_WITH_DEBUG_INFO, (Object)byteCodeText);
        String byteCodeToShow = BytecodeViewerSettings.Companion.getInstance().getState().getShowDebugInfo() ? byteCodeText : BytecodeLineMappingKt.removeDebugInfo(byteCodeText);
        ApplicationManager.getApplication().runWriteAction(() -> BytecodeToolWindowPanel.updateTextInEditor$lambda$0(this, byteCodeToShow));
        Editor editor = this.getSelectedMatchingEditor();
        if (editor == null) {
            return;
        }
        Editor sourceEditor = editor;
        BytecodeToolWindowPanel.Companion.updateBytecodeSelection(sourceEditor, this.bytecodeEditor);
    }

    private final Editor getSelectedMatchingEditor() {
        Object object;
        Editor editor = FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
        if (editor != null) {
            Editor editor2;
            Editor editor3 = editor2 = editor;
            boolean bl = false;
            Document document = editor3.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
            PsiClass psiClass = this.psiClass;
            object = Intrinsics.areEqual((Object)virtualFile, psiClass != null && (psiClass = psiClass.getContainingFile()) != null ? psiClass.getVirtualFile() : null) ? editor2 : null;
        } else {
            object = null;
        }
        return object;
    }

    public void dispose() {
        EditorFactory.getInstance().releaseEditor(this.bytecodeEditor);
    }

    private static final void updateTextInEditor$lambda$0(BytecodeToolWindowPanel this$0, String $byteCodeToShow) {
        this$0.bytecodeEditor.getDocument().setText((CharSequence)$byteCodeToShow);
    }

    static {
        Logger logger = Logger.getInstance(BytecodeToolWindowPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"BYTECODE_WITH_DEBUG_INFO");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        BYTECODE_WITH_DEBUG_INFO = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00050\u00050\n\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/byteCodeViewer/BytecodeToolWindowPanel$Companion;", "", "<init>", "()V", "TOOL_WINDOW_ID", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "BYTECODE_WITH_DEBUG_INFO", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "updateBytecodeSelection", "", "sourceEditor", "Lcom/intellij/openapi/editor/Editor;", "bytecodeEditor", "deserializeBytecode", "classFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.java.byteCodeViewer"})
    public static final class Companion {
        private Companion() {
        }

        private final void updateBytecodeSelection(Editor sourceEditor, Editor bytecodeEditor) {
            if (sourceEditor.getCaretModel().getCaretCount() != 1) {
                bytecodeEditor.getSelectionModel().removeSelection();
                return;
            }
            int sourceStartOffset = sourceEditor.getCaretModel().getCurrentCaret().getSelectionStart();
            int sourceEndOffset = sourceEditor.getCaretModel().getCurrentCaret().getSelectionEnd();
            Document document = sourceEditor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document sourceDocument = document;
            int sourceStartLine = sourceDocument.getLineNumber(sourceStartOffset);
            int sourceEndLine = sourceDocument.getLineNumber(sourceEndOffset);
            if (sourceEndLine > sourceStartLine && sourceEndOffset > 0 && sourceDocument.getCharsSequence().charAt(sourceEndOffset - 1) == '\n') {
                --sourceEndLine;
            }
            Document document2 = bytecodeEditor.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"getDocument(...)");
            Document bytecodeDocument = document2;
            String bytecodeWithDebugInfo = (String)bytecodeDocument.getUserData(BYTECODE_WITH_DEBUG_INFO);
            if (bytecodeWithDebugInfo == null) {
                LOG.warn("Bytecode with debug information is null. Ensure the bytecode has been generated correctly.");
                return;
            }
            IntRange linesRange = BytecodeLineMappingKt.mapLines(bytecodeWithDebugInfo, sourceStartLine, sourceEndLine, BytecodeViewerSettings.Companion.getInstance().getState().getShowDebugInfo());
            if (Intrinsics.areEqual((Object)linesRange, (Object)new IntRange(0, 0)) || linesRange.getFirst() < 0 || linesRange.getLast() < 0) {
                bytecodeEditor.getSelectionModel().removeSelection();
                return;
            }
            int endSelectionLineIndex = Math.min(linesRange.getLast() + 1, bytecodeDocument.getLineCount());
            int startOffset = bytecodeDocument.getLineStartOffset(linesRange.getFirst());
            int endOffset = Math.min(bytecodeDocument.getLineEndOffset(endSelectionLineIndex), bytecodeDocument.getTextLength());
            if (bytecodeDocument.getTextLength() <= startOffset || bytecodeDocument.getTextLength() <= endOffset) {
                return;
            }
            bytecodeEditor.getCaretModel().moveToOffset(endOffset);
            bytecodeEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            bytecodeEditor.getCaretModel().moveToOffset(startOffset);
            bytecodeEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
            bytecodeEditor.getSelectionModel().setSelection(startOffset, endOffset);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final String deserializeBytecode(VirtualFile classFile) {
            try {
                byte[] byArray = classFile.contentsToByteArray(false);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"contentsToByteArray(...)");
                byte[] bytes = byArray;
                StringWriter stringWriter = new StringWriter();
                Closeable closeable = new PrintWriter(stringWriter);
                Throwable throwable = null;
                try {
                    PrintWriter printWriter = (PrintWriter)closeable;
                    boolean bl = false;
                    new ClassReader(bytes).accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new Textifier(), printWriter), 4);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                String string = stringWriter.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                return string;
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return BytecodeViewerBundle.message("deserialization.error", new Object[0]);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

