/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.byteCodeViewer.ByteCodeViewerManager;
import com.intellij.byteCodeViewer.BytecodeEditorSynchronizer;
import com.intellij.byteCodeViewer.BytecodeToolWindowPanel;
import com.intellij.byteCodeViewer.BytecodeToolWindowService;
import com.intellij.byteCodeViewer.BytecodeViewerBundle;
import com.intellij.byteCodeViewer.BytecodeViewerSettings;
import com.intellij.byteCodeViewer.ShowBytecodeActionKt;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.RegisterToolWindowTaskBuilder;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/byteCodeViewer/ShowBytecodeAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "intellij.java.byteCodeViewer"})
@SourceDebugExtension(value={"SMAP\nShowBytecodeAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowBytecodeAction.kt\ncom/intellij/byteCodeViewer/ShowBytecodeAction\n+ 2 ToolWindowManager.kt\ncom/intellij/openapi/wm/ToolWindowManager\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,157:1\n99#2,3:158\n1401#3,2:161\n*S KotlinDebug\n*F\n+ 1 ShowBytecodeAction.kt\ncom/intellij/byteCodeViewer/ShowBytecodeAction\n*L\n36#1:158,3\n83#1:161,2\n*E\n"})
public final class ShowBytecodeAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        event.getPresentation().setEnabled(event.getProject() != null);
        event.getPresentation().setIcon(AllIcons.FileTypes.JavaClass);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent event) {
        Content content;
        Object object;
        BytecodeToolWindowPanel panel;
        VirtualFile classFile;
        ToolWindow toolWindow;
        Project project;
        block12: {
            VirtualFile virtualFile;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Project project2 = event.getProject();
            if (project2 == null) {
                return;
            }
            project = project2;
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
            ToolWindow toolWindow2 = toolWindowManager.getToolWindow("Bytecode");
            if (toolWindow2 == null) {
                void this_$iv;
                RegisterToolWindowTaskBuilder b$iv;
                ToolWindowManager toolWindowManager2 = toolWindowManager;
                String id$iv = "Bytecode";
                boolean $i$f$registerToolWindow = false;
                RegisterToolWindowTaskBuilder $this$actionPerformed_u24lambda_u240 = b$iv = new RegisterToolWindowTaskBuilder(id$iv);
                boolean bl = false;
                $this$actionPerformed_u24lambda_u240.icon = AllIcons.FileTypes.JavaClass;
                ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.RIGHT;
                Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"RIGHT");
                $this$actionPerformed_u24lambda_u240.anchor = toolWindowAnchor;
                $this$actionPerformed_u24lambda_u240.hideOnEmptyContent = true;
                $this$actionPerformed_u24lambda_u240.canCloseContent = true;
                toolWindow2 = this_$iv.registerToolWindow(b$iv.build());
            }
            toolWindow = toolWindow2;
            BytecodeToolWindowService.Companion.getInstance(project).ensureContentManagerListenerRegistered(toolWindow);
            MessageBus messageBus = project.getMessageBus();
            Disposable disposable = toolWindow.getDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
            MessageBusConnection messageBusConnection = messageBus.connect(disposable);
            Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
            messageBusConnection.subscribe(topic, (Object)BytecodeEditorSynchronizer.Companion.getInstance(project));
            Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
            if (editor == null) {
                return;
            }
            Editor editor2 = editor;
            PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
            if (psiFile == null) {
                return;
            }
            PsiFile psiFileInEditor = psiFile;
            VirtualFile virtualFile2 = (VirtualFile)event.getData(CommonDataKeys.VIRTUAL_FILE);
            if (virtualFile2 == null) {
                return;
            }
            VirtualFile virtualFileInEditor = virtualFile2;
            FileType fileType = FileTypeRegistry.getInstance().getFileTypeByFileName(virtualFileInEditor.getNameSequence());
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileTypeByFileName(...)");
            FileType fileTypeInEditor = fileType;
            PsiClass psiClass = null;
            if (Intrinsics.areEqual((Object)fileTypeInEditor, (Object)JavaClassFileType.INSTANCE)) {
                virtualFile = virtualFileInEditor;
            } else {
                PsiElement psiElement = psiFileInEditor.findElementAt(editor2.getCaretModel().getOffset());
                if (psiElement == null) {
                    ShowBytecodeActionKt.showErrorNotification$default(project, BytecodeViewerBundle.message("could.not.find.class.at.cursor", new Object[0]), false, 2, null);
                    return;
                }
                psiClass = ByteCodeViewerManager.getContainingClass(psiElement);
                if (psiClass == null) {
                    ShowBytecodeActionKt.showErrorNotification$default(project, BytecodeViewerBundle.message("could.not.find.class.at.cursor", new Object[0]), false, 2, null);
                    return;
                }
                VirtualFile javaClassFile = ByteCodeViewerManager.INSTANCE.findClassFile(psiClass);
                if (javaClassFile == null) {
                    ShowBytecodeActionKt.access$showErrorNotification(project, BytecodeViewerBundle.message("please.build.project", new Object[0]), true);
                    return;
                }
                virtualFile = javaClassFile;
            }
            classFile = virtualFile;
            panel = new BytecodeToolWindowPanel(project, psiClass, classFile);
            Content[] contentArray = toolWindow.getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            Object[] $this$firstOrNull$iv = contentArray;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Content it = (Content)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getUserData(ShowBytecodeActionKt.getJAVA_CLASS_FILE()), (Object)classFile)) continue;
                object = element$iv;
                break block12;
            }
            object = null;
        }
        if ((content = (Content)object) == null) {
            Content content2;
            Content $this$actionPerformed_u24lambda_u242 = content2 = ContentFactory.getInstance().createContent((JComponent)((Object)panel), classFile.getPresentableName(), false);
            boolean bl = false;
            $this$actionPerformed_u24lambda_u242.setDescription(classFile.getPresentableUrl());
            $this$actionPerformed_u24lambda_u242.putUserData(ShowBytecodeActionKt.getJAVA_CLASS_FILE(), (Object)classFile);
            Content content3 = content2;
            content = content3;
            Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"apply(...)");
        }
        Content content4 = content;
        toolWindow.getContentManager().addContent(content4);
        content4.setDisposer((Disposable)panel);
        toolWindow.getContentManager().setSelectedContent(content4);
        toolWindow.setAdditionalGearActions(this.createActionGroup());
        toolWindow.activate(() -> ShowBytecodeAction.actionPerformed$lambda$3(project, panel));
    }

    private final ActionGroup createActionGroup() {
        Supplier<String> supplier = BytecodeViewerBundle.INSTANCE.messagePointer("action.show.debug.action.name", new Object[0]);
        ToggleAction showDebugAction2 = new ToggleAction(supplier){

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return BytecodeViewerSettings.Companion.getInstance().getState().getShowDebugInfo();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BytecodeViewerSettings.Companion.getInstance().getState().setShowDebugInfo(state);
                Project project = e.getProject();
                if (project == null) {
                    return;
                }
                Project project2 = project;
                ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project2).getToolWindow("Bytecode");
                if (toolWindow == null) {
                    return;
                }
                ToolWindow toolWindow2 = toolWindow;
                Content[] contentArray = toolWindow2.getContentManager().getContents();
                Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
                Object[] $this$forEach$iv = contentArray;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    BytecodeToolWindowPanel panel;
                    Content it = (Content)element$iv;
                    boolean bl = false;
                    JComponent jComponent = it.getComponent();
                    if ((jComponent instanceof BytecodeToolWindowPanel ? (BytecodeToolWindowPanel)((Object)jComponent) : null) == null) continue;
                    panel = panel;
                    panel.updateTextInEditor();
                }
            }
        };
        AnAction[] anActionArray = BytecodeViewerBundle.INSTANCE.messagePointer("action.sync.with.editor.name", new Object[0]);
        ToggleAction syncWithEditorAction2 = new ToggleAction((Supplier<String>)anActionArray){

            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return BytecodeViewerSettings.Companion.getInstance().getState().getSyncWithEditor();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BytecodeViewerSettings.Companion.getInstance().getState().setSyncWithEditor(state);
            }
        };
        anActionArray = new AnAction[]{showDebugAction2, syncWithEditorAction2};
        return (ActionGroup)new DefaultActionGroup(anActionArray);
    }

    private static final void actionPerformed$lambda$3(Project $project, BytecodeToolWindowPanel $panel) {
        IdeFocusManager.getInstance((Project)$project).requestFocus((Component)((Object)$panel), false);
    }
}

