/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;
import org.apache.commons.io.function.Uncheck;

public final class FilesUncheck {
    public static long copy(InputStream in, Path target, CopyOption ... options) {
        return Uncheck.apply(Files::copy, in, target, options);
    }

    public static long copy(Path source, OutputStream out) {
        return Uncheck.apply(Files::copy, source, out);
    }

    public static Path copy(Path source, Path target, CopyOption ... options) {
        return Uncheck.apply(Files::copy, source, target, options);
    }

    public static Path createDirectories(Path dir, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createDirectories, dir, attrs);
    }

    public static Path createDirectory(Path dir, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createDirectory, dir, attrs);
    }

    public static Path createFile(Path path2, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createFile, path2, attrs);
    }

    public static Path createLink(Path link, Path existing) {
        return Uncheck.apply(Files::createLink, link, existing);
    }

    public static Path createSymbolicLink(Path link, Path target, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createSymbolicLink, link, target, attrs);
    }

    public static Path createTempDirectory(Path dir, String prefix, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createTempDirectory, dir, prefix, attrs);
    }

    public static Path createTempDirectory(String prefix, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createTempDirectory, prefix, attrs);
    }

    public static Path createTempFile(Path dir, String prefix, String suffix, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createTempFile, dir, prefix, suffix, attrs);
    }

    public static Path createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::createTempFile, prefix, suffix, attrs);
    }

    public static void delete(Path path2) {
        Uncheck.accept(Files::delete, path2);
    }

    public static boolean deleteIfExists(Path path2) {
        return Uncheck.apply(Files::deleteIfExists, path2);
    }

    public static Stream<Path> find(Path start2, int maxDepth, BiPredicate<Path, BasicFileAttributes> matcher, FileVisitOption ... options) {
        return Uncheck.apply(Files::find, start2, maxDepth, matcher, options);
    }

    public static Object getAttribute(Path path2, String attribute, LinkOption ... options) {
        return Uncheck.apply(Files::getAttribute, path2, attribute, options);
    }

    public static FileStore getFileStore(Path path2) {
        return Uncheck.apply(Files::getFileStore, path2);
    }

    public static FileTime getLastModifiedTime(Path path2, LinkOption ... options) {
        return Uncheck.apply(Files::getLastModifiedTime, path2, options);
    }

    public static UserPrincipal getOwner(Path path2, LinkOption ... options) {
        return Uncheck.apply(Files::getOwner, path2, options);
    }

    public static Set<PosixFilePermission> getPosixFilePermissions(Path path2, LinkOption ... options) {
        return Uncheck.apply(Files::getPosixFilePermissions, path2, options);
    }

    public static boolean isHidden(Path path2) {
        return Uncheck.apply(Files::isHidden, path2);
    }

    public static boolean isSameFile(Path path2, Path path22) {
        return Uncheck.apply(Files::isSameFile, path2, path22);
    }

    public static Stream<String> lines(Path path2) {
        return Uncheck.apply(Files::lines, path2);
    }

    public static Stream<String> lines(Path path2, Charset cs) {
        return Uncheck.apply(Files::lines, path2, cs);
    }

    public static Stream<Path> list(Path dir) {
        return Uncheck.apply(Files::list, dir);
    }

    public static Path move(Path source, Path target, CopyOption ... options) {
        return Uncheck.apply(Files::move, source, target, options);
    }

    public static BufferedReader newBufferedReader(Path path2) {
        return Uncheck.apply(Files::newBufferedReader, path2);
    }

    public static BufferedReader newBufferedReader(Path path2, Charset cs) {
        return Uncheck.apply(Files::newBufferedReader, path2, cs);
    }

    public static BufferedWriter newBufferedWriter(Path path2, Charset cs, OpenOption ... options) {
        return Uncheck.apply(Files::newBufferedWriter, path2, cs, options);
    }

    public static BufferedWriter newBufferedWriter(Path path2, OpenOption ... options) {
        return Uncheck.apply(Files::newBufferedWriter, path2, options);
    }

    public static SeekableByteChannel newByteChannel(Path path2, OpenOption ... options) {
        return Uncheck.apply(Files::newByteChannel, path2, options);
    }

    public static SeekableByteChannel newByteChannel(Path path2, Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        return Uncheck.apply(Files::newByteChannel, path2, options, attrs);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir) {
        return Uncheck.apply(Files::newDirectoryStream, dir);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir, DirectoryStream.Filter<? super Path> filter2) {
        return Uncheck.apply(Files::newDirectoryStream, dir, filter2);
    }

    public static DirectoryStream<Path> newDirectoryStream(Path dir, String glob) {
        return Uncheck.apply(Files::newDirectoryStream, dir, glob);
    }

    public static InputStream newInputStream(Path path2, OpenOption ... options) {
        return Uncheck.apply(Files::newInputStream, path2, options);
    }

    public static OutputStream newOutputStream(Path path2, OpenOption ... options) {
        return Uncheck.apply(Files::newOutputStream, path2, options);
    }

    public static String probeContentType(Path path2) {
        return Uncheck.apply(Files::probeContentType, path2);
    }

    public static byte[] readAllBytes(Path path2) {
        return Uncheck.apply(Files::readAllBytes, path2);
    }

    public static List<String> readAllLines(Path path2) {
        return Uncheck.apply(Files::readAllLines, path2);
    }

    public static List<String> readAllLines(Path path2, Charset cs) {
        return Uncheck.apply(Files::readAllLines, path2, cs);
    }

    public static <A extends BasicFileAttributes> A readAttributes(Path path2, Class<A> type, LinkOption ... options) {
        return (A)Uncheck.apply(Files::readAttributes, path2, type, options);
    }

    public static Map<String, Object> readAttributes(Path path2, String attributes2, LinkOption ... options) {
        return Uncheck.apply(Files::readAttributes, path2, attributes2, options);
    }

    public static Path readSymbolicLink(Path link) {
        return Uncheck.apply(Files::readSymbolicLink, link);
    }

    public static Path setAttribute(Path path2, String attribute, Object value, LinkOption ... options) {
        return Uncheck.apply(Files::setAttribute, path2, attribute, value, options);
    }

    public static Path setLastModifiedTime(Path path2, FileTime time) {
        return Uncheck.apply(Files::setLastModifiedTime, path2, time);
    }

    public static Path setOwner(Path path2, UserPrincipal owner) {
        return Uncheck.apply(Files::setOwner, path2, owner);
    }

    public static Path setPosixFilePermissions(Path path2, Set<PosixFilePermission> perms) {
        return Uncheck.apply(Files::setPosixFilePermissions, path2, perms);
    }

    public static long size(Path path2) {
        return Uncheck.apply(Files::size, path2);
    }

    public static Stream<Path> walk(Path start2, FileVisitOption ... options) {
        return Uncheck.apply(Files::walk, start2, options);
    }

    public static Stream<Path> walk(Path start2, int maxDepth, FileVisitOption ... options) {
        return Uncheck.apply(Files::walk, start2, maxDepth, options);
    }

    public static Path walkFileTree(Path start2, FileVisitor<? super Path> visitor) {
        return Uncheck.apply(Files::walkFileTree, start2, visitor);
    }

    public static Path walkFileTree(Path start2, Set<FileVisitOption> options, int maxDepth, FileVisitor<? super Path> visitor) {
        return Uncheck.apply(Files::walkFileTree, start2, options, maxDepth, visitor);
    }

    public static Path write(Path path2, byte[] bytes, OpenOption ... options) {
        return Uncheck.apply(Files::write, path2, bytes, options);
    }

    public static Path write(Path path2, Iterable<? extends CharSequence> lines, Charset cs, OpenOption ... options) {
        return Uncheck.apply(Files::write, path2, lines, cs, options);
    }

    public static Path write(Path path2, Iterable<? extends CharSequence> lines, OpenOption ... options) {
        return Uncheck.apply(Files::write, path2, lines, options);
    }

    private FilesUncheck() {
    }
}

