/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.relocated.com.github.weisj.jsvg.attributes.filter.FilterChannelKey;
import org.jetbrains.relocated.com.github.weisj.jsvg.nodes.filter.IllegalFilterStateException;
import org.jetbrains.relocated.com.github.weisj.jsvg.util.ConstantProvider;
import org.jetbrains.relocated.com.github.weisj.jsvg.util.LazyProvider;
import org.jetbrains.relocated.com.github.weisj.jsvg.util.Provider;

public final class ChannelStorage<T> {
    @NotNull
    private final @NotNull Map<@NotNull Object, @NotNull Provider<T>> storage = new HashMap<Object, Provider<T>>();

    public void addResult(@NotNull FilterChannelKey key, @NotNull T value) {
        this.storage.put(key.key(), new ConstantProvider<T>(value));
    }

    public void addResult(@NotNull FilterChannelKey key, @NotNull Supplier<T> value) {
        this.storage.put(key.key(), new LazyProvider<T>(value));
    }

    @NotNull
    public T get(@NotNull FilterChannelKey key) {
        Provider<T> provider = this.storage.get(key.key());
        if (provider == null) {
            throw new IllegalFilterStateException("Channel " + key + " not found.");
        }
        return provider.get();
    }
}

