/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.intellij.openapi.util.Comparing;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.ValueModifierUtil;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.wip.EvaluateSessionKt;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipCallFrameKt;
import org.jetbrains.wip.WipEvaluateContextBase;
import org.jetbrains.wip.WipSuspendContextManagerKt;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.protocol.WipRequest;
import org.jetbrains.wip.protocol.debugger.CallFrameValue;
import org.jetbrains.wip.protocol.debugger.DebuggerKt;
import org.jetbrains.wip.protocol.debugger.EvaluateOnCallFrameResult;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.debugger.ScopeValue;
import org.jetbrains.wip.protocol.runtime.CallArgument;
import org.jetbrains.wip.protocol.runtime.RemoteObjectValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000}\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004*\u0001?\u0018\u00002\u00020\u0001:\u0001EB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\n\u0010D\u001a\u00020\u000fH\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001e\u0010'\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\u0011R\u0010\u0010)\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010*\u001a\u0004\u0018\u00010\u000f2\b\u0010&\u001a\u0004\u0018\u00010\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0011R\u0014\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u0018008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u0014\u00103\u001a\u0002048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u00107\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0016R\u0016\u00109\u001a\n\u0012\u0004\u0012\u00020:\u0018\u00010-X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020:0-8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=R\u0010\u0010>\u001a\u00020?X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010@\u00a8\u0006F"}, d2={"Lorg/jetbrains/wip/WipCallFrame;", "Lorg/jetbrains/debugger/CallFrame;", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "cf", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "<init>", "(Lorg/jetbrains/wip/WipValueManager;Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;)V", "line", "", "getLine", "()I", "column", "getColumn", "functionName", "", "getFunctionName", "()Ljava/lang/String;", "asyncFunctionName", "getAsyncFunctionName", "isFromAsyncStack", "", "()Z", "returnValue", "Lorg/jetbrains/debugger/Variable;", "getReturnValue", "()Lorg/jetbrains/debugger/Variable;", "evaluateContext", "Lorg/jetbrains/wip/WipEvaluateContextBase;", "Lorg/jetbrains/wip/protocol/debugger/EvaluateOnCallFrameResult;", "getEvaluateContext", "()Lorg/jetbrains/wip/WipEvaluateContextBase;", "functionLocation", "Lorg/jetbrains/wip/protocol/debugger/LocationValue;", "getFunctionLocation", "()Lorg/jetbrains/wip/protocol/debugger/LocationValue;", "setFunctionLocation", "(Lorg/jetbrains/wip/protocol/debugger/LocationValue;)V", "value", "id", "getId", "thisObject", "scriptId", "getScriptId", "scopesData", "", "Lorg/jetbrains/wip/protocol/debugger/ScopeValue;", "receiverVariable", "Lorg/jetbrains/concurrency/Promise;", "getReceiverVariable", "()Lorg/jetbrains/concurrency/Promise;", "equalityObject", "", "getEqualityObject", "()Ljava/lang/Object;", "hasOnlyGlobalScope", "getHasOnlyGlobalScope", "_variableScopes", "Lorg/jetbrains/debugger/Scope;", "variableScopes", "getVariableScopes", "()Ljava/util/List;", "returnValueModifier", "org/jetbrains/wip/WipCallFrame$returnValueModifier$1", "Lorg/jetbrains/wip/WipCallFrame$returnValueModifier$1;", "reinit", "", "frameData", "toString", "WipCallFrameEvaluateContext", "intellij.javascript.wip.backend"})
public final class WipCallFrame
implements CallFrame {
    @NotNull
    private final WipValueManager valueManager;
    private final int line;
    private final int column;
    @Nullable
    private final String functionName;
    @Nullable
    private final String asyncFunctionName;
    @Nullable
    private final Variable returnValue;
    @NotNull
    private final WipEvaluateContextBase<EvaluateOnCallFrameResult> evaluateContext;
    @Nullable
    private LocationValue functionLocation;
    @NotNull
    private String id;
    @Nullable
    private Variable thisObject;
    @Nullable
    private String scriptId;
    @NotNull
    private List<? extends ScopeValue> scopesData;
    @Nullable
    private List<? extends Scope> _variableScopes;
    @NotNull
    private final returnValueModifier.1 returnValueModifier;

    public WipCallFrame(@NotNull WipValueManager valueManager, @NotNull CallFrameValue cf) {
        Intrinsics.checkNotNullParameter((Object)((Object)valueManager), (String)"valueManager");
        Intrinsics.checkNotNullParameter((Object)cf, (String)"cf");
        this.valueManager = valueManager;
        this.scopesData = CollectionsKt.emptyList();
        this.returnValueModifier = new ValueModifier(this){
            final /* synthetic */ WipCallFrame this$0;
            {
                this.this$0 = $receiver;
            }

            public Promise<?> setValue(Variable variable, Value newValue, EvaluateContext evaluateContext) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
                variable.setValue(newValue);
                return WipCallFrame.access$getValueManager$p(this.this$0).getVm().getCommandProcessor().send((Request)DebuggerKt.SetReturnValue((CallArgument)EvaluateSessionKt.createCallArgument(newValue)));
            }

            public Promise<?> setValue(Variable variable, String newValue, EvaluateContext evaluateContext) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)newValue, (String)"newValue");
                Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
                return ValueModifierUtil.INSTANCE.setValue(variable, "{\n(" + newValue + ")\n}", evaluateContext, (ValueModifier)this);
            }

            public Promise<Value> evaluateGet(Variable variable, EvaluateContext evaluateContext) {
                Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
                Intrinsics.checkNotNullParameter((Object)evaluateContext, (String)"evaluateContext");
                return ValueModifierUtil.INSTANCE.evaluateGet(variable, (Object)this, evaluateContext, "this");
            }
        };
        this.evaluateContext = new WipCallFrameEvaluateContext(this.valueManager);
        this.line = cf.location().getLineNumber();
        this.column = cf.location().getColumnNumber();
        this.functionName = cf.functionName();
        this.functionLocation = cf.getFunctionLocation();
        this.asyncFunctionName = null;
        this.id = cf.callFrameId();
        this.reinit(cf, this.valueManager);
        this.returnValue = cf.getReturnValue() != null ? (Variable)this.valueManager.createVariable("returnValue", cf.getReturnValue(), this.returnValueModifier) : null;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    @Nullable
    public String getFunctionName() {
        return this.functionName;
    }

    @Nullable
    public String getAsyncFunctionName() {
        return this.asyncFunctionName;
    }

    public boolean isFromAsyncStack() {
        return false;
    }

    @Nullable
    public Variable getReturnValue() {
        return this.returnValue;
    }

    @NotNull
    public WipEvaluateContextBase<EvaluateOnCallFrameResult> getEvaluateContext() {
        return this.evaluateContext;
    }

    @Nullable
    public final LocationValue getFunctionLocation() {
        return this.functionLocation;
    }

    public final void setFunctionLocation(@Nullable LocationValue locationValue) {
        this.functionLocation = locationValue;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @Nullable
    public final String getScriptId() {
        return this.scriptId;
    }

    @NotNull
    public Promise<Variable> getReceiverVariable() {
        return Promises.resolvedPromise((Object)this.thisObject);
    }

    @NotNull
    public Object getEqualityObject() {
        return this.scriptId + "#" + this.getFunctionName();
    }

    public boolean getHasOnlyGlobalScope() {
        return this.scopesData.size() == 1 && ((ScopeValue)CollectionsKt.first(this.scopesData)).type() == ScopeValue.Type.GLOBAL;
    }

    @NotNull
    public List<Scope> getVariableScopes() {
        if (this._variableScopes == null) {
            this._variableScopes = ArraysKt.asList((Object[])WipSuspendContextManagerKt.createScopes(this.scopesData, this.id, this.valueManager));
        }
        List<Scope> list = this._variableScopes;
        Intrinsics.checkNotNull(list);
        return list;
    }

    private final void reinit(CallFrameValue frameData, WipValueManager valueManager) {
        WipCallFrameKt.access$getLOG$p().assertTrue(Comparing.strEqual((String)frameData.functionName(), (String)this.getFunctionName()));
        WipCallFrameKt.access$getLOG$p().assertTrue(this.getLine() == frameData.location().getLineNumber());
        this.scopesData = frameData.scopeChain();
        this._variableScopes = null;
        this.id = frameData.callFrameId();
        this.scriptId = frameData.location().scriptId();
        RemoteObjectValue thisObjectData = frameData.getGetThis();
        if (thisObjectData == null) {
            WipCallFrameKt.access$getLOG$p().warn("Missing local scope");
            this.thisObject = null;
        } else {
            this.thisObject = (Variable)valueManager.createVariable("this", thisObjectData, null);
        }
    }

    @NotNull
    public String toString() {
        return this.scriptId + " " + this.getFunctionName() + " " + this.getLine() + ":" + this.getColumn();
    }

    public static final /* synthetic */ WipValueManager access$getValueManager$p(WipCallFrame $this) {
        return $this.valueManager;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0014J\u0014\u0010\u0011\u001a\u00060\u0000R\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/wip/WipCallFrame$WipCallFrameEvaluateContext;", "Lorg/jetbrains/wip/WipEvaluateContextBase;", "Lorg/jetbrains/wip/protocol/debugger/EvaluateOnCallFrameResult;", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "<init>", "(Lorg/jetbrains/wip/WipCallFrame;Lorg/jetbrains/wip/WipValueManager;)V", "createRequest", "Lorg/jetbrains/wip/protocol/WipRequest;", "expression", "", "awaitPromise", "", "getRemoteObjectValue", "Lorg/jetbrains/wip/protocol/runtime/RemoteObjectValue;", "data", "getWasThrown", "withValueManager", "Lorg/jetbrains/wip/WipCallFrame;", "objectGroup", "intellij.javascript.wip.backend"})
    private final class WipCallFrameEvaluateContext
    extends WipEvaluateContextBase<EvaluateOnCallFrameResult> {
        public WipCallFrameEvaluateContext(WipValueManager valueManager) {
            Intrinsics.checkNotNullParameter((Object)((Object)valueManager), (String)"valueManager");
            super(valueManager);
        }

        @Override
        @NotNull
        public WipRequest<EvaluateOnCallFrameResult> createRequest(@NotNull String expression, @NotNull WipValueManager valueManager, boolean awaitPromise) {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)((Object)valueManager), (String)"valueManager");
            return DebuggerKt.EvaluateOnCallFrame$default((CharSequence)WipCallFrame.this.getId(), (CharSequence)expression, (CharSequence)valueManager.getObjectGroupId$intellij_javascript_wip_backend(), null, null, null, (Boolean)true, null, null, (int)440, null);
        }

        @Override
        @NotNull
        protected RemoteObjectValue getRemoteObjectValue(@NotNull EvaluateOnCallFrameResult data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data.result();
        }

        @Override
        protected boolean getWasThrown(@NotNull EvaluateOnCallFrameResult data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return data.getExceptionDetails() != null;
        }

        @NotNull
        public WipCallFrameEvaluateContext withValueManager(@NotNull String objectGroup) {
            Intrinsics.checkNotNullParameter((Object)objectGroup, (String)"objectGroup");
            return new WipCallFrameEvaluateContext(new WipValueManager(((WipValueManager)this.getValueManager()).getVm(), objectGroup));
        }
    }
}

