/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.handlers.fixers;

import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.codeInsight.handlers.fixers.FixersUtilKt;
import org.jetbrains.kotlin.idea.codeInsight.handlers.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/handlers/fixers/KotlinMissingIfBranchFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/codeInsight/handlers/KotlinSmartEnterHandler;", "<init>", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "element", "Lcom/intellij/psi/PsiElement;", "intellij.kotlin.base.codeInsight.minimal"})
public final class KotlinMissingIfBranchFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor, @NotNull PsiElement element) {
        boolean probablyNextStatementParsedAsThen;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)((Object)processor), (String)"processor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof KtIfExpression)) {
            return;
        }
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        KtExpression elseBranch = ((KtIfExpression)element).getElse();
        PsiElement elseKeyword = ((KtIfExpression)element).getElseKeyword();
        if (elseKeyword != null && (elseBranch == null || !(elseBranch instanceof KtBlockExpression) && FixersUtilKt.startLine((PsiElement)elseBranch, document2) > FixersUtilKt.startLine(elseKeyword, document2))) {
            document2.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(elseKeyword)), (CharSequence)"{}");
            return;
        }
        KtExpression thenBranch = ((KtIfExpression)element).getThen();
        if (thenBranch instanceof KtBlockExpression) {
            return;
        }
        PsiElement psiElement = ((KtIfExpression)element).getRightParenthesis();
        if (psiElement == null) {
            return;
        }
        PsiElement rParen = psiElement;
        boolean transformingOneLiner = false;
        if (thenBranch != null && FixersUtilKt.startLine((PsiElement)thenBranch, document2) == FixersUtilKt.startLine(rParen, document2)) {
            if (((KtIfExpression)element).getCondition() != null) {
                return;
            }
            transformingOneLiner = true;
        }
        boolean bl = probablyNextStatementParsedAsThen = elseKeyword == null && elseBranch == null && !transformingOneLiner;
        if (thenBranch == null || probablyNextStatementParsedAsThen) {
            document2.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(rParen)), (CharSequence)"{}");
        } else {
            document2.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange(rParen)), (CharSequence)"{");
            document2.insertString(FixersUtilKt.getEnd(FixersUtilKt.getRange((PsiElement)thenBranch)) + 1, (CharSequence)"}");
        }
    }
}

