/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.refactoring.SqlSubqueryUtils;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J!\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/sql/intentions/SqlExtractNamedQueryIntention;", "Lcom/intellij/sql/intentions/SqlBaseElementAtCaretIntentionAction;", "isPreview", "", "<init>", "(Z)V", "getFamilyName", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "getFileModifierForPreview", "target", "Lcom/intellij/psi/PsiFile;", "invoke", "", "intellij.database.sql.impl"})
public final class SqlExtractNamedQueryIntention
extends SqlBaseElementAtCaretIntentionAction {
    private final boolean isPreview;

    @JvmOverloads
    public SqlExtractNamedQueryIntention(boolean isPreview) {
        this.isPreview = isPreview;
    }

    public /* synthetic */ SqlExtractNamedQueryIntention(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"intention.family.extract.named.query", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!SqlSubqueryUtils.isCTESupported(element.getContainingFile())) {
            return false;
        }
        SqlExpression sqlExpression = SqlSubqueryUtils.findCteAbleParent((PsiElement)element, (boolean)false);
        if (sqlExpression == null) {
            return false;
        }
        SqlExpression subquery = sqlExpression;
        SqlExpression sqlExpression2 = SqlSubqueryUtils.findEnclosingQueryWithContext((PsiElement)((PsiElement)subquery));
        if (sqlExpression2 == null) {
            return false;
        }
        SqlExpression query = sqlExpression2;
        return SqlSubqueryUtils.isSubquery(query, subquery) && SqlSubqueryUtils.canExtractWithoutContextLoss(subquery);
    }

    @NotNull
    public SqlExtractNamedQueryIntention getFileModifierForPreview(@NotNull PsiFile target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new SqlExtractNamedQueryIntention(true);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        SqlExpression sqlExpression = SqlSubqueryUtils.findCteAbleParent((PsiElement)element, (boolean)false);
        if (sqlExpression == null) {
            return;
        }
        SqlExpression subquery = sqlExpression;
        SqlExpression sqlExpression2 = SqlSubqueryUtils.findEnclosingQueryWithContext((PsiElement)((PsiElement)subquery));
        if (sqlExpression2 == null) {
            return;
        }
        SqlExpression query = sqlExpression2;
        SqlSubqueryUtils.extractCte(project, editor, element.getContainingFile(), subquery, query, this.isPreview);
    }

    @JvmOverloads
    public SqlExtractNamedQueryIntention() {
        this(false, 1, null);
    }
}

