/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.merge;

import com.intellij.diff.fragments.MergeLineFragment;
import com.intellij.diff.merge.MergeModelBase;
import com.intellij.diff.tools.simple.ThreesideDiffChangeBase;
import com.intellij.diff.util.MergeConflictType;
import com.intellij.diff.util.Side;
import com.intellij.diff.util.TextDiffType;
import com.intellij.diff.util.ThreeSide;
import com.intellij.openapi.editor.Editor;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0018\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u00002\u00020\u0001:\u0002/0B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0016\u001a\u00020\u0005H\u0007J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cJ\u0006\u0010\u001e\u001a\u00020\u001aJ\b\u0010\u001f\u001a\u00020\u001aH\u0007J\u0010\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020 H\u0016J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020 H\u0016J\u0010\u0010&\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020 H\u0016J\u0006\u0010+\u001a\u00020\fJ\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\fJ\b\u0010.\u001a\u00020\u001aH\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R \u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00058\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0011R\u0011\u0010\u001d\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0011\u0010!\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010R\u0011\u0010#\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0010R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00061"}, d2={"Lcom/intellij/diff/merge/TextMergeChange;", "Lcom/intellij/diff/tools/simple/ThreesideDiffChangeBase;", "index", "", "isImportChange", "", "fragment", "Lcom/intellij/diff/fragments/MergeLineFragment;", "conflictType", "Lcom/intellij/diff/util/MergeConflictType;", "model", "Lcom/intellij/diff/merge/MergeModelBase;", "Lcom/intellij/diff/merge/TextMergeChange$State;", "<init>", "(IZLcom/intellij/diff/fragments/MergeLineFragment;Lcom/intellij/diff/util/MergeConflictType;Lcom/intellij/diff/merge/MergeModelBase;)V", "getIndex", "()I", "()Z", "getFragment", "()Lcom/intellij/diff/fragments/MergeLineFragment;", "resolved", "", "value", "isOnesideAppliedConflict", "isResolvedWithAI", "setResolved", "", "side", "Lcom/intellij/diff/util/Side;", "isResolved", "markOnesideAppliedConflict", "markChangeResolvedWithAI", "Lcom/intellij/diff/util/ThreeSide;", "resultStartLine", "getResultStartLine", "resultEndLine", "getResultEndLine", "getStartLine", "getEndLine", "diffType", "Lcom/intellij/diff/util/TextDiffType;", "getDiffType", "()Lcom/intellij/diff/util/TextDiffType;", "storeState", "restoreState", "state", "resetState", "State", "AIResolvedDiffType", "intellij.platform.diff.impl"})
@ApiStatus.Internal
public final class TextMergeChange
extends ThreesideDiffChangeBase {
    private final int index;
    private final boolean isImportChange;
    @NotNull
    private final MergeLineFragment fragment;
    @NotNull
    private final MergeModelBase<State> model;
    @NotNull
    private final boolean[] resolved;
    private boolean isOnesideAppliedConflict;
    private boolean isResolvedWithAI;

    public TextMergeChange(int index, boolean isImportChange, @NotNull MergeLineFragment fragment, @NotNull MergeConflictType conflictType, @NotNull MergeModelBase<State> model) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)conflictType, (String)"conflictType");
        Intrinsics.checkNotNullParameter(model, (String)"model");
        super(conflictType);
        this.index = index;
        this.isImportChange = isImportChange;
        this.fragment = fragment;
        this.model = model;
        this.resolved = new boolean[2];
    }

    public final int getIndex() {
        return this.index;
    }

    public final boolean isImportChange() {
        return this.isImportChange;
    }

    @NotNull
    public final MergeLineFragment getFragment() {
        return this.fragment;
    }

    public final boolean isOnesideAppliedConflict() {
        return this.isOnesideAppliedConflict;
    }

    @ApiStatus.Internal
    public final boolean isResolvedWithAI() {
        return this.isResolvedWithAI;
    }

    @RequiresEdt
    public final void setResolved(@NotNull Side side, boolean value) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        this.resolved[side.getIndex()] = value;
    }

    public final boolean isResolved() {
        return this.resolved[0] && this.resolved[1];
    }

    public final boolean isResolved(@NotNull Side side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return side.select(this.resolved);
    }

    public final void markOnesideAppliedConflict() {
        this.isOnesideAppliedConflict = true;
    }

    @ApiStatus.Internal
    public final void markChangeResolvedWithAI() {
        this.isResolvedWithAI = true;
    }

    @Override
    public boolean isResolved(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return switch (WhenMappings.$EnumSwitchMapping$0[side.ordinal()]) {
            case 1 -> this.isResolved(Side.LEFT);
            case 2 -> this.isResolved();
            case 3 -> this.isResolved(Side.RIGHT);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final int getResultStartLine() {
        return this.model.getLineStart(this.index);
    }

    public final int getResultEndLine() {
        return this.model.getLineEnd(this.index);
    }

    @Override
    public int getStartLine(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (side == ThreeSide.BASE) {
            return this.getResultStartLine();
        }
        return this.fragment.getStartLine(side);
    }

    @Override
    public int getEndLine(@NotNull ThreeSide side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        if (side == ThreeSide.BASE) {
            return this.getResultEndLine();
        }
        return this.fragment.getEndLine(side);
    }

    @Override
    @NotNull
    public TextDiffType getDiffType() {
        TextDiffType baseType = super.getDiffType();
        if (!this.isResolvedWithAI) {
            return baseType;
        }
        return new AIResolvedDiffType(baseType);
    }

    @NotNull
    public final State storeState() {
        return new State(this.index, this.getResultStartLine(), this.getResultEndLine(), this.resolved[0], this.resolved[1], this.isOnesideAppliedConflict, this.isResolvedWithAI);
    }

    public final void restoreState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.resolved[0] = state.getResolved1();
        this.resolved[1] = state.getResolved2();
        this.isOnesideAppliedConflict = state.getOnesideAppliedConflict();
        this.isResolvedWithAI = state.isResolvedByAI();
    }

    @ApiStatus.Internal
    public final void resetState() {
        this.resolved[0] = false;
        this.resolved[1] = false;
        this.isOnesideAppliedConflict = false;
        this.isResolvedWithAI = false;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J)\u0010\t\u001a\f0\u0006\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000b2\u0014\b\u0001\u0010\u0007\u001a\u000e\u0018\u00010\b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\u000bH\u0097\u0001J+\u0010\r\u001a\u000e\u0018\u00010\u0006\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\u000b2\u0014\b\u0001\u0010\u0007\u001a\u000e\u0018\u00010\b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0002\b\u000bH\u0097\u0001J\u0013\u0010\u000e\u001a\f0\u000f\u00a2\u0006\u0002\b\n\u00a2\u0006\u0002\b\u000bH\u0097\u0001R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/diff/merge/TextMergeChange$AIResolvedDiffType;", "Lcom/intellij/diff/util/TextDiffType;", "baseType", "<init>", "(Lcom/intellij/diff/util/TextDiffType;)V", "getColor", "Ljava/awt/Color;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getIgnoredColor", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "Lorg/jetbrains/annotations/Nullable;", "getMarkerColor", "getName", "", "intellij.platform.diff.impl"})
    private static final class AIResolvedDiffType
    implements TextDiffType {
        @NotNull
        private final TextDiffType baseType;

        public AIResolvedDiffType(@NotNull TextDiffType baseType) {
            Intrinsics.checkNotNullParameter((Object)baseType, (String)"baseType");
            this.baseType = baseType;
        }

        @Override
        @NotNull
        public Color getColor(@Nullable Editor editor) {
            return (Color)new JBColor(8605168, 10842598);
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.baseType.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return string;
        }

        @Override
        @NotNull
        public Color getIgnoredColor(@Nullable Editor editor) {
            Color color = this.baseType.getIgnoredColor(editor);
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getIgnoredColor(...)");
            return color;
        }

        @Override
        @Nullable
        public Color getMarkerColor(@Nullable Editor editor) {
            return this.baseType.getMarkerColor(editor);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lcom/intellij/diff/merge/TextMergeChange$State;", "Lcom/intellij/diff/merge/MergeModelBase$State;", "index", "", "startLine", "endLine", "resolved1", "", "resolved2", "onesideAppliedConflict", "isResolvedByAI", "<init>", "(IIIZZZZ)V", "getResolved1", "()Z", "getResolved2", "getOnesideAppliedConflict", "intellij.platform.diff.impl"})
    public static final class State
    extends MergeModelBase.State {
        private final boolean resolved1;
        private final boolean resolved2;
        private final boolean onesideAppliedConflict;
        private final boolean isResolvedByAI;

        public State(int index, int startLine, int endLine, boolean resolved1, boolean resolved2, boolean onesideAppliedConflict, boolean isResolvedByAI) {
            super(index, startLine, endLine);
            this.resolved1 = resolved1;
            this.resolved2 = resolved2;
            this.onesideAppliedConflict = onesideAppliedConflict;
            this.isResolvedByAI = isResolvedByAI;
        }

        public final boolean getResolved1() {
            return this.resolved1;
        }

        public final boolean getResolved2() {
            return this.resolved2;
        }

        public final boolean getOnesideAppliedConflict() {
            return this.onesideAppliedConflict;
        }

        public final boolean isResolvedByAI() {
            return this.isResolvedByAI;
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeSide.values().length];
            try {
                nArray[ThreeSide.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeSide.BASE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeSide.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

