/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.util.DiffEmptyHighlighterRenderer;
import com.intellij.diff.util.DiffLineMarkerRenderer;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.LineRange;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRendererEx;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DiffDrawUtil {
    private static final Logger LOG = Logger.getInstance(DiffDrawUtil.class);
    public static final int STRIPE_LAYER = 4999;
    public static final int BASE_LAYER = 5897;
    public static final int DEFAULT_LAYER = 5898;
    public static final int INLINE_LAYER = 5899;
    public static final int LINE_MARKER_LAYER = 5900;
    public static final int LAYER_PRIORITY_STEP = 5;
    public static final int LAYER_PRIORITY_LST = 1;
    public static final int LAYER_PRIORITY_MAX = 3;
    public static final int LST_LINE_MARKER_LAYER = 5999;
    public static final Key<Boolean> EDITOR_WITH_HIGH_PRIORITY_RENDERER = Key.create((String)"DiffDrawUtil.EDITOR_WITH_HIGH_PRIORITY_RENDERER");
    private static final double CTRL_PROXIMITY_X = 0.3;
    public static final LineSeparatorRenderer BORDER_LINE_RENDERER = new LineSeparatorRenderer(){

        public void drawLine(Graphics g, int x1, int x2, int y) {
            Rectangle clip = g.getClipBounds();
            x2 = clip.x + clip.width;
            g.setColor(JBColor.border());
            g.drawLine(x1, y, x2, y);
        }
    };

    private DiffDrawUtil() {
    }

    @NotNull
    public static Color getDividerColor() {
        return DiffDrawUtil.getDividerColor(null);
    }

    @NotNull
    public static Color getDividerColor(@Nullable Editor editor) {
        EditorGutter gutter;
        EditorGutter editorGutter = gutter = editor != null ? editor.getGutter() : null;
        if (gutter instanceof EditorGutterComponentEx) {
            Color color = ((EditorGutterComponentEx)gutter).getBackground();
            if (color == null) {
                DiffDrawUtil.$$$reportNull$$$0(0);
            }
            return color;
        }
        return DiffDrawUtil.getDividerColorFromScheme(editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme());
    }

    @NotNull
    public static Color getDividerColorFromScheme(@NotNull EditorColorsScheme scheme) {
        Color gutterBackground;
        if (scheme == null) {
            DiffDrawUtil.$$$reportNull$$$0(1);
        }
        if ((gutterBackground = scheme.getColor(EditorColors.GUTTER_BACKGROUND)) == null) {
            gutterBackground = EditorColors.GUTTER_BACKGROUND.getDefaultColor();
        }
        Color color = gutterBackground;
        if (color == null) {
            DiffDrawUtil.$$$reportNull$$$0(2);
        }
        return color;
    }

    public static void drawChunkBorderLine(@NotNull Graphics2D g, int x1, int x2, int y, @NotNull Color color, boolean doubleLine, boolean dottedLine) {
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(3);
        }
        if (color == null) {
            DiffDrawUtil.$$$reportNull$$$0(4);
        }
        if (dottedLine && doubleLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)y, null, (Color)color, (boolean)false);
        } else if (dottedLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
        } else if (doubleLine) {
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)(y + 1), (int)x2, (int)(y + 1), null, (Color)color);
        } else {
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
        }
    }

    public static void drawTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(5);
        }
        if (fillColor != null) {
            int[] xPoints = new int[]{x1, x2, x2, x1};
            int[] yPoints = new int[]{start1, start2, end2 + 1, end1 + 1};
            g.setColor(fillColor);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawLine(x1, start1, x2, start2);
            g.drawLine(x1, end1, x2, end2);
        }
    }

    public static void drawCurveTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(6);
        }
        if (fillColor != null) {
            g.setColor(fillColor);
            g.fill(DiffDrawUtil.makeCurvePath(x1, x2, start1, start2, end1 + 1, end2 + 1));
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(JBUIScale.scale((float)1.0f)));
            g.draw(DiffDrawUtil.makeCurve(x1, x2, (start1 + end1) / 2, (start2 + end2) / 2, true));
            g.setStroke(oldStroke);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            DiffDrawUtil.drawCurveLine(g, x1, x2, start1, start2);
            DiffDrawUtil.drawCurveLine(g, x1, x2, end1, end2);
        }
    }

    private static void drawCurveLine(@NotNull Graphics2D g, int x1, int x2, int y1, int y2) {
        boolean isHighSlope;
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(7);
        }
        boolean bl = isHighSlope = Math.abs(x2 - x1) < Math.abs(y2 - y1);
        if (!isHighSlope && DiffDrawUtil.isThickSimpleStroke(g)) {
            g.fill(DiffDrawUtil.makeCurvePath(x1, x2, y1, y2, y1 + 1, y2 + 1));
        } else {
            g.draw(DiffDrawUtil.makeCurve(x1, x2, y1, y2, true));
        }
    }

    private static boolean isThickSimpleStroke(@NotNull Graphics2D g) {
        Stroke stroke;
        if (g == null) {
            DiffDrawUtil.$$$reportNull$$$0(8);
        }
        if ((stroke = g.getStroke()) instanceof BasicStroke) {
            float strokeWidth = ((BasicStroke)stroke).getLineWidth();
            return (double)strokeWidth == 1.0 && PaintUtil.devValue((double)strokeWidth, (Graphics2D)g) > 1.0;
        }
        return false;
    }

    @NotNull
    private static Path2D makeCurvePath(int x1, int x2, int y11, int y12, int y21, int y22) {
        Path2D.Double path = new Path2D.Double();
        path.append(DiffDrawUtil.makeCurve(x1, x2, y11, y12, true), true);
        path.append(DiffDrawUtil.makeCurve(x1, x2, y21, y22, false), true);
        path.closePath();
        Path2D.Double double_ = path;
        if (double_ == null) {
            DiffDrawUtil.$$$reportNull$$$0(9);
        }
        return double_;
    }

    private static Shape makeCurve(int x1, int x2, int y1, int y2, boolean forward) {
        int width = x2 - x1;
        if (forward) {
            return new CubicCurve2D.Double(x1, y1, (double)x1 + (double)width * 0.3, y1, (double)x1 + (double)width * 0.7, y2, x1 + width, y2);
        }
        return new CubicCurve2D.Double(x1 + width, y2, (double)x1 + (double)width * 0.7, y2, (double)x1 + (double)width * 0.3, y1, x1, y1);
    }

    public static int lineToY(@NotNull Editor editor, int line) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(10);
        }
        return DiffDrawUtil.lineToY(editor, line, true, false);
    }

    public static int lineToY(@NotNull Editor editor, int line, boolean lineStart) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(11);
        }
        return DiffDrawUtil.lineToY(editor, line, lineStart, false);
    }

    public static int lineToY(@NotNull Editor editor, int line, boolean lineStart, boolean includeInlays) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(12);
        }
        if (line < 0) {
            return 0;
        }
        Document document = editor.getDocument();
        if (line >= DiffUtil.getLineCount(document)) {
            int y = editor.logicalPositionToXY((LogicalPosition)editor.offsetToLogicalPosition((int)document.getTextLength())).y;
            int tailLines = line - DiffUtil.getLineCount(document) + (lineStart ? 0 : 1);
            return y + editor.getLineHeight() * tailLines;
        }
        if (lineStart) {
            int visualLine = editor.offsetToVisualPosition((int)document.getLineStartOffset((int)line), (boolean)false, (boolean)false).line;
            int inlay = includeInlays ? EditorUtil.getInlaysHeight((Editor)editor, (int)visualLine, (boolean)true) : 0;
            return editor.visualLineToY(visualLine) - inlay;
        }
        int visualLine = editor.offsetToVisualPosition((int)document.getLineEndOffset((int)line), (boolean)true, (boolean)true).line;
        int inlay = includeInlays ? EditorUtil.getInlaysHeight((Editor)editor, (int)visualLine, (boolean)false) : 0;
        return editor.visualLineToY(visualLine) + editor.getLineHeight() + inlay;
    }

    @NotNull
    public static MarkerRange getGutterMarkerPaintRange(@NotNull Editor editor, int startLine, int endLine) {
        int y2;
        int y1;
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(13);
        }
        if (startLine == endLine) {
            y1 = startLine == 0 ? DiffDrawUtil.lineToY(editor, 0, true, true) + 1 : DiffDrawUtil.lineToY(editor, startLine - 1, false, true);
            y2 = y1;
        } else {
            y1 = DiffDrawUtil.lineToY(editor, startLine, true, false);
            y2 = DiffDrawUtil.lineToY(editor, endLine - 1, false, false);
        }
        return new MarkerRange(y1, y2);
    }

    @Nullable
    private static TextAttributes getTextAttributes(@NotNull TextDiffType type, @Nullable Editor editor, @NotNull BackgroundType background) {
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(14);
        }
        if (background == null) {
            DiffDrawUtil.$$$reportNull$$$0(15);
        }
        if (background == BackgroundType.NONE) {
            return null;
        }
        return new DiffTextAttributes(background, type, editor);
    }

    @NotNull
    private static TextAttributes getStripeTextAttributes(@NotNull TextDiffType type, @NotNull Editor editor) {
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(17);
        }
        return new DiffStripeMarkerTextAttributes(type, editor);
    }

    private static void installEmptyRangeRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType type) {
        if (highlighter == null) {
            DiffDrawUtil.$$$reportNull$$$0(18);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(19);
        }
        highlighter.setCustomRenderer((CustomHighlighterRenderer)new DiffEmptyHighlighterRenderer(type));
    }

    @NotNull
    public static List<RangeHighlighter> createUnifiedChunkHighlighters(@NotNull Editor editor, @NotNull LineRange deleted, @NotNull LineRange inserted, @Nullable List<? extends DiffFragment> innerFragments) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(20);
        }
        if (deleted == null) {
            DiffDrawUtil.$$$reportNull$$$0(21);
        }
        if (inserted == null) {
            DiffDrawUtil.$$$reportNull$$$0(22);
        }
        return DiffDrawUtil.createUnifiedChunkHighlighters(editor, deleted, inserted, false, false, innerFragments);
    }

    @NotNull
    public static List<RangeHighlighter> createUnifiedChunkHighlighters(@NotNull Editor editor, @NotNull LineRange deleted, @NotNull LineRange inserted, boolean excluded, boolean skipped, @Nullable List<? extends DiffFragment> innerFragments) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(23);
        }
        if (deleted == null) {
            DiffDrawUtil.$$$reportNull$$$0(24);
        }
        if (inserted == null) {
            DiffDrawUtil.$$$reportNull$$$0(25);
        }
        boolean ignored = innerFragments != null;
        ArrayList<RangeHighlighter> list = new ArrayList<RangeHighlighter>();
        if (!inserted.isEmpty() && !deleted.isEmpty()) {
            list.addAll(DiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored, skipped, excluded));
            list.addAll(DiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored, skipped, excluded));
        } else if (!inserted.isEmpty()) {
            list.addAll(DiffDrawUtil.createHighlighter(editor, inserted.start, inserted.end, TextDiffType.INSERTED, ignored, skipped, excluded));
        } else if (!deleted.isEmpty()) {
            list.addAll(DiffDrawUtil.createHighlighter(editor, deleted.start, deleted.end, TextDiffType.DELETED, ignored, skipped, excluded));
        }
        if (innerFragments != null && !skipped) {
            int deletedStartOffset = editor.getDocument().getLineStartOffset(deleted.start);
            int insertedStartOffset = editor.getDocument().getLineStartOffset(inserted.start);
            for (DiffFragment diffFragment : innerFragments) {
                int deletedWordStart = deletedStartOffset + diffFragment.getStartOffset1();
                int deletedWordEnd = deletedStartOffset + diffFragment.getEndOffset1();
                list.addAll(DiffDrawUtil.createInlineHighlighter(editor, deletedWordStart, deletedWordEnd, TextDiffType.DELETED));
                int insertedWordStart = insertedStartOffset + diffFragment.getStartOffset2();
                int insertedWordEnd = insertedStartOffset + diffFragment.getEndOffset2();
                list.addAll(DiffDrawUtil.createInlineHighlighter(editor, insertedWordStart, insertedWordEnd, TextDiffType.INSERTED));
            }
        }
        ArrayList<RangeHighlighter> arrayList = list;
        if (arrayList == null) {
            DiffDrawUtil.$$$reportNull$$$0(26);
        }
        return arrayList;
    }

    @NotNull
    private static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored, boolean excludedInEditor, boolean excludedInGutter) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(27);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(28);
        }
        List<RangeHighlighter> list = new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withExcludedInEditor(excludedInEditor).withExcludedInGutter(excludedInGutter).done();
        if (list == null) {
            DiffDrawUtil.$$$reportNull$$$0(29);
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(30);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(31);
        }
        List<RangeHighlighter> list = new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).done();
        if (list == null) {
            DiffDrawUtil.$$$reportNull$$$0(32);
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored, boolean resolved, boolean isExcluded, boolean hideWithoutLineNumbers, boolean hideStripeMarkers) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(33);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(34);
        }
        List<RangeHighlighter> list = new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withResolved(resolved).withExcluded(isExcluded).withHideWithoutLineNumbers(hideWithoutLineNumbers).withHideStripeMarkers(hideStripeMarkers).done();
        if (list == null) {
            DiffDrawUtil.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, @NotNull PaintMode editorMode, @NotNull PaintMode gutterMode) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(36);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(37);
        }
        if (editorMode == null) {
            DiffDrawUtil.$$$reportNull$$$0(38);
        }
        if (gutterMode == null) {
            DiffDrawUtil.$$$reportNull$$$0(39);
        }
        List<RangeHighlighter> list = new LineHighlighterBuilder(editor, startLine, endLine, type).withEditorMode(editorMode).withGutterMode(gutterMode).done();
        if (list == null) {
            DiffDrawUtil.$$$reportNull$$$0(40);
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createInlineHighlighter(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(41);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(42);
        }
        List<RangeHighlighter> list = new InlineHighlighterBuilder(editor, start, end, type).done();
        if (list == null) {
            DiffDrawUtil.$$$reportNull$$$0(43);
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createInlineHighlighter(@NotNull Editor editor, int start, int end, int layer, @NotNull TextDiffType type) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(44);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(45);
        }
        List<RangeHighlighter> list = new InlineHighlighterBuilder(editor, start, end, type).withLayerPriority(layer).done();
        if (list == null) {
            DiffDrawUtil.$$$reportNull$$$0(46);
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(47);
        }
        if (type == null) {
            DiffDrawUtil.$$$reportNull$$$0(48);
        }
        if (line == 0) {
            List<RangeHighlighter> list = Collections.emptyList();
            if (list == null) {
                DiffDrawUtil.$$$reportNull$$$0(49);
            }
            return list;
        }
        List<RangeHighlighter> list = new LineMarkerBuilder(editor, line, SeparatorPlacement.TOP).withDefaultRenderer(type, false, false, null).withDefaultGutterRenderer(type, false, false).withDefaultStripeAttributes(type).done();
        if (list == null) {
            DiffDrawUtil.$$$reportNull$$$0(50);
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createBorderLineMarker(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(51);
        }
        if (placement == null) {
            DiffDrawUtil.$$$reportNull$$$0(52);
        }
        List<RangeHighlighter> list = new LineMarkerBuilder(editor, line, placement).withRenderer(BORDER_LINE_RENDERER).done();
        if (list == null) {
            DiffDrawUtil.$$$reportNull$$$0(53);
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createLineSeparatorHighlighter(@NotNull Editor editor, int offset1, int offset2) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(54);
        }
        return DiffDrawUtil.createLineSeparatorHighlighter(editor, offset1, offset2, () -> true);
    }

    @NotNull
    public static List<RangeHighlighter> createLineSeparatorHighlighter(@NotNull Editor editor, int offset1, int offset2, @NotNull BooleanSupplier visibilityCondition) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(55);
        }
        if (visibilityCondition == null) {
            DiffDrawUtil.$$$reportNull$$$0(56);
        }
        return DiffDrawUtil.createLineSeparatorHighlighter(editor, offset1, offset2, new SimpleSeparatorPresentation(visibilityCondition));
    }

    @ApiStatus.Internal
    @NotNull
    public static List<RangeHighlighter> createLineSeparatorHighlighter(@NotNull Editor editor, int offset1, int offset2, @NotNull DiffLineSeparatorRenderer.SeparatorPresentation presentation) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(57);
        }
        if (presentation == null) {
            DiffDrawUtil.$$$reportNull$$$0(58);
        }
        RangeHighlighter marker = editor.getMarkupModel().addRangeHighlighter(null, offset1, offset2, 5900, HighlighterTargetArea.LINES_IN_RANGE);
        DiffLineSeparatorRenderer renderer = new DiffLineSeparatorRenderer(editor, presentation);
        marker.setLineSeparatorPlacement(SeparatorPlacement.TOP);
        marker.setLineSeparatorRenderer((LineSeparatorRenderer)renderer);
        marker.setLineMarkerRenderer((LineMarkerRenderer)renderer);
        List<RangeHighlighter> list = Collections.singletonList(marker);
        if (list == null) {
            DiffDrawUtil.$$$reportNull$$$0(59);
        }
        return list;
    }

    private static int getLayer(int layer, int layerPriority) {
        return layer + layerPriority * 5;
    }

    public static void setupLayeredRendering(@NotNull Editor editor, int startLine, int endLine, int layerPriority, @NotNull Disposable disposable) {
        if (editor == null) {
            DiffDrawUtil.$$$reportNull$$$0(60);
        }
        if (disposable == null) {
            DiffDrawUtil.$$$reportNull$$$0(61);
        }
        if (startLine == endLine) {
            return;
        }
        editor.putUserData(EDITOR_WITH_HIGH_PRIORITY_RENDERER, (Object)true);
        TextAttributes attributes = new TextAttributes();
        attributes.setBackgroundColor(editor.getColorsScheme().getDefaultBackground());
        TextRange offsets = DiffUtil.getLinesRange(editor.getDocument(), startLine, endLine);
        RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(offsets.getStartOffset(), offsets.getEndOffset(), DiffDrawUtil.getLayer(5897, layerPriority), attributes, HighlighterTargetArea.LINES_IN_RANGE);
        highlighter.setCustomRenderer((CustomHighlighterRenderer)new DiffLayeredRendererMarker());
        Disposer.register((Disposable)disposable, () -> {
            editor.putUserData(EDITOR_WITH_HIGH_PRIORITY_RENDERER, null);
            highlighter.dispose();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 28, 30, 31, 33, 34, 36, 37, 38, 39, 41, 42, 44, 45, 47, 48, 51, 52, 54, 55, 56, 57, 58, 60, 61 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 20: 
            case 23: 
            case 27: 
            case 30: 
            case 33: 
            case 36: 
            case 41: 
            case 44: 
            case 47: 
            case 51: 
            case 54: 
            case 55: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 14: 
            case 16: 
            case 19: 
            case 28: 
            case 31: 
            case 34: 
            case 37: 
            case 42: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighter";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deleted";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inserted";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorMode";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutterMode";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placement";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visibilityCondition";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDividerColor";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 60: 
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDividerColorFromScheme";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makeCurvePath";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnifiedChunkHighlighters";
                break;
            }
            case 29: 
            case 32: 
            case 35: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlighter";
                break;
            }
            case 43: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createInlineHighlighter";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineMarker";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createBorderLineMarker";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineSeparatorHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getDividerColorFromScheme";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "drawChunkBorderLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "drawTrapezium";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "drawCurveTrapezium";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "drawCurveLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isThickSimpleStroke";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lineToY";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGutterMarkerPaintRange";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTextAttributes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStripeTextAttributes";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "installEmptyRangeRenderer";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createUnifiedChunkHighlighters";
                break;
            }
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createInlineHighlighter";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createLineMarker";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createBorderLineMarker";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "createLineSeparatorHighlighter";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "setupLayeredRendering";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 6, 7, 8, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 27, 28, 30, 31, 33, 34, 36, 37, 38, 39, 41, 42, 44, 45, 47, 48, 51, 52, 54, 55, 56, 57, 58, 60, 61 -> new IllegalArgumentException(string);
        };
    }

    public static class MarkerRange {
        public final int y1;
        public final int y2;

        public MarkerRange(int y1, int y2) {
            this.y1 = y1;
            this.y2 = y2;
        }

        public int component1() {
            return this.y1;
        }

        public int component2() {
            return this.y2;
        }
    }

    @ApiStatus.Internal
    public static enum BackgroundType {
        NONE,
        DEFAULT,
        IGNORED;

    }

    @ApiStatus.Internal
    public static class DiffTextAttributes
    extends TextAttributes {
        @NotNull
        private final BackgroundType myBackground;
        @NotNull
        private final TextDiffType myType;
        @Nullable
        private final Editor myEditor;

        public DiffTextAttributes(@NotNull BackgroundType background, @NotNull TextDiffType type, @Nullable Editor editor) {
            if (background == null) {
                DiffTextAttributes.$$$reportNull$$$0(0);
            }
            if (type == null) {
                DiffTextAttributes.$$$reportNull$$$0(1);
            }
            this.myBackground = background;
            this.myType = type;
            this.myEditor = editor;
        }

        public Color getBackgroundColor() {
            return this.myBackground == BackgroundType.IGNORED ? this.myType.getIgnoredColor(this.myEditor) : this.myType.getColor(this.myEditor);
        }

        @NotNull
        public TextDiffType getType() {
            TextDiffType textDiffType = this.myType;
            if (textDiffType == null) {
                DiffTextAttributes.$$$reportNull$$$0(2);
            }
            return textDiffType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "background";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil$DiffTextAttributes";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil$DiffTextAttributes";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static class DiffStripeMarkerTextAttributes
    extends TextAttributes {
        @NotNull
        private final TextDiffType myType;
        @NotNull
        private final Editor myEditor;

        @ApiStatus.Internal
        public DiffStripeMarkerTextAttributes(@NotNull TextDiffType type, @NotNull Editor editor) {
            if (type == null) {
                DiffStripeMarkerTextAttributes.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                DiffStripeMarkerTextAttributes.$$$reportNull$$$0(1);
            }
            this.myType = type;
            this.myEditor = editor;
        }

        public Color getErrorStripeColor() {
            return this.myType.getMarkerColor(this.myEditor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/util/DiffDrawUtil$DiffStripeMarkerTextAttributes";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class LineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int startLine;
        private final int endLine;
        private boolean ignored;
        private boolean resolved;
        private boolean excludedInEditor;
        private boolean excludedInGutter;
        private boolean hideWithoutLineNumbers;
        private boolean hideStripeMarkers;
        private boolean hideGutterMarkers;
        private boolean alignedSides;
        private boolean clearThinLineBetweenGutterAndEditor;
        private int layerPriority;
        @Nullable
        private PaintMode fixedEditorMode;
        @Nullable
        private PaintMode fixedGutterMode;

        public LineHighlighterBuilder(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type) {
            if (editor == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(0);
            }
            if (type == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(1);
            }
            this.ignored = false;
            this.resolved = false;
            this.excludedInEditor = false;
            this.excludedInGutter = false;
            this.hideWithoutLineNumbers = false;
            this.hideStripeMarkers = false;
            this.hideGutterMarkers = false;
            this.alignedSides = false;
            this.clearThinLineBetweenGutterAndEditor = false;
            this.layerPriority = 0;
            this.editor = editor;
            this.type = type;
            this.startLine = startLine;
            this.endLine = endLine;
        }

        @NotNull
        public LineHighlighterBuilder withIgnored(boolean ignored) {
            this.ignored = ignored;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(2);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withResolved(boolean resolved) {
            this.resolved = resolved;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(3);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withExcluded(boolean excluded) {
            this.excludedInEditor = excluded;
            this.excludedInGutter = excluded;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(4);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withExcludedInEditor(boolean excluded) {
            this.excludedInEditor = excluded;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(5);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withExcludedInGutter(boolean excluded) {
            this.excludedInGutter = excluded;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(6);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withHideWithoutLineNumbers(boolean hideWithoutLineNumbers) {
            this.hideWithoutLineNumbers = hideWithoutLineNumbers;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(7);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withHideStripeMarkers(boolean hideStripeMarkers) {
            this.hideStripeMarkers = hideStripeMarkers;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(8);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withHideGutterMarkers(boolean hideGutterMarkers) {
            this.hideGutterMarkers = hideGutterMarkers;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(9);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withAlignedSides(boolean aligned) {
            this.alignedSides = aligned;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(10);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withEditorMode(@NotNull PaintMode mode) {
            if (mode == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(11);
            }
            this.fixedEditorMode = mode;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(12);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withGutterMode(@NotNull PaintMode mode) {
            if (mode == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(13);
            }
            this.fixedGutterMode = mode;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(14);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withClearThinLineBetweenGutterAndEditor(boolean clear) {
            this.clearThinLineBetweenGutterAndEditor = clear;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(15);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withLayerPriority(int layerPriority) {
            this.layerPriority = layerPriority;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(16);
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
            PaintMode editorMode = PaintMode.DEFAULT;
            PaintMode gutterMode = PaintMode.DEFAULT;
            if (this.ignored) {
                editorMode = PaintMode.IGNORED;
            }
            if (this.excludedInEditor) {
                editorMode = PaintMode.EXCLUDED_EDITOR;
            }
            if (this.excludedInGutter) {
                gutterMode = PaintMode.EXCLUDED_GUTTER;
            }
            if (this.resolved) {
                editorMode = PaintMode.RESOLVED;
                gutterMode = PaintMode.RESOLVED;
            }
            if (this.fixedEditorMode != null) {
                editorMode = this.fixedEditorMode;
            }
            if (this.fixedGutterMode != null) {
                gutterMode = this.fixedGutterMode;
            }
            boolean isEmptyRange = this.startLine == this.endLine;
            boolean isFirstLine = this.startLine == 0;
            boolean isLastLine = this.endLine == DiffUtil.getLineCount(this.editor.getDocument());
            TextRange offsets = DiffUtil.getLinesRange(this.editor.getDocument(), this.startLine, this.endLine);
            int start = offsets.getStartOffset();
            int end = offsets.getEndOffset();
            TextAttributes attributes = isEmptyRange ? null : DiffDrawUtil.getTextAttributes(this.type, this.editor, editorMode.background);
            TextAttributes stripeAttributes = this.hideStripeMarkers || editorMode.background == BackgroundType.NONE ? null : DiffDrawUtil.getStripeTextAttributes(this.type, this.editor);
            boolean dottedLine = editorMode.border == BorderType.DOTTED;
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(start, end, DiffDrawUtil.getLayer(5898, this.layerPriority), attributes, HighlighterTargetArea.LINES_IN_RANGE);
            highlighters.add(highlighter);
            if (!this.hideGutterMarkers) {
                highlighter.setLineMarkerRenderer((LineMarkerRenderer)new DiffLineMarkerRenderer(highlighter, this.type, editorMode, gutterMode, this.hideWithoutLineNumbers, isEmptyRange, isFirstLine, isLastLine, this.alignedSides, this.clearThinLineBetweenGutterAndEditor));
            }
            if (isEmptyRange && !this.alignedSides) {
                LineMarkerBuilder builder = isFirstLine ? new LineMarkerBuilder(this.editor, 0, SeparatorPlacement.TOP, this.layerPriority) : new LineMarkerBuilder(this.editor, this.startLine - 1, SeparatorPlacement.BOTTOM, this.layerPriority);
                builder.withDefaultRenderer(this.type, true, dottedLine, highlighter);
                highlighters.addAll(builder.done());
            } else if (editorMode.border != BorderType.NONE && !this.alignedSides) {
                LineMarkerBuilder firstLineBuilder = new LineMarkerBuilder(this.editor, this.startLine, SeparatorPlacement.TOP, this.layerPriority).withDefaultRenderer(this.type, false, dottedLine, highlighter);
                LineMarkerBuilder secondLineBuilder = new LineMarkerBuilder(this.editor, this.endLine - 1, SeparatorPlacement.BOTTOM, this.layerPriority).withDefaultRenderer(this.type, false, dottedLine, highlighter);
                highlighters.addAll(firstLineBuilder.done());
                highlighters.addAll(secondLineBuilder.done());
            }
            if (stripeAttributes != null) {
                RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(start, end, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
                highlighters.add(stripeHighlighter);
            }
            ArrayList<RangeHighlighter> arrayList = highlighters;
            if (arrayList == null) {
                LineHighlighterBuilder.$$$reportNull$$$0(17);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 15, 16, 17 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder";
                    break;
                }
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withIgnored";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withResolved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withExcluded";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withExcludedInEditor";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withExcludedInGutter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withHideWithoutLineNumbers";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withHideStripeMarkers";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withHideGutterMarkers";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withAlignedSides";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withEditorMode";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withGutterMode";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withClearThinLineBetweenGutterAndEditor";
                    break;
                }
                case 16: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withLayerPriority";
                    break;
                }
                case 17: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "withEditorMode";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "withGutterMode";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 14, 15, 16, 17 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static class PaintMode {
        @NotNull
        public final BackgroundType background;
        @NotNull
        public final BorderType border;
        public static final PaintMode DEFAULT = new PaintMode(BackgroundType.DEFAULT, BorderType.NONE);
        public static final PaintMode IGNORED = new PaintMode(BackgroundType.IGNORED, BorderType.NONE);
        public static final PaintMode RESOLVED = new PaintMode(BackgroundType.NONE, BorderType.DOTTED);
        public static final PaintMode EXCLUDED_EDITOR = new PaintMode(BackgroundType.NONE, BorderType.LINE);
        public static final PaintMode EXCLUDED_GUTTER = new PaintMode(BackgroundType.IGNORED, BorderType.LINE);

        public PaintMode(@NotNull BackgroundType background, @NotNull BorderType border) {
            if (background == null) {
                PaintMode.$$$reportNull$$$0(0);
            }
            if (border == null) {
                PaintMode.$$$reportNull$$$0(1);
            }
            this.background = background;
            this.border = border;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PaintMode mode = (PaintMode)o;
            return this.background == mode.background && this.border == mode.border;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.background, this.border});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "background";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "border";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/util/DiffDrawUtil$PaintMode";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class InlineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int start;
        private final int end;
        private int layerPriority;

        public InlineHighlighterBuilder(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type) {
            if (editor == null) {
                InlineHighlighterBuilder.$$$reportNull$$$0(0);
            }
            if (type == null) {
                InlineHighlighterBuilder.$$$reportNull$$$0(1);
            }
            this.layerPriority = 0;
            this.editor = editor;
            this.type = type;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public InlineHighlighterBuilder withLayerPriority(int layerPriority) {
            this.layerPriority = layerPriority;
            InlineHighlighterBuilder inlineHighlighterBuilder = this;
            if (inlineHighlighterBuilder == null) {
                InlineHighlighterBuilder.$$$reportNull$$$0(2);
            }
            return inlineHighlighterBuilder;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            TextAttributes attributes = DiffDrawUtil.getTextAttributes(this.type, this.editor, BackgroundType.DEFAULT);
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(this.start, this.end, DiffDrawUtil.getLayer(5899, this.layerPriority), attributes, HighlighterTargetArea.EXACT_RANGE);
            if (this.start == this.end) {
                DiffDrawUtil.installEmptyRangeRenderer(highlighter, this.type);
            }
            List<RangeHighlighter> list = Collections.singletonList(highlighter);
            if (list == null) {
                InlineHighlighterBuilder.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil$InlineHighlighterBuilder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil$InlineHighlighterBuilder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withLayerPriority";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static final class LineMarkerBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final SeparatorPlacement placement;
        private final int offset;
        @NotNull
        private final RangeHighlighter highlighter;
        @Nullable
        private LineSeparatorRenderer lineRenderer;
        @Nullable
        private LineMarkerRenderer gutterRenderer;
        @Nullable
        private TextAttributes stripeAttributes;

        private LineMarkerBuilder(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
            if (editor == null) {
                LineMarkerBuilder.$$$reportNull$$$0(0);
            }
            if (placement == null) {
                LineMarkerBuilder.$$$reportNull$$$0(1);
            }
            this(editor, line, placement, 0);
        }

        private LineMarkerBuilder(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement, int layerPriority) {
            if (editor == null) {
                LineMarkerBuilder.$$$reportNull$$$0(2);
            }
            if (placement == null) {
                LineMarkerBuilder.$$$reportNull$$$0(3);
            }
            this.editor = editor;
            this.placement = placement;
            this.offset = DocumentUtil.getFirstNonSpaceCharOffset((Document)editor.getDocument(), (int)line);
            this.highlighter = editor.getMarkupModel().addRangeHighlighter(null, this.offset, this.offset, DiffDrawUtil.getLayer(5900, layerPriority), HighlighterTargetArea.LINES_IN_RANGE);
        }

        @NotNull
        public LineMarkerBuilder withRenderer(@Nullable LineSeparatorRenderer lineRenderer) {
            this.lineRenderer = lineRenderer;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(4);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withGutterRenderer(@Nullable LineMarkerRenderer gutterRenderer) {
            this.gutterRenderer = gutterRenderer;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(5);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withStripeAttributes(@Nullable TextAttributes stripeAttributes) {
            this.stripeAttributes = stripeAttributes;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(6);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withDefaultRenderer(@NotNull TextDiffType type, boolean doubleLine, boolean dottedLine, @Nullable RangeHighlighter parentHighlighter) {
            if (type == null) {
                LineMarkerBuilder.$$$reportNull$$$0(7);
            }
            RangeHighlighter parent = (RangeHighlighter)ObjectUtils.chooseNotNull((Object)parentHighlighter, (Object)this.highlighter);
            LineMarkerBuilder lineMarkerBuilder = this.withRenderer(new DiffDefaultBorderRenderer(parent, this.editor, this.placement, type, doubleLine, dottedLine));
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(8);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withDefaultGutterRenderer(@NotNull TextDiffType type, boolean doubleLine, boolean dottedLine) {
            if (type == null) {
                LineMarkerBuilder.$$$reportNull$$$0(9);
            }
            LineMarkerBuilder lineMarkerBuilder = this.withGutterRenderer((LineMarkerRenderer)new DiffFoldingGutterLineRenderer(this.placement, type, doubleLine, dottedLine));
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(10);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withDefaultStripeAttributes(@NotNull TextDiffType type) {
            if (type == null) {
                LineMarkerBuilder.$$$reportNull$$$0(11);
            }
            TextAttributes attributes = DiffDrawUtil.getStripeTextAttributes(type, this.editor);
            LineMarkerBuilder lineMarkerBuilder = this.withStripeAttributes(attributes);
            if (lineMarkerBuilder == null) {
                LineMarkerBuilder.$$$reportNull$$$0(12);
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            this.highlighter.setLineSeparatorPlacement(this.placement);
            this.highlighter.setLineSeparatorRenderer(this.lineRenderer);
            this.highlighter.setLineMarkerRenderer(this.gutterRenderer);
            if (this.stripeAttributes == null) {
                List<RangeHighlighter> list = Collections.singletonList(this.highlighter);
                if (list == null) {
                    LineMarkerBuilder.$$$reportNull$$$0(13);
                }
                return list;
            }
            RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(this.offset, this.offset, 4999, this.stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
            List<RangeHighlighter> list = Arrays.asList(this.highlighter, stripeHighlighter);
            if (list == null) {
                LineMarkerBuilder.$$$reportNull$$$0(14);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 6, 8, 10, 12, 13, 14 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "placement";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder";
                    break;
                }
                case 7: 
                case 9: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withRenderer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withGutterRenderer";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withStripeAttributes";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDefaultRenderer";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDefaultGutterRenderer";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "withDefaultStripeAttributes";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "done";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 8: 
                case 10: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "withDefaultRenderer";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "withDefaultGutterRenderer";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "withDefaultStripeAttributes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 6, 8, 10, 12, 13, 14 -> new IllegalStateException(string);
            };
        }
    }

    private static class SimpleSeparatorPresentation
    implements DiffLineSeparatorRenderer.SeparatorPresentation {
        @NotNull
        private final BooleanSupplier myVisibilityCondition;

        SimpleSeparatorPresentation(@NotNull BooleanSupplier visibilityCondition) {
            if (visibilityCondition == null) {
                SimpleSeparatorPresentation.$$$reportNull$$$0(0);
            }
            this.myVisibilityCondition = visibilityCondition;
        }

        @Override
        public boolean isVisible() {
            return this.myVisibilityCondition.getAsBoolean();
        }

        @Override
        public boolean isHovered() {
            return false;
        }

        @Override
        @Nullable
        public String getDescription() {
            return null;
        }

        @Override
        public void setExpanded(boolean value) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibilityCondition", "com/intellij/diff/util/DiffDrawUtil$SimpleSeparatorPresentation", "<init>"));
        }
    }

    @ApiStatus.Internal
    public static class DiffLayeredRendererMarker
    implements CustomHighlighterRenderer {
        public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
            if (editor == null) {
                DiffLayeredRendererMarker.$$$reportNull$$$0(0);
            }
            if (highlighter == null) {
                DiffLayeredRendererMarker.$$$reportNull$$$0(1);
            }
            if (g == null) {
                DiffLayeredRendererMarker.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "highlighter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "g";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/util/DiffDrawUtil$DiffLayeredRendererMarker";
            objectArray[2] = "paint";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DiffDefaultBorderRenderer
    implements LineSeparatorRenderer {
        @Nullable
        private final RangeHighlighter myParentHighlighter;
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final SeparatorPlacement myPlacement;
        @NotNull
        private final TextDiffType myType;
        private final boolean myDoubleLine;
        private final boolean myResolved;

        DiffDefaultBorderRenderer(@Nullable RangeHighlighter parentHighlighter, @NotNull Editor editor, @NotNull SeparatorPlacement placement, @NotNull TextDiffType type, boolean doubleLine, boolean resolved) {
            if (editor == null) {
                DiffDefaultBorderRenderer.$$$reportNull$$$0(0);
            }
            if (placement == null) {
                DiffDefaultBorderRenderer.$$$reportNull$$$0(1);
            }
            if (type == null) {
                DiffDefaultBorderRenderer.$$$reportNull$$$0(2);
            }
            this.myParentHighlighter = parentHighlighter;
            this.myEditor = editor;
            this.myPlacement = placement;
            this.myType = type;
            this.myDoubleLine = doubleLine;
            this.myResolved = resolved;
        }

        public void drawLine(Graphics g, int x1, int x2, int y) {
            if (this.myParentHighlighter != null && FoldingUtil.isHighlighterFolded((Editor)this.myEditor, (RangeHighlighter)this.myParentHighlighter)) {
                return;
            }
            Rectangle clip = g.getClipBounds();
            x2 = clip.x + clip.width;
            if (this.myPlacement == SeparatorPlacement.TOP) {
                ++y;
            }
            DiffDrawUtil.drawChunkBorderLine((Graphics2D)g, x1, x2, y, this.myType.getColor(this.myEditor), this.myDoubleLine, this.myResolved);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "placement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/intellij/diff/util/DiffDrawUtil$DiffDefaultBorderRenderer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DiffFoldingGutterLineRenderer
    implements LineMarkerRendererEx {
        @NotNull
        private final SeparatorPlacement myPlacement;
        @NotNull
        private final TextDiffType myType;
        private final boolean myDoubleLine;
        private final boolean myResolved;

        DiffFoldingGutterLineRenderer(@NotNull SeparatorPlacement placement, @NotNull TextDiffType type, boolean doubleLine, boolean resolved) {
            if (placement == null) {
                DiffFoldingGutterLineRenderer.$$$reportNull$$$0(0);
            }
            if (type == null) {
                DiffFoldingGutterLineRenderer.$$$reportNull$$$0(1);
            }
            this.myPlacement = placement;
            this.myType = type;
            this.myDoubleLine = doubleLine;
            this.myResolved = resolved;
        }

        public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
            if (editor == null) {
                DiffFoldingGutterLineRenderer.$$$reportNull$$$0(2);
            }
            if (g == null) {
                DiffFoldingGutterLineRenderer.$$$reportNull$$$0(3);
            }
            if (r == null) {
                DiffFoldingGutterLineRenderer.$$$reportNull$$$0(4);
            }
            EditorGutterComponentEx gutter = ((EditorEx)editor).getGutterComponentEx();
            Graphics2D g2 = (Graphics2D)g;
            int x1 = gutter.getWhitespaceSeparatorOffset();
            int x2 = gutter.getWidth();
            int y = r.y;
            if (this.myPlacement == SeparatorPlacement.BOTTOM) {
                LOG.warn("BOTTOM gutter line renderers are not supported");
                y += editor.getLineHeight() - 1;
            }
            DiffDrawUtil.drawChunkBorderLine(g2, x1, x2, y, this.myType.getColor(editor), this.myDoubleLine, this.myResolved);
        }

        @NotNull
        public LineMarkerRendererEx.Position getPosition() {
            LineMarkerRendererEx.Position position = LineMarkerRendererEx.Position.CUSTOM;
            if (position == null) {
                DiffFoldingGutterLineRenderer.$$$reportNull$$$0(5);
            }
            return position;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "placement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diff/util/DiffDrawUtil$DiffFoldingGutterLineRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diff/util/DiffDrawUtil$DiffFoldingGutterLineRenderer";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPosition";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "paint";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    public static enum BorderType {
        NONE,
        LINE,
        DOTTED;

    }
}

