/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.dashboard.RunDashboardCustomizationBuilder;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.dashboard.RunDashboardListener;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationUrlUtil;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringBootApplicationRunDashboardCustomizer
extends RunDashboardCustomizer {
    @NlsSafe
    private static final String DEVTOOLS_TAIL = " [devtools]";

    SpringBootApplicationRunDashboardCustomizer() {
    }

    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        if (settings == null) {
            SpringBootApplicationRunDashboardCustomizer.$$$reportNull$$$0(0);
        }
        return settings.getConfiguration() instanceof SpringBootApplicationRunConfigurationBase;
    }

    public boolean updatePresentation(@NotNull RunDashboardCustomizationBuilder customizationBuilder, @NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        SpringBootApplicationInfo info;
        RunConfiguration runConfiguration;
        if (customizationBuilder == null) {
            SpringBootApplicationRunDashboardCustomizer.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            SpringBootApplicationRunDashboardCustomizer.$$$reportNull$$$0(2);
        }
        if (!((runConfiguration = settings.getConfiguration()) instanceof SpringBootApplicationRunConfigurationBase)) {
            return false;
        }
        SpringBootApplicationRunConfigurationBase springBootRunConfiguration = (SpringBootApplicationRunConfigurationBase)runConfiguration;
        Project project = settings.getConfiguration().getProject();
        if (!DumbService.getInstance((Project)project).isDumb()) {
            ApplicationManager.getApplication().runReadAction(() -> {
                if (SpringBootApplicationRunDashboardCustomizer.hasDevtools(springBootRunConfiguration)) {
                    customizationBuilder.addText(DEVTOOLS_TAIL, SimpleTextAttributes.GRAY_ATTRIBUTES);
                }
            });
        }
        ProcessHandler handler = descriptor != null ? descriptor.getProcessHandler() : null;
        SpringBootApplicationInfo springBootApplicationInfo = info = handler != null && !handler.isProcessTerminated() ? SpringBootApplicationLifecycleManager.getInstance((Project)project).getSpringBootApplicationInfo(handler) : null;
        if (info != null) {
            Integer serverPort;
            if (Boolean.FALSE.equals(info.getReadyState().getValue())) {
                XDebugSession session = (XDebugSession)ContainerUtil.find((Object[])XDebuggerManager.getInstance((Project)project).getDebugSessions(), s -> s.getDebugProcess().getProcessHandler() == handler);
                if (session == null || !session.isPaused()) {
                    customizationBuilder.setIcon((Icon)AnimatedIcon.Default.INSTANCE);
                } else {
                    customizationBuilder.setIcon(AllIcons.Process.Step_4);
                }
            }
            if ((serverPort = (Integer)info.getServerPort().getValue()) != null && serverPort > 0) {
                customizationBuilder.addText(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
                String path = springBootRunConfiguration.getUrlPath();
                String applicationLink = ":" + serverPort + (StringUtil.isEmpty((String)path) ? "/" : path);
                customizationBuilder.addText(applicationLink, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                customizationBuilder.addLink(applicationLink, (Runnable)new ApplicationLinkListener(info, springBootRunConfiguration));
            }
        }
        return true;
    }

    private static boolean hasDevtools(SpringBootApplicationRunConfigurationBase springBootRunConfiguration) {
        Module module = springBootRunConfiguration.getModule();
        if (module == null || module.isDisposed()) {
            return false;
        }
        Project project = module.getProject();
        DevtoolsState state = (DevtoolsState)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)module, () -> {
            DevtoolsState result = new DevtoolsState(project);
            ReadAction.nonBlocking(() -> JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.boot.devtools.RemoteSpringApplication", GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false))).finishOnUiThread(ModalityState.defaultModalityState(), psiClass -> result.setDevtools(psiClass != null)).inSmartMode(project).coalesceBy(new Object[]{module}).expireWith((Disposable)module).submit((Executor)NonUrgentExecutor.getInstance());
            return CachedValueProvider.Result.createSingleDependency((Object)result, (Object)PsiModificationTracker.MODIFICATION_COUNT);
        });
        AppUIUtil.invokeOnEdt(() -> state.addConfiguration((RunConfiguration)springBootRunConfiguration));
        return state.hasDevtools();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customizationBuilder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardCustomizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "updatePresentation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ApplicationLinkListener
    implements Runnable {
        final SpringBootApplicationInfo myLinkInfo;
        final SpringBootApplicationRunConfigurationBase myConfiguration;

        ApplicationLinkListener(@NotNull SpringBootApplicationInfo linkInfo, @NotNull SpringBootApplicationRunConfigurationBase configuration) {
            if (linkInfo == null) {
                ApplicationLinkListener.$$$reportNull$$$0(0);
            }
            if (configuration == null) {
                ApplicationLinkListener.$$$reportNull$$$0(1);
            }
            this.myLinkInfo = linkInfo;
            this.myConfiguration = configuration;
        }

        @Override
        public void run() {
            String applicationUrl = (String)this.myLinkInfo.getApplicationUrl().getValue();
            if (applicationUrl != null) {
                SpringBootApplicationUrlUtil urlUtil = SpringBootApplicationUrlUtil.getInstance();
                String mappingPath = this.myConfiguration.getUrlPath();
                String servletPath = urlUtil.getServletPath(this.myLinkInfo, mappingPath);
                BrowserUtil.browse((String)urlUtil.getMappingUrl(applicationUrl, servletPath, mappingPath));
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.myLinkInfo.equals((Object)((ApplicationLinkListener)o).myLinkInfo);
        }

        public int hashCode() {
            return this.myLinkInfo.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "linkInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/boot/run/SpringBootApplicationRunDashboardCustomizer$ApplicationLinkListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DevtoolsState {
        private final Project myProject;
        private volatile boolean myDevtools;
        private Set<RunConfiguration> myConfigurations = new HashSet<RunConfiguration>();

        DevtoolsState(Project project) {
            this.myProject = project;
        }

        boolean hasDevtools() {
            return this.myDevtools;
        }

        void setDevtools(boolean hasDevtools) {
            this.myDevtools = hasDevtools;
            for (RunConfiguration configuration : this.myConfigurations) {
                ((RunDashboardListener)this.myProject.getMessageBus().syncPublisher(RunDashboardListener.DASHBOARD_TOPIC)).configurationChanged(configuration, false);
            }
            this.myConfigurations = null;
        }

        void addConfiguration(RunConfiguration configuration) {
            if (this.myConfigurations != null) {
                this.myConfigurations.add(configuration);
            }
        }
    }
}

