/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationDescriptor;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.configuration.SpringBootRunConfigurationExtender;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdateContext;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdateContextImpl;
import com.intellij.spring.boot.run.update.SpringBootApplicationUpdatePolicy;
import com.intellij.util.SmartList;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class SpringBootApplicationCompileManager {
    SpringBootApplicationCompileManager(final @NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            SpringBootApplicationCompileManager.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            SpringBootApplicationCompileManager.$$$reportNull$$$0(1);
        }
        ApplicationManager.getApplication().getMessageBus().connect(parentDisposable).subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener(){

            public void applicationDeactivated(@NotNull IdeFrame ideFrame) {
                if (ideFrame == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(project.isDisposed() || !project.isInitialized() || CompilerManager.getInstance((Project)project).isCompilationActive() || LaterInvocator.isInModalContext() || ProgressManager.getInstance().hasModalProgressIndicator())) {
                    ExecutorRegistry executorRegistry = ExecutorRegistry.getInstance();
                    HashMap<SpringBootApplicationUpdatePolicy, List> appsToUpdate = new HashMap<SpringBootApplicationUpdatePolicy, List>();
                    SpringBootApplicationLifecycleManager.getInstance((Project)project).getRunningSpringBootApplications().forEach(descriptor -> {
                        SpringBootApplicationUpdatePolicy policy;
                        ProcessHandler handler = descriptor.getProcessHandler();
                        if (handler.isProcessTerminated() || handler.isProcessTerminating() || !handler.isStartNotified()) {
                            return;
                        }
                        Executor executor = executorRegistry.getExecutorById(descriptor.getExecutorId());
                        if (executor == null) {
                            return;
                        }
                        RunProfile patt0$temp = descriptor.getRunProfile();
                        if (!(patt0$temp instanceof SpringBootApplicationRunConfiguration)) {
                            return;
                        }
                        SpringBootApplicationRunConfiguration configuration = (SpringBootApplicationRunConfiguration)patt0$temp;
                        SpringBootRunConfigurationExtender extender = (SpringBootRunConfigurationExtender)configuration.getExtenderOfType(SpringBootRunConfigurationExtender.class);
                        SpringBootApplicationUpdatePolicy springBootApplicationUpdatePolicy = policy = extender != null ? extender.getFrameDeactivationUpdatePolicy() : null;
                        if (policy == null) {
                            return;
                        }
                        if (policy.isAvailableForConfiguration((SpringBootApplicationRunConfigurationBase)configuration) && policy.isAvailableForExecutor(executor) && policy.isAvailableOnFrameDeactivation()) {
                            appsToUpdate.computeIfAbsent(policy, key -> new SmartList()).add(descriptor);
                        }
                    });
                    appsToUpdate.forEach((policy, descriptors) -> policy.runUpdate((SpringBootApplicationUpdateContext)new SpringBootApplicationUpdateContextImpl(project, (List<SpringBootApplicationDescriptor>)descriptors, true)));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideFrame", "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationCompileManager$1", "applicationDeactivated"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "parentDisposable";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationCompileManager";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

