/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.ExecutionManagerImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationBase;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationCompileManager;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationDescriptor;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationDescriptorImpl;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfo;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationInfoImpl;
import com.intellij.spring.boot.run.lifecycle.SpringBootApplicationLifecycleManager;
import com.intellij.spring.boot.run.lifecycle.configuration.SpringBootRunConfigurationExtender;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpringBootApplicationLifecycleManagerImpl
implements SpringBootApplicationLifecycleManager,
Disposable {
    public static final Key<String> PROCESS_UID = Key.create((String)"SPRING_BOOT_APPLICATION_PROCESS_UID");
    public static final String IJ_SPRING_BOOT_APPLICATION_PROCESS = "ij.spring.boot.application.process";
    private final Project myProject;
    private final Map<ProcessHandler, SpringBootApplicationDescriptor> myRunningApps = new ConcurrentHashMap<ProcessHandler, SpringBootApplicationDescriptor>();
    private final Map<ProcessHandler, SpringBootApplicationInfo> myInfos = new ConcurrentHashMap<ProcessHandler, SpringBootApplicationInfo>();
    private final List<SpringBootApplicationLifecycleManager.InfoListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public SpringBootApplicationLifecycleManagerImpl(Project project) {
        this.myProject = project;
        this.init();
        new SpringBootApplicationCompileManager(this.myProject, this);
    }

    private void init() {
        this.myProject.getMessageBus().connect((Disposable)this).subscribe(ExecutionManager.EXECUTION_TOPIC, (Object)new ExecutionListener(){

            public void processStarted(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                RunnerAndConfigurationSettings configurationSettings;
                if (executorId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((configurationSettings = env.getRunnerAndConfigurationSettings()) == null) {
                    return;
                }
                SpringBootApplicationRunConfiguration configuration = SpringBootApplicationLifecycleManagerImpl.getConfiguration(configurationSettings);
                if (configuration == null) {
                    return;
                }
                Module module = configuration.getModule();
                if (module == null) {
                    return;
                }
                SpringBootApplicationLifecycleManagerImpl.this.myRunningApps.put(handler, new SpringBootApplicationDescriptorImpl(handler, (RunProfile)configuration, executorId, module));
                SpringBootRunConfigurationExtender extender = (SpringBootRunConfigurationExtender)configuration.getExtenderOfType(SpringBootRunConfigurationExtender.class);
                if (extender == null || !extender.isLifecycleManagementEnabled()) {
                    return;
                }
                SpringBootApplicationInfo info = SpringBootApplicationInfoImpl.createInfo(SpringBootApplicationLifecycleManagerImpl.this.myProject, configuration.getModule(), (SpringBootApplicationRunConfigurationBase)configuration, configuration.getActiveProfiles(), handler);
                Disposer.register((Disposable)SpringBootApplicationLifecycleManagerImpl.this, (Disposable)info);
                SpringBootApplicationLifecycleManagerImpl.this.myInfos.put(handler, info);
                SpringBootApplicationLifecycleManagerImpl.this.myListeners.forEach(listener -> listener.infoAdded(handler, info));
            }

            public void processTerminating(@NotNull String executorId, @NotNull ExecutionEnvironment env, @NotNull ProcessHandler handler) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (env == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (handler == null) {
                    1.$$$reportNull$$$0(5);
                }
                SpringBootApplicationLifecycleManagerImpl.this.myRunningApps.remove(handler);
                SpringBootApplicationInfo info = SpringBootApplicationLifecycleManagerImpl.this.myInfos.remove(handler);
                if (info != null) {
                    Disposer.dispose((Disposable)info);
                    SpringBootApplicationLifecycleManagerImpl.this.myListeners.forEach(listener -> listener.infoRemoved(handler, info));
                    DaemonCodeAnalyzer.getInstance((Project)SpringBootApplicationLifecycleManagerImpl.this.myProject).restart((Object)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 1: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "env";
                        break;
                    }
                    case 2: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "handler";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processStarted";
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminating";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void dispose() {
        this.myRunningApps.clear();
        this.myInfos.forEach((handler, info) -> this.myListeners.forEach(listener -> listener.infoRemoved(handler, info)));
        this.myInfos.clear();
    }

    @Nullable
    public SpringBootApplicationInfo getSpringBootApplicationInfo(ProcessHandler handler) {
        return this.myInfos.get(handler);
    }

    public List<SpringBootApplicationInfo> getSpringBootApplicationInfos() {
        return new ArrayList<SpringBootApplicationInfo>(this.myInfos.values());
    }

    @Nullable
    public SpringBootApplicationDescriptor getSpringBootApplicationDescriptor(ProcessHandler handler) {
        return this.myRunningApps.get(handler);
    }

    public List<SpringBootApplicationDescriptor> getRunningSpringBootApplications() {
        return new ArrayList<SpringBootApplicationDescriptor>(this.myRunningApps.values());
    }

    public void addInfoListener(@NotNull SpringBootApplicationLifecycleManager.InfoListener listener) {
        if (listener == null) {
            SpringBootApplicationLifecycleManagerImpl.$$$reportNull$$$0(0);
        }
        this.myListeners.add(listener);
    }

    public void removeInfoListener(@NotNull SpringBootApplicationLifecycleManager.InfoListener listener) {
        if (listener == null) {
            SpringBootApplicationLifecycleManagerImpl.$$$reportNull$$$0(1);
        }
        this.myListeners.remove(listener);
    }

    @Nullable
    private static SpringBootApplicationRunConfiguration getConfiguration(@NotNull RunnerAndConfigurationSettings settings) {
        RunConfiguration configuration;
        if (settings == null) {
            SpringBootApplicationLifecycleManagerImpl.$$$reportNull$$$0(2);
        }
        if ((configuration = settings.getConfiguration()) instanceof SpringBootApplicationRunConfiguration) {
            return (SpringBootApplicationRunConfiguration)configuration;
        }
        RunProfile delegate = ExecutionManagerImpl.getDelegatedRunProfile((RunProfile)configuration);
        if (delegate instanceof SpringBootApplicationRunConfiguration) {
            return (SpringBootApplicationRunConfiguration)delegate;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/boot/run/lifecycle/SpringBootApplicationLifecycleManagerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addInfoListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeInfoListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getConfiguration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

