/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.beans.model.impl;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveBean;
import com.intellij.spring.boot.run.lifecycle.beans.model.LiveResource;
import com.intellij.spring.runtime.SpringRuntimeBeanResolver;
import com.intellij.spring.runtime.SpringRuntimeResolverService;
import com.intellij.spring.runtime.SpringRuntimeResource;
import com.intellij.xml.util.PsiElementPointer;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 72\u00020\u0001:\u00017B7\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0003H\u0016J\n\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00010\u0016H\u0016J\b\u0010\u0018\u001a\u00020\tH\u0016J\b\u0010\u0019\u001a\u00020\tH\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u0003H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u001eH\u0016J&\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u001e2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0000J\u0014\u00101\u001a\u00020\t2\b\u00102\u001a\u0004\u0018\u000103H\u0096\u0082\u0004J\n\u00104\u001a\u000205H\u0096\u0080\u0004J\n\u00106\u001a\u00020\u0003H\u0096\u0080\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveBeanImpl;", "Lcom/intellij/spring/boot/run/lifecycle/beans/model/LiveBean;", "id", "", "scope", "type", "resource", "Lcom/intellij/spring/boot/run/lifecycle/beans/model/LiveResource;", "innerBean", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/intellij/spring/boot/run/lifecycle/beans/model/LiveResource;Z)V", "resolver", "Lcom/intellij/spring/runtime/SpringRuntimeBeanResolver;", "dependencies", "", "injectedInto", "getId", "getScope", "getType", "getResource", "getDependencies", "", "getInjectedInto", "isInnerBean", "isMock", "getName", "getClassName", "getFactoryMethodName", "findBeanClass", "Lcom/intellij/psi/PsiClass;", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "matches", "psiClass", "findBeanPointer", "Lcom/intellij/xml/util/PsiElementPointer;", "beanClass", "resourceElement", "Lcom/intellij/psi/PsiElement;", "springModel", "Lcom/intellij/spring/CommonSpringModel;", "getIcon", "Ljavax/swing/Icon;", "addDependency", "", "dependency", "equals", "other", "", "hashCode", "", "toString", "Companion", "intellij.spring.boot.run"})
public final class LiveBeanImpl
implements LiveBean {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @Nullable
    private final String scope;
    @Nullable
    private final String type;
    @Nullable
    private final LiveResource resource;
    private final boolean innerBean;
    @NotNull
    private final SpringRuntimeBeanResolver resolver;
    @NotNull
    private final Set<LiveBean> dependencies;
    @NotNull
    private final Set<LiveBean> injectedInto;

    private LiveBeanImpl(String id, String scope, String type, LiveResource resource, boolean innerBean) {
        this.id = id;
        this.scope = scope;
        this.type = type;
        this.resource = resource;
        this.innerBean = innerBean;
        this.resolver = SpringRuntimeResolverService.Companion.getInstance().createBeanResolver(this.id, this.type, null, this.getFactoryMethodName(), (SpringRuntimeResource)this.resource);
        this.dependencies = new HashSet();
        this.injectedInto = new HashSet();
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @Override
    @Nullable
    public LiveResource getResource() {
        return this.resource;
    }

    @Override
    @NotNull
    public Set<LiveBean> getDependencies() {
        return CollectionsKt.toSet((Iterable)this.dependencies);
    }

    @Override
    @NotNull
    public Set<LiveBean> getInjectedInto() {
        return CollectionsKt.toSet((Iterable)this.injectedInto);
    }

    public boolean isInnerBean() {
        return this.innerBean;
    }

    public boolean isMock() {
        return false;
    }

    @NotNull
    public String getName() {
        return this.resolver.getName();
    }

    @NotNull
    public String getClassName() {
        return this.resolver.getClassName();
    }

    @Nullable
    public String getFactoryMethodName() {
        return null;
    }

    @Nullable
    public PsiClass findBeanClass(@NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        return this.resolver.findBeanClass(project, searchScope);
    }

    public boolean matches(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        return this.resolver.matches(psiClass);
    }

    @NotNull
    public PsiElementPointer findBeanPointer(@Nullable PsiClass beanClass, @Nullable PsiElement resourceElement, @Nullable CommonSpringModel springModel) {
        return this.resolver.findBeanPointer(beanClass, resourceElement, springModel);
    }

    @NotNull
    public Icon getIcon() {
        if (!(this.resource != null && this.resource.hasDescription() && this.resource.hasDetails() && this.resource.isXmlResource())) {
            Icon icon = SpringApiIcons.SpringJavaBean;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SpringJavaBean");
            return icon;
        }
        Icon icon = SpringApiIcons.SpringBean;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SpringBean");
        return icon;
    }

    public final void addDependency(@NotNull LiveBeanImpl dependency) {
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        this.dependencies.add(dependency);
        dependency.injectedInto.add(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof LiveBeanImpl) {
            return Intrinsics.areEqual((Object)this.id, (Object)((LiveBeanImpl)other).id) && Intrinsics.areEqual((Object)this.resource, (Object)((LiveBeanImpl)other).resource);
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.id.hashCode();
        LiveResource liveResource = this.resource;
        result = 31 * result + (liveResource != null ? liveResource.hashCode() : 0);
        return result;
    }

    @NotNull
    public String toString() {
        return this.id;
    }

    @JvmStatic
    @NotNull
    public static final LiveBeanImpl createLiveBean(@NotNull String id, @Nullable String scope, @Nullable String type, @NotNull LiveResource resource) {
        return Companion.createLiveBean(id, scope, type, resource);
    }

    @JvmStatic
    @NotNull
    public static final LiveBeanImpl createInnerBean(@NotNull String id) {
        return Companion.createInnerBean(id);
    }

    public /* synthetic */ LiveBeanImpl(String id, String scope, String type, LiveResource resource, boolean innerBean, DefaultConstructorMarker $constructor_marker) {
        this(id, scope, type, resource, innerBean);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveBeanImpl$Companion;", "", "<init>", "()V", "createLiveBean", "Lcom/intellij/spring/boot/run/lifecycle/beans/model/impl/LiveBeanImpl;", "id", "", "scope", "type", "resource", "Lcom/intellij/spring/boot/run/lifecycle/beans/model/LiveResource;", "createInnerBean", "intellij.spring.boot.run"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LiveBeanImpl createLiveBean(@NotNull String id, @Nullable String scope, @Nullable String type, @NotNull LiveResource resource) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
            return new LiveBeanImpl(id, scope, type, resource, false, null);
        }

        @JvmStatic
        @NotNull
        public final LiveBeanImpl createInnerBean(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return new LiveBeanImpl(id, null, null, null, true, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

