/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.lifecycle.env.model;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.spring.runtime.SpringRuntimeResolverService;
import com.intellij.spring.runtime.SpringRuntimeResource;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u001e\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u00152\u0006\u0010\u0005\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/spring/boot/run/lifecycle/env/model/RuntimeProperty;", "", "name", "", "value", "source", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getValue", "getSource", "resource", "Lcom/intellij/spring/runtime/SpringRuntimeResource;", "getResource", "()Lcom/intellij/spring/runtime/SpringRuntimeResource;", "offset", "getOffset", "isHidden", "", "splitOffset", "Lkotlin/Pair;", "intellij.spring.boot.run"})
@SourceDebugExtension(value={"SMAP\nRuntimeProperty.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeProperty.kt\ncom/intellij/spring/boot/run/lifecycle/env/model/RuntimeProperty\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,56:1\n1#2:57\n1088#3,2:58\n*S KotlinDebug\n*F\n+ 1 RuntimeProperty.kt\ncom/intellij/spring/boot/run/lifecycle/env/model/RuntimeProperty\n*L\n43#1:58,2\n*E\n"})
public final class RuntimeProperty {
    @NotNull
    private final String name;
    @NotNull
    private final String value;
    @Nullable
    private final String source;
    @Nullable
    private final SpringRuntimeResource resource;
    @Nullable
    private final String offset;

    /*
     * WARNING - void declaration
     */
    public RuntimeProperty(@NlsSafe @NotNull String name, @NlsSafe @NotNull String value, @Nullable String source) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.name = name;
        this.value = value;
        this.source = source;
        if (this.source == null) {
            this.resource = null;
            this.offset = null;
        } else {
            SpringRuntimeResolverService resolverService = SpringRuntimeResolverService.Companion.getInstance();
            if (StringsKt.startsWith$default((String)this.source, (String)"Config Server", (boolean)false, (int)2, null)) {
                String details;
                String string;
                String string2 = this.source.substring(13);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                Pair<String, String> pair = this.splitOffset(((Object)StringsKt.trim((CharSequence)string2)).toString());
                String path = (String)pair.component1();
                String offset = (String)pair.component2();
                String it = string = StringsKt.substringBefore((String)StringsKt.substringAfter((String)path, (char)'\'', (String)""), (char)'\'', (String)"");
                boolean bl = false;
                String string3 = details = ((CharSequence)it).length() > 0 ? string : null;
                if (details != null) {
                    resourcePath = resolverService.extractPath(details);
                    this.resource = resourcePath == null ? null : resolverService.createResource(details, resourcePath);
                } else {
                    String string4 = resolverService.extractPath(path);
                    if (string4 == null) {
                        string4 = path;
                    }
                    resourcePath = string4;
                    this.resource = resolverService.createResource(this.source, resourcePath);
                }
                this.offset = offset;
            } else {
                void it;
                String string;
                String resourcePath = resolverService.extractPath(this.source);
                this.resource = resourcePath == null ? null : resolverService.createResource(this.source, resourcePath);
                String offset = string = StringsKt.substringAfterLast((String)this.source, (String)"] - ", (String)"");
                RuntimeProperty runtimeProperty = this;
                boolean bl = false;
                boolean bl2 = ((CharSequence)it).length() > 0;
                runtimeProperty.offset = bl2 ? string : null;
            }
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @Nullable
    public final String getSource() {
        return this.source;
    }

    @Nullable
    public final SpringRuntimeResource getResource() {
        return this.resource;
    }

    @Nullable
    public final String getOffset() {
        return this.offset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isHidden() {
        if (this.value.length() <= 1) return false;
        CharSequence $this$all$iv = this.value;
        boolean $i$f$all = false;
        int n = 0;
        while (n < $this$all$iv.length()) {
            char element$iv;
            char it = element$iv = $this$all$iv.charAt(n);
            boolean bl = false;
            if (it != '*') return false;
            boolean bl2 = true;
            if (!bl2) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private final Pair<String, String> splitOffset(String source) {
        int offsetSeparator = StringsKt.lastIndexOf$default((CharSequence)source, (char)':', (int)0, (boolean)false, (int)6, null);
        if (offsetSeparator == -1) {
            return TuplesKt.to((Object)source, null);
        }
        if ((offsetSeparator = StringsKt.lastIndexOf$default((CharSequence)source, (char)':', (int)(offsetSeparator - 1), (boolean)false, (int)4, null)) == -1) {
            return TuplesKt.to((Object)source, null);
        }
        String string = source.substring(0, offsetSeparator);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String string2 = source.substring(offsetSeparator + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        return TuplesKt.to((Object)string, (Object)string2);
    }
}

