/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.models;

import com.intellij.history.core.revisions.Revision;
import com.intellij.util.text.DateFormatUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0013\u001a\u00020\u000bH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0018\u0010\n\u001a\t\u0018\u00010\u000b\u00a2\u0006\u0002\b\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lcom/intellij/history/integration/ui/models/RecentChange;", "", "revisionBefore", "Lcom/intellij/history/core/revisions/Revision;", "revisionAfter", "<init>", "(Lcom/intellij/history/core/revisions/Revision;Lcom/intellij/history/core/revisions/Revision;)V", "getRevisionBefore", "()Lcom/intellij/history/core/revisions/Revision;", "getRevisionAfter", "changeName", "", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getChangeName", "()Ljava/lang/String;", "timestamp", "", "getTimestamp", "()J", "toString", "intellij.platform.lvcs.impl"})
@ApiStatus.Internal
public final class RecentChange {
    @NotNull
    private final Revision revisionBefore;
    @NotNull
    private final Revision revisionAfter;

    public RecentChange(@NotNull Revision revisionBefore, @NotNull Revision revisionAfter) {
        Intrinsics.checkNotNullParameter((Object)revisionBefore, (String)"revisionBefore");
        Intrinsics.checkNotNullParameter((Object)revisionAfter, (String)"revisionAfter");
        this.revisionBefore = revisionBefore;
        this.revisionAfter = revisionAfter;
    }

    @NotNull
    public final Revision getRevisionBefore() {
        return this.revisionBefore;
    }

    @NotNull
    public final Revision getRevisionAfter() {
        return this.revisionAfter;
    }

    @Nullable
    public final String getChangeName() {
        return this.revisionAfter.getChangeSetName();
    }

    public final long getTimestamp() {
        return this.revisionAfter.getTimestamp();
    }

    @NotNull
    public String toString() {
        return this.getChangeName() + "[" + DateFormatUtil.formatDateTime((long)this.getTimestamp()) + "]";
    }
}

