/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jvm.advanced.java.log.capture;

import com.intellij.build.BuildView;
import com.intellij.codeInsight.hints.presentation.InlayButtonPresentationFactory;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.AsyncStacksUtils;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImplKt;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.jvm.advanced.java.log.capture.LogCaptureBundle;
import com.intellij.debugger.jvm.advanced.java.log.capture.OfflineStackFrame;
import com.intellij.debugger.memory.ui.StackFramePopup;
import com.intellij.debugger.memory.utils.StackFrameItem;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.breakpoints.SyntheticLineBreakpoint;
import com.intellij.execution.filters.ConsoleDependentFilterProvider;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkInfoBase;
import com.intellij.execution.impl.InlayProvider;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.idea.AppMode;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtilKmp;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0007\u0018\u0000 \u00172\u00020\u0001:\n\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture;", "", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "bySession", "", "Lcom/intellij/debugger/impl/DebuggerSession;", "Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$SessionData;", "byConsole", "Lcom/intellij/execution/ui/ConsoleView;", "SessionData", "NavigationInfo", "BreakpointNavigationInfo", "CapturedStackTraceNavigationInfo", "DebuggerListener", "AgentBreakpoint", "ConsoleFilterProvider", "ConsoleFilter", "InlayButtonResult", "Companion", "intellij.debugger.jvm.advanced.java"})
public final class LogCapture {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Map<DebuggerSession, SessionData> bySession;
    @NotNull
    private final Map<ConsoleView, SessionData> byConsole;
    @NotNull
    private static final TextAttributes EMPTY_TEXT_ATTRS;
    @NotNull
    private static final TextAttributes DEFAULT_HOVER_TEXT_ATTRS;

    public LogCapture(@NotNull Project project, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        this.bySession = new LinkedHashMap();
        this.byConsole = new LinkedHashMap();
        BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx((Project)project).getBreakpointManager();
        Intrinsics.checkNotNullExpressionValue((Object)breakpointManager, (String)"getBreakpointManager(...)");
        BreakpointManager breakpointManager2 = breakpointManager;
        breakpointManager2.addLogMessageListener(scope, (arg_0, arg_1, arg_2) -> LogCapture._init_$lambda$0(this, arg_0, arg_1, arg_2));
    }

    private static final void _init_$lambda$0(LogCapture this$0, Breakpoint breakpoint, String message, DebugProcessImpl debugProcess) {
        Intrinsics.checkNotNullParameter((Object)breakpoint, (String)"breakpoint");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        if (!Companion.isEnabledForBreakpoints()) {
            return;
        }
        XSourcePosition xSourcePosition = breakpoint.getXBreakpoint().getSourcePosition();
        if (xSourcePosition == null) {
            return;
        }
        XSourcePosition xPosition = xSourcePosition;
        DebuggerSession debuggerSession = debugProcess.getSession();
        if (debuggerSession == null) {
            return;
        }
        DebuggerSession session = debuggerSession;
        SessionData sessionData = this$0.bySession.get(session);
        if (sessionData == null) {
            return;
        }
        SessionData data = sessionData;
        data.captureText(message, new BreakpointNavigationInfo(xPosition));
    }

    @JvmStatic
    @NotNull
    public static final LogCapture getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final boolean isEnabledForStdout() {
        return Companion.isEnabledForStdout();
    }

    public static final boolean isEnabledForBreakpoints() {
        return Companion.isEnabledForBreakpoints();
    }

    public static final boolean isEnabled() {
        return Companion.isEnabled();
    }

    static {
        TextAttributes textAttributes;
        Companion = new Companion(null);
        EMPTY_TEXT_ATTRS = new TextAttributes(null, null, null, null, 0);
        TextAttributes $this$DEFAULT_HOVER_TEXT_ATTRS_u24lambda_u240 = textAttributes = new TextAttributes();
        boolean bl = false;
        $this$DEFAULT_HOVER_TEXT_ATTRS_u24lambda_u240.setEffectType(EffectType.BOLD_DOTTED_LINE);
        $this$DEFAULT_HOVER_TEXT_ATTRS_u24lambda_u240.setEffectColor(NamedColorUtil.getInactiveTextColor());
        DEFAULT_HOVER_TEXT_ATTRS = textAttributes;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\tH\u0016J\u0012\u0010\u001c\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J&\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010#0\u001eH\u0002J\u0018\u0010$\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$AgentBreakpoint;", "Lcom/intellij/debugger/ui/breakpoints/SyntheticLineBreakpoint;", "project", "Lcom/intellij/openapi/project/Project;", "data", "Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$SessionData;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$SessionData;)V", "className", "", "methodName", "processLocatableEvent", "", "action", "Lcom/intellij/debugger/engine/events/SuspendContextCommandImpl;", "event", "Lcom/sun/jdi/event/LocatableEvent;", "createRequest", "", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "createRequestForPreparedClass", "classType", "Lcom/sun/jdi/ReferenceType;", "createRequestInMethod", "method", "Lcom/sun/jdi/Method;", "getDisplayName", "getEventMessage", "collectNavigatableLocations", "", "Lcom/intellij/debugger/jvm/advanced/java/log/capture/OfflineStackFrame;", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "frames", "Lcom/intellij/debugger/memory/utils/StackFrameItem;", "isFilteredLocation", "location", "Lcom/sun/jdi/Location;", "intellij.debugger.jvm.advanced.java"})
    @SourceDebugExtension(value={"SMAP\nLogCapture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogCapture.kt\ncom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$AgentBreakpoint\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,428:1\n1915#2,2:429\n*S KotlinDebug\n*F\n+ 1 LogCapture.kt\ncom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$AgentBreakpoint\n*L\n182#1:429,2\n*E\n"})
    private static final class AgentBreakpoint
    extends SyntheticLineBreakpoint {
        @NotNull
        private final SessionData data;
        @NotNull
        private final String className;
        @NotNull
        private final String methodName;

        public AgentBreakpoint(@NotNull Project project, @NotNull SessionData data) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            super(project);
            this.data = data;
            this.className = "com.intellij.rt.debugger.agent.LogCaptureStorage";
            this.methodName = "save";
            this.setSuspendPolicy("SuspendNone");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean processLocatableEvent(@NotNull SuspendContextCommandImpl action, @Nullable LocatableEvent event) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            if (event == null) {
                return false;
            }
            SuspendContextImpl suspendContextImpl = action.getSuspendContext();
            Intrinsics.checkNotNull((Object)suspendContextImpl);
            SuspendContextImpl suspendContext = suspendContextImpl;
            StackFrame frame = event.thread().frame(0);
            List arguments = DebuggerUtilsEx.getArgumentValues((StackFrame)frame);
            Object e = arguments.get(0);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.sun.jdi.StringReference");
            String captured = ((StringReference)e).value();
            String content = null;
            List stackTrace = null;
            Intrinsics.checkNotNull((Object)captured);
            Object object = captured;
            Charset charset = StandardCharsets.ISO_8859_1;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"ISO_8859_1");
            Object object2 = charset;
            byte[] byArray = ((String)object).getBytes((Charset)object2);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            object = new DataInputStream(new ByteArrayInputStream(byArray));
            object2 = null;
            try {
                List list;
                DataInputStream it = (DataInputStream)object;
                boolean bl = false;
                int size = it.readInt();
                byte[] byArray2 = it.readNBytes(size);
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"readNBytes(...)");
                byte[] byArray3 = byArray2;
                Charset charset2 = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
                Charset charset3 = charset2;
                content = new String(byArray3, charset3);
                if (AsyncStacksUtils.parseAgentAsyncStackTrace((DataInputStream)it, (VirtualMachineProxyImpl)suspendContext.getVirtualMachineProxy()) == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                stackTrace = list;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
            this.data.captureText(content, new CapturedStackTraceNavigationInfo(this.collectNavigatableLocations(suspendContext, stackTrace)));
            return false;
        }

        public void createRequest(@NotNull DebugProcessImpl debugProcess) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            this.createOrWaitPrepare(debugProcess, this.className);
        }

        protected void createRequestForPreparedClass(@NotNull DebugProcessImpl debugProcess, @NotNull ReferenceType classType) {
            Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
            Intrinsics.checkNotNullParameter((Object)classType, (String)"classType");
            List list = DebuggerUtilsEx.declaredMethodsByName((ReferenceType)classType, (String)this.methodName);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"declaredMethodsByName(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                boolean bl;
                Method method = (Method)element$iv;
                boolean bl2 = false;
                if (method.isNative()) continue;
                boolean bl3 = bl = !method.isAbstract();
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                Intrinsics.checkNotNull((Object)method);
                this.createRequestInMethod(debugProcess, method);
            }
        }

        private final void createRequestInMethod(DebugProcessImpl debugProcess, Method method) {
            Location location = method.locationOfCodeIndex(0L);
            RequestManagerImpl requestsManager = debugProcess.getRequestsManager();
            BreakpointRequest request = requestsManager.createBreakpointRequest((FilteredRequestor)this, location);
            requestsManager.enableRequest((EventRequest)request);
        }

        @NotNull
        public String getDisplayName() {
            return LogCaptureBundle.INSTANCE.message("debugger.log.capture.breakpoint.name", new Object[0]);
        }

        @NotNull
        public String getEventMessage(@Nullable LocatableEvent event) {
            return "";
        }

        private final List<OfflineStackFrame> collectNavigatableLocations(SuspendContextImpl suspendContext, List<? extends StackFrameItem> frames) {
            List list;
            List $this$collectNavigatableLocations_u24lambda_u240 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            DebugProcessImpl debugProcess = suspendContext.getDebugProcess();
            for (StackFrameItem stackFrameItem : frames) {
                SourcePosition position;
                if (stackFrameItem == null) continue;
                Location location = stackFrameItem.location();
                Intrinsics.checkNotNull((Object)location);
                if (this.isFilteredLocation(debugProcess, location) || debugProcess.getPositionManager().getSourcePosition(location) == null) continue;
                $this$collectNavigatableLocations_u24lambda_u240.add(new OfflineStackFrame(stackFrameItem, position));
            }
            return CollectionsKt.build((List)list);
        }

        private final boolean isFilteredLocation(DebugProcessImpl debugProcess, Location location) {
            if (DebugProcessImpl.isPositionFiltered((Location)location)) {
                return true;
            }
            SourcePosition sourcePosition = debugProcess.getPositionManager().getSourcePosition(location);
            if (sourcePosition == null) {
                return true;
            }
            SourcePosition position = sourcePosition;
            return DebuggerUtilsEx.isInLibraryContent((VirtualFile)position.getFile().getVirtualFile(), (Project)debugProcess.getProject());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$BreakpointNavigationInfo;", "Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$NavigationInfo;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "<init>", "(Lcom/intellij/xdebugger/XSourcePosition;)V", "getPosition", "()Lcom/intellij/xdebugger/XSourcePosition;", "intellij.debugger.jvm.advanced.java"})
    private static final class BreakpointNavigationInfo
    implements NavigationInfo {
        @NotNull
        private final XSourcePosition position;

        public BreakpointNavigationInfo(@NotNull XSourcePosition position) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            this.position = position;
        }

        @NotNull
        public final XSourcePosition getPosition() {
            return this.position;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$CapturedStackTraceNavigationInfo;", "Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$NavigationInfo;", "stackTrace", "", "Lcom/intellij/debugger/jvm/advanced/java/log/capture/OfflineStackFrame;", "<init>", "(Ljava/util/List;)V", "getStackTrace", "()Ljava/util/List;", "intellij.debugger.jvm.advanced.java"})
    private static final class CapturedStackTraceNavigationInfo
    implements NavigationInfo {
        @NotNull
        private final List<OfflineStackFrame> stackTrace;

        public CapturedStackTraceNavigationInfo(@NotNull List<? extends OfflineStackFrame> stackTrace) {
            Intrinsics.checkNotNullParameter(stackTrace, (String)"stackTrace");
            this.stackTrace = stackTrace;
        }

        @NotNull
        public final List<OfflineStackFrame> getStackTrace() {
            return this.stackTrace;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0002R\u001a\u0010\b\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\b\u0010\u000bR\u001a\u0010\f\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\r\u0010\u0003\u001a\u0004\b\f\u0010\u000bR\u001a\u0010\u000e\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u000f\u0010\u0003\u001a\u0004\b\u000e\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000bR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture;", "project", "Lcom/intellij/openapi/project/Project;", "isEnabledForStdout", "", "isEnabledForStdout$annotations", "()Z", "isEnabledForBreakpoints", "isEnabledForBreakpoints$annotations", "isEnabled", "isEnabled$annotations", "enabledState", "Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$Companion$EnabledState;", "uiKind", "Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$Companion$UiKind;", "getUiKind", "()Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$Companion$UiKind;", "showPopup", "getShowPopup", "EMPTY_TEXT_ATTRS", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "DEFAULT_HOVER_TEXT_ATTRS", "EnabledState", "UiKind", "intellij.debugger.jvm.advanced.java"})
    @SourceDebugExtension(value={"SMAP\nLogCapture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogCapture.kt\ncom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 LogCapture.kt\ncom/intellij/debugger/jvm/advanced/java/log/capture/LogCaptureKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,428:1\n30#2,2:429\n425#3:431\n426#3:433\n427#3:437\n425#3:438\n426#3:440\n427#3:444\n1#4:432\n1#4:439\n57#5:434\n35#5,2:435\n57#5:441\n35#5,2:442\n*S KotlinDebug\n*F\n+ 1 LogCapture.kt\ncom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$Companion\n*L\n364#1:429,2\n397#1:431\n397#1:433\n397#1:437\n408#1:438\n408#1:440\n408#1:444\n397#1:432\n408#1:439\n397#1:434\n397#1:435,2\n408#1:441\n408#1:442,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LogCapture getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LogCapture> serviceClass$iv = LogCapture.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LogCapture)object;
        }

        public final boolean isEnabledForStdout() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.enabledState().ordinal()]) {
                case 1, 2 -> false;
                case 3, 4 -> true;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @JvmStatic
        public static /* synthetic */ void isEnabledForStdout$annotations() {
        }

        public final boolean isEnabledForBreakpoints() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.enabledState().ordinal()]) {
                case 1, 3 -> false;
                case 2, 4 -> true;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @JvmStatic
        public static /* synthetic */ void isEnabledForBreakpoints$annotations() {
        }

        public final boolean isEnabled() {
            return switch (WhenMappings.$EnumSwitchMapping$0[this.enabledState().ordinal()]) {
                case 1 -> false;
                case 2, 3, 4 -> true;
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @JvmStatic
        public static /* synthetic */ void isEnabled$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        private final EnabledState enabledState() {
            Object object;
            void $this$asEnumWithDefault$iv;
            if (AppMode.isRemoteDevHost()) {
                return EnabledState.OFF;
            }
            RegistryValue registryValue = Registry.Companion.get("debugger.navigation.from.console.to.sources");
            Enum default$iv = EnabledState.OFF;
            boolean $i$f$asEnumWithDefault = false;
            Object object2 = $this$asEnumWithDefault$iv;
            try {
                void $this$asEnumWithDefault_u24lambda_u240$iv = object2;
                boolean bl = false;
                String string = $this$asEnumWithDefault_u24lambda_u240$iv.getSelectedOption();
                Intrinsics.checkNotNull((Object)string);
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                object = Result.constructor-impl((Object)((Object)EnabledState.valueOf(string2)));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it$iv = object = throwable;
                boolean bl = false;
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("unexpected registry value '" + (RegistryValue)$this$asEnumWithDefault$iv + "'");
            }
            return (EnabledState)((Enum)(Result.isFailure-impl((Object)object2) ? default$iv : object2));
        }

        /*
         * WARNING - void declaration
         */
        private final UiKind getUiKind() {
            Object object;
            void $this$asEnumWithDefault$iv;
            RegistryValue registryValue = Registry.Companion.get("debugger.navigation.from.console.to.sources.console.ui");
            Enum default$iv = UiKind.WHOLE_LINE;
            boolean $i$f$asEnumWithDefault = false;
            Object object2 = $this$asEnumWithDefault$iv;
            try {
                void $this$asEnumWithDefault_u24lambda_u240$iv = object2;
                boolean bl = false;
                String string = $this$asEnumWithDefault_u24lambda_u240$iv.getSelectedOption();
                Intrinsics.checkNotNull((Object)string);
                String string2 = string.toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                object = Result.constructor-impl((Object)((Object)UiKind.valueOf(string2)));
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object it$iv = object = throwable;
                boolean bl = false;
                boolean $i$f$fileLogger = false;
                boolean $i$f$currentClassLogger = false;
                Class<?> clazz$iv$iv$iv = MethodHandles.lookup().lookupClass();
                Logger logger = Logger.getInstance(clazz$iv$iv$iv);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("unexpected registry value '" + (RegistryValue)$this$asEnumWithDefault$iv + "'");
            }
            return (UiKind)((Enum)(Result.isFailure-impl((Object)object2) ? default$iv : object2));
        }

        private final boolean getShowPopup() {
            return Registry.Companion.is("debugger.navigation.from.console.to.sources.show.popup", false);
        }

        public static final /* synthetic */ boolean access$getShowPopup(Companion $this) {
            return $this.getShowPopup();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$Companion$EnabledState;", "", "<init>", "(Ljava/lang/String;I)V", "OFF", "ONLY_BREAKPOINTS", "ONLY_STDOUT", "ALL", "intellij.debugger.jvm.advanced.java"})
        private static final class EnabledState
        extends Enum<EnabledState> {
            public static final /* enum */ EnabledState OFF = new EnabledState();
            public static final /* enum */ EnabledState ONLY_BREAKPOINTS = new EnabledState();
            public static final /* enum */ EnabledState ONLY_STDOUT = new EnabledState();
            public static final /* enum */ EnabledState ALL = new EnabledState();
            private static final /* synthetic */ EnabledState[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static EnabledState[] values() {
                return (EnabledState[])$VALUES.clone();
            }

            public static EnabledState valueOf(String value) {
                return Enum.valueOf(EnabledState.class, value);
            }

            @NotNull
            public static EnumEntries<EnabledState> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = enabledStateArray = new EnabledState[]{EnabledState.OFF, EnabledState.ONLY_BREAKPOINTS, EnabledState.ONLY_STDOUT, EnabledState.ALL};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$Companion$UiKind;", "", "<init>", "(Ljava/lang/String;I)V", "WHOLE_LINE", "MINIMAL", "BUTTON", "INVISIBLE", "intellij.debugger.jvm.advanced.java"})
        private static final class UiKind
        extends Enum<UiKind> {
            public static final /* enum */ UiKind WHOLE_LINE = new UiKind();
            public static final /* enum */ UiKind MINIMAL = new UiKind();
            public static final /* enum */ UiKind BUTTON = new UiKind();
            public static final /* enum */ UiKind INVISIBLE = new UiKind();
            private static final /* synthetic */ UiKind[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static UiKind[] values() {
                return (UiKind[])$VALUES.clone();
            }

            public static UiKind valueOf(String value) {
                return Enum.valueOf(UiKind.class, value);
            }

            @NotNull
            public static EnumEntries<UiKind> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = uiKindArray = new UiKind[]{UiKind.WHOLE_LINE, UiKind.MINIMAL, UiKind.BUTTON, UiKind.INVISIBLE};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EnabledState.values().length];
                try {
                    nArray[EnabledState.OFF.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EnabledState.ONLY_BREAKPOINTS.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EnabledState.ONLY_STDOUT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EnabledState.ALL.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$ConsoleFilter;", "Lcom/intellij/execution/filters/Filter;", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/execution/ui/ConsoleView;Lcom/intellij/openapi/project/Project;)V", "getConsoleView", "()Lcom/intellij/execution/ui/ConsoleView;", "getProject", "()Lcom/intellij/openapi/project/Project;", "applyFilter", "Lcom/intellij/execution/filters/Filter$Result;", "line", "", "entireLength", "", "intellij.debugger.jvm.advanced.java"})
    @SourceDebugExtension(value={"SMAP\nLogCapture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogCapture.kt\ncom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$ConsoleFilter\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,428:1\n140#2:429\n129#2,5:430\n1#3:435\n627#4,6:436\n*S KotlinDebug\n*F\n+ 1 LogCapture.kt\ncom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$ConsoleFilter\n*L\n243#1:429\n243#1:430,5\n299#1:436,6\n*E\n"})
    private static final class ConsoleFilter
    implements Filter {
        @NotNull
        private final ConsoleView consoleView;
        @NotNull
        private final Project project;

        public ConsoleFilter(@NotNull ConsoleView consoleView, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.consoleView = consoleView;
            this.project = project;
        }

        @NotNull
        public final ConsoleView getConsoleView() {
            return this.consoleView;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @Nullable
        public Filter.Result applyFilter(@NotNull String line, int entireLength) {
            int n;
            String string;
            int lineStartOffs;
            HyperlinkInfoBase hyperlinkInfo2;
            Object[] info;
            block19: {
                Object v2;
                Iterable $i$f$trimEnd3;
                SessionData sessionData;
                block18: {
                    CharSequence charSequence;
                    block17: {
                        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                        SessionData sessionData2 = (SessionData)Companion.getInstance(this.project).byConsole.get(this.consoleView);
                        if (sessionData2 == null) {
                            return null;
                        }
                        sessionData = sessionData2;
                        String $this$trimEnd$iv = line;
                        boolean $i$f$trimEnd2 = false;
                        CharSequence $this$trimEnd$iv$iv = $this$trimEnd$iv;
                        boolean $i$f$trimEnd3 = false;
                        int n2 = $this$trimEnd$iv$iv.length() + -1;
                        if (0 <= n2) {
                            do {
                                int index$iv$iv = n2--;
                                char it = $this$trimEnd$iv$iv.charAt(index$iv$iv);
                                boolean bl = false;
                                if (StringUtilKmp.isLineBreak((char)it)) continue;
                                charSequence = $this$trimEnd$iv$iv.subSequence(0, index$iv$iv + 1);
                                break block17;
                            } while (0 <= n2);
                        }
                        charSequence = "";
                    }
                    String lineTrimmed = ((Object)charSequence).toString();
                    if (((CharSequence)lineTrimmed).length() == 0) {
                        return null;
                    }
                    $i$f$trimEnd3 = sessionData.getCapturedNotYetHighlighted();
                    for (Object index$iv$iv : $i$f$trimEnd3) {
                        Pair it = (Pair)index$iv$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)lineTrimmed)) continue;
                        v2 = index$iv$iv;
                        break block18;
                    }
                    v2 = null;
                }
                Pair $i$f$trimEnd2 = v2;
                if ($i$f$trimEnd2 == null) {
                    return null;
                }
                Iterable it = $i$f$trimEnd3 = $i$f$trimEnd2;
                boolean bl = false;
                sessionData.getCapturedNotYetHighlighted().remove(it);
                info = (Object[])$i$f$trimEnd3.component2();
                hyperlinkInfo2 = new HyperlinkInfoBase((NavigationInfo)info){
                    final /* synthetic */ NavigationInfo $info;
                    {
                        this.$info = $info;
                    }

                    private final void navigateSingle(Project project, XSourcePosition position) {
                        XDebuggerUtilImpl.createNavigatable((Project)project, (XSourcePosition)position).navigate(true);
                    }

                    /*
                     * Unable to fully structure code
                     * Could not resolve type clashes
                     */
                    public void navigate(Project project, RelativePoint hyperlinkLocationPoint) {
                        block11: {
                            block12: {
                                block9: {
                                    block10: {
                                        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                                        var3_3 = this.$info;
                                        if (!(var3_3 instanceof BreakpointNavigationInfo)) break block10;
                                        this.navigateSingle(project, ((BreakpointNavigationInfo)this.$info).getPosition());
                                        break block11;
                                    }
                                    if (!(var3_3 instanceof CapturedStackTraceNavigationInfo)) break block12;
                                    frames = ((CapturedStackTraceNavigationInfo)this.$info).getStackTrace();
                                    var5_5 = (OfflineStackFrame)CollectionsKt.singleOrNull(frames);
                                    if (var5_5 != null && (var6_7 = var5_5.getSourcePosition()) != null) {
                                        it = var6_7;
                                        $i$a$-let-LogCapture$ConsoleFilter$applyFilter$hyperlinkInfo$1$navigate$1 = false;
                                        this.navigateSingle(project, it);
                                        return;
                                    }
                                    $this$indexOfFirst$iv = frames;
                                    $i$f$indexOfFirst = false;
                                    index$iv = 0;
                                    var9_11 = $this$indexOfFirst$iv.iterator();
                                    while (var9_11.hasNext()) {
                                        f = item$iv = var9_11.next();
                                        $i$a$-indexOfFirst-LogCapture$ConsoleFilter$applyFilter$hyperlinkInfo$1$navigate$selected$1 = false;
                                        Intrinsics.checkNotNullExpressionValue((Object)f.getJavaSourcePosition(), (String)"getJavaSourcePosition(...)");
                                        line = pos.getLine();
                                        Intrinsics.checkNotNullExpressionValue((Object)pos.getFile().getFileDocument(), (String)"getFileDocument(...)");
                                        if (0 > line || line >= doc.getLineCount()) ** GOTO lbl-1000
                                        v0 = doc.getText(new TextRange(doc.getLineStartOffset(line), doc.getLineEndOffset(line)));
                                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getText(...)");
                                        if (StringsKt.contains$default((CharSequence)v0, (char)'\"', (boolean)false, (int)2, null)) {
                                            v1 = true;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v1 = false;
                                        }
                                        if (v1) {
                                            v2 = index$iv;
                                            break block9;
                                        }
                                        ++index$iv;
                                    }
                                    v2 = selected = -1;
                                }
                                if (com.intellij.debugger.jvm.advanced.java.log.capture.LogCapture$Companion.access$getShowPopup(LogCapture.Companion)) {
                                    StackFramePopup.show(frames, (Project)project, (RelativePoint)hyperlinkLocationPoint, (int)selected);
                                } else {
                                    v3 = (OfflineStackFrame)CollectionsKt.getOrNull(frames, (int)selected);
                                    v4 /* !! */  = selectedPosition = v3 != null ? v3.getSourcePosition() : null;
                                    if (selectedPosition != null) {
                                        this.navigateSingle(project, selectedPosition);
                                    } else {
                                        XDebuggerManagerImpl.getNotificationGroup().createNotification(LogCaptureBundle.INSTANCE.message("debugger.log.capture.notification.unable.to.choose.single.frame", new Object[0]), NotificationType.INFORMATION).notify(project);
                                    }
                                }
                                break block11;
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                };
                lineStartOffs = entireLength - line.length();
                String $this$takeLastWhile$iv = line;
                boolean $i$f$takeLastWhile = false;
                for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                    char it2 = $this$takeLastWhile$iv.charAt(index$iv);
                    int n3 = 0;
                    if (StringUtilKmp.isLineBreak((char)it2)) continue;
                    String string2 = $this$takeLastWhile$iv;
                    n3 = index$iv + 1;
                    String string3 = string2.substring(n3);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    break block19;
                }
                string = $this$takeLastWhile$iv;
            }
            int lineBreakSuffixLen = string.length();
            int lineEndOffs = entireLength - lineBreakSuffixLen;
            switch (WhenMappings.$EnumSwitchMapping$0[Companion.getUiKind().ordinal()]) {
                case 1: {
                    return null;
                }
                case 2: {
                    String string4;
                    Object[] objectArray = info;
                    if (objectArray instanceof BreakpointNavigationInfo) {
                        string4 = LogCaptureBundle.INSTANCE.message("debugger.log.capture.navigate.to.breakpoint.button.title", new Object[0]);
                    } else if (objectArray instanceof CapturedStackTraceNavigationInfo) {
                        string4 = LogCaptureBundle.INSTANCE.message("debugger.log.capture.navigate.to.source.button.title", new Object[0]);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    String buttonTitle = string4;
                    objectArray = new Filter.ResultItem[]{new InlayButtonResult(this.project, lineStartOffs, lineEndOffs, hyperlinkInfo2, buttonTitle), new Filter.ResultItem(0, 0, null)};
                    return new Filter.Result(CollectionsKt.listOf((Object[])objectArray));
                }
                case 3: {
                    n = Math.min(lineStartOffs + 3, lineEndOffs);
                    break;
                }
                case 4: {
                    n = lineEndOffs;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            int endOffset = n;
            return new Filter.Result(lineStartOffs, endOffset, (HyperlinkInfo)hyperlinkInfo2, EMPTY_TEXT_ATTRS, DEFAULT_HOVER_TEXT_ATTRS, DEFAULT_HOVER_TEXT_ATTRS);
        }

        @Metadata(mv={2, 3, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Companion.UiKind.values().length];
                try {
                    nArray[Companion.UiKind.INVISIBLE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Companion.UiKind.BUTTON.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Companion.UiKind.MINIMAL.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Companion.UiKind.WHOLE_LINE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$ConsoleFilterProvider;", "Lcom/intellij/execution/filters/ConsoleDependentFilterProvider;", "<init>", "()V", "getDefaultFilters", "", "Lcom/intellij/execution/filters/Filter;", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "project", "Lcom/intellij/openapi/project/Project;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/execution/ui/ConsoleView;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/search/GlobalSearchScope;)[Lcom/intellij/execution/filters/Filter;", "intellij.debugger.jvm.advanced.java"})
    public static final class ConsoleFilterProvider
    extends ConsoleDependentFilterProvider {
        @NotNull
        public Filter[] getDefaultFilters(@NotNull ConsoleView consoleView, @NotNull Project project, @NotNull GlobalSearchScope scope) {
            Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            if (!Companion.isEnabled()) {
                Intrinsics.checkNotNullExpressionValue((Object)Filter.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
                return Filter.EMPTY_ARRAY;
            }
            ConsoleFilter[] consoleFilterArray = new ConsoleFilter[]{new ConsoleFilter(consoleView, project)};
            return consoleFilterArray;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0012\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$DebuggerListener;", "Lcom/intellij/debugger/impl/DebuggerManagerListener;", "<init>", "()V", "sessionCreated", "", "session", "Lcom/intellij/debugger/impl/DebuggerSession;", "sessionAttached", "sessionDetached", "intellij.debugger.jvm.advanced.java"})
    public static final class DebuggerListener
    implements DebuggerManagerListener {
        public void sessionCreated(@Nullable DebuggerSession session) {
            ConsoleView consoleView;
            if (!Companion.isEnabled()) {
                return;
            }
            if (session == null) {
                return;
            }
            Project project = session.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            LogCapture $this$sessionCreated_u24lambda_u240 = Companion.getInstance(project);
            boolean bl = false;
            if ($this$sessionCreated_u24lambda_u240.bySession.containsKey(session)) {
                return;
            }
            ExecutionConsole ec = session.getProcess().getExecutionResult().getExecutionConsole();
            if (ec instanceof BuildView) {
                ExecutionConsole executionConsole = ((BuildView)ec).getConsoleView();
                consoleView = executionConsole instanceof ConsoleView ? (ConsoleView)executionConsole : null;
                if (consoleView == null) {
                    return;
                }
            } else if (ec instanceof ConsoleView) {
                consoleView = (ConsoleView)ec;
            } else {
                return;
            }
            ConsoleView consoleView2 = consoleView;
            SessionData sessionData = new SessionData();
            $this$sessionCreated_u24lambda_u240.bySession.put(session, sessionData);
            $this$sessionCreated_u24lambda_u240.byConsole.put(consoleView2, sessionData);
            Disposer.register((Disposable)((Disposable)consoleView2), () -> DebuggerListener.sessionCreated$lambda$0$0($this$sessionCreated_u24lambda_u240, consoleView2));
        }

        public void sessionAttached(@Nullable DebuggerSession session) {
            if (!Companion.isEnabledForStdout()) {
                return;
            }
            if (session == null) {
                return;
            }
            Project project = session.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            LogCapture $this$sessionAttached_u24lambda_u240 = Companion.getInstance(project);
            boolean bl = false;
            SessionData sessionData = (SessionData)$this$sessionAttached_u24lambda_u240.bySession.get(session);
            if (sessionData == null) {
                return;
            }
            SessionData sessionData2 = sessionData;
            DebuggerManagerThreadImpl debuggerManagerThreadImpl = session.getProcess().getManagerThread();
            Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerThreadImpl, (String)"getManagerThread(...)");
            DebuggerManagerThreadImplKt.executeOnDMT$default((DebuggerManagerThreadImpl)debuggerManagerThreadImpl, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session, sessionData2, null){
                int label;
                final /* synthetic */ DebuggerSession $session;
                final /* synthetic */ SessionData $sessionData;
                {
                    this.$session = $session;
                    this.$sessionData = $sessionData;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Project project = this.$session.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                            AgentBreakpoint agentBreakpoint = new AgentBreakpoint(project, this.$sessionData);
                            DebugProcessImpl debugProcessImpl = this.$session.getProcess();
                            Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"getProcess(...)");
                            agentBreakpoint.createRequest(debugProcessImpl);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
        }

        public void sessionDetached(@Nullable DebuggerSession session) {
            if (!Companion.isEnabled()) {
                return;
            }
            if (session == null) {
                return;
            }
            Project project = session.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            LogCapture $this$sessionDetached_u24lambda_u240 = Companion.getInstance(project);
            boolean bl = false;
            SessionData cfr_ignored_0 = (SessionData)$this$sessionDetached_u24lambda_u240.bySession.remove(session);
        }

        private static final void sessionCreated$lambda$0$0(LogCapture $this_with, ConsoleView $consoleView) {
            $this_with.byConsole.remove($consoleView);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B6\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000b\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u00070\u000b\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$InlayButtonResult;", "Lcom/intellij/execution/filters/Filter$ResultItem;", "Lcom/intellij/execution/impl/InlayProvider;", "project", "Lcom/intellij/openapi/project/Project;", "highlightStartOffset", "", "highlightEndOffset", "hyperlinkInfo", "Lcom/intellij/execution/filters/HyperlinkInfoBase;", "buttonTitle", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Lcom/intellij/openapi/project/Project;IILcom/intellij/execution/filters/HyperlinkInfoBase;Ljava/lang/String;)V", "createInlayRenderer", "Lcom/intellij/openapi/editor/EditorCustomElementRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.debugger.jvm.advanced.java"})
    public static final class InlayButtonResult
    extends Filter.ResultItem
    implements InlayProvider {
        @NotNull
        private final Project project;
        @NotNull
        private final HyperlinkInfoBase hyperlinkInfo;
        @NotNull
        private final String buttonTitle;

        public InlayButtonResult(@NotNull Project project, int highlightStartOffset, int highlightEndOffset, @NotNull HyperlinkInfoBase hyperlinkInfo2, @NotNull String buttonTitle) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)hyperlinkInfo2, (String)"hyperlinkInfo");
            Intrinsics.checkNotNullParameter((Object)buttonTitle, (String)"buttonTitle");
            super(highlightStartOffset, highlightEndOffset, null, DEFAULT_HOVER_TEXT_ATTRS);
            this.project = project;
            this.hyperlinkInfo = hyperlinkInfo2;
            this.buttonTitle = buttonTitle;
        }

        @NotNull
        public EditorCustomElementRenderer createInlayRenderer(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            PresentationFactory factory = new PresentationFactory(editor);
            TextAttributesKey textAttributesKey = DefaultLanguageHighlighterColors.INLAY_BUTTON_DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"INLAY_BUTTON_DEFAULT");
            TextAttributesKey textAttributesKey2 = DefaultLanguageHighlighterColors.INLAY_BUTTON_HOVERED;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey2, (String)"INLAY_BUTTON_HOVERED");
            TextAttributesKey textAttributesKey3 = DefaultLanguageHighlighterColors.INLAY_BUTTON_FOCUSED;
            Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey3, (String)"INLAY_BUTTON_FOCUSED");
            InlayButtonPresentationFactory inlayButtonFactory = new InlayButtonPresentationFactory(editor, factory, textAttributesKey, textAttributesKey2, textAttributesKey3);
            InlayPresentation presentation = inlayButtonFactory.smallText(this.buttonTitle).onClick((arg_0, arg_1) -> InlayButtonResult.createInlayRenderer$lambda$0(this, arg_0, arg_1)).build();
            return (EditorCustomElementRenderer)new PresentationRenderer(presentation);
        }

        private static final void createInlayRenderer$lambda$0(InlayButtonResult this$0, MouseEvent event, Point point) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)point, (String)"<unused var>");
            this$0.hyperlinkInfo.navigate(this$0.project, new RelativePoint(event));
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001\u0082\u0001\u0002\u0002\u0003\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$NavigationInfo;", "", "Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$BreakpointNavigationInfo;", "Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$CapturedStackTraceNavigationInfo;", "intellij.debugger.jvm.advanced.java"})
    private static sealed interface NavigationInfo
    permits BreakpointNavigationInfo, CapturedStackTraceNavigationInfo {
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\bR#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$SessionData;", "", "<init>", "()V", "capturedNotYetHighlighted", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lkotlin/Pair;", "", "Lcom/intellij/debugger/jvm/advanced/java/log/capture/LogCapture$NavigationInfo;", "getCapturedNotYetHighlighted", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "captureText", "", "text", "info", "intellij.debugger.jvm.advanced.java"})
    private static final class SessionData {
        @NotNull
        private final ConcurrentLinkedQueue<Pair<String, NavigationInfo>> capturedNotYetHighlighted = new ConcurrentLinkedQueue();

        @NotNull
        public final ConcurrentLinkedQueue<Pair<String, NavigationInfo>> getCapturedNotYetHighlighted() {
            return this.capturedNotYetHighlighted;
        }

        public final void captureText(@NotNull String text, @NotNull NavigationInfo info) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            for (String line : StringsKt.lines((CharSequence)text)) {
                if (!(!StringsKt.isBlank((CharSequence)line))) continue;
                ((Collection)this.capturedNotYetHighlighted).add(TuplesKt.to((Object)line, (Object)info));
            }
        }
    }
}

