/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.vcs.log.VcsCommitStyleFactory;
import com.intellij.vcs.log.VcsLogAggregatedStoredRefs;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogHighlighter;
import com.intellij.vcs.log.VcsLogRangeFilter;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogGraphData;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.ui.highlighters.MergeCommitsHighlighter;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import git4idea.GitLocalBranch;
import git4idea.branch.CherryPickedCommitsHighlighterHolder;
import git4idea.branch.DeepComparator;
import git4idea.branch.GitCompareBranchesUi;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000 12\u00020\u00012\u00020\u0002:\u0003/01B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\rJ(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001fH\u0016J\u0018\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0011H\u0007J\b\u0010'\u001a\u00020!H\u0007J\b\u0010(\u001a\u00020\u001fH\u0007J\u0010\u0010%\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\b\u0010)\u001a\u00020!H\u0002J\b\u0010*\u001a\u00020!H\u0002J$\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u00132\u0006\u0010\"\u001a\u00020#2\u0006\u0010&\u001a\u00020\u0011H\u0002J\u0012\u0010,\u001a\u00020!2\b\u0010-\u001a\u0004\u0018\u00010\u0011H\u0002J\b\u0010.\u001a\u00020!H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lgit4idea/branch/CherryPickedCommitsHighlighter;", "Lcom/intellij/vcs/log/VcsLogHighlighter;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "repositoryManager", "Lgit4idea/repo/GitRepositoryManager;", "vcsLogData", "Lcom/intellij/vcs/log/data/VcsLogData;", "ui", "Lcom/intellij/vcs/log/VcsLogUi;", "parent", "<init>", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepositoryManager;Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/VcsLogUi;Lcom/intellij/openapi/Disposable;)V", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "comparedBranch", "", "repositoriesWithTargetBranches", "", "Lgit4idea/repo/GitRepository;", "nonPickedCommits", "Lit/unimi/dsi/fastutil/ints/IntOpenHashSet;", "getStyle", "Lcom/intellij/vcs/log/VcsLogHighlighter$VcsCommitStyle;", "commitId", "", "commitDetails", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "column", "isSelected", "", "update", "", "dataPack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "refreshHappened", "startTask", "branchToCompare", "stopTaskAndUnhighlight", "hasHighlightingOrInProgress", "stopTask", "unhighlight", "getRepositoriesWithTargetBranches", "notifyUnhighlight", "branch", "dispose", "MyTask", "Factory", "Companion", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nCherryPickedCommitsHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CherryPickedCommitsHighlighter.kt\ngit4idea/branch/CherryPickedCommitsHighlighter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1642#2,10:249\n1915#2:259\n1916#2:261\n1652#2:262\n777#2:263\n873#2,2:264\n1300#2,2:266\n1315#2,4:268\n1#3:260\n*S KotlinDebug\n*F\n+ 1 CherryPickedCommitsHighlighter.kt\ngit4idea/branch/CherryPickedCommitsHighlighter\n*L\n148#1:249,10\n148#1:259\n148#1:261\n148#1:262\n148#1:263\n148#1:264,2\n150#1:266,2\n150#1:268,4\n148#1:260\n*E\n"})
public final class CherryPickedCommitsHighlighter
implements VcsLogHighlighter,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepositoryManager repositoryManager;
    @NotNull
    private final VcsLogData vcsLogData;
    @NotNull
    private final VcsLogUi ui;
    @Nullable
    private ProgressIndicator progressIndicator;
    @Nullable
    private String comparedBranch;
    @Nullable
    private Map<GitRepository, String> repositoriesWithTargetBranches;
    @Nullable
    private IntOpenHashSet nonPickedCommits;
    @NotNull
    private static final Logger LOG;

    public CherryPickedCommitsHighlighter(@NotNull Project project, @NotNull GitRepositoryManager repositoryManager, @NotNull VcsLogData vcsLogData, @NotNull VcsLogUi ui2, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)repositoryManager), (String)"repositoryManager");
        Intrinsics.checkNotNullParameter((Object)vcsLogData, (String)"vcsLogData");
        Intrinsics.checkNotNullParameter((Object)ui2, (String)"ui");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.project = project;
        this.repositoryManager = repositoryManager;
        this.vcsLogData = vcsLogData;
        this.ui = ui2;
        Disposer.register((Disposable)parent, (Disposable)this);
    }

    @NotNull
    public VcsLogHighlighter.VcsCommitStyle getStyle(int commitId, @NotNull VcsShortCommitDetails commitDetails, int column, boolean isSelected) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)commitDetails, (String)"commitDetails");
                if (this.nonPickedCommits == null) break block2;
                IntOpenHashSet intOpenHashSet = this.nonPickedCommits;
                Intrinsics.checkNotNull((Object)intOpenHashSet);
                if (!intOpenHashSet.contains(commitId)) break block3;
            }
            VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsLogHighlighter.VcsCommitStyle.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)vcsCommitStyle, (String)"DEFAULT");
            return vcsCommitStyle;
        }
        VcsLogHighlighter.VcsCommitStyle vcsCommitStyle = VcsCommitStyleFactory.foreground((Color)((Color)MergeCommitsHighlighter.MERGE_COMMIT_FOREGROUND));
        Intrinsics.checkNotNullExpressionValue((Object)vcsCommitStyle, (String)"foreground(...)");
        return vcsCommitStyle;
    }

    public void update(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        if (this.comparedBranch == null) {
            return;
        }
        VcsLogFilterCollection vcsLogFilterCollection = dataPack.getFilters();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"getFilters(...)");
        VcsLogAggregatedStoredRefs vcsLogAggregatedStoredRefs = dataPack.getRefs();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogAggregatedStoredRefs, (String)"getRefs(...)");
        String singleFilteredBranch = Companion.getComparedBranchFromFilters(vcsLogFilterCollection, vcsLogAggregatedStoredRefs);
        if (!Intrinsics.areEqual((Object)this.comparedBranch, (Object)singleFilteredBranch)) {
            String oldComparedBranch = this.comparedBranch;
            LOG.debug("Branch filter changed. Compared branch: " + oldComparedBranch + ", filtered branch: " + singleFilteredBranch);
            this.stopTaskAndUnhighlight();
            this.notifyUnhighlight(oldComparedBranch);
            return;
        }
        if (refreshHappened) {
            this.stopTask();
            String string = this.comparedBranch;
            Intrinsics.checkNotNull((Object)string);
            Map<GitRepository, String> repositories = this.getRepositoriesWithTargetBranches(dataPack, string);
            if (Intrinsics.areEqual(repositories, this.repositoriesWithTargetBranches)) {
                this.startTask(dataPack);
            } else {
                LOG.debug("Repositories with target branches changed. Actual:\n" + repositories + "\nExpected:\n" + this.repositoriesWithTargetBranches);
                this.unhighlight();
            }
        }
    }

    @RequiresEdt
    public final void startTask(@NotNull VcsLogDataPack dataPack, @NotNull String branchToCompare) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter((Object)branchToCompare, (String)"branchToCompare");
        ThreadingAssertions.assertEventDispatchThread();
        if (this.comparedBranch != null) {
            LOG.error("Already comparing with branch " + this.comparedBranch);
            return;
        }
        VcsLogDataPack vcsLogDataPack = this.ui.getDataPack();
        Intrinsics.checkNotNullExpressionValue((Object)vcsLogDataPack, (String)"getDataPack(...)");
        Map<GitRepository, String> repositories = this.getRepositoriesWithTargetBranches(vcsLogDataPack, branchToCompare);
        if (repositories.isEmpty()) {
            LOG.debug("Could not find suitable repositories for selected branch " + this.comparedBranch);
            return;
        }
        this.comparedBranch = branchToCompare;
        this.repositoriesWithTargetBranches = repositories;
        this.startTask(dataPack);
    }

    @RequiresEdt
    public final void stopTaskAndUnhighlight() {
        ThreadingAssertions.assertEventDispatchThread();
        this.stopTask();
        this.unhighlight();
    }

    @RequiresEdt
    public final boolean hasHighlightingOrInProgress() {
        ThreadingAssertions.assertEventDispatchThread();
        return this.comparedBranch != null;
    }

    private final void startTask(VcsLogDataPack dataPack) {
        LOG.debug("Highlighting requested for " + this.repositoriesWithTargetBranches);
        Map<GitRepository, String> map2 = this.repositoriesWithTargetBranches;
        Intrinsics.checkNotNull(map2);
        String string = this.comparedBranch;
        Intrinsics.checkNotNull((Object)string);
        MyTask task = new MyTask(map2, dataPack, string);
        this.progressIndicator = (ProgressIndicator)new BackgroundableProcessIndicator((Task.Backgroundable)task);
        ProgressManager progressManager = ProgressManager.getInstance();
        Task.Backgroundable backgroundable = task;
        ProgressIndicator progressIndicator = this.progressIndicator;
        Intrinsics.checkNotNull((Object)progressIndicator);
        progressManager.runProcessWithProgressAsynchronously(backgroundable, progressIndicator);
    }

    private final void stopTask() {
        if (this.progressIndicator != null) {
            ProgressIndicator progressIndicator = this.progressIndicator;
            Intrinsics.checkNotNull((Object)progressIndicator);
            progressIndicator.cancel();
            this.progressIndicator = null;
        }
    }

    private final void unhighlight() {
        this.nonPickedCommits = null;
        this.comparedBranch = null;
        this.repositoriesWithTargetBranches = null;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRepository, String> getRepositoriesWithTargetBranches(VcsLogDataPack dataPack, String branchToCompare) {
        void $this$associateWithTo$iv$iv;
        void $this$associateWith$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapNotNullTo$iv$iv;
        String string;
        Map map2 = dataPack.getLogProviders();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getLogProviders(...)");
        Map providers = map2;
        boolean isCompareBranchesUi = this.ui instanceof GitCompareBranchesUi.MyVcsLogUi;
        if (isCompareBranchesUi) {
            VcsLogFilterCollection vcsLogFilterCollection = dataPack.getFilters();
            Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"getFilters(...)");
            string = CherryPickedCommitsHighlighter.Companion.getTargetBranchFromRangeFilter(vcsLogFilterCollection);
        } else {
            string = null;
        }
        String targetBranchFromRangeFilter = string;
        Iterable $this$mapNotNull$iv = providers.keySet();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GitRepository it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if ((GitRepository)this.repositoryManager.getRepositoryForRootQuick(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapNotNullTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GitRepository repository2 = (GitRepository)element$iv$iv;
            boolean bl = false;
            if (!(repository2.getBranches().findBranchByName(branchToCompare) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        destination$iv$iv = $this$associateWith$iv;
        Map destination$iv$iv2 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            GitRepository bl = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map3 = destination$iv$iv2;
            boolean bl4 = false;
            String string2 = targetBranchFromRangeFilter;
            if (string2 == null) {
                void it;
                GitLocalBranch gitLocalBranch = it.getCurrentBranch();
                string2 = gitLocalBranch != null ? gitLocalBranch.getName() : null;
                if (string2 == null) {
                    string2 = "HEAD";
                }
            }
            String string3 = string2;
            map3.put(t, string3);
        }
        return destination$iv$iv2;
    }

    private final void notifyUnhighlight(String branch) {
        if (this.ui instanceof VcsLogUiEx) {
            Object[] objectArray = new Object[]{branch};
            String string = GitBundle.message((String)"git.log.cherry.picked.highlighter.cancelled.message", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(message, null, MessageType.INFO.getPopupBackground(), null).setFadeoutTime(5000L).createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
            Balloon balloon2 = balloon;
            JComponent jComponent = VcsLogUiUtil.getComponent((VcsLogUiEx)((VcsLogUiEx)this.ui));
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
            JComponent component2 = jComponent;
            balloon2.show(new RelativePoint((Component)component2, new Point(component2.getWidth() / 2, component2.getVisibleRect().y)), Balloon.Position.below);
            Disposer.register((Disposable)this, (Disposable)((Disposable)balloon2));
        }
    }

    public void dispose() {
        this.stopTaskAndUnhighlight();
    }

    @JvmStatic
    @NotNull
    public static final CherryPickedCommitsHighlighter getInstance(@NotNull Project project, @NotNull VcsLogData dataProvider, @NotNull VcsLogUi logUi) {
        return Companion.getInstance(project, dataProvider, logUi);
    }

    @JvmStatic
    @Nullable
    public static final String getComparedBranchFromFilters(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogAggregatedStoredRefs refs) {
        return Companion.getComparedBranchFromFilters(filters, refs);
    }

    @JvmStatic
    private static final String getTargetBranchFromRangeFilter(VcsLogFilterCollection filters) {
        return CherryPickedCommitsHighlighter.Companion.getTargetBranchFromRangeFilter(filters);
    }

    static {
        Logger logger = Logger.getInstance(CherryPickedCommitsHighlighter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgit4idea/branch/CherryPickedCommitsHighlighter$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getInstance", "Lgit4idea/branch/CherryPickedCommitsHighlighter;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "getComparedBranchFromFilters", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "refs", "Lcom/intellij/vcs/log/VcsLogAggregatedStoredRefs;", "getTargetBranchFromRangeFilter", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final CherryPickedCommitsHighlighter getInstance(@NotNull Project project, @NotNull VcsLogData dataProvider, @NotNull VcsLogUi logUi) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
            Intrinsics.checkNotNullParameter((Object)logUi, (String)"logUi");
            CherryPickedCommitsHighlighter cherryPickedCommitsHighlighter = ((CherryPickedCommitsHighlighterHolder)project.getService(CherryPickedCommitsHighlighterHolder.class)).getInstance(dataProvider, logUi);
            Intrinsics.checkNotNullExpressionValue((Object)cherryPickedCommitsHighlighter, (String)"getInstance(...)");
            return cherryPickedCommitsHighlighter;
        }

        @JvmStatic
        @Nullable
        public final String getComparedBranchFromFilters(@NotNull VcsLogFilterCollection filters, @NotNull VcsLogAggregatedStoredRefs refs) {
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)refs, (String)"refs");
            String singleFilteredBranch = VcsLogUtil.getSingleFilteredBranch((VcsLogFilterCollection)filters, (VcsLogAggregatedStoredRefs)refs);
            if (singleFilteredBranch != null) {
                return singleFilteredBranch;
            }
            VcsLogRangeFilter vcsLogRangeFilter = (VcsLogRangeFilter)filters.get(VcsLogFilterCollection.RANGE_FILTER);
            if (vcsLogRangeFilter == null) {
                return null;
            }
            VcsLogRangeFilter rangeFilter = vcsLogRangeFilter;
            VcsLogRangeFilter.RefRange refRange = (VcsLogRangeFilter.RefRange)CollectionsKt.singleOrNull((List)rangeFilter.getRanges());
            return refRange != null ? refRange.getInclusiveRef() : null;
        }

        @JvmStatic
        private final String getTargetBranchFromRangeFilter(VcsLogFilterCollection filters) {
            VcsLogRangeFilter vcsLogRangeFilter = (VcsLogRangeFilter)filters.get(VcsLogFilterCollection.RANGE_FILTER);
            if (vcsLogRangeFilter == null) {
                return null;
            }
            VcsLogRangeFilter rangeFilter = vcsLogRangeFilter;
            VcsLogRangeFilter.RefRange refRange = (VcsLogRangeFilter.RefRange)CollectionsKt.singleOrNull((List)rangeFilter.getRanges());
            return refRange != null ? refRange.getExclusiveRef() : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lgit4idea/branch/CherryPickedCommitsHighlighter$Factory;", "Lcom/intellij/vcs/log/ui/highlighters/VcsLogHighlighterFactory;", "<init>", "()V", "createHighlighter", "Lcom/intellij/vcs/log/VcsLogHighlighter;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "logUi", "Lcom/intellij/vcs/log/VcsLogUi;", "getId", "", "getTitle", "showMenuItem", "", "intellij.vcs.git"})
    public static final class Factory
    implements VcsLogHighlighterFactory {
        @NotNull
        public VcsLogHighlighter createHighlighter(@NotNull VcsLogData logData, @NotNull VcsLogUi logUi) {
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            Intrinsics.checkNotNullParameter((Object)logUi, (String)"logUi");
            return Companion.getInstance(logData.getProject(), logData, logUi);
        }

        @NotNull
        public String getId() {
            return "CHERRY_PICKED_COMMITS";
        }

        @NotNull
        public String getTitle() {
            String string = GitBundle.message((String)"action.Git.Log.HighlightCherryPickedCommits.text", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean showMenuItem() {
            return false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B+\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\n\u0010\u0013\u001a\u00020\u0005H\u0096\u0080\u0004R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgit4idea/branch/CherryPickedCommitsHighlighter$MyTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "repositoriesWithTargetBranches", "", "Lgit4idea/repo/GitRepository;", "", "vcsLogDataPack", "Lcom/intellij/vcs/log/VcsLogDataPack;", "comparedBranch", "<init>", "(Lgit4idea/branch/CherryPickedCommitsHighlighter;Ljava/util/Map;Lcom/intellij/vcs/log/VcsLogDataPack;Ljava/lang/String;)V", "comparator", "Lgit4idea/branch/DeepComparator;", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "onFinished", "onSuccess", "toString", "intellij.vcs.git"})
    private final class MyTask
    extends Task.Backgroundable {
        @NotNull
        private final Map<GitRepository, String> repositoriesWithTargetBranches;
        @NotNull
        private final String comparedBranch;
        @NotNull
        private final DeepComparator comparator;

        public MyTask(@NotNull Map<GitRepository, String> repositoriesWithTargetBranches, @NotNull VcsLogDataPack vcsLogDataPack, String comparedBranch) {
            Intrinsics.checkNotNullParameter(repositoriesWithTargetBranches, (String)"repositoriesWithTargetBranches");
            Intrinsics.checkNotNullParameter((Object)vcsLogDataPack, (String)"vcsLogDataPack");
            Intrinsics.checkNotNullParameter((Object)comparedBranch, (String)"comparedBranch");
            super(CherryPickedCommitsHighlighter.this.project, GitBundle.message((String)"git.log.cherry.picked.highlighter.process", (Object[])new Object[0]));
            this.repositoriesWithTargetBranches = repositoriesWithTargetBranches;
            this.comparedBranch = comparedBranch;
            Project project = this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VisiblePack visiblePack = vcsLogDataPack instanceof VisiblePack ? (VisiblePack)vcsLogDataPack : null;
            VcsLogGraphData vcsLogGraphData = visiblePack != null ? visiblePack.getDataPack() : null;
            this.comparator = new DeepComparator(project, CherryPickedCommitsHighlighter.this.vcsLogData, (VcsLogGraphData)(vcsLogGraphData instanceof VcsLogGraphData ? vcsLogGraphData : null), this.repositoriesWithTargetBranches, this.comparedBranch);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.comparator.compare();
        }

        public void onFinished() {
            CherryPickedCommitsHighlighter.this.progressIndicator = null;
        }

        public void onSuccess() {
            VcsException exception = this.comparator.getException();
            if (exception != null) {
                CherryPickedCommitsHighlighter.this.nonPickedCommits = null;
                Object[] objectArray = new Object[]{this.comparedBranch};
                VcsNotifier.getInstance((Project)this.getProject()).notifyError("git.could.not.compare.with.branch", GitBundle.message((String)"git.log.cherry.picked.highlighter.error.message", (Object[])objectArray), exception.getMessage());
                return;
            }
            CherryPickedCommitsHighlighter.this.nonPickedCommits = this.comparator.getCollectedNonPickedCommits();
        }

        @NotNull
        public String toString() {
            return "Task for '" + this.comparedBranch + "' in " + this.repositoriesWithTargetBranches;
        }
    }
}

