/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.execution.process.ProcessOutputType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import git4idea.GitFormatException;
import git4idea.GitUtil;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.i18n.GitBundle;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class GitLogOutputSplitter<R extends GitLogRecord>
implements GitLineHandlerListener {
    @NotNull
    private final GitLineHandler myHandler;
    @NotNull
    private final GitLogParser<R> myParser;
    @NotNull
    private final Consumer<? super R> myRecordConsumer;
    @NotNull
    @Nls
    private final StringBuilder myErrors;
    @Nullable
    private VcsException myException;

    public GitLogOutputSplitter(@NotNull GitLineHandler handler, @NotNull GitLogParser<R> parser, @NotNull Consumer<? super R> recordConsumer) {
        if (handler == null) {
            GitLogOutputSplitter.$$$reportNull$$$0(0);
        }
        if (parser == null) {
            GitLogOutputSplitter.$$$reportNull$$$0(1);
        }
        if (recordConsumer == null) {
            GitLogOutputSplitter.$$$reportNull$$$0(2);
        }
        this.myErrors = new StringBuilder();
        this.myException = null;
        this.myHandler = handler;
        this.myParser = parser;
        this.myRecordConsumer = recordConsumer;
        this.myHandler.addLineListener(this);
    }

    @Override
    public void onLineAvailable(@NlsSafe String line, Key outputType) {
        if (ProcessOutputType.isStderr((Key)outputType)) {
            this.myErrors.append(GitUtil.cleanupErrorPrefixes(line)).append("\n");
        } else if (ProcessOutputType.isStdout((Key)outputType)) {
            try {
                this.processOutputLine(line);
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (VcsException e) {
                this.myException = e;
            }
            catch (Throwable e) {
                this.myException = new VcsException(e);
            }
        }
    }

    private void processOutputLine(@NotNull @NlsSafe String line) throws VcsException {
        if (line == null) {
            GitLogOutputSplitter.$$$reportNull$$$0(3);
        }
        try {
            R record = this.myParser.parseLine(line);
            if (record != null) {
                ((GitLogRecord)record).setUsedHandler(this.myHandler);
                this.myRecordConsumer.accept(record);
            }
        }
        catch (GitFormatException e) {
            this.myParser.clear();
            throw new VcsException(GitBundle.message((String)"log.parser.exception.message.error.parsing.line", (Object[])new Object[]{StringUtil.escapeStringCharacters((String)line)}), (Throwable)e);
        }
    }

    public void processTerminated(int exitCode) {
        if (exitCode != 0) {
            String errorMessage = this.myErrors.toString();
            if (errorMessage.isEmpty()) {
                errorMessage = GitBundle.message((String)"git.error.exit", (Object[])new Object[]{exitCode});
            }
            this.myException = new VcsException(GitBundle.message((String)"log.parser.exception.message.error.command.line", (Object[])new Object[]{errorMessage, this.myHandler.printableCommandLine()}));
        } else {
            try {
                R record = this.myParser.finish();
                if (record != null) {
                    ((GitLogRecord)record).setUsedHandler(this.myHandler);
                    this.myRecordConsumer.accept(record);
                }
            }
            catch (ProcessCanceledException pce) {
                throw pce;
            }
            catch (Throwable t) {
                this.myException = new VcsException(t);
            }
        }
    }

    public void startFailed(@NotNull Throwable exception) {
        if (exception == null) {
            GitLogOutputSplitter.$$$reportNull$$$0(4);
        }
        this.myException = new VcsException(exception);
    }

    public boolean hasErrors() {
        return this.myException != null;
    }

    public void reportErrors() throws VcsException {
        if (this.myException != null) {
            if (this.myException.getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)this.myException.getCause();
            }
            throw this.myException;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordConsumer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
        }
        objectArray2[1] = "git4idea/history/GitLogOutputSplitter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processOutputLine";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startFailed";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

