/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.repo.VcsRepositoryManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.messages.MessageBusConnection;
import git4idea.config.GitConfigUtil;
import git4idea.repo.GitConfigKey;
import git4idea.repo.GitConfigurationCacheBase;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryConfigKey;
import git4idea.repo.GitRepositoryManager;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lgit4idea/repo/GitProjectConfigurationCache;", "Lgit4idea/repo/GitConfigurationCacheBase;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "readRepositoryConfig", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "key", "clearForRepo", "", "repository", "Lgit4idea/repo/GitRepository;", "clearInvalidKeys", "Companion", "RepositoryConfigKey", "intellij.vcs.git"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nGitConfigurationCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConfigurationCache.kt\ngit4idea/repo/GitProjectConfigurationCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,98:1\n1661#2,3:99\n13#3:102\n*S KotlinDebug\n*F\n+ 1 GitConfigurationCache.kt\ngit4idea/repo/GitProjectConfigurationCache\n*L\n66#1:99,3\n52#1:102\n*E\n"})
public final class GitProjectConfigurationCache
extends GitConfigurationCacheBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public GitProjectConfigurationCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        connection.subscribe(VcsRepositoryManager.VCS_REPOSITORY_MAPPING_UPDATED, () -> GitProjectConfigurationCache._init_$lambda$0(this));
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @RequiresBackgroundThread
    @Nullable
    public final String readRepositoryConfig(@NotNull VirtualFile root, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return (String)this.computeCachedValue(new RepositoryConfigKey(root, key), () -> GitProjectConfigurationCache.readRepositoryConfig$lambda$0(this, root, key));
    }

    public final void clearForRepo(@NotNull GitRepository repository2) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        this.getCache().keySet().removeIf(arg_0 -> GitProjectConfigurationCache.clearForRepo$lambda$1(arg_0 -> GitProjectConfigurationCache.clearForRepo$lambda$0(repository2, arg_0), arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final void clearInvalidKeys() {
        void destination$iv;
        void $this$mapTo$iv;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getInstance(...)");
        GitRepositoryManager gitRepositoryManager2 = gitRepositoryManager;
        List<GitRepository> list = gitRepositoryManager2.getRepositories();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getRepositories(...)");
        Iterable iterable = list;
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            GitRepository gitRepository = (GitRepository)item$iv;
            void var10_9 = destination$iv;
            boolean bl = false;
            var10_9.add(it.getRoot());
        }
        Set activeRoots = (Set)destination$iv;
        this.getCache().keySet().removeIf(arg_0 -> GitProjectConfigurationCache.clearInvalidKeys$lambda$2(arg_0 -> GitProjectConfigurationCache.clearInvalidKeys$lambda$1(activeRoots, arg_0), arg_0));
    }

    private static final void _init_$lambda$0(GitProjectConfigurationCache this$0) {
        this$0.clearInvalidKeys();
    }

    private static final String readRepositoryConfig$lambda$0(GitProjectConfigurationCache this$0, VirtualFile $root, String $key) {
        String string;
        try {
            string = GitConfigUtil.getValue(this$0.project, $root, $key);
        }
        catch (VcsException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(GitProjectConfigurationCache.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn((Throwable)e);
            string = null;
        }
        return string;
    }

    private static final boolean clearForRepo$lambda$0(GitRepository $repository, GitConfigKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof GitRepositoryConfigKey && Intrinsics.areEqual((Object)((GitRepositoryConfigKey)it).getRoot(), (Object)$repository.getRoot());
    }

    private static final boolean clearForRepo$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean clearInvalidKeys$lambda$1(Set $activeRoots, GitConfigKey it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof GitRepositoryConfigKey && !$activeRoots.contains(((GitRepositoryConfigKey)it).getRoot());
    }

    private static final boolean clearInvalidKeys$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final GitProjectConfigurationCache getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lgit4idea/repo/GitProjectConfigurationCache$Companion;", "", "<init>", "()V", "getInstance", "Lgit4idea/repo/GitProjectConfigurationCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitConfigurationCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConfigurationCache.kt\ngit4idea/repo/GitProjectConfigurationCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,98:1\n30#2,2:99\n*S KotlinDebug\n*F\n+ 1 GitConfigurationCache.kt\ngit4idea/repo/GitProjectConfigurationCache$Companion\n*L\n35#1:99,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GitProjectConfigurationCache getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GitProjectConfigurationCache> serviceClass$iv = GitProjectConfigurationCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (GitProjectConfigurationCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0002H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0083\u0004J\n\u0010\u0013\u001a\u00020\u0014H\u00d6\u0081\u0004J\n\u0010\u0015\u001a\u00020\u0002H\u00d6\u0081\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lgit4idea/repo/GitProjectConfigurationCache$RepositoryConfigKey;", "Lgit4idea/repo/GitRepositoryConfigKey;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "key", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getKey", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.vcs.git"})
    public static final class RepositoryConfigKey
    implements GitRepositoryConfigKey<String> {
        @NotNull
        private final VirtualFile root;
        @NotNull
        private final String key;

        public RepositoryConfigKey(@NotNull VirtualFile root, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.root = root;
            this.key = key;
        }

        @Override
        @NotNull
        public VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public final String getKey() {
            return this.key;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.root;
        }

        @NotNull
        public final String component2() {
            return this.key;
        }

        @NotNull
        public final RepositoryConfigKey copy(@NotNull VirtualFile root, @NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return new RepositoryConfigKey(root, key);
        }

        public static /* synthetic */ RepositoryConfigKey copy$default(RepositoryConfigKey repositoryConfigKey, VirtualFile virtualFile, String string, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = repositoryConfigKey.root;
            }
            if ((n & 2) != 0) {
                string = repositoryConfigKey.key;
            }
            return repositoryConfigKey.copy(virtualFile, string);
        }

        @NotNull
        public String toString() {
            return "RepositoryConfigKey(root=" + this.root + ", key=" + this.key + ")";
        }

        public int hashCode() {
            int result2 = this.root.hashCode();
            result2 = result2 * 31 + this.key.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RepositoryConfigKey)) {
                return false;
            }
            RepositoryConfigKey repositoryConfigKey = (RepositoryConfigKey)other;
            if (!Intrinsics.areEqual((Object)this.root, (Object)repositoryConfigKey.root)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.key, (Object)repositoryConfigKey.key);
        }
    }
}

