/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.permissions;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remoteDev.OsRegistryConfigProvider;
import com.jetbrains.rd.platform.codeWithMe.permissions.FileAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.RunAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.TerminalAccessLevel;
import com.jetbrains.rd.platform.codeWithMe.permissions.ToolWindowAccessLevel;
import com.jetbrains.rdserver.permissions.PermissionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\b\u001a\u0004\u0018\u0001H\t\"\u0010\b\u0000\u0010\t*\u00020\n*\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\t0\u000f\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\r\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u001aR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/cwm/plugin/permissions/OsRegistryPermissionRestrictions;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "osRegistryConfigProvider", "Lcom/intellij/remoteDev/OsRegistryConfigProvider;", "calculateMaximumLevel", "T", "Lcom/jetbrains/rd/actions/AccessLevelMarker;", "", "settingValue", "", "model", "", "(Ljava/lang/String;[Ljava/lang/Enum;)Ljava/lang/Enum;", "maximumTerminalAccessLevel", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/TerminalAccessLevel;", "maximumFileAccessLevel", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/FileAccessLevel;", "maximumRunAccessLevel", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/RunAccessLevel;", "maximumToolWindowAccessLevel", "Lcom/jetbrains/rd/platform/codeWithMe/permissions/ToolWindowAccessLevel;", "maximumAllowed", "Lcom/jetbrains/rdserver/permissions/PermissionModel;", "maximumAllowed$intellij_cwm_plugin", "restrict", "intellij.cwm.plugin"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nOsRegistryPermissionRestrictions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OsRegistryPermissionRestrictions.kt\ncom/intellij/cwm/plugin/permissions/OsRegistryPermissionRestrictions\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,67:1\n11705#2:68\n12052#2,3:69\n11705#2:74\n12052#2,3:75\n296#3,2:72\n13#4:78\n*S KotlinDebug\n*F\n+ 1 OsRegistryPermissionRestrictions.kt\ncom/intellij/cwm/plugin/permissions/OsRegistryPermissionRestrictions\n*L\n23#1:68\n23#1:69,3\n26#1:74\n26#1:75,3\n24#1:72,2\n19#1:78\n*E\n"})
public final class OsRegistryPermissionRestrictions {
    @NotNull
    public static final OsRegistryPermissionRestrictions INSTANCE = new OsRegistryPermissionRestrictions();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final OsRegistryConfigProvider osRegistryConfigProvider;

    private OsRegistryPermissionRestrictions() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T extends Enum<?>> T calculateMaximumLevel(@NotNull String settingValue, @NotNull T[] model2) {
        Enum calculatedMaximumLevel;
        Object v2;
        Collection collection;
        block4: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)settingValue, (String)"settingValue");
            Intrinsics.checkNotNullParameter(model2, (String)"model");
            String string = settingValue.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            String lowercasedSetting = string;
            T[] $this$map$iv = model2;
            boolean $i$f$map = false;
            T[] TArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var13_23 = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                String string2 = it.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                collection.add(TuplesKt.to((Object)string2, (Object)it));
            }
            List lowercasedValues = (List)destination$iv$iv;
            Iterable $this$firstOrNull$iv = lowercasedValues;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)lowercasedSetting)) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        Pair pair = v2;
        Enum enum_ = calculatedMaximumLevel = pair != null ? (Enum)pair.getSecond() : null;
        if (calculatedMaximumLevel == null) {
            Collection<String> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            T[] $i$f$map = model2;
            String string = settingValue;
            collection = logger;
            boolean $i$f$map2 = false;
            void $i$f$firstOrNull = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void bl = item$iv$iv = $this$mapTo$iv$iv[i];
                collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(it.name());
            }
            collection2 = (List)destination$iv$iv;
            collection.warn("Failed to parse maximum allowed level for access setting '" + string + "'. Available values: " + (List)collection2);
        }
        return (T)calculatedMaximumLevel;
    }

    private final TerminalAccessLevel maximumTerminalAccessLevel() {
        OsRegistryConfigProvider.OsRegistrySystemSetting osRegistrySystemSetting = osRegistryConfigProvider.get("access_terminal");
        if (osRegistrySystemSetting == null) {
            return TerminalAccessLevel.FullAccess;
        }
        OsRegistryConfigProvider.OsRegistrySystemSetting setting = osRegistrySystemSetting;
        TerminalAccessLevel terminalAccessLevel = (TerminalAccessLevel)this.calculateMaximumLevel((String)setting.getValue(), (Enum[])TerminalAccessLevel.values());
        if (terminalAccessLevel == null) {
            terminalAccessLevel = TerminalAccessLevel.FullAccess;
        }
        return terminalAccessLevel;
    }

    private final FileAccessLevel maximumFileAccessLevel() {
        OsRegistryConfigProvider.OsRegistrySystemSetting osRegistrySystemSetting = osRegistryConfigProvider.get("access_files");
        if (osRegistrySystemSetting == null) {
            return FileAccessLevel.FullAccess;
        }
        OsRegistryConfigProvider.OsRegistrySystemSetting setting = osRegistrySystemSetting;
        FileAccessLevel fileAccessLevel = (FileAccessLevel)this.calculateMaximumLevel((String)setting.getValue(), (Enum[])FileAccessLevel.values());
        if (fileAccessLevel == null) {
            fileAccessLevel = FileAccessLevel.FullAccess;
        }
        return fileAccessLevel;
    }

    private final RunAccessLevel maximumRunAccessLevel() {
        OsRegistryConfigProvider.OsRegistrySystemSetting osRegistrySystemSetting = osRegistryConfigProvider.get("access_run");
        if (osRegistrySystemSetting == null) {
            return RunAccessLevel.FullAccess;
        }
        OsRegistryConfigProvider.OsRegistrySystemSetting setting = osRegistrySystemSetting;
        RunAccessLevel runAccessLevel = (RunAccessLevel)this.calculateMaximumLevel((String)setting.getValue(), (Enum[])RunAccessLevel.values());
        if (runAccessLevel == null) {
            runAccessLevel = RunAccessLevel.FullAccess;
        }
        return runAccessLevel;
    }

    private final ToolWindowAccessLevel maximumToolWindowAccessLevel() {
        OsRegistryConfigProvider.OsRegistrySystemSetting osRegistrySystemSetting = osRegistryConfigProvider.get("access_toolwindow");
        if (osRegistrySystemSetting == null) {
            return ToolWindowAccessLevel.FullAccess;
        }
        OsRegistryConfigProvider.OsRegistrySystemSetting setting = osRegistrySystemSetting;
        ToolWindowAccessLevel toolWindowAccessLevel = (ToolWindowAccessLevel)this.calculateMaximumLevel((String)setting.getValue(), (Enum[])ToolWindowAccessLevel.values());
        if (toolWindowAccessLevel == null) {
            toolWindowAccessLevel = ToolWindowAccessLevel.FullAccess;
        }
        return toolWindowAccessLevel;
    }

    @NotNull
    public final PermissionModel maximumAllowed$intellij_cwm_plugin() {
        return PermissionModel.Companion.create(CollectionsKt.emptyList(), this.maximumFileAccessLevel(), this.maximumTerminalAccessLevel(), this.maximumRunAccessLevel(), this.maximumToolWindowAccessLevel());
    }

    @NotNull
    public final PermissionModel restrict(@NotNull PermissionModel model2) {
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        return this.maximumAllowed$intellij_cwm_plugin().combine(model2);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(OsRegistryPermissionRestrictions.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        OsRegistryPermissionRestrictions.logger = logger;
        osRegistryConfigProvider = new OsRegistryConfigProvider("CodeWithMe");
    }
}

