/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.session;

import com.intellij.cwm.plugin.common.connection.CwmConnectionStatusService;
import com.intellij.cwm.plugin.ui.CWMHostNotifications;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.codeWithMe.model.CWMSessionStatus;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/cwm/plugin/session/BackendNMinutesLeftNotificationMonitor;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "monitoringLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "startNMinutesLeftNotificationMonitoring", "", "stopNMinutesLeftNotificationMonitoring", "Companion", "intellij.cwm.plugin"})
public final class BackendNMinutesLeftNotificationMonitor
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private LifetimeDefinition monitoringLifetime;

    public BackendNMinutesLeftNotificationMonitor(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.monitoringLifetime = this.getServiceLifetime().createNested();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    public final void startNMinutesLeftNotificationMonitoring() {
        this.monitoringLifetime = this.getServiceLifetime().createNested();
        CwmConnectionStatusService statusService = CwmConnectionStatusService.Companion.getInstance();
        statusService.getSessionStatus().view((Lifetime)this.monitoringLifetime, (arg_0, arg_1) -> BackendNMinutesLeftNotificationMonitor.startNMinutesLeftNotificationMonitoring$lambda$0(statusService, this, arg_0, arg_1));
    }

    public final void stopNMinutesLeftNotificationMonitoring() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.monitoringLifetime, (boolean)false, (int)1, null);
    }

    private static final Unit startNMinutesLeftNotificationMonitoring$lambda$0$0(CwmConnectionStatusService $statusService, BackendNMinutesLeftNotificationMonitor this$0, Long it) {
        Long l = it;
        if (l == null) {
            return Unit.INSTANCE;
        }
        long remaining = l;
        if (TimeUnit.MILLISECONDS.toMinutes(remaining) <= (long)$statusService.getFreeSessionMinutesBeforeWarning()) {
            CWMHostNotifications.INSTANCE.showNMinutesLeftNotifications(this$0.project);
        }
        return Unit.INSTANCE;
    }

    private static final Unit startNMinutesLeftNotificationMonitoring$lambda$0(CwmConnectionStatusService $statusService, BackendNMinutesLeftNotificationMonitor this$0, Lifetime lt, CWMSessionStatus status) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        if (status == CWMSessionStatus.FREE_SESSION) {
            $statusService.getFreeSessionRemainingTimeMs().advise(lt, arg_0 -> BackendNMinutesLeftNotificationMonitor.startNMinutesLeftNotificationMonitoring$lambda$0$0($statusService, this$0, arg_0));
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/cwm/plugin/session/BackendNMinutesLeftNotificationMonitor$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/cwm/plugin/session/BackendNMinutesLeftNotificationMonitor;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cwm.plugin"})
    @SourceDebugExtension(value={"SMAP\nBackendRemainingTimeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendRemainingTimeListener.kt\ncom/intellij/cwm/plugin/session/BackendNMinutesLeftNotificationMonitor$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,50:1\n30#2,2:51\n*S KotlinDebug\n*F\n+ 1 BackendRemainingTimeListener.kt\ncom/intellij/cwm/plugin/session/BackendNMinutesLeftNotificationMonitor$Companion\n*L\n19#1:51,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendNMinutesLeftNotificationMonitor getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<BackendNMinutesLeftNotificationMonitor> serviceClass$iv = BackendNMinutesLeftNotificationMonitor.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (BackendNMinutesLeftNotificationMonitor)((Object)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

