/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlFormattingContext;
import com.intellij.sql.formatter.model.SqlNodeBlock;
import com.intellij.sql.psi.SqlCommonTokens;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0014J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/sql/formatter/model/SqlAssignmentBlock;", "Lcom/intellij/sql/formatter/model/SqlNodeBlock;", "<init>", "()V", "determineRole", "Lcom/intellij/sql/formatter/model/BlockRole;", "node", "Lcom/intellij/lang/ASTNode;", "configureFormattingAttributes", "", "decideSpacing", "Lcom/intellij/formatting/Spacing;", "block1", "Lcom/intellij/sql/formatter/model/SqlBlock;", "block2", "intellij.database.sql.core.impl"})
public final class SqlAssignmentBlock
extends SqlNodeBlock {
    @Override
    @NotNull
    public BlockRole determineRole(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_ASSIGN) || Intrinsics.areEqual((Object)iElementType, (Object)SqlCommonTokens.SQL_OP_EQ) ? BlockRole.EQ : super.determineRole(node);
    }

    @Override
    protected void configureFormattingAttributes() {
        int n = this.getNestedBlocks().size();
        if (n == 0) {
            return;
        }
        this.setInnerWrap(this.makeWrap(WrapType.NORMAL, false));
        this.getNestedBlocks().get(0).setMyWrap(this.getInnerWrap());
        for (int i2 = 2; i2 < n; ++i2) {
            if (this.getNestedBlocks().get(i2 - 1).getRole() != BlockRole.EQ) continue;
            this.getNestedBlocks().get(i2).setMyWrap(this.getInnerWrap());
            this.getNestedBlocks().get(i2).setMyIndent(Indent.getContinuationIndent());
        }
    }

    @Override
    @Nullable
    public Spacing decideSpacing(@NotNull SqlBlock block1, @NotNull SqlBlock block2) {
        Intrinsics.checkNotNullParameter((Object)block1, (String)"block1");
        Intrinsics.checkNotNullParameter((Object)block2, (String)"block2");
        return block1.getRole() == BlockRole.EQ || block2.getRole() == BlockRole.EQ ? SqlFormattingContext.makeSpace$default(this.getContext(), false, 1, null) : super.decideSpacing(block1, block2);
    }
}

