/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.model;

import com.intellij.formatting.Indent;
import com.intellij.sql.formatter.model.AdjacentBlocks;
import com.intellij.sql.formatter.model.BlockRole;
import com.intellij.sql.formatter.model.SqlBlock;
import com.intellij.sql.formatter.model.SqlBlockCommentBlock;
import com.intellij.sql.formatter.model.SqlFormattingFunKt;
import com.intellij.sql.formatter.model.SqlRangeBlock;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0014J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/sql/formatter/model/SqlCommentsFlowBlock;", "Lcom/intellij/sql/formatter/model/SqlRangeBlock;", "<init>", "()V", "produceNestedBlocks", "", "defaultChildIndent", "Lcom/intellij/formatting/Indent;", "block", "Lcom/intellij/sql/formatter/model/SqlBlock;", "getNewLineIndent", "", "blocks", "Lcom/intellij/sql/formatter/model/AdjacentBlocks;", "intellij.database.sql.core.impl"})
public final class SqlCommentsFlowBlock
extends SqlRangeBlock {
    @Override
    protected void produceNestedBlocks() {
        super.produceNestedBlocks();
        int n = this.getNestedBlocks().size();
        this.setRole(switch (n) {
            case 0 -> BlockRole.LINE_COMMENT;
            case 1 -> ((SqlBlock)CollectionsKt.first(this.getNestedBlocks())).getRole();
            default -> BlockRole.LARGE_COMMENT;
        });
    }

    @Override
    @NotNull
    public Indent defaultChildIndent(@NotNull SqlBlock block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        return SqlFormattingFunKt.getNONE_INDENT();
    }

    @Override
    @Nullable
    public String getNewLineIndent(@NotNull AdjacentBlocks blocks) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        SqlBlock b1 = blocks.getBlock1();
        if (blocks.getSame() && b1 instanceof SqlBlockCommentBlock) {
            return ((SqlBlockCommentBlock)b1).getNewLineIndent(blocks);
        }
        return null;
    }
}

