/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.promo;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.PromoAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.FUSEventSource;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserService;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.PluginAdvertiserServiceKt;
import com.intellij.openapi.updateSettings.impl.pluginsAdvertisement.SuggestedIde;
import com.intellij.openapi.util.registry.Registry;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/java/promo/UltimatePromoAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/ide/actions/searcheverywhere/PromoAction;", "pluginId", "", "<init>", "(Ljava/lang/String;)V", "getPromotedProductIcon", "Ljavax/swing/Icon;", "getCallToAction", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.java.promo"})
public abstract class UltimatePromoAction
extends DumbAwareAction
implements PromoAction {
    @NotNull
    private final String pluginId;

    public UltimatePromoAction(@NotNull String pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        this.pluginId = pluginId;
    }

    @NotNull
    public Icon getPromotedProductIcon() {
        Icon icon = AllIcons.Ultimate.IdeaUltimatePromo;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"IdeaUltimatePromo");
        return icon;
    }

    @NotNull
    public String getCallToAction() {
        Object[] objectArray = new Object[]{PluginAdvertiserService.Companion.getIdeaUltimate().getName(), IdeBundle.message((String)"plugin.advertiser.free.trial.action", (Object[])new Object[0])};
        String string = IdeBundle.message((String)"plugin.advertiser.product.call.to.action", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(Registry.Companion.is("idea.ultimate.features.hints.enabled"));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        PluginId pluginId = PluginId.Companion.getId(this.pluginId);
        if (project != null) {
            PluginAdvertiserServiceKt.tryUltimate$default((PluginId)pluginId, (SuggestedIde)PluginAdvertiserService.Companion.getIdeaUltimate(), (Project)project, (FUSEventSource)FUSEventSource.ACTIONS, null, null, (int)48, null);
            return;
        }
        FUSEventSource.ACTIONS.openDownloadPageAndLog(e.getProject(), PluginAdvertiserService.Companion.getIdeaUltimate().getDownloadUrl(), PluginAdvertiserService.Companion.getIdeaUltimate(), pluginId);
    }
}

