/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import java.lang.ref.SoftReference;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.Mappings;
import org.jetbrains.debugger.sourcemap.SourceMapData;
import org.jetbrains.debugger.sourcemap.SourceMapDataCache;
import org.jetbrains.debugger.sourcemap.SourceMapDataEx;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010'\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010(\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0011R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0011R\u0019\u0010\u001e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006)"}, d2={"Lorg/jetbrains/debugger/sourcemap/FileBackedSourceMapData;", "Lorg/jetbrains/debugger/sourcemap/SourceMapData;", "filePath", "Ljava/nio/file/Path;", "initialData", "Lorg/jetbrains/debugger/sourcemap/SourceMapDataEx;", "<init>", "(Ljava/nio/file/Path;Lorg/jetbrains/debugger/sourcemap/SourceMapDataEx;)V", "cachedData", "Ljava/lang/ref/SoftReference;", "file", "", "getFile", "()Ljava/lang/String;", "sources", "", "getSources", "()Ljava/util/List;", "sourcesContent", "getSourcesContent", "hasNameMappings", "", "getHasNameMappings", "()Z", "mappings", "Lorg/jetbrains/debugger/sourcemap/MappingEntry;", "getMappings", "ignoreList", "", "getIgnoreList", "sourceIndexToMappings", "", "Lorg/jetbrains/debugger/sourcemap/MappingList;", "getSourceIndexToMappings", "()[Lorg/jetbrains/debugger/sourcemap/MappingList;", "generatedMappings", "Lorg/jetbrains/debugger/sourcemap/Mappings;", "getGeneratedMappings", "()Lorg/jetbrains/debugger/sourcemap/Mappings;", "calculateData", "getData", "intellij.platform.scriptDebugger.backend"})
final class FileBackedSourceMapData
implements SourceMapData {
    @NotNull
    private final Path filePath;
    @NotNull
    private SoftReference<SourceMapDataEx> cachedData;
    @Nullable
    private final String file;
    @NotNull
    private final List<String> sources;
    private final boolean hasNameMappings;

    public FileBackedSourceMapData(@NotNull Path filePath, @NotNull SourceMapDataEx initialData) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)initialData, (String)"initialData");
        this.filePath = filePath;
        this.cachedData = new SoftReference<SourceMapDataEx>(initialData);
        this.file = initialData.getSourceMapData().getFile();
        this.sources = initialData.getSourceMapData().getSources();
        this.hasNameMappings = initialData.getSourceMapData().getHasNameMappings();
    }

    @Override
    @Nullable
    public String getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public List<String> getSources() {
        return this.sources;
    }

    @Override
    @Nullable
    public List<String> getSourcesContent() {
        return this.getData().getSourceMapData().getSourcesContent();
    }

    @Override
    public boolean getHasNameMappings() {
        return this.hasNameMappings;
    }

    @Override
    @NotNull
    public List<MappingEntry> getMappings() {
        return this.getData().getSourceMapData().getMappings();
    }

    @Override
    @NotNull
    public List<Integer> getIgnoreList() {
        return this.getData().getSourceMapData().getIgnoreList();
    }

    @NotNull
    public final MappingList[] getSourceIndexToMappings() {
        return this.getData().getSourceIndexToMappings();
    }

    @NotNull
    public final Mappings getGeneratedMappings() {
        return this.getData().getGeneratedMappings();
    }

    private final SourceMapDataEx calculateData() {
        String text = PathsKt.readText$default((Path)this.filePath, null, (int)1, null);
        return SourceMapDataCache.INSTANCE.getOrCreate(text, ((Object)this.filePath).toString());
    }

    private final SourceMapDataEx getData() {
        SourceMapDataEx cached = this.cachedData.get();
        if (cached != null) {
            return cached;
        }
        SourceMapDataEx sourceMapDataEx = this.calculateData();
        if (sourceMapDataEx == null) {
            throw new RuntimeException("Cannot decode " + this.filePath);
        }
        SourceMapDataEx calculated = sourceMapDataEx;
        this.cachedData = new SoftReference<SourceMapDataEx>(calculated);
        return calculated;
    }
}

