/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.BodyGenerator;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.FuncSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.FunctionHeapTypeSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.GcHeapTypeSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LiteralGlobalSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationProvider;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationProviderImpl;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationProviderStub;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.Synthetics;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VTableHeapTypeSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleMetadataCache;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleTypeTransformer;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.UtilsKt;
import org.jetbrains.kotlin.backend.wasm.utils.WasmArrayInfo;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.backend.js.lower.StaticMembersLoweringKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.wasm.WasmExportUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrFakeOverrideUtilsKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.wasm.ir.JsBuiltinDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmArrayDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmExport;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilderWithOptimizer;
import org.jetbrains.kotlin.wasm.ir.WasmFunction;
import org.jetbrains.kotlin.wasm.ir.WasmFunctionType;
import org.jetbrains.kotlin.wasm.ir.WasmGlobal;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImportDescriptor;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmStructDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmStructFieldDeclaration;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\r\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020 2\u0006\u0010$\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020 2\u0006\u0010$\u001a\u00020)H\u0016J:\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u0002002\n\b\u0002\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020\u000b2\u0006\u00104\u001a\u00020\u000bH\u0002J \u00105\u001a\u00020 2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010<\u001a\u00020 2\u0006\u00106\u001a\u000207H\u0002J-\u0010=\u001a\u00020 2\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u0002092\u0006\u0010>\u001a\u00020.2\u0006\u0010:\u001a\u00020;H\u0000\u00a2\u0006\u0002\b?J\u0010\u0010@\u001a\u00020 2\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010A\u001a\u00020 2\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010B\u001a\u00020 2\u0006\u0010$\u001a\u00020CH\u0016J \u0010D\u001a\u00020 2\u0006\u00108\u001a\u0002092\u0006\u0010E\u001a\u0002072\u0006\u0010:\u001a\u00020;H\u0002J\u0010\u0010F\u001a\u00020 2\u0006\u0010$\u001a\u00020GH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u0018\u001a\u0004\u0018\u00010\u00198BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmFileCodegenContext", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "wasmModuleTypeTransformer", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleTypeTransformer;", "wasmModuleMetadataCache", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleMetadataCache;", "allowIncompleteImplementations", "", "skipCommentInstructions", "skipLocations", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleTypeTransformer;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleMetadataCache;ZZZ)V", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unitGetInstanceFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstanceFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstanceFunction$delegate", "Lkotlin/Lazy;", "unitPrimaryConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getUnitPrimaryConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "unitPrimaryConstructor$delegate", "locationProvider", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/LocationProvider;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitProperty", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "visitTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "visitFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "createVirtualTableStruct", "Lorg/jetbrains/kotlin/wasm/ir/WasmStructDeclaration;", "methods", "", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/VirtualMethodMetadata;", "name", "", "superType", "Lorg/jetbrains/kotlin/wasm/ir/WasmHeapType$Type$VTableType;", "isFinal", "generateSpecialITableField", "buildSpecialITableInit", "metadata", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/ClassMetadata;", "builder", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "createVTable", "addInterfaceMethod", "method", "addInterfaceMethod$backend_wasm", "createRtti", "createClassITable", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "interfaceTable", "classMetadata", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nDeclarationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilderKt\n*L\n1#1,745:1\n1586#2:746\n1661#2,3:747\n1661#2,3:751\n777#2:754\n873#2,2:755\n1586#2:757\n1661#2,3:758\n1786#2,3:761\n1586#2:764\n1661#2,3:765\n296#2,2:768\n1924#2,3:772\n832#2:781\n862#2,2:782\n1661#2,3:785\n3347#2,10:788\n1#3:750\n402#4,2:770\n404#4:775\n402#4,3:776\n402#4,2:779\n404#4:784\n*S KotlinDebug\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGenerator\n*L\n95#1:746\n95#1:747,3\n246#1:751,3\n272#1:754\n272#1:755,2\n273#1:757\n273#1:758,3\n275#1:761,3\n294#1:764\n294#1:765,3\n298#1:768,2\n342#1:772,3\n489#1:781\n489#1:782,2\n555#1:785,3\n588#1:788,10\n339#1:770,2\n339#1:775\n411#1:776,3\n486#1:779,2\n486#1:784\n*E\n"})
public final class DeclarationGenerator
extends IrVisitorVoid {
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmFileCodegenContext wasmFileCodegenContext;
    @NotNull
    private final WasmModuleTypeTransformer wasmModuleTypeTransformer;
    @NotNull
    private final WasmModuleMetadataCache wasmModuleMetadataCache;
    private final boolean allowIncompleteImplementations;
    private final boolean skipCommentInstructions;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Lazy unitGetInstanceFunction$delegate;
    @NotNull
    private final Lazy unitPrimaryConstructor$delegate;
    @NotNull
    private final LocationProvider locationProvider;

    public DeclarationGenerator(@NotNull WasmBackendContext backendContext, @NotNull WasmFileCodegenContext wasmFileCodegenContext, @NotNull WasmModuleTypeTransformer wasmModuleTypeTransformer, @NotNull WasmModuleMetadataCache wasmModuleMetadataCache, boolean allowIncompleteImplementations, boolean skipCommentInstructions, boolean skipLocations) {
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)wasmFileCodegenContext, (String)"wasmFileCodegenContext");
        Intrinsics.checkNotNullParameter((Object)wasmModuleTypeTransformer, (String)"wasmModuleTypeTransformer");
        Intrinsics.checkNotNullParameter((Object)wasmModuleMetadataCache, (String)"wasmModuleMetadataCache");
        this.backendContext = backendContext;
        this.wasmFileCodegenContext = wasmFileCodegenContext;
        this.wasmModuleTypeTransformer = wasmModuleTypeTransformer;
        this.wasmModuleMetadataCache = wasmModuleMetadataCache;
        this.allowIncompleteImplementations = allowIncompleteImplementations;
        this.skipCommentInstructions = skipCommentInstructions;
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
        this.unitGetInstanceFunction$delegate = LazyKt.lazy(() -> DeclarationGenerator.unitGetInstanceFunction_delegate$lambda$0(this));
        this.unitPrimaryConstructor$delegate = LazyKt.lazy(() -> DeclarationGenerator.unitPrimaryConstructor_delegate$lambda$0(this));
        this.locationProvider = skipLocations ? (LocationProvider)LocationProviderStub.INSTANCE : (LocationProvider)LocationProviderImpl.INSTANCE;
    }

    private final IrSimpleFunction getUnitGetInstanceFunction() {
        Lazy lazy = this.unitGetInstanceFunction$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    private final IrConstructor getUnitPrimaryConstructor() {
        Lazy lazy = this.unitPrimaryConstructor$delegate;
        return (IrConstructor)lazy.getValue();
    }

    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IllegalStateException(("Unexpected element of type " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    public void visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!declaration.isExternal()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
    }

    /*
     * WARNING - void declaration
     */
    public void visitFunction(@NotNull IrFunction declaration) {
        String nameIfExported;
        WasmImportDescriptor importedName;
        WasmImportDescriptor wasmImportDescriptor;
        void $this$mapTo$iv$iv;
        boolean isIntrinsic;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof IrConstructor && (this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)declaration))) || AnnotationsKt.hasWasmPrimitiveConstructorAnnotation((IrAnnotationContainer)declaration))) {
            return;
        }
        boolean bl = isIntrinsic = AnnotationsKt.hasWasmNoOpCastAnnotation((IrAnnotationContainer)declaration) || AnnotationsKt.getWasmOpAnnotation((IrAnnotationContainer)declaration) != null;
        if (isIntrinsic) {
            return;
        }
        if (IrFakeOverrideUtilsKt.isFakeOverride((IrDeclaration)((IrDeclaration)declaration))) {
            return;
        }
        String watName = String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)));
        List<IrValueParameter> irParameters = DeclarationGeneratorKt.getEffectiveValueParameters(declaration);
        IrFunction irFunction = declaration;
        WasmType resultType = Intrinsics.areEqual((Object)irFunction, (Object)this.getUnitGetInstanceFunction()) || Intrinsics.areEqual((Object)irFunction, (Object)this.getUnitPrimaryConstructor()) ? this.wasmModuleTypeTransformer.transformType(declaration.getReturnType()) : this.wasmModuleTypeTransformer.transformResultType(declaration.getReturnType());
        Iterable $this$map$iv22 = irParameters;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv22;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv22, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(this.wasmModuleTypeTransformer.transformValueParameterType((IrValueParameter)it));
        }
        List list = CollectionsKt.listOfNotNull((Object)resultType);
        List list2 = (List)destination$iv$iv;
        WasmFunctionType wasmFunctionType = new WasmFunctionType(list2, list);
        this.wasmFileCodegenContext.defineFunctionType(declaration.getSymbol(), wasmFunctionType);
        if (declaration instanceof IrSimpleFunction && ((IrSimpleFunction)declaration).getModality() == Modality.ABSTRACT) {
            return;
        }
        boolean $this$map$iv22 = Intrinsics.areEqual((Object)declaration, (Object)IrResolveUtilsKt.getRealOverrideTarget(declaration));
        if (_Assertions.ENABLED && !$this$map$iv22) {
            boolean $i$a$-assert-DeclarationGenerator$visitFunction$22 = false;
            String $i$a$-assert-DeclarationGenerator$visitFunction$22 = "Sanity check that " + declaration + " is a real function that can be used in calls";
            throw new AssertionError((Object)$i$a$-assert-DeclarationGenerator$visitFunction$22);
        }
        if (this.wasmFileCodegenContext.handleFunctionWithImport(declaration.getSymbol())) {
            return;
        }
        FunctionHeapTypeSymbol functionTypeSymbol = this.wasmFileCodegenContext.referenceFunctionHeapType(declaration.getSymbol());
        WasmImportDescriptor wasmImportModule = AnnotationsKt.getWasmImportDescriptor(declaration);
        JsBuiltinDescriptor jsBuiltin = AnnotationsKt.getJsBuiltinDescriptor(declaration);
        String jsCode = AnnotationsKt.getJsFunAnnotation((IrAnnotationContainer)declaration);
        if (wasmImportModule != null) {
            if (!declaration.isExternal()) {
                boolean $i$a$-check-DeclarationGenerator$visitFunction$importedName$32 = false;
                String $i$a$-check-DeclarationGenerator$visitFunction$importedName$32 = "Non-external fun with @WasmImport " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration));
                throw new IllegalStateException($i$a$-check-DeclarationGenerator$visitFunction$importedName$32.toString());
            }
            this.wasmFileCodegenContext.addJsModuleImport(declaration.getSymbol(), wasmImportModule.getModuleName());
            wasmImportDescriptor = wasmImportModule;
        } else if (jsBuiltin != null) {
            if (!declaration.isExternal()) {
                boolean $i$a$-check-DeclarationGenerator$visitFunction$importedName$42 = false;
                String $i$a$-check-DeclarationGenerator$visitFunction$importedName$42 = "Non-external fun with @JsBuiltin " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration));
                throw new IllegalStateException($i$a$-check-DeclarationGenerator$visitFunction$importedName$42.toString());
            }
            this.wasmFileCodegenContext.addJsModuleImport(declaration.getSymbol(), jsBuiltin.getModuleName());
            this.wasmFileCodegenContext.addJsBuiltin(jsBuiltin.getDeclarationName(), jsBuiltin.getPolyfillImpl());
            wasmImportDescriptor = new WasmImportDescriptor(jsBuiltin.getModuleName(), (WasmSymbolReadOnly)new WasmSymbol((Object)jsBuiltin.getDeclarationName()));
        } else if (jsCode != null) {
            if (!(declaration instanceof IrSimpleFunction)) {
                String $i$a$-check-DeclarationGenerator$visitFunction$importedName$42 = "Failed requirement.";
                throw new IllegalArgumentException($i$a$-check-DeclarationGenerator$visitFunction$importedName$42.toString());
            }
            WasmSymbol jsFunName = new WasmSymbol((Object)String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration))));
            this.wasmFileCodegenContext.addJsFun((IrFunctionSymbol)((IrSimpleFunction)declaration).getSymbol(), (WasmSymbol<String>)jsFunName, jsCode);
            wasmImportDescriptor = new WasmImportDescriptor("js_code", (WasmSymbolReadOnly)jsFunName);
        } else {
            wasmImportDescriptor = importedName = null;
        }
        if (importedName != null) {
            this.wasmFileCodegenContext.defineFunction(declaration.getSymbol(), (WasmFunction)new WasmFunction.Imported(watName, (WasmHeapType.Type.FunctionType)functionTypeSymbol, importedName));
            return;
        }
        IrFileEntry irFileEntry = IrInlineUtilsKt.getSourceFile((IrDeclaration)((IrDeclaration)declaration));
        Intrinsics.checkNotNull((Object)irFileEntry);
        IrFileEntry sourceFile = irFileEntry;
        IrElement locationTarget = DeclarationGeneratorKt.getLocationTarget(declaration);
        SourceLocation functionStartLocation = this.locationProvider.getSourceLocation(locationTarget, (IrSymbol)declaration.getSymbol(), sourceFile);
        SourceLocation functionEndLocation = this.locationProvider.getSourceEndLocation(locationTarget, (IrSymbol)declaration.getSymbol(), sourceFile);
        WasmExpressionBuilderWithOptimizer expressionBuilder = new WasmExpressionBuilderWithOptimizer(this.skipCommentInstructions);
        WasmFunction.Defined function2 = new WasmFunction.Defined(watName, (WasmHeapType.Type.FunctionType)functionTypeSymbol, null, expressionBuilder.getExpression(), functionStartLocation, functionEndLocation, 4, null);
        WasmFunctionCodegenContext functionCodegenContext = new WasmFunctionCodegenContext(declaration, function2, this.backendContext, this.wasmFileCodegenContext, this.wasmModuleTypeTransformer, sourceFile);
        for (IrValueParameter irParameter : irParameters) {
            functionCodegenContext.defineLocal((IrValueSymbol)irParameter.getSymbol());
        }
        BodyGenerator bodyBuilder = new BodyGenerator(this.backendContext, this.wasmFileCodegenContext, functionCodegenContext, this.wasmModuleMetadataCache, this.wasmModuleTypeTransformer, this.locationProvider, (WasmExpressionBuilder)expressionBuilder);
        IrBody declarationBody = declaration.getBody();
        if (!(declarationBody instanceof IrBlockBody)) {
            boolean bl3 = false;
            String string = "Only IrBlockBody is supported";
            throw new IllegalArgumentException(string.toString());
        }
        if (declaration instanceof IrConstructor) {
            bodyBuilder.generateObjectCreationPrefixIfNeeded((IrConstructor)declaration);
        }
        IrVisitorsKt.acceptVoid((IrElement)((IrElement)declarationBody), (IrVisitorVoid)bodyBuilder);
        if (declaration instanceof IrConstructor) {
            expressionBuilder.buildGetLocal((WasmLocal)function2.getLocals().get(0), SourceLocation.Companion.NoLocation("Get implicit dispatch receiver"));
            expressionBuilder.buildInstr(WasmOp.RETURN, SourceLocation.Companion.NoLocation("Implicit return from constructor"));
        }
        if (!((Collection)wasmFunctionType.getResultTypes()).isEmpty()) {
            UtilsKt.buildUnreachableForVerifier((WasmExpressionBuilder)expressionBuilder);
        }
        expressionBuilder.complete();
        this.wasmFileCodegenContext.defineFunction(declaration.getSymbol(), (WasmFunction)function2);
        String string = AnnotationUtilsKt.isExplicitlyExported((IrAnnotationContainer)declaration) ? AnnotationUtilsKt.getJsNameOrKotlinName((IrDeclarationWithName)declaration).getIdentifier() : (nameIfExported = WasmExportUtilsKt.isWasmExportDeclaration((IrAnnotationContainer)((IrAnnotationContainer)declaration)) ? WasmExportUtilsKt.getWasmExportName((IrDeclarationWithName)((IrDeclarationWithName)declaration)) : null);
        if (nameIfExported != null) {
            String string2 = nameIfExported;
            this.wasmFileCodegenContext.addExport((WasmExport)new WasmExport.Function(string2, (WasmFunction)function2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final WasmStructDeclaration createVirtualTableStruct(List<VirtualMethodMetadata> methods2, String name, WasmHeapType.Type.VTableType superType, boolean isFinal, boolean generateSpecialITableField) {
        void $this$mapTo$iv;
        Iterable specialITableField;
        List vtableFields = new ArrayList();
        if (generateSpecialITableField) {
            specialITableField = new WasmStructFieldDeclaration("<SpecialITable>", (WasmType)new WasmRefNullType((WasmHeapType)Synthetics.HeapTypes.INSTANCE.getSpecialSlotITableType()), false);
            vtableFields.add(specialITableField);
        }
        specialITableField = methods2;
        Collection destination$iv = vtableFields;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            String string = it.getSignature().getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            collection.add(new WasmStructFieldDeclaration(string, (WasmType)new WasmRefNullType((WasmHeapType)this.wasmFileCodegenContext.referenceFunctionHeapType((IrFunctionSymbol)it.getFunction().getSymbol())), false));
        }
        return new WasmStructDeclaration(name, vtableFields, (WasmHeapType.Type)superType, isFinal);
    }

    static /* synthetic */ WasmStructDeclaration createVirtualTableStruct$default(DeclarationGenerator declarationGenerator, List list, String string, WasmHeapType.Type.VTableType vTableType, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            vTableType = null;
        }
        return declarationGenerator.createVirtualTableStruct(list, string, vTableType, bl, bl2);
    }

    /*
     * WARNING - void declaration
     */
    private final void buildSpecialITableInit(ClassMetadata metadata, WasmExpressionBuilder builder, SourceLocation location) {
        Collection collection;
        Iterator<Object> $this$mapTo$iv$iv;
        Object element$iv$iv22;
        void $this$filterTo$iv$iv;
        IrClass klass = metadata.getKlass();
        if (!ClassInfoKt.hasInterfaceSuperClass(klass)) {
            builder.buildRefNull((WasmHeapType)WasmHeapType.Simple.None.INSTANCE, location);
            return;
        }
        List<IrClass> supportedIFaces = metadata.getInterfaces();
        List<IrClassSymbol> specialSlotITableTypes = this.backendContext.getSpecialSlotITableTypes$backend_wasm();
        Iterable $this$filter$iv = supportedIFaces;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean bl = false;
        for (Object element$iv$iv22 : $this$filterTo$iv$iv) {
            IrClass it = (IrClass)element$iv$iv22;
            boolean bl2 = false;
            if (!IrTypeUtilsKt.isFunction((IrClassifierSymbol)((IrClassifierSymbol)it.getSymbol()))) continue;
            destination$iv$iv.add(element$iv$iv22);
        }
        List functionalInterfaces = (List)destination$iv$iv;
        Iterable $this$map$iv = specialSlotITableTypes;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        element$iv$iv22 = $this$mapTo$iv$iv.iterator();
        while (element$iv$iv22.hasNext()) {
            void iFace;
            void var18_47;
            Object item$iv$iv = element$iv$iv22.next();
            IrClassSymbol bl2 = (IrClassSymbol)item$iv$iv;
            collection = collection2;
            boolean bl22 = false;
            void it = var18_47 = iFace;
            boolean bl3 = false;
            collection.add(supportedIFaces.contains(it.getOwner()) ? var18_47 : null);
        }
        List specialInterfacesIfSupported = (List)collection2;
        if (functionalInterfaces.isEmpty()) {
            boolean bl3;
            block20: {
                Iterable $this$all$iv = specialInterfacesIfSupported;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    $this$mapTo$iv$iv = $this$all$iv.iterator();
                    while ($this$mapTo$iv$iv.hasNext()) {
                        Object t = $this$mapTo$iv$iv.next();
                        IrClassSymbol it = (IrClassSymbol)t;
                        boolean bl4 = false;
                        if (it == null) continue;
                        bl3 = false;
                        break block20;
                    }
                    bl3 = true;
                }
            }
            if (bl3) {
                builder.buildRefNull((WasmHeapType)WasmHeapType.Simple.None.INSTANCE, location);
                return;
            }
        }
        for (IrClassSymbol supportedSpecialInterface : specialInterfacesIfSupported) {
            if (supportedSpecialInterface != null) {
                for (VirtualMethodMetadata virtualMethodMetadata : this.wasmModuleMetadataCache.getInterfaceMetadata(supportedSpecialInterface).getMethods()) {
                    this.addInterfaceMethod$backend_wasm(metadata, builder, virtualMethodMetadata, location);
                }
                builder.buildStructNew((WasmImmediate.TypeIdx)this.wasmFileCodegenContext.referenceVTableGcType(supportedSpecialInterface), location);
                continue;
            }
            builder.buildRefNull((WasmHeapType)WasmHeapType.Simple.None.INSTANCE, location);
        }
        if (!((Collection)functionalInterfaces).isEmpty()) {
            Iterable $this$map$iv2 = functionalInterfaces;
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : iterable2) {
                void it;
                IrClass bl22 = (IrClass)item$iv$iv2;
                collection = destination$iv$iv3;
                boolean bl4 = false;
                collection.add(TuplesKt.to((Object)it, (Object)UtilsKt.getFunctionalInterfaceSlot((IrClass)it)));
            }
            List functionInterfaceToSlot = (List)destination$iv$iv3;
            Iterator iterator2 = ((Iterable)functionInterfaceToSlot).iterator();
            if (!iterator2.hasNext()) {
                throw new NoSuchElementException();
            }
            Pair it232 = (Pair)iterator2.next();
            boolean bl5 = false;
            int it232 = ((Number)it232.getSecond()).intValue();
            while (iterator2.hasNext()) {
                Pair it332 = (Pair)iterator2.next();
                boolean bl6 = false;
                int it332 = ((Number)it332.getSecond()).intValue();
                if (it232 >= it332) continue;
                it232 = it332;
            }
            int functionsITableSize = it232 + 1;
            for (int i = 0; i < functionsITableSize; ++i) {
                IrClassSymbol currentInterface;
                Pair pair;
                Object v1;
                block21: {
                    int n = i;
                    boolean bl52 = false;
                    Iterable $this$firstOrNull$iv = functionInterfaceToSlot;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Pair it = (Pair)element$iv;
                        boolean bl6 = false;
                        if (!(((Number)it.getSecond()).intValue() == n)) continue;
                        v1 = element$iv;
                        break block21;
                    }
                    v1 = null;
                }
                IrClassSymbol irClassSymbol = (pair = (Pair)v1) != null && (pair = (IrClass)pair.getFirst()) != null ? pair.getSymbol() : (currentInterface = null);
                if (currentInterface != null) {
                    for (VirtualMethodMetadata method2 : this.wasmModuleMetadataCache.getInterfaceMetadata(currentInterface).getMethods()) {
                        this.addInterfaceMethod$backend_wasm(metadata, builder, method2, location);
                    }
                    builder.buildStructNew((WasmImmediate.TypeIdx)this.wasmFileCodegenContext.referenceVTableGcType(currentInterface), location);
                    continue;
                }
                builder.buildRefNull((WasmHeapType)WasmHeapType.Simple.Any.INSTANCE, location);
            }
            builder.buildInstr(WasmOp.ARRAY_NEW_FIXED, location, (WasmImmediate)Synthetics.GcTypes.INSTANCE.getWasmAnyArrayType(), (WasmImmediate)new WasmImmediate.ConstI32(functionsITableSize));
        } else {
            builder.buildRefNull((WasmHeapType)WasmHeapType.Simple.None.INSTANCE, location);
        }
        builder.buildStructNew((WasmImmediate.TypeIdx)Synthetics.GcTypes.INSTANCE.getSpecialSlotITableType(), location);
    }

    /*
     * WARNING - void declaration
     */
    private final void createVTable(ClassMetadata metadata) {
        VTableHeapTypeSymbol vTableHeapTypeSymbol;
        IrClass klass = metadata.getKlass();
        IrClassSymbol symbol = klass.getSymbol();
        DeclarationGenerator declarationGenerator = this;
        List<VirtualMethodMetadata> list = metadata.getVirtualMethods();
        String string = "<classVTable>";
        ClassMetadata classMetadata = metadata.getSuperClass();
        if (classMetadata != null && (classMetadata = classMetadata.getKlass()) != null && (classMetadata = classMetadata.getSymbol()) != null) {
            void p0;
            ClassMetadata classMetadata2 = classMetadata;
            WasmFileCodegenContext wasmFileCodegenContext = this.wasmFileCodegenContext;
            ClassMetadata classMetadata3 = classMetadata2;
            String string2 = string;
            List<VirtualMethodMetadata> list2 = list;
            DeclarationGenerator declarationGenerator2 = declarationGenerator;
            boolean bl = false;
            VTableHeapTypeSymbol vTableHeapTypeSymbol2 = wasmFileCodegenContext.referenceVTableHeapType((IrClassSymbol)p0);
            declarationGenerator = declarationGenerator2;
            list = list2;
            string = string2;
            vTableHeapTypeSymbol = vTableHeapTypeSymbol2;
        } else {
            vTableHeapTypeSymbol = null;
        }
        WasmStructDeclaration vtableStruct = declarationGenerator.createVirtualTableStruct(list, string, vTableHeapTypeSymbol, klass.getModality() == Modality.FINAL, true);
        this.wasmFileCodegenContext.defineVTableGcType(metadata.getKlass().getSymbol(), vtableStruct);
        if (UtilsKt.isAbstractOrSealed(klass)) {
            return;
        }
        if (this.wasmFileCodegenContext.handleVTableWithImport(symbol)) {
            return;
        }
        WasmRefType vTableRefGcType = new WasmRefType((WasmHeapType)this.wasmFileCodegenContext.referenceVTableHeapType(symbol));
        boolean $i$f$buildWasmExpression = false;
        List res$iv = new ArrayList();
        WasmExpressionBuilder $this$createVTable_u24lambda_u240 = new WasmExpressionBuilder(res$iv, false, 2, null);
        boolean bl = false;
        SourceLocation location = SourceLocation.Companion.NoLocation("Create instance of vtable struct");
        this.buildSpecialITableInit(metadata, $this$createVTable_u24lambda_u240, location);
        Iterable $this$forEachIndexed$iv = metadata.getVirtualMethods();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void method;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            VirtualMethodMetadata virtualMethodMetadata = (VirtualMethodMetadata)item$iv;
            int i = n;
            boolean bl2 = false;
            if (method.getFunction().getModality() != Modality.ABSTRACT) {
                $this$createVTable_u24lambda_u240.buildInstr(WasmOp.REF_FUNC, location, (WasmImmediate)this.wasmFileCodegenContext.referenceFunction((IrFunctionSymbol)method.getFunction().getSymbol()));
                continue;
            }
            if (!this.allowIncompleteImplementations) {
                boolean bl3 = false;
                String string3 = "Cannot find class implementation of method " + method.getSignature() + " in class " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass));
                throw new IllegalStateException(string3.toString());
            }
            $this$createVTable_u24lambda_u240.buildRefNull((WasmHeapType)WasmHeapType.Simple.NoFunc.INSTANCE, location);
        }
        $this$createVTable_u24lambda_u240.buildStructNew((WasmImmediate.TypeIdx)this.wasmFileCodegenContext.referenceVTableGcType(symbol), location);
        List initVTableGlobal = res$iv;
        this.wasmFileCodegenContext.defineGlobalVTable(symbol, new WasmGlobal("<classVTable>", (WasmType)vTableRefGcType, false, initVTableGlobal, null, 16, null));
    }

    public final void addInterfaceMethod$backend_wasm(@NotNull ClassMetadata metadata, @NotNull WasmExpressionBuilder builder, @NotNull VirtualMethodMetadata method, @NotNull SourceLocation location) {
        Object v0;
        IrClass klass;
        block4: {
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            klass = metadata.getKlass();
            Iterable iterable = metadata.getVirtualMethods();
            for (Object t : iterable) {
                VirtualMethodMetadata it = (VirtualMethodMetadata)t;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)it.getSignature(), (Object)method.getSignature()) && it.getFunction().getModality() != Modality.ABSTRACT)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        VirtualMethodMetadata classMethod = v0;
        if (classMethod == null && !this.allowIncompleteImplementations && !this.backendContext.getPartialLinkageSupport().isEnabled()) {
            throw new IllegalStateException(("Cannot find interface implementation of method " + method.getSignature() + " in class " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass))).toString());
        }
        if (classMethod != null) {
            FuncSymbol functionTypeReference = this.wasmFileCodegenContext.referenceFunction((IrFunctionSymbol)classMethod.getFunction().getSymbol());
            builder.buildInstr(WasmOp.REF_FUNC, location, (WasmImmediate)functionTypeReference);
        } else {
            builder.buildRefNull((WasmHeapType)WasmHeapType.Simple.NoFunc.INSTANCE, location);
        }
    }

    private final void createRtti(ClassMetadata metadata) {
        String string;
        IrClassSymbol superType;
        IrClass klass = metadata.getKlass();
        IrClassSymbol symbol = klass.getSymbol();
        IrClass irClass = ClassInfoKt.getSuperClass(klass, this.irBuiltIns);
        Object object = superType = irClass != null ? irClass.getSymbol() : null;
        if (this.wasmFileCodegenContext.handleRTTIWithImport(symbol, superType)) {
            return;
        }
        boolean fqnShouldBeEmitted = (Boolean)CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)this.backendContext.getConfiguration()).getFlag(AnalysisFlags.getAllowFullyQualifiedNameInKClass());
        if (fqnShouldBeEmitted) {
            FqName fqName = StaticMembersLoweringKt.getOriginalFqName(klass);
            if (fqName == null) {
                fqName = AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)klass));
            }
            if ((string = FqNamesUtilKt.parentOrNull((FqName)fqName)) == null || (string = string.asString()) == null) {
                string = "";
            }
        } else {
            string = "";
        }
        String qualifier = string;
        String string2 = klass.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        String simpleName = string2;
        WasmSymbol<Integer> packageNameStringLiteralId = null;
        WasmSymbol<Integer> simpleNameStringLiteralId = null;
        if (this.backendContext.isWasmJsTarget()) {
            packageNameStringLiteralId = this.wasmFileCodegenContext.referenceGlobalStringId(qualifier);
            simpleNameStringLiteralId = this.wasmFileCodegenContext.referenceGlobalStringId(simpleName);
        } else {
            packageNameStringLiteralId = this.wasmFileCodegenContext.referenceStringLiteralId(qualifier);
            simpleNameStringLiteralId = this.wasmFileCodegenContext.referenceStringLiteralId(simpleName);
        }
        SourceLocation location = SourceLocation.Companion.NoLocation("Create instance of rtti struct");
        boolean $i$f$buildWasmExpression = false;
        List res$iv = new ArrayList();
        WasmExpressionBuilder $this$createRtti_u24lambda_u240 = new WasmExpressionBuilder(res$iv, false, 2, null);
        boolean bl = false;
        this.interfaceTable($this$createRtti_u24lambda_u240, metadata, location);
        if (superType != null) {
            $this$createRtti_u24lambda_u240.buildGetGlobal((WasmImmediate.GlobalIdx)this.wasmFileCodegenContext.referenceRttiGlobal(superType), location);
        } else {
            $this$createRtti_u24lambda_u240.buildRefNull((WasmHeapType)WasmHeapType.Simple.None.INSTANCE, location);
        }
        $this$createRtti_u24lambda_u240.buildConstI32Symbol(packageNameStringLiteralId, location);
        $this$createRtti_u24lambda_u240.buildConstI32Symbol(simpleNameStringLiteralId, location);
        $this$createRtti_u24lambda_u240.buildConstI64(this.wasmFileCodegenContext.referenceTypeId(symbol), location);
        int isAnonymousFlag = IrUtilsKt.isAnonymousObject((IrClass)klass) ? 1 : 0;
        int isLocalFlag = AdditionalIrUtilsKt.isOriginallyLocalDeclaration((IrDeclaration)((IrDeclaration)klass)) ? 2 : 0;
        $this$createRtti_u24lambda_u240.buildConstI32(isAnonymousFlag | isLocalFlag, location);
        FuncSymbol qualifierStringLoaderRef = this.backendContext.isWasmJsTarget() ? Synthetics.Functions.INSTANCE.getCreateStringLiteralJsString() : (UtilsKt.getFitsLatin1(qualifier) ? Synthetics.Functions.INSTANCE.getCreateStringLiteralLatin1() : Synthetics.Functions.INSTANCE.getCreateStringLiteralUtf16());
        $this$createRtti_u24lambda_u240.buildInstr(WasmOp.REF_FUNC, location, (WasmImmediate)qualifierStringLoaderRef);
        FuncSymbol simpleNameStringLoaderRef = this.backendContext.isWasmJsTarget() ? Synthetics.Functions.INSTANCE.getCreateStringLiteralJsString() : (UtilsKt.getFitsLatin1(simpleName) ? Synthetics.Functions.INSTANCE.getCreateStringLiteralLatin1() : Synthetics.Functions.INSTANCE.getCreateStringLiteralUtf16());
        $this$createRtti_u24lambda_u240.buildInstr(WasmOp.REF_FUNC, location, (WasmImmediate)simpleNameStringLoaderRef);
        if (this.backendContext.isWasmJsTarget()) {
            LiteralGlobalSymbol packageNameGlobalReference = this.wasmFileCodegenContext.referenceGlobalStringGlobal(qualifier);
            $this$createRtti_u24lambda_u240.buildGetGlobal((WasmImmediate.GlobalIdx)packageNameGlobalReference, location);
            LiteralGlobalSymbol simpleNameGlobalReference = this.wasmFileCodegenContext.referenceGlobalStringGlobal(simpleName);
            $this$createRtti_u24lambda_u240.buildGetGlobal((WasmImmediate.GlobalIdx)simpleNameGlobalReference, location);
        }
        $this$createRtti_u24lambda_u240.buildStructNew((WasmImmediate.TypeIdx)Synthetics.GcTypes.INSTANCE.getRttiType(), location);
        List initRttiGlobal = res$iv;
        WasmGlobal rttiGlobal = new WasmGlobal(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass)) + "_rtti", (WasmType)new WasmRefType((WasmHeapType)Synthetics.HeapTypes.INSTANCE.getRttiType()), false, initRttiGlobal, null, 16, null);
        this.wasmFileCodegenContext.defineRttiGlobal(rttiGlobal, symbol, superType);
    }

    /*
     * WARNING - void declaration
     */
    private final void createClassITable(ClassMetadata metadata) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        IrClass klass = metadata.getKlass();
        if (UtilsKt.isAbstractOrSealed(klass)) {
            return;
        }
        if (!ClassInfoKt.hasInterfaceSuperClass(klass)) {
            return;
        }
        if (this.wasmFileCodegenContext.handleClassITableWithImport(klass.getSymbol())) {
            return;
        }
        SourceLocation location = SourceLocation.Companion.NoLocation("Create instance of itable struct");
        boolean $i$f$buildWasmExpression = false;
        List res$iv = new ArrayList();
        WasmExpressionBuilder $this$createClassITable_u24lambda_u240 = new WasmExpressionBuilder(res$iv, false, 2, null);
        boolean bl = false;
        List<IrClass> supportedIFaces = metadata.getInterfaces();
        Iterable iterable = supportedIFaces;
        boolean $i$f$filterNot = false;
        Iterator<VirtualMethodMetadata> iterator2 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            IrClass it = (IrClass)element$iv$iv;
            boolean bl2 = false;
            if (this.backendContext.getSpecialSlotITableTypes$backend_wasm().contains(it.getSymbol()) || IrTypeUtilsKt.isFunction((IrClassifierSymbol)((IrClassifierSymbol)it.getSymbol()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List regularITableIFaces = (List)destination$iv$iv;
        for (IrClass iFace : regularITableIFaces) {
            for (VirtualMethodMetadata method : this.wasmModuleMetadataCache.getInterfaceMetadata(iFace.getSymbol()).getMethods()) {
                this.addInterfaceMethod$backend_wasm(metadata, $this$createClassITable_u24lambda_u240, method, location);
            }
            $this$createClassITable_u24lambda_u240.buildStructNew((WasmImmediate.TypeIdx)this.wasmFileCodegenContext.referenceVTableGcType(iFace.getSymbol()), location);
        }
        $this$createClassITable_u24lambda_u240.buildInstr(WasmOp.ARRAY_NEW_FIXED, location, (WasmImmediate)Synthetics.GcTypes.INSTANCE.getWasmAnyArrayType(), (WasmImmediate)new WasmImmediate.ConstI32(regularITableIFaces.size()));
        List initITableGlobal = res$iv;
        WasmGlobal wasmClassIFaceGlobal = new WasmGlobal("<classITable>", (WasmType)new WasmRefType((WasmHeapType)Synthetics.HeapTypes.INSTANCE.getWasmAnyArrayType()), false, initITableGlobal, null, 16, null);
        this.wasmFileCodegenContext.defineGlobalClassITable(klass.getSymbol(), wasmClassIFaceGlobal);
    }

    /*
     * WARNING - void declaration
     */
    public void visitClass(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration.isExternal()) {
            return;
        }
        IrClassSymbol symbol = declaration.getSymbol();
        WasmArrayInfo wasmArrayInfo = AnnotationsKt.getWasmArrayAnnotation((IrAnnotationContainer)declaration);
        if (wasmArrayInfo != null) {
            WasmArrayInfo wasmArrayAnnotation = wasmArrayInfo;
            boolean bl = false;
            String nameStr2 = String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)));
            WasmArrayDeclaration wasmArrayDeclaration = new WasmArrayDeclaration(nameStr2, new WasmStructFieldDeclaration("field", this.wasmModuleTypeTransformer.transformFieldType(wasmArrayAnnotation.getType()), wasmArrayAnnotation.isMutable()));
            this.wasmFileCodegenContext.defineGcType(symbol, (WasmTypeDeclaration)wasmArrayDeclaration);
            return;
        }
        String nameStr = String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration)));
        if (IrUtilsKt.isInterface((IrClass)declaration)) {
            WasmStructDeclaration vtableStruct = DeclarationGenerator.createVirtualTableStruct$default(this, this.wasmModuleMetadataCache.getInterfaceMetadata(symbol).getMethods(), "<classITable>", null, true, false, 4, null);
            this.wasmFileCodegenContext.defineVTableGcType(symbol, vtableStruct);
        } else {
            GcHeapTypeSymbol gcHeapTypeSymbol;
            void $this$mapTo$iv;
            ClassMetadata metadata = this.wasmModuleMetadataCache.getClassMetadata(symbol);
            this.createVTable(metadata);
            this.createClassITable(metadata);
            this.createRtti(metadata);
            WasmRefType vtableRefGcType = new WasmRefType((WasmHeapType)this.wasmFileCodegenContext.referenceVTableHeapType(symbol));
            List fields2 = new ArrayList();
            fields2.add(new WasmStructFieldDeclaration("vtable", (WasmType)vtableRefGcType, false));
            fields2.add(new WasmStructFieldDeclaration("itable", (WasmType)new WasmRefNullType((WasmHeapType)Synthetics.HeapTypes.INSTANCE.getWasmAnyArrayType()), false));
            fields2.add(new WasmStructFieldDeclaration("rtti", (WasmType)new WasmRefType((WasmHeapType)Synthetics.HeapTypes.INSTANCE.getRttiType()), false));
            Iterable nameStr2 = ClassInfoKt.allFields(declaration, this.irBuiltIns);
            Collection destination$iv = fields2;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                IrField irField = (IrField)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                String string = it.getName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                collection.add(new WasmStructFieldDeclaration(string, this.wasmModuleTypeTransformer.transformFieldType(it.getType()), true));
            }
            ClassMetadata superClass = metadata.getSuperClass();
            String string = nameStr;
            List list = fields2;
            ClassMetadata classMetadata = superClass;
            if (classMetadata != null) {
                ClassMetadata classMetadata2 = classMetadata;
                List list2 = list;
                String string2 = string;
                boolean bl = false;
                GcHeapTypeSymbol gcHeapTypeSymbol2 = this.wasmFileCodegenContext.referenceHeapType(superClass.getKlass().getSymbol());
                string = string2;
                list = list2;
                gcHeapTypeSymbol = gcHeapTypeSymbol2;
            } else {
                gcHeapTypeSymbol = null;
            }
            boolean bl = declaration.getModality() == Modality.FINAL;
            WasmHeapType.Type type = (WasmHeapType.Type)gcHeapTypeSymbol;
            List list3 = list;
            String string3 = string;
            WasmStructDeclaration structType = new WasmStructDeclaration(string3, list3, type, bl);
            this.wasmFileCodegenContext.defineGcType(symbol, (WasmTypeDeclaration)structType);
        }
        for (IrDeclaration member : declaration.getDeclarations()) {
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)member), (IrVisitorVoid)this);
        }
    }

    private final void interfaceTable(WasmExpressionBuilder builder, ClassMetadata classMetadata, SourceLocation location) {
        List<IrClass> supportedInterfaces = classMetadata.getInterfaces();
        if (supportedInterfaces.isEmpty()) {
            builder.buildRefNull((WasmHeapType)WasmHeapType.Simple.None.INSTANCE, location);
            return;
        }
        List<IrClassSymbol> specialSlotIFaces = this.backendContext.getSpecialSlotITableTypes$backend_wasm();
        Iterable $this$partition$iv = supportedInterfaces;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            IrClass it = (IrClass)element$iv;
            boolean bl = false;
            boolean bl2 = !specialSlotIFaces.contains(it.getSymbol()) && !IrTypeUtilsKt.isFunction((IrClassifierSymbol)((IrClassifierSymbol)it.getSymbol())) ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List forward = (List)pair.component1();
        List back = (List)pair.component2();
        List supportedPushedBack = CollectionsKt.plus((Collection)forward, (Iterable)back);
        for (IrClass iFace : supportedPushedBack) {
            builder.buildConstI64(this.wasmFileCodegenContext.referenceTypeId(iFace.getSymbol()), location);
        }
        builder.buildInstr(WasmOp.ARRAY_NEW_FIXED, location, (WasmImmediate)this.wasmFileCodegenContext.referenceGcType(this.backendContext.getWasmSymbols().getWasmLongImmutableArray$backend_wasm()), (WasmImmediate)new WasmImmediate.ConstI32(supportedPushedBack.size()));
    }

    public void visitField(@NotNull IrField declaration) {
        IrExpression initValue;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.wasmFileCodegenContext.handleGlobalField(declaration.getSymbol())) {
            return;
        }
        if (!declaration.isStatic()) {
            return;
        }
        WasmType wasmType = this.wasmModuleTypeTransformer.transformType(declaration.getType());
        List initBody = new ArrayList();
        WasmExpressionBuilder wasmExpressionGenerator = new WasmExpressionBuilder(initBody, this.skipCommentInstructions);
        IrExpressionBody irExpressionBody = declaration.getInitializer();
        Object object = initValue = irExpressionBody != null ? irExpressionBody.getExpression() : null;
        if (initValue instanceof IrConst && !(((IrConst)initValue).getKind() instanceof IrConstKind.String)) {
            IrFileEntry irFileEntry = IrInlineUtilsKt.getSourceFile((IrDeclaration)((IrDeclaration)declaration));
            Intrinsics.checkNotNull((Object)irFileEntry);
            IrFileEntry sourceFile = irFileEntry;
            SourceLocation location = this.locationProvider.getSourceLocation((IrElement)initValue, (IrSymbol)declaration.getSymbol(), sourceFile);
            DeclarationGeneratorKt.generateConstExpression((IrConst)initValue, wasmExpressionGenerator, this.wasmFileCodegenContext, this.backendContext, location);
        } else {
            DeclarationGeneratorKt.generateDefaultInitializerForType(wasmType, wasmExpressionGenerator);
        }
        WasmGlobal global = new WasmGlobal(String.valueOf(IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration))), wasmType, true, initBody, null, 16, null);
        this.wasmFileCodegenContext.defineGlobalField(declaration.getSymbol(), global);
    }

    private static final IrSimpleFunction unitGetInstanceFunction_delegate$lambda$0(DeclarationGenerator this$0) {
        return MiscKt.findUnitGetInstanceFunction(this$0.backendContext);
    }

    private static final IrConstructor unitPrimaryConstructor_delegate$lambda$0(DeclarationGenerator this$0) {
        return IrUtilsKt.getPrimaryConstructor((IrClass)((IrClass)this$0.backendContext.getIrBuiltIns().getUnitClass().getOwner()));
    }
}

