/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.lower.WebCallableReferenceLowering;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.FuncSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LiteralGlobalSymbol;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.Synthetics;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFileCodegenContext;
import org.jetbrains.kotlin.backend.wasm.utils.UtilsKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.wasm.WasmExportUtilsKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeErasureUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmExternRef;
import org.jetbrains.kotlin.wasm.ir.WasmF32;
import org.jetbrains.kotlin.wasm.ir.WasmF64;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullExternrefType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullrefType;
import org.jetbrains.kotlin.wasm.ir.WasmRefType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmUnreachableType;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\r\u001a\n\u0010\u000e\u001a\u00020\u000f*\u00020\r\u001a.\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u001a\u001a\u00020\u001b*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"TYPE_INFO_FLAG_ANONYMOUS_CLASS", "", "TYPE_INFO_FLAG_LOCAL_CLASS", "MAX_WASM_IMPORT_NAME_LENGTH", "generateDefaultInitializerForType", "", "type", "Lorg/jetbrains/kotlin/wasm/ir/WasmType;", "g", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getEffectiveValueParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isExported", "", "generateConstExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "body", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFileCodegenContext;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "locationTarget", "Lorg/jetbrains/kotlin/ir/IrElement;", "getLocationTarget", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Lorg/jetbrains/kotlin/ir/IrElement;", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nDeclarationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGeneratorKt\n+ 2 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder\n*L\n1#1,745:1\n389#2,4:746\n*S KotlinDebug\n*F\n+ 1 DeclarationGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/DeclarationGeneratorKt\n*L\n696#1:746,4\n*E\n"})
public final class DeclarationGeneratorKt {
    private static final int TYPE_INFO_FLAG_ANONYMOUS_CLASS = 1;
    private static final int TYPE_INFO_FLAG_LOCAL_CLASS = 2;
    private static final int MAX_WASM_IMPORT_NAME_LENGTH = 100000;

    public static final void generateDefaultInitializerForType(@NotNull WasmType type, @NotNull WasmExpressionBuilder g) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        SourceLocation location = SourceLocation.Companion.NoLocation("Default initializer, usually don't require location");
        boolean bl = false;
        WasmType wasmType = type;
        if (Intrinsics.areEqual((Object)wasmType, (Object)WasmI32.INSTANCE)) {
            g.buildConstI32(0, location);
        } else if (Intrinsics.areEqual((Object)wasmType, (Object)WasmI64.INSTANCE)) {
            g.buildConstI64(0L, location);
        } else if (Intrinsics.areEqual((Object)wasmType, (Object)WasmF32.INSTANCE)) {
            g.buildConstF32(0.0f, location);
        } else if (Intrinsics.areEqual((Object)wasmType, (Object)WasmF64.INSTANCE)) {
            g.buildConstF64(0.0, location);
        } else if (wasmType instanceof WasmRefNullType) {
            g.buildRefNull(((WasmRefNullType)type).getHeapType(), location);
        } else if (wasmType instanceof WasmRefType) {
            g.buildRefNull(((WasmRefType)type).getHeapType(), location);
        } else if (wasmType instanceof WasmRefNullrefType) {
            g.buildRefNull((WasmHeapType)WasmHeapType.Simple.None.INSTANCE, location);
        } else if (wasmType instanceof WasmRefNullExternrefType) {
            g.buildRefNull((WasmHeapType)WasmHeapType.Simple.NoExtern.INSTANCE, location);
        } else if (wasmType instanceof WasmAnyRef) {
            g.buildRefNull((WasmHeapType)WasmHeapType.Simple.Any.INSTANCE, location);
        } else if (wasmType instanceof WasmExternRef) {
            g.buildRefNull((WasmHeapType)WasmHeapType.Simple.Extern.INSTANCE, location);
        } else {
            if (Intrinsics.areEqual((Object)wasmType, (Object)WasmUnreachableType.INSTANCE)) {
                throw new IllegalStateException("Unreachable type can't be initialized".toString());
            }
            throw new IllegalStateException(("Unknown value type " + type.getName()).toString());
        }
    }

    @NotNull
    public static final List<IrValueParameter> getEffectiveValueParameters(@NotNull IrFunction $this$getEffectiveValueParameters) {
        Intrinsics.checkNotNullParameter((Object)$this$getEffectiveValueParameters, (String)"<this>");
        List result = new ArrayList();
        if ($this$getEffectiveValueParameters instanceof IrConstructor) {
            IrValueParameter irValueParameter = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)$this$getEffectiveValueParameters)).getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter);
            result.add(irValueParameter);
        }
        result.addAll($this$getEffectiveValueParameters.getParameters());
        return result;
    }

    public static final boolean isExported(@NotNull IrFunction $this$isExported) {
        Intrinsics.checkNotNullParameter((Object)$this$isExported, (String)"<this>");
        return AnnotationUtilsKt.isExplicitlyExported((IrAnnotationContainer)$this$isExported) || WasmExportUtilsKt.isWasmExportDeclaration((IrAnnotationContainer)((IrAnnotationContainer)$this$isExported));
    }

    public static final void generateConstExpression(@NotNull IrConst expression2, @NotNull WasmExpressionBuilder body, @NotNull WasmFileCodegenContext context, @NotNull WasmBackendContext backendContext, @NotNull SourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)backendContext, (String)"backendContext");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        IrConstKind kind = expression2.getKind();
        if (kind instanceof IrConstKind.Null) {
            IrClass irClass = IrTypesKt.getClass((IrType)expression2.getType());
            boolean isExternal = irClass != null ? irClass.isExternal() : IrTypeErasureUtilsKt.getErasedUpperBound((IrType)expression2.getType()).isExternal();
            WasmType bottomType = isExternal ? (WasmType)WasmRefNullExternrefType.INSTANCE : (WasmType)WasmRefNullrefType.INSTANCE;
            body.buildInstr(WasmOp.REF_NULL, location, (WasmImmediate)new WasmImmediate.HeapType(bottomType));
        } else if (kind instanceof IrConstKind.Boolean) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Boolean");
            body.buildConstI32((Boolean)object != false ? 1 : 0, location);
        } else if (kind instanceof IrConstKind.Byte) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Byte");
            body.buildConstI32((int)((Byte)object).byteValue(), location);
        } else if (kind instanceof IrConstKind.Short) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Short");
            body.buildConstI32((int)((Short)object).shortValue(), location);
        } else if (kind instanceof IrConstKind.Int) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
            body.buildConstI32(((Integer)object).intValue(), location);
        } else if (kind instanceof IrConstKind.Long) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Long");
            body.buildConstI64(((Long)object).longValue(), location);
        } else if (kind instanceof IrConstKind.Char) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Char");
            body.buildConstI32((int)((Character)object).charValue(), location);
        } else if (kind instanceof IrConstKind.Float) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Float");
            body.buildConstF32(((Float)object).floatValue(), location);
        } else if (kind instanceof IrConstKind.Double) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Double");
            body.buildConstF64(((Double)object).doubleValue(), location);
        } else if (kind instanceof IrConstKind.String) {
            Object object = expression2.getValue();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String stringValue = (String)object;
            WasmExpressionBuilder this_$iv = body;
            boolean $i$f$commentGroupStart = false;
            if (!this_$iv.getSkipCommentInstructions()) {
                String string;
                SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
                WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                boolean bl = false;
                String string2 = string = "const string: \"" + stringValue + '\"';
                wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, (WasmImmediate)new WasmImmediate.ConstString(string2));
            }
            if (backendContext.isWasmJsTarget() && !UtilsKt.getHasUnpairedSurrogates(stringValue)) {
                WasmSymbol<Integer> literalIdToStore = context.referenceGlobalStringId(stringValue);
                body.buildConstI32Symbol(literalIdToStore, location);
                if (stringValue.length() > 100000) {
                    List stringValueSplits = StringsKt.chunked((CharSequence)stringValue, (int)100000);
                    FuncSymbol jsConcat = context.referenceFunction((IrFunctionSymbol)backendContext.getWasmSymbols().getJsRelatedSymbols().getJsConcat());
                    LiteralGlobalSymbol globalReferenceFirst = context.referenceGlobalStringGlobal((String)CollectionsKt.first((List)stringValueSplits));
                    body.buildGetGlobal((WasmImmediate.GlobalIdx)globalReferenceFirst, location);
                    for (String stringValueSplit : CollectionsKt.drop((Iterable)stringValueSplits, (int)1)) {
                        LiteralGlobalSymbol globalReference = context.referenceGlobalStringGlobal(stringValueSplit);
                        body.buildGetGlobal((WasmImmediate.GlobalIdx)globalReference, location);
                        body.buildCall((WasmImmediate.FuncIdx)jsConcat, location);
                    }
                } else {
                    LiteralGlobalSymbol globalReferenceFirst = context.referenceGlobalStringGlobal(stringValue);
                    body.buildGetGlobal((WasmImmediate.GlobalIdx)globalReferenceFirst, location);
                }
                body.buildCall((WasmImmediate.FuncIdx)Synthetics.Functions.INSTANCE.getCreateStringLiteralJsString(), location);
            } else {
                WasmSymbol<Integer> literalId = context.referenceStringLiteralId(stringValue);
                body.buildConstI32Symbol(literalId, location);
                if (UtilsKt.getFitsLatin1(stringValue)) {
                    body.buildCall((WasmImmediate.FuncIdx)Synthetics.Functions.INSTANCE.getCreateStringLiteralLatin1(), location);
                } else {
                    body.buildCall((WasmImmediate.FuncIdx)Synthetics.Functions.INSTANCE.getCreateStringLiteralUtf16(), location);
                }
            }
            body.commentGroupEnd();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    @NotNull
    public static final IrElement getLocationTarget(@NotNull IrFunction $this$locationTarget) {
        IrElement irElement;
        Intrinsics.checkNotNullParameter((Object)$this$locationTarget, (String)"<this>");
        IrDeclarationOrigin irDeclarationOrigin = $this$locationTarget.getOrigin();
        if (Intrinsics.areEqual((Object)irDeclarationOrigin, (Object)IrDeclarationOrigin.Companion.getFUNCTION_FOR_DEFAULT_PARAMETER())) {
            irElement = (IrElement)$this$locationTarget;
        } else if (Intrinsics.areEqual((Object)irDeclarationOrigin, (Object)IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA())) {
            irElement = (IrElement)$this$locationTarget;
        } else {
            IrElementBase irElementBase;
            IrDeclarationOrigin irDeclarationOrigin2;
            IrClass irClass = IrUtilsKt.getParentClassOrNull((IrDeclaration)((IrDeclaration)$this$locationTarget));
            Object object = irDeclarationOrigin2 = irClass != null ? irClass.getOrigin() : null;
            if (Intrinsics.areEqual((Object)irDeclarationOrigin2, (Object)WebCallableReferenceLowering.Companion.getFUNCTION_REFERENCE_IMPL()) || Intrinsics.areEqual((Object)irDeclarationOrigin2, (Object)IrDeclarationOrigin.Companion.getLOCAL_FUNCTION_FOR_LAMBDA())) {
                irElementBase = (IrElementBase)$this$locationTarget;
            } else {
                IrBody irBody = $this$locationTarget.getBody();
                irElementBase = irBody != null ? (IrElementBase)irBody : (IrElementBase)$this$locationTarget;
            }
            irElement = (IrElement)irElementBase;
        }
        return irElement;
    }
}

