/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.javascript.debugger.LocalVariablesHolder;
import com.intellij.javascript.debugger.VariablesHolder;
import com.intellij.javascript.debugger.VariablesHolderKt;
import com.intellij.javascript.debugger.console.JavaScriptDebuggerConsoleExecuteActionHandlerKt;
import com.intellij.openapi.application.ActionsKt;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javascript/debugger/LocalVariablesHolder;", "Lcom/intellij/javascript/debugger/VariablesHolder;", "vmSupplier", "Ljava/util/function/Supplier;", "Lorg/jetbrains/debugger/Vm;", "<init>", "(Ljava/util/function/Supplier;)V", "callFrame", "Lorg/jetbrains/debugger/CallFrame;", "getCallFrame", "()Lorg/jetbrains/debugger/CallFrame;", "setCallFrame", "(Lorg/jetbrains/debugger/CallFrame;)V", "variablesLoader", "Lorg/jetbrains/concurrency/AsyncValueLoader;", "", "getVariablesLoader", "()Lorg/jetbrains/concurrency/AsyncValueLoader;", "intellij.javascript.debugger.backend"})
public final class LocalVariablesHolder
extends VariablesHolder {
    @Nullable
    private volatile CallFrame callFrame;
    @NotNull
    private final AsyncValueLoader<Boolean> variablesLoader;

    public LocalVariablesHolder(@NotNull Supplier<Vm> vmSupplier2) {
        Intrinsics.checkNotNullParameter(vmSupplier2, (String)"vmSupplier");
        this.variablesLoader = (AsyncValueLoader)new AsyncValueLoader<Boolean>(this, vmSupplier2){
            final /* synthetic */ LocalVariablesHolder this$0;
            final /* synthetic */ Supplier<Vm> $vmSupplier;
            {
                this.this$0 = $receiver;
                this.$vmSupplier = $vmSupplier;
            }

            protected Promise<Boolean> load(AsyncPromise<Boolean> promise) {
                Intrinsics.checkNotNullParameter(promise, (String)"promise");
                CallFrame currentCallFrame = this.this$0.getCallFrame();
                if (currentCallFrame == null) {
                    promise.cancel();
                    return (Promise)promise;
                }
                Scope scope = JavaScriptDebuggerConsoleExecuteActionHandlerKt.getLocalScope(currentCallFrame);
                if (scope == null) {
                    promise.cancel();
                    return (Promise)promise;
                }
                Promise promise2 = scope.getVariablesHost().get().then(arg_0 -> variablesLoader.1.load$lambda$1(arg_0 -> variablesLoader.1.load$lambda$0(this.$vmSupplier, this.this$0, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
                return promise2;
            }

            private static final Unit load$lambda$0$0(LocalVariablesHolder this$0, List $variables) {
                this$0.getNameToPsiTypeName().clear();
                this$0.getLookupElements().clear();
                this$0.getLookupElements().ensureCapacity($variables.size());
                for (Variable variable : $variables) {
                    LookupElementBuilder lookupItem;
                    String name;
                    Intrinsics.checkNotNullExpressionValue((Object)variable.getName(), (String)"getName(...)");
                    String string = VariablesHolderKt.backendTypeNameToPsiTypeName(variable.getValue());
                    if (string == null) continue;
                    this$0.getNameToPsiTypeName().put(name, string);
                    Intrinsics.checkNotNullExpressionValue((Object)LookupElementBuilder.create((String)name), (String)"create(...)");
                    if (variable.getValue() != null) {
                        Value it;
                        boolean bl = false;
                        lookupItem.withIcon(VariableView.Companion.getIcon(it));
                    }
                    this$0.getLookupElements().add((LookupElement)lookupItem);
                }
                return Unit.INSTANCE;
            }

            private static final Boolean load$lambda$0(Supplier $vmSupplier, LocalVariablesHolder this$0, List variables) {
                if ($vmSupplier.get() == null || variables.isEmpty()) {
                    return true;
                }
                ActionsKt.runReadAction(() -> variablesLoader.1.load$lambda$0$0(this$0, variables));
                return true;
            }

            private static final Boolean load$lambda$1(Function1 $tmp0, Object p0) {
                return (Boolean)$tmp0.invoke(p0);
            }
        };
    }

    @Nullable
    public final CallFrame getCallFrame() {
        return this.callFrame;
    }

    public final void setCallFrame(@Nullable CallFrame callFrame) {
        this.callFrame = callFrame;
    }

    @NotNull
    protected AsyncValueLoader<Boolean> getVariablesLoader() {
        return this.variablesLoader;
    }
}

