/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bJ\u0018\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/api/GHEServerVersionChecker;", "", "<init>", "()V", "REQUIRED_VERSION_MAJOR", "", "REQUIRED_VERSION_MINOR", "ENTERPRISE_VERSION_HEADER", "", "checkVersionSupported", "", "versionValue", "throwUnsupportedVersion", "currentMajor", "currentMinor", "intellij.vcs.github"})
public final class GHEServerVersionChecker {
    @NotNull
    public static final GHEServerVersionChecker INSTANCE = new GHEServerVersionChecker();
    private static final int REQUIRED_VERSION_MAJOR = 3;
    private static final int REQUIRED_VERSION_MINOR = 2;
    @NotNull
    public static final String ENTERPRISE_VERSION_HEADER = "x-github-enterprise-version";

    private GHEServerVersionChecker() {
    }

    public final void checkVersionSupported(@NotNull String versionValue) {
        Intrinsics.checkNotNullParameter((Object)versionValue, (String)"versionValue");
        int majorVersion = 0;
        int minorVersion = 0;
        try {
            char[] cArray = new char[]{'.'};
            List versionSplit = StringsKt.split$default((CharSequence)versionValue, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            majorVersion = Integer.parseInt((String)versionSplit.get(0));
            minorVersion = Integer.parseInt((String)versionSplit.get(1));
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not determine GitHub Enterprise server version", e);
        }
        if (majorVersion > 3) {
            return;
        }
        if (majorVersion < 3) {
            this.throwUnsupportedVersion(majorVersion, minorVersion);
        } else if (minorVersion < 2) {
            this.throwUnsupportedVersion(majorVersion, minorVersion);
        }
    }

    private final void throwUnsupportedVersion(int currentMajor, int currentMinor) {
        throw new IllegalStateException(("Unsupported GitHub Enterprise server version " + currentMajor + "." + currentMinor + ". Earliest supported version is 3.2").toString());
    }
}

