/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.library;

import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.microservices.jvm.dependencies.FrameworkDependenciesManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.boot.SpringBootApiBundle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00070\u0005\u00a2\u0006\u0002\b\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/spring/boot/library/AddDependencyFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "module", "Lcom/intellij/openapi/module/Module;", "name", "", "groupId", "artifactId", "version", "scope", "<init>", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "previewDescriptor", "Companion", "intellij.spring.boot"})
public final class AddDependencyFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Module module;
    @NotNull
    private final String name;
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    @Nullable
    private final String version;
    @Nullable
    private final String scope;

    public AddDependencyFix(@NotNull Module module, @NotNull String name, @NotNull String groupId, @NotNull String artifactId, @Nullable String version, @Nullable String scope) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)groupId, (String)"groupId");
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        this.module = module;
        this.name = name;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.scope = scope;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.name};
        String string = SpringBootApiBundle.message("spring.data.no.driver.dependency.fix", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        FrameworkDependenciesManager frameworkDependenciesManager = AddDependencyFix.Companion.getDependenciesManager(this.module);
        if (frameworkDependenciesManager == null) {
            return;
        }
        FrameworkDependenciesManager starterManager = frameworkDependenciesManager;
        String string = this.version;
        if (string == null) {
            string = "";
        }
        starterManager.addDependency(this.module, new UnifiedDependency(this.groupId, this.artifactId, string, this.scope));
        starterManager.refresh(this.module);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)previewDescriptor, (String)"previewDescriptor");
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/spring/boot/library/AddDependencyFix$Companion;", "", "<init>", "()V", "isAvailable", "", "module", "Lcom/intellij/openapi/module/Module;", "getDependenciesManager", "Lcom/intellij/microservices/jvm/dependencies/FrameworkDependenciesManager;", "intellij.spring.boot"})
    @SourceDebugExtension(value={"SMAP\nAddDependencyFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddDependencyFix.kt\ncom/intellij/spring/boot/library/AddDependencyFix$Companion\n+ 2 FrameworkDependenciesManager.kt\ncom/intellij/microservices/jvm/dependencies/FrameworkDependenciesManager$Companion\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n25#2:49\n26#2:62\n812#3,12:50\n1#4:63\n*S KotlinDebug\n*F\n+ 1 AddDependencyFix.kt\ncom/intellij/spring/boot/library/AddDependencyFix$Companion\n*L\n28#1:49\n28#1:62\n28#1:50,12\n28#1:63\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAvailable(@NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            return this.getDependenciesManager(module) != null;
        }

        /*
         * WARNING - void declaration
         */
        private final FrameworkDependenciesManager getDependenciesManager(Module module) {
            Iterable iterable;
            block2: {
                void $this$filterIsInstanceTo$iv$iv$iv;
                void this_$iv;
                FrameworkDependenciesManager.Companion companion = FrameworkDependenciesManager.Companion;
                Module module$iv = module;
                boolean $i$f$getInstance = false;
                Iterable $this$filterIsInstance$iv$iv = this_$iv.getEP_NAME().getExtensionList();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable2 = $this$filterIsInstance$iv$iv;
                Collection destination$iv$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                    if (!(element$iv$iv$iv instanceof FrameworkDependenciesManager)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                for (FrameworkDependenciesManager it$iv : (Iterable)((List)destination$iv$iv$iv)) {
                    FrameworkDependenciesManager frameworkDependenciesManager;
                    boolean bl = false;
                    FrameworkDependenciesManager it$iv2 = frameworkDependenciesManager = it$iv;
                    boolean bl2 = false;
                    iterable2 = it$iv2.supports(module$iv) ? frameworkDependenciesManager : null;
                    if (iterable2 == null) continue;
                    iterable = iterable2;
                    break block2;
                }
                iterable = null;
            }
            return iterable;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

