/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.model.autoconfigure.conditions;

import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.boot.model.ConfigurationValueResult;
import com.intellij.spring.boot.model.ConfigurationValueSearchParams;
import com.intellij.spring.boot.model.SpringBootConfigValueSearcher;
import com.intellij.spring.boot.model.SpringBootModelConfigFileContributor;
import com.intellij.spring.boot.model.autoconfigure.conditions.ConditionalOnEvaluationContext;
import com.intellij.util.Processor;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalOnEvaluationContextBase
extends UserDataHolderBase
implements ConditionalOnEvaluationContext {
    @NotNull
    private final PsiClass myAutoConfigClass;
    @NotNull
    private final Module myModule;
    @Nullable
    private final Set<String> myActiveProfiles;
    @NotNull
    private final NotNullLazyValue<? extends List<VirtualFile>> myConfigFilesCache;

    public ConditionalOnEvaluationContextBase(@NotNull PsiClass autoConfigClass, @NotNull Module module, @Nullable Set<String> activeProfiles, @NotNull NotNullLazyValue<? extends List<VirtualFile>> configFilesCache, @Nullable ConditionalOnEvaluationContextBase sharedContext) {
        if (autoConfigClass == null) {
            ConditionalOnEvaluationContextBase.$$$reportNull$$$0(0);
        }
        if (module == null) {
            ConditionalOnEvaluationContextBase.$$$reportNull$$$0(1);
        }
        if (configFilesCache == null) {
            ConditionalOnEvaluationContextBase.$$$reportNull$$$0(2);
        }
        this.myAutoConfigClass = autoConfigClass;
        this.myModule = module;
        this.myActiveProfiles = activeProfiles;
        this.myConfigFilesCache = configFilesCache;
        if (sharedContext != null) {
            sharedContext.copyUserDataTo(this);
        }
    }

    @Override
    @NotNull
    public PsiClass getAutoConfigClass() {
        PsiClass psiClass = this.myAutoConfigClass;
        if (psiClass == null) {
            ConditionalOnEvaluationContextBase.$$$reportNull$$$0(3);
        }
        return psiClass;
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            ConditionalOnEvaluationContextBase.$$$reportNull$$$0(4);
        }
        return module;
    }

    @Override
    @Nullable
    public Set<String> getActiveProfiles() {
        return this.myActiveProfiles;
    }

    @Override
    public boolean processConfigurationValues(Processor<? super List<ConfigurationValueResult>> processor, boolean checkRelaxedNames, @NotNull MetaConfigKey configKey) {
        if (configKey == null) {
            ConditionalOnEvaluationContextBase.$$$reportNull$$$0(5);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.getModule().getProject());
        Set<String> activeProfiles = SpringBootConfigValueSearcher.clearDefaultTestProfile(this.getActiveProfiles());
        ConfigurationValueSearchParams searchParams = new ConfigurationValueSearchParams(this.getModule(), checkRelaxedNames, activeProfiles, configKey, configKey.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED}) ? "" : null);
        for (VirtualFile file : (List)this.myConfigFilesCache.getValue()) {
            List<ConfigurationValueResult> values;
            PsiFile psiFile;
            SpringBootModelConfigFileContributor contributor = SpringBootModelConfigFileContributor.getContributor(file);
            if (contributor == null || (psiFile = psiManager.findFile(file)) == null || processor.process(values = contributor.findConfigurationValues(psiFile, searchParams))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autoConfigClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilesCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/model/autoconfigure/conditions/ConditionalOnEvaluationContextBase";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/model/autoconfigure/conditions/ConditionalOnEvaluationContextBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAutoConfigClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processConfigurationValues";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

