/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.properties.IndexAccessTextProcessor;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.spring.boot.application.config.SpringBootConfigFileAnnotatorBase;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.SimpleTextAttributes;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0012\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesAnnotatorBase;", "Lcom/intellij/spring/boot/application/config/SpringBootConfigFileAnnotatorBase;", "<init>", "()V", "isSuitableFile", "", "file", "Lcom/intellij/psi/PsiFile;", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "getPlaceholderTextAttributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "doAnnotateKey", "Lcom/intellij/lang/properties/psi/impl/PropertyKeyImpl;", "annotateIndexAccessExpressions", "text", "", "configKey", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "elementStartOffset", "", "intellij.spring.boot.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSpringBootApplicationPropertiesAnnotatorBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootApplicationPropertiesAnnotatorBase.kt\ncom/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesAnnotatorBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public abstract class SpringBootApplicationPropertiesAnnotatorBase
extends SpringBootConfigFileAnnotatorBase {
    public abstract boolean isSuitableFile(@NotNull PsiFile var1);

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(element instanceof PropertyValueImpl) && !(element instanceof PropertyKeyImpl)) {
            return;
        }
        PsiFile psiFile = holder.getCurrentAnnotationSession().getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        if (!(file instanceof PropertiesFile)) {
            return;
        }
        if (!SpringCommonUtils.isSpringConfigured((Project)((PropertiesFile)file).getProject()) || !this.isSuitableFile(file)) {
            return;
        }
        if (element instanceof PropertyValueImpl) {
            this.annotateValue(element, holder);
        }
        if (element instanceof PropertyKeyImpl) {
            this.doAnnotateKey((PropertyKeyImpl)element, holder);
        }
    }

    @NotNull
    protected TextAttributesKey getPlaceholderTextAttributesKey() {
        TextAttributesKey textAttributesKey = PropertiesHighlighter.PropertiesComponent.PROPERTY_KEY.getTextAttributesKey();
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"getTextAttributesKey(...)");
        return textAttributesKey;
    }

    private final void doAnnotateKey(PropertyKeyImpl element, AnnotationHolder holder) {
        MetaConfigKey configKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)((PsiElement)element));
        if (configKey == null) {
            return;
        }
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String keyText = string;
        int elementStartOffset = element.getNode().getStartOffset();
        this.annotateIndexAccessExpressions(holder, keyText, configKey, elementStartOffset);
        MetaConfigKey.AccessType[] accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL};
        if (configKey.isAccessType(accessTypeArray)) {
            return;
        }
        this.annotateKey((PsiElement)element, holder);
        accessTypeArray = new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.MAP};
        if (configKey.isAccessType(accessTypeArray) && configKey.getKeyItemHint() != MetaConfigKey.ItemHint.NONE) {
            boolean bl;
            int configKeyNameLength = -1;
            PsiReference[] psiReferenceArray = element.getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            for (PsiReference reference : psiReferenceArray) {
                if (!(reference instanceof MetaConfigKeyReference)) continue;
                configKeyNameLength = ((MetaConfigKeyReference)reference).getRangeInElement().getEndOffset();
                break;
            }
            boolean bl2 = bl = configKeyNameLength != -1;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-SpringBootApplicationPropertiesAnnotatorBase$doAnnotateKey$22 = false;
                String $i$a$-assert-SpringBootApplicationPropertiesAnnotatorBase$doAnnotateKey$22 = keyText;
                throw new AssertionError((Object)$i$a$-assert-SpringBootApplicationPropertiesAnnotatorBase$doAnnotateKey$22);
            }
            int endOffset = keyText.length() - configKeyNameLength - (StringUtil.endsWithChar((CharSequence)keyText, (char)']') ? 2 : 1);
            if (endOffset < 0) {
                return;
            }
            TextRange textRange = TextRange.from((int)(configKeyNameLength + 1), (int)endOffset).shiftRight(elementStartOffset);
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
            TextRange genericKeyRange = textRange;
            this.doAnnotateEnforced(holder, genericKeyRange, SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES, "REGULAR_ITALIC_ATTRIBUTES");
        }
    }

    private final void annotateIndexAccessExpressions(AnnotationHolder holder, String text, MetaConfigKey configKey, int elementStartOffset) {
        new IndexAccessTextProcessor(text, configKey, this, holder, elementStartOffset){
            final /* synthetic */ SpringBootApplicationPropertiesAnnotatorBase this$0;
            final /* synthetic */ AnnotationHolder $holder;
            final /* synthetic */ int $elementStartOffset;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$elementStartOffset = $elementStartOffset;
                super($text, $configKey);
            }

            protected void onMissingClosingBracket(int startIdx) {
            }

            protected void onMissingIndexValue(int startIdx) {
            }

            protected void onBracket(int startIdx) {
                SpringBootApplicationPropertiesAnnotatorBase.access$doAnnotate(this.this$0, this.$holder, TextRange.from((int)startIdx, (int)1).shiftRight(this.$elementStartOffset), DefaultLanguageHighlighterColors.BRACKETS);
            }

            protected void onIndexValue(TextRange indexValueRange) {
                Intrinsics.checkNotNullParameter((Object)indexValueRange, (String)"indexValueRange");
                SpringBootApplicationPropertiesAnnotatorBase.access$doAnnotate(this.this$0, this.$holder, indexValueRange.shiftRight(this.$elementStartOffset), DefaultLanguageHighlighterColors.NUMBER);
            }

            protected void onIndexValueNotInteger(TextRange indexValueRange) {
                Intrinsics.checkNotNullParameter((Object)indexValueRange, (String)"indexValueRange");
            }
        }.process();
    }

    public static final /* synthetic */ void access$doAnnotate(SpringBootApplicationPropertiesAnnotatorBase $this, AnnotationHolder p0, TextRange p1, TextAttributesKey p2) {
        $this.doAnnotate(p0, p1, p2);
    }
}

