/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.properties;

import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.impl.PropertyKeyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.hints.LoggerNameReferenceProvider;
import com.intellij.microservices.jvm.config.properties.ConfigKeyPathReferenceProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesKeyReferenceProvider;
import com.intellij.spring.boot.application.properties.SpringBootApplicationPropertiesValueReferenceProvider;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.model.SpringBootConfigurationFileService;
import com.intellij.spring.constants.SpringReferencePatternConditions;
import com.intellij.util.ProcessingContext;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class SpringBootApplicationPropertiesReferenceContributorBase
extends PsiReferenceContributor {
    private static final String LOGGING_LEVEL_KEY_PREFIX = "logging.level.";

    protected PatternCondition<PsiElement> getKeyPattern() {
        return Holder.APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER;
    }

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            SpringBootApplicationPropertiesReferenceContributorBase.$$$reportNull$$$0(0);
        }
        this.registerKeyProviders(registrar);
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PropertyValueImpl.class).with(this.getKeyPattern()), (PsiReferenceProvider)new SpringBootApplicationPropertiesValueReferenceProvider(), 100.0);
    }

    private void registerKeyProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            SpringBootApplicationPropertiesReferenceContributorBase.$$$reportNull$$$0(1);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(this.getKeyPattern()), (PsiReferenceProvider)new SpringBootApplicationPropertiesKeyReferenceProvider());
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(this.getKeyPattern())).without(SpringBootLibraryUtil.SB_1_3_OR_HIGHER)).with((PatternCondition)new PatternCondition<PropertyKeyImpl>(this, "logging.level"){

            public boolean accepts(@NotNull PropertyKeyImpl key, ProcessingContext context) {
                if (key == null) {
                    2.$$$reportNull$$$0(0);
                }
                return StringUtil.startsWith((CharSequence)key.getText(), (CharSequence)SpringBootApplicationPropertiesReferenceContributorBase.LOGGING_LEVEL_KEY_PREFIX);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributorBase$2", "accepts"));
            }
        }), new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
                int startInElement = SpringBootApplicationPropertiesReferenceContributorBase.LOGGING_LEVEL_KEY_PREFIX.length();
                if (startInElement <= textRange.getLength()) {
                    TextRange shiftedTextRange = textRange.shiftRight(startInElement).grown(-startInElement);
                    LoggerNameReferenceProvider provider = new LoggerNameReferenceProvider();
                    PsiReference[] psiReferenceArray = provider.getReferences(element, Collections.singletonList(shiftedTextRange), context);
                    if (psiReferenceArray == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    1.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributorBase$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributorBase$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        });
        final Condition mapTypeKeyCondition = configKey -> configKey.isAccessType(MetaConfigKey.AccessType.MAP_GROUP);
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(this.getKeyPattern())).with(SpringBootLibraryUtil.SB_1_3_OR_HIGHER)).with((PatternCondition)new PatternCondition<PropertyKeyImpl>(this, "mapTypeKey"){

            public boolean accepts(@NotNull PropertyKeyImpl key, ProcessingContext context) {
                if (key == null) {
                    4.$$$reportNull$$$0(0);
                }
                return MetaConfigKeyReference.findAndStoreMetaConfigKeyIfMatches((PsiElement)key, (ProcessingContext)context, (Condition)mapTypeKeyCondition);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributorBase$4", "accepts"));
            }
        }), new PsiReferenceProvider(this){

            public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    3.$$$reportNull$$$0(1);
                }
                MetaConfigKey configKey = (MetaConfigKey)context.get(MetaConfigKeyReference.META_CONFIG_KEY);
                TextRange textRange = ElementManipulators.getValueTextRange((PsiElement)element);
                int startInElement = configKey.getName().length() + 1;
                if (startInElement <= textRange.getLength()) {
                    TextRange shiftedTextRange = textRange.shiftRight(startInElement).grown(-startInElement);
                    SpringBootHintReferencesProvider hintReferencesProvider = SpringBootHintReferencesProvider.getInstance();
                    PsiReference[] psiReferenceArray = hintReferencesProvider.getKeyReferences(configKey, element, shiftedTextRange, context);
                    if (psiReferenceArray == null) {
                        3.$$$reportNull$$$0(2);
                    }
                    return psiReferenceArray;
                }
                if (PsiReference.EMPTY_ARRAY == null) {
                    3.$$$reportNull$$$0(3);
                }
                return PsiReference.EMPTY_ARRAY;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2, 3 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributorBase$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributorBase$3";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReferencesByElement";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReferencesByElement";
                        break;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2, 3 -> new IllegalStateException(string);
                };
            }
        });
        registrar.registerReferenceProvider((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PropertyKeyImpl.class).with(Holder.APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER)).with((PatternCondition)new PatternCondition<PropertyKeyImpl>(this, "isMapOrIndexedKey"){

            public boolean accepts(@NotNull PropertyKeyImpl key, ProcessingContext context) {
                if (key == null) {
                    5.$$$reportNull$$$0(0);
                }
                return MetaConfigKeyReference.findAndStoreMetaConfigKeyIfMatches((PsiElement)key, (ProcessingContext)context, (Condition)MetaConfigKey.MAP_OR_INDEXED_WITHOUT_KEY_HINTS_CONDITION);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributorBase$5", "accepts"));
            }
        }), (PsiReferenceProvider)new ConfigKeyPathReferenceProvider());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "registrar";
        objectArray2[1] = "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerReferenceProviders";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "registerKeyProviders";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class Holder {
        static final PatternCondition<PsiElement> APPLICATION_PROPERTIES_SB_1_2_OR_HIGHER = new PatternCondition<PsiElement>("isApplicationPropertiesAndSB_1_2"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!SpringReferencePatternConditions.PROJECT_HAS_SPRING_FACETS_CONDITION.accepts((Object)element, context)) {
                    return false;
                }
                PsiFile containingFile = element.getContainingFile().getOriginalFile();
                if (!(containingFile instanceof PropertiesFile)) {
                    return false;
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
                if (SpringBootLibraryUtil.isBelowVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_1_2_0)) {
                    return false;
                }
                return SpringBootConfigurationFileService.getInstance().isApplicationConfigurationFile(containingFile);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/boot/application/properties/SpringBootApplicationPropertiesReferenceContributorBase$Holder$1", "accepts"));
            }
        };

        Holder() {
        }
    }
}

