/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.microservices.jvm.config.ConfigKeyPathReference;
import com.intellij.microservices.jvm.config.ConfigPlaceholderReference;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.microservices.jvm.config.MicroservicesConfigUtils;
import com.intellij.microservices.jvm.config.hints.BooleanHintReference;
import com.intellij.microservices.jvm.config.hints.NumberHintReferenceBase;
import com.intellij.microservices.jvm.config.yaml.ConfigYamlUtils;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.boot.application.config.SpringBootHintReferencesProvider;
import com.intellij.spring.boot.application.config.SpringBootPlaceholderReference;
import com.intellij.spring.boot.application.config.SpringBootReplacementTokenResolver;
import com.intellij.spring.boot.application.yaml.SpringBootApplicationYamlInspection;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;

class SpringBootApplicationYamlValueReferenceProvider
extends PsiReferenceProvider {
    static final String INSPECTION_ID = new SpringBootApplicationYamlInspection().getID();
    private static final Key<SpringBootApplicationYamlInspection> INSPECTION_KEY = Key.create((String)INSPECTION_ID);

    SpringBootApplicationYamlValueReferenceProvider() {
    }

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        MetaConfigKey key;
        YAMLKeyValue yamlKeyValue;
        if (element == null) {
            SpringBootApplicationYamlValueReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            SpringBootApplicationYamlValueReferenceProvider.$$$reportNull$$$0(1);
        }
        if ((yamlKeyValue = (YAMLKeyValue)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLKeyValue.class)) == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootApplicationYamlValueReferenceProvider.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootApplicationYamlValueReferenceProvider.$$$reportNull$$$0(3);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        YAMLScalar yamlScalar = (YAMLScalar)element;
        if (yamlScalar.isMultiline()) {
            if (PsiReference.EMPTY_ARRAY == null) {
                SpringBootApplicationYamlValueReferenceProvider.$$$reportNull$$$0(4);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Object[] placeholderReferences = ConfigPlaceholderReference.createPlaceholderReferences((PsiElement)element, SpringBootPlaceholderReference::new);
        Object[] references = yamlKeyValue.getReferences();
        MetaConfigKeyReference keyReference = (MetaConfigKeyReference)ContainerUtil.findInstance((Object[])references, MetaConfigKeyReference.class);
        MetaConfigKey metaConfigKey = key = keyReference != null ? keyReference.getResolvedKey() : null;
        if (key == null) {
            if (placeholderReferences == null) {
                SpringBootApplicationYamlValueReferenceProvider.$$$reportNull$$$0(5);
            }
            return placeholderReferences;
        }
        List<TextRange> valueTextRanges = SpringBootApplicationYamlValueReferenceProvider.canHaveMultipleValues(yamlKeyValue.getValue(), key) ? MicroservicesConfigUtils.getListValueRanges((PsiElement)element) : Collections.singletonList(ElementManipulators.getValueTextRange((PsiElement)element));
        List<Couple<String>> replacementTokens = SpringBootApplicationYamlValueReferenceProvider.getReplacementTokens(element);
        String elementText = element.getText();
        SmartList rangesWithoutReplacementTokens = new SmartList();
        for (TextRange range : valueTextRanges) {
            String rangeText = range.substring(elementText);
            boolean isRangeWithoutReplacementTokens = true;
            for (Couple<String> tokens : replacementTokens) {
                String prefix = (String)tokens.first;
                String suffix = (String)tokens.second;
                if (!StringUtil.contains((CharSequence)rangeText, (CharSequence)prefix) || !StringUtil.contains((CharSequence)rangeText, (CharSequence)suffix)) continue;
                Set ranges = PlaceholderTextRanges.getPlaceholderRanges((String)rangeText, (String)prefix, (String)suffix);
                if (!ranges.isEmpty()) {
                    isRangeWithoutReplacementTokens = false;
                }
                for (TextRange textRange : ranges) {
                    PsiReference tokenReference = SpringBootReplacementTokenResolver.createReference((PsiElement)element, (TextRange)textRange.shiftRight(range.getStartOffset()));
                    placeholderReferences = (PsiReference[])ArrayUtil.append((Object[])placeholderReferences, (Object)tokenReference);
                }
            }
            if (!isRangeWithoutReplacementTokens) continue;
            rangesWithoutReplacementTokens.add(range);
        }
        if (key.isAccessType(MetaConfigKey.AccessType.MAP_GROUP) && ContainerUtil.findInstance((Object[])references, ConfigKeyPathReference.class) == null) {
            if (placeholderReferences == null) {
                SpringBootApplicationYamlValueReferenceProvider.$$$reportNull$$$0(6);
            }
            return placeholderReferences;
        }
        if (!key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            context.put(SpringBootHintReferencesProvider.HINT_REFERENCES_CONFIG_KEY_TEXT, (Object)ConfigYamlUtils.getQualifiedConfigKeyName((YAMLKeyValue)yamlKeyValue));
        }
        context.put(NumberHintReferenceBase.NUMBER_VALUE_SANITIZER_KEY, (Object)ConfigYamlUtils.getYamlNumberValueSanitizer());
        Object[] providerReferences = SpringBootHintReferencesProvider.getInstance().getValueReferences(module, key, (PsiElement)yamlKeyValue, element, (List)rangesWithoutReplacementTokens, context);
        for (int i = 0; i < providerReferences.length; ++i) {
            PsiReference reference = providerReferences[i];
            if (!(reference instanceof BooleanHintReference) || !SpringBootLibraryUtil.isAtLeastVersion((Module)module, (SpringBootLibraryUtil.SpringBootVersion)SpringBootLibraryUtil.SpringBootVersion.VERSION_2_2_0)) continue;
            providerReferences[i] = new BooleanHintReference(reference.getElement(), reference.getRangeInElement(), new String[]{"on", "off"});
        }
        PsiReference[] psiReferenceArray = (PsiReference[])ArrayUtil.mergeArrays((Object[])providerReferences, (Object[])placeholderReferences);
        if (psiReferenceArray == null) {
            SpringBootApplicationYamlValueReferenceProvider.$$$reportNull$$$0(7);
        }
        return psiReferenceArray;
    }

    private static boolean canHaveMultipleValues(YAMLValue valueElement, MetaConfigKey key) {
        if (valueElement instanceof YAMLSequence) {
            return false;
        }
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.NORMAL})) {
            return false;
        }
        if (key.isAccessType(new MetaConfigKey.AccessType[]{MetaConfigKey.AccessType.INDEXED})) {
            return true;
        }
        PsiType mapValueType = key.getEffectiveValueType();
        if (mapValueType == null) {
            return false;
        }
        MetaConfigKey.AccessType mapValueAccessType = MetaConfigKey.AccessType.forPsiType((PsiType)mapValueType);
        return mapValueAccessType == MetaConfigKey.AccessType.INDEXED;
    }

    static List<Couple<String>> getReplacementTokens(PsiElement element) {
        InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        SpringBootApplicationYamlInspection tool = (SpringBootApplicationYamlInspection)profile.getUnwrappedTool(INSPECTION_KEY, element);
        return tool == null ? Collections.emptyList() : tool.getReplacementTokens();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlValueReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/boot/application/yaml/SpringBootApplicationYamlValueReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

