/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.application.yaml;

import com.intellij.lexer.Lexer;
import com.intellij.microservices.jvm.config.MetaConfigKeyManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.spring.boot.application.metadata.RelaxedNamesConfigKeyNameBinder;
import com.intellij.spring.boot.application.yaml.SpringBootYamlImportsKt;
import com.intellij.spring.boot.application.yaml.SpringBootYamlScanner;
import com.intellij.spring.boot.index.ConfigImport;
import com.intellij.spring.boot.index.ConfigImportKeyDescriptor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.KeyDescriptor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.lexer.YAMLFlexLexer;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00040\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u0016J\u001e\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00142\u0006\u0010\u0015\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/spring/boot/application/yaml/SpringBootYamlImportsIndex;", "Lcom/intellij/util/indexing/ScalarIndexExtension;", "Lcom/intellij/spring/boot/index/ConfigImport;", "Lcom/intellij/util/indexing/DataIndexer;", "Ljava/lang/Void;", "Lcom/intellij/util/indexing/FileContent;", "<init>", "()V", "getName", "Lcom/intellij/util/indexing/ID;", "dependsOnFileContent", "", "getVersion", "", "getInputFilter", "Lcom/intellij/util/indexing/FileBasedIndex$InputFilter;", "getKeyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "getIndexer", "map", "", "inputData", "hasSpringYamlKeys", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "ifSpringKey", "lexer", "Lcom/intellij/lexer/Lexer;", "intellij.spring.boot.configYaml"})
public final class SpringBootYamlImportsIndex
extends ScalarIndexExtension<ConfigImport>
implements DataIndexer<ConfigImport, Void, FileContent> {
    @NotNull
    public ID<ConfigImport, Void> getName() {
        return SpringBootYamlImportsKt.YAML_IMPORTS_INDEX_KEY;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileType[] fileTypeArray = new FileType[]{YAMLFileType.YML};
        return (FileBasedIndex.InputFilter)new DefaultFileTypeSpecificInputFilter(fileTypeArray);
    }

    @NotNull
    public KeyDescriptor<ConfigImport> getKeyDescriptor() {
        return (KeyDescriptor)ConfigImportKeyDescriptor.INSTANCE;
    }

    @NotNull
    public DataIndexer<ConfigImport, Void, FileContent> getIndexer() {
        return this;
    }

    @NotNull
    public Map<ConfigImport, Void> map(@NotNull FileContent inputData) {
        Intrinsics.checkNotNullParameter((Object)inputData, (String)"inputData");
        VirtualFile virtualFile = inputData.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        if (!this.hasSpringYamlKeys(virtualFile)) {
            return MapsKt.emptyMap();
        }
        PsiFile psiFile = inputData.getPsiFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getPsiFile(...)");
        PsiFile psiFile2 = psiFile;
        List<Pair<String, Integer>> pairs = new SpringBootYamlScanner((MetaConfigKeyManager.ConfigKeyNameBinder)new RelaxedNamesConfigKeyNameBinder(), true).collectImports(psiFile2);
        if (pairs.isEmpty()) {
            return MapsKt.emptyMap();
        }
        Map map = new LinkedHashMap();
        for (Pair<String, Integer> it : pairs) {
            Map map2 = map;
            Object object = it.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
            String string = (String)object;
            Object object2 = it.second;
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"second");
            ConfigImport configImport = new ConfigImport(string, ((Number)object2).intValue());
            Object v = null;
            map2.put(configImport, v);
        }
        return map;
    }

    private final boolean hasSpringYamlKeys(VirtualFile file) {
        if (!(file.getFileType() instanceof YAMLFileType)) {
            return false;
        }
        YAMLFlexLexer lexer = new YAMLFlexLexer();
        lexer.start(LoadTextUtil.loadText((VirtualFile)file, (int)10240));
        while (lexer.getTokenStart() < lexer.getBufferEnd()) {
            if (this.ifSpringKey((Lexer)lexer)) {
                return true;
            }
            lexer.advance();
        }
        return false;
    }

    private final boolean ifSpringKey(Lexer lexer) {
        return Intrinsics.areEqual((Object)YAMLTokenTypes.SCALAR_KEY, (Object)lexer.getTokenType()) && StringUtil.equals((CharSequence)lexer.getTokenSequence(), (CharSequence)"spring");
    }
}

