/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.inspection.fix;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModChooseAction;
import com.intellij.modcommand.ModCommand;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModCommandQuickFix;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.PackageCheckerBundle;
import com.intellij.packageChecker.fus.PackageCheckerUsageStat;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.Vulnerability;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/packageChecker/inspection/fix/ShowVulnerabilityInfoFix;", "Lcom/intellij/modcommand/ModCommandQuickFix;", "vulnerabilities", "", "Lcom/intellij/packageChecker/model/Vulnerability;", "pkg", "Lcom/intellij/packageChecker/model/Package;", "<init>", "(Ljava/util/Collection;Lcom/intellij/packageChecker/model/Package;)V", "perform", "Lcom/intellij/modcommand/ModCommand;", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "OpenUrl", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nShowVulnerabilityInfoFix.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShowVulnerabilityInfoFix.kt\ncom/intellij/packageChecker/inspection/fix/ShowVulnerabilityInfoFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,51:1\n1080#2:52\n1586#2:53\n1661#2,3:54\n1#3:57\n*S KotlinDebug\n*F\n+ 1 ShowVulnerabilityInfoFix.kt\ncom/intellij/packageChecker/inspection/fix/ShowVulnerabilityInfoFix\n*L\n22#1:52\n23#1:53\n23#1:54,3\n*E\n"})
public final class ShowVulnerabilityInfoFix
extends ModCommandQuickFix {
    @NotNull
    private final Collection<Vulnerability> vulnerabilities;
    @Nullable
    private final Package pkg;

    public ShowVulnerabilityInfoFix(@NotNull Collection<Vulnerability> vulnerabilities, @Nullable Package pkg) {
        Intrinsics.checkNotNullParameter(vulnerabilities, (String)"vulnerabilities");
        this.vulnerabilities = vulnerabilities;
        this.pkg = pkg;
    }

    public /* synthetic */ ShowVulnerabilityInfoFix(Collection collection, Package package_, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            package_ = null;
        }
        this(collection, package_);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ModCommand perform(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Object object;
        List list;
        block4: {
            block3: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable $this$sortedByDescending$iv;
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                Iterable iterable = this.vulnerabilities;
                boolean $i$f$sortedByDescending = false;
                $this$sortedByDescending$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Vulnerability it = (Vulnerability)b;
                        boolean bl = false;
                        Comparable comparable = Float.valueOf(it.getCvssScore());
                        it = (Vulnerability)a;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Float.valueOf(it.getCvssScore()));
                    }
                });
                boolean $i$f$map = false;
                void var6_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Vulnerability vulnerability = (Vulnerability)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new OpenUrl((Vulnerability)it));
                }
                list = (List)destination$iv$iv;
                object = this.pkg;
                if (object == null) break block3;
                Package it = object;
                boolean bl = false;
                Object[] objectArray = new Object[]{this.pkg.getHumanReadableCoordinates()};
                String string = PackageCheckerBundle.message("show.info.quickfix.title", objectArray);
                object = string;
                if (string != null) break block4;
            }
            String string = PackageCheckerBundle.message("show.info.quickfix.title.without.package", new Object[0]);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        Object chooserTitle = object;
        return (ModCommand)new ModChooseAction((String)chooserTitle, list);
    }

    @NotNull
    public String getFamilyName() {
        String string = PackageCheckerBundle.message("show.info.quickfix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/packageChecker/inspection/fix/ShowVulnerabilityInfoFix$OpenUrl;", "Lcom/intellij/modcommand/ModCommandAction;", "vulnerability", "Lcom/intellij/packageChecker/model/Vulnerability;", "<init>", "(Lcom/intellij/packageChecker/model/Vulnerability;)V", "getVulnerability", "()Lcom/intellij/packageChecker/model/Vulnerability;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "perform", "Lcom/intellij/modcommand/ModCommand;", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "intellij.packageChecker"})
    private static final class OpenUrl
    implements ModCommandAction {
        @NotNull
        private final Vulnerability vulnerability;

        public OpenUrl(@NotNull Vulnerability vulnerability) {
            Intrinsics.checkNotNullParameter((Object)vulnerability, (String)"vulnerability");
            this.vulnerability = vulnerability;
        }

        @NotNull
        public final Vulnerability getVulnerability() {
            return this.vulnerability;
        }

        @NotNull
        public Presentation getPresentation(@NotNull ActionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Object[] objectArray = new Object[]{this.vulnerability.getCve(), StringsKt.take((String)this.vulnerability.getTitle(), (int)145)};
            String string = PackageCheckerBundle.message("vulnerability.popup.step.text", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String name = string;
            return new Presentation(name, PriorityAction.Priority.NORMAL, CollectionsKt.emptyList(), AllIcons.Ide.External_link_arrow, null);
        }

        @NotNull
        public ModCommand perform(@NotNull ActionContext context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (!IntentionPreviewUtils.isIntentionPreviewActive()) {
                PackageCheckerUsageStat.INSTANCE.getNavigateInfo().log(context.project());
            }
            ModCommand modCommand = ModCommand.openUrl((String)this.vulnerability.getReference());
            Intrinsics.checkNotNullExpressionValue((Object)modCommand, (String)"openUrl(...)");
            return modCommand;
        }

        @NotNull
        public String getFamilyName() {
            String string = PackageCheckerBundle.message("show.info.quickfix", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
    }
}

