/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.java;

import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.packageChecker.java.VulnerableApiUsageProcessor;
import com.intellij.packageChecker.java.VulnerablePathHintedVisitor;
import com.intellij.packageChecker.service.VulnerableApiService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLanguagePlugin;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J-\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0017\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016H\u0003\u00a8\u0006\u0017"}, d2={"Lcom/intellij/packageChecker/java/VulnerableCodeUsagesInspection;", "Lcom/intellij/codeInspection/AbstractBaseUastLocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "buildRecursiveVisitor", "inspectionName", "", "intellij.packageChecker.java"})
public final class VulnerableCodeUsagesInspection
extends AbstractBaseUastLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)holder.getFile()));
        if (module == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Module module2 = module;
        if (!VulnerableApiService.Companion.getInstance(module2).vulnerablePathsExisted()) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        String string = this.getShortName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
        ApiUsageUastVisitor apiVisitor = new ApiUsageUastVisitor((ApiUsageProcessor)new VulnerableApiUsageProcessor(holder, module2, string));
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        UastLanguagePlugin uastLanguagePlugin = UastLanguagePlugin.Companion.byLanguage(language);
        if (uastLanguagePlugin == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        UastLanguagePlugin languagePlugin = uastLanguagePlugin;
        return new VulnerablePathHintedVisitor(languagePlugin, (AbstractUastNonRecursiveVisitor)apiVisitor, module2, true);
    }

    @TestOnly
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemDescriptor[] problemDescriptorArray;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ProblemsHolder holder = new ProblemsHolder(manager, file, isOnTheFly);
            String string = this.getShortName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getShortName(...)");
            PsiElementVisitor psiElementVisitor = this.buildRecursiveVisitor(holder, string);
            if (psiElementVisitor == null) {
                return ProblemDescriptor.EMPTY_ARRAY;
            }
            PsiElementVisitor recursiveVisitor2 = psiElementVisitor;
            file.accept(recursiveVisitor2);
            List list = holder.getResults();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getResults(...)");
            problemDescriptorArray = (ProblemDescriptor[])UtilKt.toArray((Collection)list, (Object[])new ProblemDescriptor[0]);
        } else {
            problemDescriptorArray = super.checkFile(file, manager, isOnTheFly);
        }
        return problemDescriptorArray;
    }

    @TestOnly
    private final PsiElementVisitor buildRecursiveVisitor(ProblemsHolder holder, String inspectionName) {
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)holder.getFile()));
        if (module == null) {
            return null;
        }
        Module module2 = module;
        ApiUsageUastVisitor uastApiVisitor = new ApiUsageUastVisitor((ApiUsageProcessor)new VulnerableApiUsageProcessor(holder, module2, inspectionName));
        AbstractUastVisitor recursiveVisitor2 = new AbstractUastVisitor(uastApiVisitor){
            final /* synthetic */ ApiUsageUastVisitor $uastApiVisitor;
            {
                this.$uastApiVisitor = $uastApiVisitor;
            }

            public boolean visitCallExpression(UCallExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                return this.$uastApiVisitor.visitCallExpression(expression);
            }
        };
        return new PsiElementVisitor(recursiveVisitor2){
            final /* synthetic */ AbstractUastVisitor $recursiveVisitor;
            {
                this.$recursiveVisitor = $recursiveVisitor;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                super.visitElement(element);
                UElement uElement = UastContextKt.toUElement((PsiElement)element);
                if (uElement == null) {
                    return;
                }
                UElement uElement2 = uElement;
                if (uElement2 instanceof UCallExpression) {
                    this.$recursiveVisitor.visitCallExpression((UCallExpression)uElement2);
                }
                if (uElement2 instanceof UFile) {
                    ((UFile)uElement2).accept((UastVisitor)this.$recursiveVisitor);
                }
            }
        };
    }
}

