/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.util;

import com.intellij.buildsystem.model.DeclaredDependency;
import com.intellij.buildsystem.model.unified.UnifiedDependency;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.project.dependencies.ArtifactDependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ComponentDependencies;
import com.intellij.openapi.externalSystem.model.project.dependencies.DependencyNode;
import com.intellij.openapi.externalSystem.model.project.dependencies.ProjectDependencies;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.model.Package;
import com.intellij.packageChecker.model.PackageType;
import com.intellij.packageChecker.util.PackageUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r2\u0006\u0010\t\u001a\u00020\nJ(\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00100\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J^\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00100\u000f\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u00152\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u0002H\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00172\u001a\u0010\u0018\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u0001H\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u00150\u0017J\u0014\u0010\u0019\u001a\u0004\u0018\u00010\u0007*\u00020\u001a2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/packageChecker/util/PackageUtils;", "", "<init>", "()V", "LOGGER_CATEGORY", "", "toPackage", "Lcom/intellij/packageChecker/model/Package;", "Lcom/intellij/buildsystem/model/unified/UnifiedDependency;", "project", "Lcom/intellij/openapi/project/Project;", "toModelPackageDeclaration", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "Lcom/intellij/buildsystem/model/DeclaredDependency;", "rootDependencies", "", "", "projectDependencies", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/ProjectDependencies;", "T", "rootNodes", "", "pkgMapper", "Lkotlin/Function1;", "getChildren", "createMavenPackage", "Lcom/intellij/openapi/externalSystem/model/project/dependencies/DependencyNode;", "AbstractObjectGraphIterator", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nPackageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageUtils.kt\ncom/intellij/packageChecker/util/PackageUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,121:1\n1391#2:122\n1480#2,5:123\n1266#2,4:137\n383#3,7:128\n466#3:135\n415#3:136\n*S KotlinDebug\n*F\n+ 1 PackageUtils.kt\ncom/intellij/packageChecker/util/PackageUtils\n*L\n37#1:122\n37#1:123,5\n70#1:137,4\n67#1:128,7\n70#1:135\n70#1:136\n*E\n"})
public final class PackageUtils {
    @NotNull
    public static final PackageUtils INSTANCE = new PackageUtils();
    @NotNull
    private static final String LOGGER_CATEGORY = "org.jetbrains.security.dependencies.calculator";

    private PackageUtils() {
    }

    @Nullable
    public final Package toPackage(@NotNull UnifiedDependency $this$toPackage, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$toPackage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string = $this$toPackage.getCoordinates().getArtifactId();
        if (string == null) {
            return null;
        }
        String name = string;
        String string2 = $this$toPackage.getCoordinates().getVersion();
        if (string2 == null) {
            return null;
        }
        String version = string2;
        return Package.Companion.create(project, PackageType.maven, $this$toPackage.getCoordinates().getGroupId(), name, version);
    }

    @Nullable
    public final PackageDeclaration toModelPackageDeclaration(@NotNull DeclaredDependency $this$toModelPackageDeclaration, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$toModelPackageDeclaration, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Package package_ = this.toPackage($this$toModelPackageDeclaration.getUnifiedDependency(), project);
        if (package_ == null) {
            return null;
        }
        Package pkg = package_;
        return new PackageDeclaration(pkg, $this$toModelPackageDeclaration.getPsiElement(), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Package, Set<Package>> rootDependencies(@NotNull Project project, @NotNull ProjectDependencies projectDependencies) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)projectDependencies, (String)"projectDependencies");
        List list = projectDependencies.getComponentsDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getComponentsDependencies(...)");
        Iterable iterable = list;
        PackageUtils packageUtils = this;
        boolean $i$f$flatMap = false;
        void var5_6 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ComponentDependencies it = (ComponentDependencies)element$iv$iv;
            boolean bl = false;
            List list2 = it.getCompileDependenciesGraph().getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDependencies(...)");
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return packageUtils.rootDependencies((List)destination$iv$iv, arg_0 -> PackageUtils.rootDependencies$lambda$1(project, arg_0), PackageUtils::rootDependencies$lambda$2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> Map<Package, Set<Package>> rootDependencies(@NotNull List<? extends T> rootNodes, @NotNull Function1<? super T, Package> pkgMapper, @NotNull Function1<? super T, ? extends List<? extends T>> getChildren) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map.Entry value$iv;
        Iterable<Object> child2;
        Object rootPackage;
        Intrinsics.checkNotNullParameter(rootNodes, (String)"rootNodes");
        Intrinsics.checkNotNullParameter(pkgMapper, (String)"pkgMapper");
        Intrinsics.checkNotNullParameter(getChildren, (String)"getChildren");
        Logger logger = Logger.getInstance((String)LOGGER_CATEGORY);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        Logger logger2 = logger;
        HashMap result = new HashMap();
        for (T dependency : rootNodes) {
            rootPackage = (Package)pkgMapper.invoke(dependency);
            if (rootPackage == null) {
                logger2.debug("Fail to parse package from " + dependency);
                continue;
            }
            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u00072\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"com/intellij/packageChecker/util/PackageUtils$rootDependencies$GraphIterator", "Lcom/intellij/packageChecker/util/PackageUtils$AbstractObjectGraphIterator;", "dependencies", "", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/util/List;)V", "getChildren", "", "t", "(Ljava/lang/Object;)Ljava/util/Collection;", "intellij.packageChecker"})
            public final class GraphIterator
            extends AbstractObjectGraphIterator<T> {
                final /* synthetic */ Function1<T, List<T>> $getChildren;

                public GraphIterator(Function1<? super T, ? extends List<? extends T>> $getChildren, List<? extends T> dependencies) {
                    Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
                    this.$getChildren = $getChildren;
                    super((Collection)dependencies);
                }

                public Collection<? extends T> getChildren(T t) {
                    return CollectionsKt.toMutableList((Collection)((Collection)this.$getChildren.invoke(t)));
                }
            }
            List children = SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)new GraphIterator(getChildren, (List)getChildren.invoke(dependency))));
            for (Iterable<Object> child2 : children) {
                Object object;
                void $this$getOrPut$iv;
                Package childPackage = (Package)pkgMapper.invoke((Object)child2);
                if (childPackage == null) {
                    logger2.debug("Fail to parse package from " + child2);
                    continue;
                }
                Map map2 = result;
                Package key$iv = childPackage;
                boolean $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(rootPackage);
            }
        }
        Map $this$mapValues$iv = result;
        boolean $i$f$mapValues = false;
        rootPackage = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        child2 = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            value$iv = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            Set set = (Set)it.getValue();
            map4.put(k, set);
        }
        return destination$iv$iv$iv;
    }

    @Nullable
    public final Package createMavenPackage(@NotNull DependencyNode $this$createMavenPackage, @NotNull Project project) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$createMavenPackage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Object object2 = $this$createMavenPackage;
        try {
            DependencyNode $this$createMavenPackage_u24lambda_u240 = object2;
            boolean bl = false;
            if (!($this$createMavenPackage_u24lambda_u240 instanceof ArtifactDependencyNode)) {
                return null;
            }
            String string = ((ArtifactDependencyNode)$this$createMavenPackage_u24lambda_u240).getGroup();
            String string2 = ((ArtifactDependencyNode)$this$createMavenPackage_u24lambda_u240).getModule();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getModule(...)");
            String string3 = ((ArtifactDependencyNode)$this$createMavenPackage_u24lambda_u240).getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getVersion(...)");
            object = Result.constructor-impl((Object)Package.Companion.create(project, PackageType.maven, string, string2, string3));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (Package)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    private static final Package rootDependencies$lambda$1(Project $project, DependencyNode node) {
        Intrinsics.checkNotNull((Object)node);
        return INSTANCE.createMavenPackage(node, $project);
    }

    private static final List rootDependencies$lambda$2(DependencyNode it) {
        Object object = it;
        if (object == null || (object = object.getDependencies()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010)\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\"\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00042\u0006\u0010\u000f\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0010J\n\u0010\u0011\u001a\u00020\u0012H\u0096\u0082\u0004J\u000f\u0010\u0013\u001a\u00028\u0000H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\u0014J\n\u0010\u0015\u001a\u00020\u0016H\u0096\u0080\u0004R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00018\u00008\u00000\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/packageChecker/util/PackageUtils$AbstractObjectGraphIterator;", "T", "", "dependencies", "", "<init>", "(Ljava/util/Collection;)V", "mySeenObjects", "", "myToProcess", "Ljava/util/LinkedList;", "kotlin.jvm.PlatformType", "myProcessedStructure", "", "getChildren", "t", "(Ljava/lang/Object;)Ljava/util/Collection;", "hasNext", "", "next", "()Ljava/lang/Object;", "remove", "", "intellij.packageChecker"})
    private static abstract class AbstractObjectGraphIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        @NotNull
        private final Set<T> mySeenObjects;
        @NotNull
        private final LinkedList<T> myToProcess;
        @NotNull
        private final LinkedList<Integer> myProcessedStructure;

        public AbstractObjectGraphIterator(@NotNull Collection<? extends T> dependencies) {
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Set set = Collections.newSetFromMap(new IdentityHashMap());
            Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
            this.mySeenObjects = set;
            this.myToProcess = new LinkedList<T>(dependencies);
            this.myProcessedStructure = new LinkedList();
        }

        @NotNull
        public abstract Collection<T> getChildren(T var1);

        @Override
        public boolean hasNext() {
            T t = this.myToProcess.peekFirst();
            if (t == null) {
                return false;
            }
            T dependency = t;
            if (this.mySeenObjects.contains(dependency)) {
                this.myToProcess.removeFirst();
                return this.hasNext();
            }
            return true;
        }

        @Override
        public T next() {
            T dependency = this.myToProcess.removeFirst();
            if (this.mySeenObjects.add(dependency)) {
                Collection<T> children = this.getChildren(dependency);
                this.myToProcess.addAll(children);
                this.myProcessedStructure.add(children.size());
                return dependency;
            }
            return this.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

