/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.CantRunException;
import com.intellij.execution.CommonJavaRunConfigurationParameters;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.JUnitBundle;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.JavaTestFrameworkRunnableState;
import com.intellij.execution.Location;
import com.intellij.execution.TestClassCollector;
import com.intellij.execution.configurations.CompositeParameterTargetedValue;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.junit.DisabledConditionUtil;
import com.intellij.execution.junit.JUnit3Framework;
import com.intellij.execution.junit.JUnit4Framework;
import com.intellij.execution.junit.JUnit5Framework;
import com.intellij.execution.junit.JUnit6Framework;
import com.intellij.execution.junit.JUnitConfiguration;
import com.intellij.execution.junit.JUnitExternalLibraryDescriptor;
import com.intellij.execution.junit.JUnitTestFramework;
import com.intellij.execution.junit.JUnitUtil;
import com.intellij.execution.junit.ProgressIndicatorWrapper;
import com.intellij.execution.junit.TestCategory;
import com.intellij.execution.junit.TestClass;
import com.intellij.execution.junit.TestDirectory;
import com.intellij.execution.junit.TestMethod;
import com.intellij.execution.junit.TestPackage;
import com.intellij.execution.junit.TestTags;
import com.intellij.execution.junit.TestUniqueId;
import com.intellij.execution.junit.TestsPattern;
import com.intellij.execution.junit.testDiscovery.TestBySource;
import com.intellij.execution.junit.testDiscovery.TestsByChanges;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.execution.testframework.TestSearchScope;
import com.intellij.execution.util.JavaParametersUtil;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.ide.JavaUiBundle;
import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.java.JavaBundle;
import com.intellij.junit4.JUnit4IdeaTestRunner;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ArchivedCompilationContextUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaSdkVersionUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiProvidesStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.rt.execution.junit.RepeatCount;
import com.intellij.rt.junit.JUnitStarter;
import com.intellij.spi.SPIFileType;
import com.intellij.spi.psi.SPIClassProviderReferenceElement;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathsList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DumbModeAccessType;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;

public abstract class TestObject
extends JavaTestFrameworkRunnableState<JUnitConfiguration>
implements PossiblyDumbAware {
    private static final String LAUNCHER_MODULE_NAME = "org.junit.platform.launcher";
    private static final String JUPITER_ENGINE_NAME = "org.junit.jupiter.engine";
    private static final String VINTAGE_ENGINE_NAME = "org.junit.vintage.engine";
    private static final String SUITE_ENGINE_NAME = "org.junit.platform.suite.engine";
    protected static final Logger LOG = Logger.getInstance(TestObject.class);
    @NonNls
    private static final String DEBUG_RT_PATH = "idea.junit_rt.path";
    @NlsSafe
    private static final String JUNIT_TEST_FRAMEWORK_NAME = "JUnit";
    @NonNls
    private static final String DEFAULT_RUNNER = "default";
    private static final int DEFAULT_SHUTDOWN_TIMEOUT = 600;
    private final JUnitConfiguration myConfiguration;
    protected File myListenersFile;
    private final Map<Module, JavaParameters> myAdditionalJarsForModuleFork = new HashMap<Module, JavaParameters>();
    private static final Map<String, String> RUNNER_VERSIONS = Map.of("-junit3", "3", "-junit4", "4", "-junit5", "5", "-junit6", "6");
    private static final Set<String> STANDARD_JUNIT_ENGINE_CLASSES = Set.of("org.junit.jupiter.engine.JupiterTestEngine", "org.junit.vintage.engine.VintageTestEngine", "org.junit.platform.launcher.core.SuiteTestEngine", "org.junit.platform.suite.engine.SuiteTestEngine");
    protected static final Set<String> JUPITER_RUNNERS = Set.of("-junit5", "-junit6");
    private String myRunner;
    private static final Object LOCK = ObjectUtils.sentinel((String)"JUnitRunner");

    protected TestObject(JUnitConfiguration configuration, ExecutionEnvironment environment) {
        super(environment);
        this.myConfiguration = configuration;
    }

    protected <T> void addClassesListToJavaParameters(Collection<? extends T> elements, Function<? super T, String> nameFunction, String packageName, boolean createTempFile, JavaParameters javaParameters) {
        JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
        this.addClassesListToJavaParameters(elements, nameFunction, packageName, createTempFile, javaParameters, "pattern".equals(data.TEST_OBJECT) ? data.getPatternPresentation() : "");
    }

    protected <T> void addClassesListToJavaParameters(Collection<? extends T> elements, Function<? super T, String> nameFunction, String packageName, boolean createTempFile, JavaParameters javaParameters, @NlsSafe String filters) {
        try {
            if (createTempFile) {
                this.createTempFiles(javaParameters);
            }
            TreeMap<Module, List<String>> perModule = this.forkPerModule() ? new TreeMap<Module, List<String>>((o1, o2) -> StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true)) : null;
            ArrayList<String> testNames = new ArrayList<String>();
            if (elements.isEmpty() && perModule != null) {
                for (Module module : this.collectPackageModules(packageName)) {
                    perModule.put(module, new ArrayList<String>(TestObject.composeDirectoryFilter(module)));
                }
            }
            for (Object element : elements) {
                String name = (String)nameFunction.fun(element);
                if (name == null) continue;
                PsiElement psiElement = this.retrievePsiElement(element);
                if (perModule != null && psiElement != null) {
                    Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                    if (module == null) continue;
                    this.fillForkModule(perModule, module, name);
                    continue;
                }
                testNames.add(name);
            }
            JUnitConfiguration.Data data = this.getConfiguration().getPersistentData();
            if (perModule != null) {
                for (List perModuleClasses : perModule.values()) {
                    Collections.sort(perModuleClasses);
                    testNames.addAll(perModuleClasses);
                }
            } else if ("package".equals(data.TEST_OBJECT)) {
                Collections.sort(testNames);
            }
            String category = "category".equals(data.TEST_OBJECT) ? data.getCategory() : ("tags".equals(data.TEST_OBJECT) ? data.getTags().replaceAll(" ", "") : "");
            JUnitStarter.printClassesList(testNames, (String)packageName, (String)category, (String)filters, (File)this.myTempFile);
            this.writeClassesPerModule(packageName, javaParameters, perModule, filters);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private Set<Module> collectPackageModules(String packageName) {
        TestSearchScope scope;
        PsiPackage aPackage;
        HashSet<Module> result = new HashSet<Module>();
        SourceScope sourceScope = this.getSourceScope();
        Project project = this.getConfiguration().getProject();
        if (sourceScope != null && packageName != null && JUPITER_RUNNERS.contains(this.getRunner()) && (aPackage = JavaPsiFacade.getInstance((Project)this.getConfiguration().getProject()).findPackage(packageName)) != null && (scope = this.getScope()) != null) {
            PsiDirectory[] directories;
            GlobalSearchScope configurationSearchScope = GlobalSearchScopesCore.projectTestScope((Project)project).intersectWith(sourceScope.getGlobalSearchScope());
            for (PsiDirectory directory : directories = aPackage.getDirectories(configurationSearchScope)) {
                ContainerUtil.addIfNotNull(result, (Object)ModuleUtilCore.findModuleForFile((VirtualFile)directory.getVirtualFile(), (Project)project));
            }
        }
        return result;
    }

    protected void fillForkModule(Map<Module, List<String>> perModule, Module module, String name) {
        perModule.computeIfAbsent(module, elemList -> new ArrayList()).add(name);
    }

    public Module[] getModulesToCompile() {
        SourceScope sourceScope = this.getSourceScope();
        return sourceScope != null ? sourceScope.getModulesToCompile() : Module.EMPTY_ARRAY;
    }

    @NlsActions.ActionText
    public abstract String suggestActionName();

    public abstract RefactoringElementListener getListener(PsiElement var1);

    public abstract boolean isConfiguredByElement(JUnitConfiguration var1, PsiClass var2, PsiMethod var3, PsiPackage var4, PsiDirectory var5);

    public void checkConfiguration() throws RuntimeConfigurationException {
        JavaParametersUtil.checkAlternativeJRE((CommonJavaRunConfigurationParameters)this.getConfiguration());
        ProgramParametersUtil.checkWorkingDirectoryExist((CommonProgramRunConfigurationParameters)this.getConfiguration(), (Project)this.getConfiguration().getProject(), (Module)((JavaRunConfigurationModule)this.getConfiguration().getConfigurationModule()).getModule());
    }

    @Nullable
    public SourceScope getSourceScope() {
        return SourceScope.modules((Module[])this.getConfiguration().getModules());
    }

    protected void configureRTClasspath(JavaParameters javaParameters, Module module) throws CantRunException {
        String path = System.getProperty(DEBUG_RT_PATH);
        Sdk jdk = javaParameters.getJdk();
        JavaSdkVersion jdkVersion = JavaSdkVersionUtil.getJavaSdkVersion((Sdk)jdk);
        if (jdkVersion != null && !JavaSdkUtil.isJdkAtLeast((Sdk)jdk, (JavaSdkVersion)JavaSdkVersion.JDK_1_8)) {
            throw new CantRunException(JavaBundle.message((String)"error.message.ide.does.not.support.starting.processes.using.old.java", (Object[])new Object[]{jdkVersion.getDescription()}));
        }
        javaParameters.getClassPath().addFirst(path != null ? path : TestObject.getJUnitRtPath().getAbsolutePath());
        javaParameters.getClassPath().addFirst(TestObject.getJUnitRtFile("-junit5"));
        String runner = this.getRunner();
        if (runner.equals("-junit6")) {
            javaParameters.getClassPath().addFirst(TestObject.getJUnitRtFile("-junit6"));
        }
        this.appendDownloadedDependenciesForForkedConfigurations(javaParameters, module);
    }

    private void appendDownloadedDependenciesForForkedConfigurations(JavaParameters javaParameters, Module module) {
        JavaParameters parameters;
        if (module != null && (parameters = this.myAdditionalJarsForModuleFork.get(module)) != null) {
            boolean toModulePath = parameters.getClassPath().isEmpty();
            PathsList sourcePath = toModulePath ? parameters.getModulePath() : parameters.getClassPath();
            PathsList targetPath = toModulePath ? javaParameters.getModulePath() : javaParameters.getClassPath();
            for (String dependencyPath : sourcePath.getPathList()) {
                targetPath.addFirst(dependencyPath);
            }
            ParamsGroup group = TestObject.getJigsawOptions((JavaParameters)parameters);
            if (group != null) {
                TestObject.getOrCreateJigsawOptions((JavaParameters)javaParameters).addParameters(group.getParameters());
            }
        }
    }

    public static File getJUnitRtFile(@NotNull String runner) throws CantRunException {
        Class<?> junitCurrentIdeaTestRunnerClass;
        if (runner == null) {
            TestObject.$$$reportNull$$$0(0);
        }
        String version = RUNNER_VERSIONS.getOrDefault(runner, "5");
        File junit4Rt = TestObject.getJUnitRtPath();
        if (version.equals("3") || version.equals("4")) {
            return junit4Rt;
        }
        String junitCurrentModuleName = "intellij.junit.v" + version + ".rt";
        if (junit4Rt.isDirectory()) {
            return new File(junit4Rt.getParent(), junitCurrentModuleName);
        }
        String relevantJarsRoot = ArchivedCompilationContextUtil.getArchivedCompiledClassesLocation();
        Map mapping = ArchivedCompilationContextUtil.getArchivedCompiledClassesMapping();
        if (relevantJarsRoot != null && junit4Rt.toPath().startsWith(relevantJarsRoot) && mapping != null) {
            return new File((String)mapping.get("production/" + junitCurrentModuleName));
        }
        String junitCurrentIdeaTestRunnerClassName = "com.intellij.junit" + version + ".JUnit" + version + "IdeaTestRunner";
        try {
            junitCurrentIdeaTestRunnerClass = Class.forName(junitCurrentIdeaTestRunnerClassName, false, TestObject.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new CantRunException(JUnitBundle.message("dialog.message.failed.to.resolve.junit.rt.jar.class.0.not.found", junitCurrentIdeaTestRunnerClassName), (Throwable)e);
        }
        return new File(PathUtil.getJarPathForClass(junitCurrentIdeaTestRunnerClass));
    }

    public static File getJUnitRtPath() {
        File rtJar;
        String currentPath = PathUtil.getJarPathForClass(TestObject.class);
        String currentUrl = VfsUtil.getUrlForLibraryRoot((File)new File(currentPath));
        if ("file".equals(VirtualFileManager.extractProtocol((String)currentUrl))) {
            File rtDir = new File(new File(currentPath).getParentFile(), "intellij.junit.rt");
            if (rtDir.isDirectory()) {
                return rtDir;
            }
        } else if ("jar".equals(VirtualFileManager.extractProtocol((String)currentUrl)) && (rtJar = new File(new File(new File(currentPath).getParentFile().getParentFile(), "junit_rt"), "junit-rt.jar")).isFile()) {
            return rtJar;
        }
        return new File(PathUtil.getJarPathForClass(JUnit4IdeaTestRunner.class));
    }

    protected static @Unmodifiable List<String> composeDirectoryFilter(@NotNull Module module) {
        if (module == null) {
            TestObject.$$$reportNull$$$0(1);
        }
        return ContainerUtil.map((Object[])OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutLibraries().withoutDepModules().classes().getRoots(), root -> "+" + root.getPath());
    }

    protected JavaParameters createJavaParameters() throws ExecutionException {
        String preferredRunner;
        JavaParameters javaParameters = super.createJavaParameters();
        int timeout = Registry.intValue((String)"idea.test.graceful.shutdown.timeout.seconds", (int)600);
        if (timeout != 600) {
            javaParameters.getVMParametersList().addProperty("idea.test.graceful.shutdown.timeout.seconds", String.valueOf(timeout));
        }
        if (javaParameters.getMainClass() == null) {
            javaParameters.setMainClass("com.intellij.rt.junit.JUnitStarter");
        }
        javaParameters.getProgramParametersList().add("-ideVersion5");
        StringBuilder buf = new StringBuilder();
        this.collectListeners(javaParameters, buf, "com.intellij.junitListener", "\n");
        if (!buf.isEmpty()) {
            try {
                this.myListenersFile = FileUtil.createTempFile((String)"junit_listeners_", (String)"", (boolean)true);
                javaParameters.getProgramParametersList().add("@@" + this.myListenersFile.getPath());
                FileUtil.writeToFile((File)this.myListenersFile, (byte[])buf.toString().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (!DEFAULT_RUNNER.equals(preferredRunner = this.getRunner())) {
            javaParameters.getProgramParametersList().add(preferredRunner);
        }
        return javaParameters;
    }

    @TestOnly
    public JavaParameters createJavaParameters4Tests() throws ExecutionException {
        JavaParameters parameters = this.createJavaParameters();
        this.downloadAdditionalDependencies(parameters);
        return parameters;
    }

    public void appendJUnitLauncherClasses(String runnerName, JavaParameters javaParameters, Project project, GlobalSearchScope globalSearchScope, boolean ensureOnModulePath) throws CantRunException {
        ParamsGroup group;
        ParametersList vmParametersList;
        boolean isModularized;
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        DumbService dumbService = DumbService.getInstance((Project)project);
        String launcherVersion = TestObject.getLibraryVersion("org.junit.platform.commons.JUnitException", globalSearchScope, project);
        if (launcherVersion == null) {
            LOG.info("Failed to detect junit " + RUNNER_VERSIONS.getOrDefault(runnerName, "5") + " launcher version, please configure explicit dependency");
            return;
        }
        boolean bl = isModularized = ensureOnModulePath && JavaSdkUtil.isJdkAtLeast((Sdk)javaParameters.getJdk(), (JavaSdkVersion)JavaSdkVersion.JDK_1_9) && (Boolean)ReadAction.nonBlocking(() -> !FilenameIndex.getVirtualFilesByName((String)"module-info.java", (GlobalSearchScope)globalSearchScope).isEmpty()).executeSynchronously() != false && VersionComparatorUtil.compare((String)launcherVersion, (String)"1.5.0") >= 0;
        if (isModularized && !(vmParametersList = (group = TestObject.getOrCreateJigsawOptions((JavaParameters)javaParameters)).getParametersList()).hasParameter(LAUNCHER_MODULE_NAME)) {
            vmParametersList.add("--add-modules");
            vmParametersList.add(LAUNCHER_MODULE_NAME);
            TestObject.ensureSpecifiedModuleOnModulePath(javaParameters, globalSearchScope, psiFacade, LAUNCHER_MODULE_NAME);
        }
        ArrayList<String> additionalDependencies = new ArrayList<String>();
        if (!JUnitUtil.hasPackageWithDirectories((JavaPsiFacade)psiFacade, (String)LAUNCHER_MODULE_NAME, (GlobalSearchScope)globalSearchScope)) {
            this.downloadDependenciesWhenRequired(project, additionalDependencies, new RepositoryLibraryProperties("org.junit.platform", "junit-platform-launcher", launcherVersion));
        }
        if (!TestObject.hasJupiterEnginesAPI(globalSearchScope, psiFacade) || !this.isCustomJUnit(globalSearchScope, "-junit6".equals(runnerName) ? "org.junit.platform.engine.CancellationToken" : "org.junit.platform.engine.TestEngine")) {
            String defaultMinVersion = "-junit6".equals(runnerName) ? JUnitExternalLibraryDescriptor.JUNIT6.getMinVersion() : JUnitExternalLibraryDescriptor.JUNIT5.getMinVersion();
            String jupiterVersion = (String)ObjectUtils.notNull((Object)TestObject.getLibraryVersion("org.junit.jupiter.api.Test", globalSearchScope, project), (Object)defaultMinVersion);
            if (JUnitUtil.hasPackageWithDirectories((JavaPsiFacade)psiFacade, (String)"org.junit.jupiter.api", (GlobalSearchScope)globalSearchScope)) {
                if (!JUnitUtil.hasPackageWithDirectories((JavaPsiFacade)psiFacade, (String)JUPITER_ENGINE_NAME, (GlobalSearchScope)globalSearchScope)) {
                    this.downloadDependenciesWhenRequired(project, additionalDependencies, new RepositoryLibraryProperties("org.junit.jupiter", "junit-jupiter-engine", jupiterVersion));
                } else if (isModularized) {
                    TestObject.ensureSpecifiedModuleOnModulePath(javaParameters, globalSearchScope, psiFacade, JUPITER_ENGINE_NAME);
                }
            }
            if (JUnitUtil.hasPackageWithDirectories((JavaPsiFacade)psiFacade, (String)"org.junit.platform.suite.api", (GlobalSearchScope)globalSearchScope)) {
                if (!JUnitUtil.hasPackageWithDirectories((JavaPsiFacade)psiFacade, (String)SUITE_ENGINE_NAME, (GlobalSearchScope)globalSearchScope)) {
                    String suiteVersion = TestObject.getLibraryVersion("org.junit.platform.suite.api.Suite", globalSearchScope, project);
                    if (suiteVersion != null && VersionComparatorUtil.compare((String)suiteVersion, (String)"1.8.0") >= 0) {
                        this.downloadDependenciesWhenRequired(project, additionalDependencies, new RepositoryLibraryProperties("org.junit.platform", "junit-platform-suite-engine", suiteVersion));
                    }
                } else if (isModularized) {
                    TestObject.ensureSpecifiedModuleOnModulePath(javaParameters, globalSearchScope, psiFacade, SUITE_ENGINE_NAME);
                }
            }
            if (!JUnitUtil.hasPackageWithDirectories((JavaPsiFacade)psiFacade, (String)VINTAGE_ENGINE_NAME, (GlobalSearchScope)globalSearchScope)) {
                PsiClass junit4RunnerClass;
                if (JUnitUtil.hasPackageWithDirectories((JavaPsiFacade)psiFacade, (String)"junit.framework", (GlobalSearchScope)globalSearchScope) && (junit4RunnerClass = (PsiClass)dumbService.computeWithAlternativeResolveEnabled(() -> (PsiClass)ReadAction.nonBlocking(() -> psiFacade.findClass("junit.runner.Version", globalSearchScope)).executeSynchronously())) != null && this.isAcceptableVintageVersion()) {
                    String version = VersionComparatorUtil.compare((String)launcherVersion, (String)"1.1.0") >= 0 ? jupiterVersion : "4.12." + StringUtil.getShortName((String)launcherVersion);
                    this.downloadDependenciesWhenRequired(project, additionalDependencies, new RepositoryLibraryProperties("org.junit.vintage", "junit-vintage-engine", version, false, ContainerUtil.emptyList()));
                }
            } else if (isModularized) {
                TestObject.ensureSpecifiedModuleOnModulePath(javaParameters, globalSearchScope, psiFacade, VINTAGE_ENGINE_NAME);
            }
        }
        PathsList targetList = isModularized ? javaParameters.getModulePath() : javaParameters.getClassPath();
        for (int i = additionalDependencies.size() - 1; i >= 0; --i) {
            targetList.addFirst((String)additionalDependencies.get(i));
        }
    }

    private static void ensureSpecifiedModuleOnModulePath(JavaParameters javaParameters, GlobalSearchScope globalSearchScope, JavaPsiFacade psiFacade, String moduleName) {
        ReadAction.run(() -> DumbModeAccessType.RELIABLE_DATA_ONLY.ignoreDumbMode(() -> {
            PsiJavaModule launcherModule = psiFacade.findModule(moduleName, globalSearchScope);
            if (launcherModule != null) {
                JavaParametersUtil.putDependenciesOnModulePath((JavaParameters)javaParameters, (PsiJavaModule)launcherModule, (boolean)true);
            }
        }));
    }

    private boolean isAcceptableVintageVersion() {
        ClassLoader loader = TestClassCollector.createUsersClassLoader((JavaTestConfigurationBase)this.myConfiguration);
        try {
            Class<?> aClass = loader.loadClass("junit.runner.Version");
            Method id = aClass.getDeclaredMethod("id", new Class[0]);
            Object result = id.invoke(null, new Object[0]);
            return result instanceof String && VersionComparatorUtil.compare((String)"4.12", (String)((String)result)) <= 0;
        }
        catch (Throwable e) {
            LOG.debug(e);
            return false;
        }
    }

    public static boolean hasJupiterEnginesAPI(GlobalSearchScope globalSearchScope, JavaPsiFacade psiFacade) {
        return JUnitUtil.hasPackageWithDirectories((JavaPsiFacade)psiFacade, (String)"org.junit.platform.engine", (GlobalSearchScope)globalSearchScope);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getLibraryVersion(String className, GlobalSearchScope globalSearchScope, Project project) {
        VirtualFile root = (VirtualFile)ReadAction.nonBlocking(() -> {
            PsiClass psiClass = (PsiClass)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> JavaPsiFacade.getInstance((Project)project).findClass(className, globalSearchScope));
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiClass);
            if (virtualFile == null) {
                return null;
            }
            return ProjectFileIndex.getInstance((Project)project).getClassRootForFile(virtualFile);
        }).executeSynchronously();
        if (root == null) return null;
        if (!(root.getFileSystem() instanceof JarFileSystem)) return null;
        VirtualFile manifestFile = root.findFileByRelativePath("META-INF/MANIFEST.MF");
        if (manifestFile == null) return null;
        try (InputStream inputStream = manifestFile.getInputStream();){
            Attributes mainAttributes = new Manifest(inputStream).getMainAttributes();
            if (!"junit.org".equals(mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR))) return null;
            String string = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private void downloadDependenciesWhenRequired(@NotNull Project project, @NotNull List<String> classPath, @NotNull RepositoryLibraryProperties properties) throws CantRunException {
        Collection<Object> roots;
        if (project == null) {
            TestObject.$$$reportNull$$$0(2);
        }
        if (classPath == null) {
            TestObject.$$$reportNull$$$0(3);
        }
        if (properties == null) {
            TestObject.$$$reportNull$$$0(4);
        }
        try {
            Application application = ApplicationManager.getApplication();
            application.assertIsNonDispatchThread();
            ThreadingAssertions.assertNoOwnReadAccess();
            TargetProgressIndicator targetProgressIndicator = this.getTargetProgressIndicator();
            if (targetProgressIndicator != null) {
                String title = JavaUiBundle.message((String)"jar.repository.manager.dialog.resolving.dependencies.title", (Object[])new Object[]{1});
                targetProgressIndicator.addSystemLine(title);
            }
            roots = JarRepositoryManager.loadDependenciesSync((Project)project, (RepositoryLibraryProperties)properties, (boolean)false, (boolean)false, null, null, (ProgressIndicator)(targetProgressIndicator != null ? new ProgressIndicatorWrapper(targetProgressIndicator) : (ProgressIndicator)ObjectUtils.notNull((Object)ProgressManager.getInstance().getProgressIndicator(), (Object)new DumbProgressIndicator())));
        }
        catch (ProcessCanceledException e) {
            roots = Collections.emptyList();
        }
        catch (Throwable e) {
            LOG.error(e);
            roots = Collections.emptyList();
        }
        if (roots.isEmpty()) {
            throw new CantRunException(JUnitBundle.message("dialog.message.failed.to.resolve.maven.id", properties.getMavenId()));
        }
        for (OrderRoot root : roots) {
            String path;
            if (root.getType() != OrderRootType.CLASSES || classPath.contains(path = PathUtil.getLocalPath((VirtualFile)root.getFile()))) continue;
            classPath.add(path);
        }
    }

    private static GlobalSearchScope getScopeForJUnit(@Nullable Module module, Project project) {
        return module != null ? GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)true) : GlobalSearchScope.allScope((Project)project);
    }

    public static GlobalSearchScope getScopeForJUnit(JUnitConfiguration configuration) {
        return TestObject.getScopeForJUnit(((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule(), configuration.getProject());
    }

    public void appendRepeatMode() throws ExecutionException {
        String repeatMode = this.getConfiguration().getRepeatMode();
        if (!"Once".equals(repeatMode)) {
            int repeatCount = this.getConfiguration().getRepeatCount();
            String countString = "N Times".equals(repeatMode) && repeatCount > 0 ? RepeatCount.getCountString((int)repeatCount) : repeatMode;
            this.getJavaParameters().getProgramParametersList().add(countString);
        }
    }

    protected boolean useModulePath() {
        return this.getConfiguration().isUseModulePath();
    }

    protected boolean isIdBasedTestTree() {
        return JUPITER_RUNNERS.contains(this.getRunner());
    }

    @NotNull
    protected String getForkMode() {
        String string = this.getConfiguration().getForkMode();
        if (string == null) {
            TestObject.$$$reportNull$$$0(5);
        }
        return string;
    }

    protected boolean isPrintAsyncStackTraceForExceptions() {
        return this.getConfiguration().isPrintAsyncStackTraceForExceptions();
    }

    public void downloadAdditionalDependencies(JavaParameters javaParameters) throws ExecutionException {
        super.downloadAdditionalDependencies(javaParameters);
        String preferredRunner = this.getRunner();
        if (JUPITER_RUNNERS.contains(preferredRunner)) {
            JUnitConfiguration configuration = this.getConfiguration();
            Project project = configuration.getProject();
            Module module = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
            ThrowableComputable downloader = () -> {
                String disabledCondition;
                this.appendJUnitLauncherClasses(preferredRunner, javaParameters, project, TestObject.getScopeForJUnit(module, project), this.useModulePath() && module != null && ReadAction.compute(() -> TestObject.findJavaModule((Module)module, (boolean)true)) != null);
                if (this.forkPerModule()) {
                    for (Module packageModule : (Set)ReadAction.compute(() -> this.collectPackageModules(configuration.getPackage()))) {
                        JavaParameters parameters = new JavaParameters();
                        ParamsGroup group = TestObject.getJigsawOptions((JavaParameters)javaParameters);
                        if (group != null) {
                            parameters.getVMParametersList().addParamsGroup(group.clone());
                        }
                        parameters.setJdk(javaParameters.getJdk());
                        this.appendJUnitLauncherClasses(preferredRunner, parameters, project, TestObject.getScopeForJUnit(packageModule, project), this.useModulePath() && packageModule != null && ReadAction.compute(() -> TestObject.findJavaModule((Module)packageModule, (boolean)true)) != null);
                        this.myAdditionalJarsForModuleFork.put(packageModule, parameters);
                    }
                }
                if ((disabledCondition = (String)ReadAction.nonBlocking(() -> {
                    if (DumbService.isDumb((Project)project)) {
                        return null;
                    }
                    return DisabledConditionUtil.getDisabledConditionValue(this.myConfiguration);
                }).executeSynchronously()) != null) {
                    javaParameters.getVMParametersList().add("-Djunit.jupiter.conditions.deactivate=" + disabledCondition);
                }
                return null;
            };
            if (ApplicationManager.getApplication().isDispatchThread()) {
                ProgressManager.getInstance().runProcessWithProgressSynchronously(downloader, JUnitBundle.message("progress.title.download.additional.dependencies", new Object[0]), true, this.getConfiguration().getProject());
            } else {
                downloader.compute();
            }
        }
    }

    public static TestObject fromString(String id, JUnitConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            TestObject.$$$reportNull$$$0(6);
        }
        if ("method".equals(id)) {
            return new TestMethod(configuration, environment);
        }
        if ("class".equals(id)) {
            return new TestClass(configuration, environment);
        }
        if ("package".equals(id)) {
            return new TestPackage(configuration, environment);
        }
        if ("directory".equals(id)) {
            return new TestDirectory(configuration, environment);
        }
        if ("category".equals(id)) {
            return new TestCategory(configuration, environment);
        }
        if ("pattern".equals(id)) {
            return new TestsPattern(configuration, environment);
        }
        if ("uniqueId".equals(id)) {
            return new TestUniqueId(configuration, environment);
        }
        if ("tags".equals(id)) {
            return new TestTags(configuration, environment);
        }
        if ("source location".equals(id)) {
            return new TestBySource(configuration, environment);
        }
        if ("changes".equals(id)) {
            return new TestsByChanges(configuration, environment);
        }
        LOG.info(JUnitBundle.message("configuration.not.specified.message", id));
        return null;
    }

    protected PsiElement retrievePsiElement(Object element) {
        if (element instanceof String) {
            String qName = (String)element;
            SourceScope scope = this.getSourceScope();
            Project project = this.getConfiguration().getProject();
            int idx = qName.indexOf(44);
            String className = idx > 0 ? qName.substring(0, idx) : qName;
            return (PsiElement)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> JavaPsiFacade.getInstance((Project)project).findClass(className, scope != null ? scope.getGlobalSearchScope() : GlobalSearchScope.projectScope((Project)project)));
        }
        if (element instanceof Location) {
            return ((Location)element).getPsiElement();
        }
        return element instanceof PsiElement ? (PsiElement)element : null;
    }

    protected void deleteTempFiles() {
        super.deleteTempFiles();
        if (this.myListenersFile != null) {
            FileUtil.delete((File)this.myListenersFile);
        }
    }

    @NotNull
    protected String getFrameworkName() {
        return JUNIT_TEST_FRAMEWORK_NAME;
    }

    @NotNull
    protected String getFrameworkId() {
        return "junit";
    }

    protected void passTempFile(ParametersList parametersList, String tempFilePath) {
        parametersList.add(new CompositeParameterTargetedValue().addLocalPart("@").addPathPart(tempFilePath));
    }

    @NotNull
    public JUnitConfiguration getConfiguration() {
        JUnitConfiguration jUnitConfiguration = this.myConfiguration;
        if (jUnitConfiguration == null) {
            TestObject.$$$reportNull$$$0(7);
        }
        return jUnitConfiguration;
    }

    protected TestSearchScope getScope() {
        return this.getConfiguration().getPersistentData().getScope();
    }

    protected void passForkMode(String forkMode, File tempFile, JavaParameters parameters) {
        parameters.getProgramParametersList().add("@@@" + forkMode + "," + tempFile.getAbsolutePath());
        if (this.getForkSocket() != null) {
            parameters.getProgramParametersList().add("-debugSocket" + this.getForkSocket().getLocalPort());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected String getRunner() {
        Object object = LOCK;
        // MONITORENTER : object
        if (this.myRunner == null) {
            this.myRunner = ApplicationManager.getApplication().isDispatchThread() ? (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> (String)ReadAction.nonBlocking(this::getRunnerInner).executeSynchronously(), JUnitBundle.message("dialog.title.preparing.test", new Object[0]), true, this.myConfiguration.getProject()) : (!ApplicationManager.getApplication().isReadAccessAllowed() ? (String)ReadAction.nonBlocking(this::getRunnerInner).executeSynchronously() : this.getRunnerInner());
        }
        String string = this.myRunner;
        // MONITOREXIT : object
        if (string != null) return string;
        TestObject.$$$reportNull$$$0(8);
        return string;
    }

    private String getRunner(@NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (scope == null) {
            TestObject.$$$reportNull$$$0(9);
        }
        if (project == null) {
            TestObject.$$$reportNull$$$0(10);
        }
        if (JUnitUtil.isJUnit6((GlobalSearchScope)scope, (Project)project) || this.isCustomJUnit(scope, "org.junit.platform.engine.CancellationToken")) {
            return "-junit6";
        }
        if (JUnitUtil.isJUnit5((GlobalSearchScope)scope, (Project)project) || this.isCustomJUnit(scope, "org.junit.platform.engine.TestEngine")) {
            return "-junit5";
        }
        return DEFAULT_RUNNER;
    }

    @RequiresBackgroundThread
    @NotNull
    private String getRunnerInner() {
        PsiClass psiClass;
        ThreadingAssertions.assertBackgroundThread();
        Project project = this.myConfiguration.getProject();
        LOG.assertTrue(!DumbService.getInstance((Project)project).isAlternativeResolveEnabled());
        GlobalSearchScope globalSearchScope = TestObject.getScopeForJUnit(this.myConfiguration);
        JUnitConfiguration.Data data = this.myConfiguration.getPersistentData();
        if ("category".equals(data.TEST_OBJECT)) {
            return "-junit4";
        }
        if ("tags".equals(data.TEST_OBJECT)) {
            String string = this.getRunner(globalSearchScope, project);
            if (string == null) {
                TestObject.$$$reportNull$$$0(11);
            }
            return string;
        }
        boolean isMethodConfiguration = "method".equals(data.TEST_OBJECT);
        boolean isClassConfiguration = "class".equals(data.TEST_OBJECT);
        PsiClass psiClass2 = psiClass = isMethodConfiguration || isClassConfiguration ? JavaExecutionUtil.findMainClass((Project)project, (String)data.getMainClassName(), (GlobalSearchScope)globalSearchScope) : null;
        if (psiClass != null) {
            Set testFrameworks = TestFrameworks.detectApplicableFrameworks((PsiClass)psiClass);
            TestFramework testFramework = (TestFramework)ContainerUtil.getFirstItem((Collection)testFrameworks);
            if (testFramework instanceof JUnit6Framework || testFrameworks.size() > 1 && ContainerUtil.find((Iterable)testFrameworks, f -> f instanceof JUnit6Framework) != null) {
                return "-junit6";
            }
            if (testFramework instanceof JUnit5Framework || testFrameworks.size() > 1 && ContainerUtil.find((Iterable)testFrameworks, f -> f instanceof JUnit5Framework) != null) {
                return "-junit5";
            }
            if (testFramework instanceof JUnit4Framework) {
                return "-junit4";
            }
            if (testFramework instanceof JUnit3Framework) {
                return isClassConfiguration ? "-junit4" : "-junit3";
            }
            if (testFramework instanceof JUnitTestFramework && !((JUnitTestFramework)testFramework).shouldRunSingleClassAsJUnit5(project, globalSearchScope)) {
                return "-junit4";
            }
        }
        if ("pattern".equals(data.TEST_OBJECT) && ContainerUtil.and(data.getPatterns(), name -> {
            PsiClass aClass = JavaExecutionUtil.findMainClass((Project)project, (String)name, (GlobalSearchScope)globalSearchScope);
            if (aClass == null) {
                return false;
            }
            TestFramework framework = TestFrameworks.detectFramework((PsiClass)aClass);
            return framework instanceof JUnit4Framework || framework instanceof JUnit3Framework;
        })) {
            return "-junit4";
        }
        String string = this.getRunner(globalSearchScope, project);
        if (string == null) {
            TestObject.$$$reportNull$$$0(12);
        }
        return string;
    }

    private boolean isCustomJUnit(GlobalSearchScope globalSearchScope, String jupiterClassName) {
        JavaPsiFacade psiFacade;
        Project project = this.myConfiguration.getProject();
        Boolean isCustomJUnitUsingPsi = (Boolean)ReadAction.nonBlocking(() -> TestObject.lambda$isCustomJUnit$20(project, globalSearchScope, psiFacade = JavaPsiFacade.getInstance((Project)project), jupiterClassName)).executeSynchronously();
        if (isCustomJUnitUsingPsi != null) {
            return isCustomJUnitUsingPsi;
        }
        return this.findCustomJupiterTestEngineUsingClassLoader(globalSearchScope, psiFacade);
    }

    private boolean findCustomJupiterTestEngineUsingClassLoader(@NotNull GlobalSearchScope globalSearchScope, @NotNull JavaPsiFacade psiFacade) {
        boolean hasPlatformEngine;
        if (globalSearchScope == null) {
            TestObject.$$$reportNull$$$0(13);
        }
        if (psiFacade == null) {
            TestObject.$$$reportNull$$$0(14);
        }
        if (!(hasPlatformEngine = ((Boolean)ReadAction.compute(() -> {
            PsiPackage aPackage = psiFacade.findPackage("org.junit.platform.engine");
            return aPackage != null && aPackage.getDirectories(globalSearchScope).length > 0;
        })).booleanValue())) {
            return false;
        }
        ClassLoader loader = TestClassCollector.createUsersClassLoader((JavaTestConfigurationBase)this.myConfiguration);
        try {
            ServiceLoader<?> serviceLoader = ServiceLoader.load(Class.forName("org.junit.platform.engine.TestEngine", false, loader), loader);
            for (Object engine : serviceLoader) {
                String engineClassName = engine.getClass().getName();
                if (!TestObject.isCustomJupiterTestEngineName(engineClassName)) continue;
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private static boolean hasCustomJupiterTestEngineUsingPsi(@NotNull GlobalSearchScope globalSearchScope, @NotNull Project project, @NotNull JavaPsiFacade psiFacade, @NotNull String jupiterClassName) {
        PsiClass testEngine;
        if (globalSearchScope == null) {
            TestObject.$$$reportNull$$$0(15);
        }
        if (project == null) {
            TestObject.$$$reportNull$$$0(16);
        }
        if (psiFacade == null) {
            TestObject.$$$reportNull$$$0(17);
        }
        if (jupiterClassName == null) {
            TestObject.$$$reportNull$$$0(18);
        }
        if ((testEngine = psiFacade.findClass(jupiterClassName, globalSearchScope)) == null) {
            return false;
        }
        Collection files = FilenameIndex.getVirtualFilesByName((String)"module-info.java", (GlobalSearchScope)globalSearchScope);
        if (!files.isEmpty() && ReferencesSearch.search((PsiElement)testEngine, (SearchScope)GlobalSearchScope.filesScope((Project)project, (Collection)files)).anyMatch(ref -> TestObject.isCustomEngineProvided(testEngine, ref))) {
            return true;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        GlobalSearchScope scope = GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)globalSearchScope, (FileType[])new FileType[]{SPIFileType.INSTANCE});
        return FilenameIndex.getVirtualFilesByName((String)jupiterClassName, (GlobalSearchScope)scope).stream().map(f -> psiManager.findFile(f)).filter(Objects::nonNull).flatMap(f -> PsiTreeUtil.findChildrenOfType((PsiElement)f, SPIClassProviderReferenceElement.class).stream()).map(r -> r.resolve()).filter(e -> e instanceof PsiClass).map(e -> (PsiClass)e).filter(c -> TestObject.isCustomJupiterTestEngineName(c.getQualifiedName())).anyMatch(c -> InheritanceUtil.isInheritorOrSelf((PsiClass)c, (PsiClass)testEngine, (boolean)true));
    }

    private static boolean isCustomEngineProvided(PsiClass testEngine, @NotNull PsiReference ref) {
        PsiProvidesStatement providesStatement;
        if (ref == null) {
            TestObject.$$$reportNull$$$0(19);
        }
        if ((providesStatement = (PsiProvidesStatement)PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), PsiProvidesStatement.class)) != null) {
            PsiJavaCodeReferenceElement interfaceReference = providesStatement.getInterfaceReference();
            PsiReferenceList implementationList = providesStatement.getImplementationList();
            return interfaceReference != null && interfaceReference.isReferenceTo((PsiElement)testEngine) && implementationList != null && implementationList.getReferenceElements().length > 0;
        }
        return false;
    }

    private static boolean isCustomJupiterTestEngineName(@Nullable String engineImplClassName) {
        return !STANDARD_JUNIT_ENGINE_CLASSES.contains(engineImplClassName);
    }

    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ Boolean lambda$isCustomJUnit$20(Project project, GlobalSearchScope globalSearchScope, JavaPsiFacade psiFacade, String jupiterClassName) throws Exception {
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        return TestObject.hasCustomJupiterTestEngineUsingPsi(globalSearchScope, project, psiFacade, jupiterClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/junit/TestObject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalSearchScope";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFacade";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jupiterClassName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/junit/TestObject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getForkMode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunner";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunnerInner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getJUnitRtFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "composeDirectoryFilter";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "downloadDependenciesWhenRequired";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRunner";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findCustomJupiterTestEngineUsingClassLoader";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "hasCustomJupiterTestEngineUsingPsi";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isCustomEngineProvided";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8, 11, 12 -> new IllegalStateException(string);
        };
    }
}

