/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.generator.nova;

import com.jetbrains.rd.generator.nova.GenerateKt;
import com.jetbrains.rd.generator.nova.GenerationSpec;
import com.jetbrains.rd.generator.nova.IGenerator;
import com.jetbrains.rd.generator.nova.Toplevel;
import com.jetbrains.rd.generator.nova.util.EnvUtilKt;
import com.jetbrains.rd.util.kli.Kli;
import com.jetbrains.rd.util.kli.Option;
import java.io.Closeable;
import java.io.File;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010 \u001a\u00020!2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\bH\u0002J\u0006\u0010#\u001a\u00020!J\u0010\u0010$\u001a\u00020%2\u0006\u0010\"\u001a\u00020\bH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0006R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0011\u0010\u001e\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0006\u00a8\u0006("}, d2={"Lcom/jetbrains/rd/generator/nova/RdGen;", "Lcom/jetbrains/rd/util/kli/Kli;", "()V", "clearOutput", "Lcom/jetbrains/rd/util/kli/Option$Flag;", "getClearOutput", "()Lcom/jetbrains/rd/util/kli/Option$Flag;", "comments", "", "getComments", "()Ljava/lang/String;", "defaultClassloader", "Ljava/lang/ClassLoader;", "description", "getDescription", "filter", "Lcom/jetbrains/rd/util/kli/Option$Valued;", "getFilter", "()Lcom/jetbrains/rd/util/kli/Option$Valued;", "generatorsFile", "getGeneratorsFile", "gradleGenerationSpecs", "", "Lcom/jetbrains/rd/generator/nova/GenerationSpec;", "getGradleGenerationSpecs", "()Ljava/util/List;", "noLineNumbersInComments", "getNoLineNumbersInComments", "packages", "getPackages", "verbose", "getVerbose", "errorAndExit", "", "msg", "run", "v", "", "ClassLoaderResource", "Companion", "rd-gen"})
@SourceDebugExtension(value={"SMAP\nRdGen.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RdGen.kt\ncom/jetbrains/rd/generator/nova/RdGen\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,127:1\n1#2:128\n37#3,2:129\n*S KotlinDebug\n*F\n+ 1 RdGen.kt\ncom/jetbrains/rd/generator/nova/RdGen\n*L\n87#1:129,2\n*E\n"})
public final class RdGen
extends Kli {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Option.Flag clearOutput = this.option_flag(Character.valueOf('x'), "clear", "Clear output folder before generation (if it is not incremental) ");
    @NotNull
    private final Option.Valued<String> packages = this.option_string(Character.valueOf('p'), "packages", "Java package names to search toplevels, delimited by ','. Example: com.jetbrains.rd.model.nova", "com,org");
    @NotNull
    private final Option.Valued<String> filter = Kli.option_string$default(this, null, "filter", "Filter generators by searching regular expression inside generator class simple name (case insensitive). Example: kotlin|csharp|cpp", null, 8, null);
    @NotNull
    private final Option.Flag verbose = this.option_flag(Character.valueOf('v'), "verbose", "Verbose output");
    @NotNull
    private final Option.Flag noLineNumbersInComments = this.option_flag(Character.valueOf('n'), "no-line-numbers", "Don't save original source line numbers in comments inside of generated files");
    @NotNull
    private final Option.Valued<String> generatorsFile = Kli.option_string$default(this, Character.valueOf('g'), "generators", "Path to the file with serialized GeneratorSpecs", null, 8, null);
    @NotNull
    private final ClassLoader defaultClassloader;
    @NotNull
    public static final String version = "1.13";

    public RdGen() {
        ClassLoader classLoader = RdGen.class.getClassLoader();
        Intrinsics.checkNotNull((Object)classLoader);
        this.defaultClassloader = classLoader;
    }

    @Override
    @NotNull
    public String getDescription() {
        return "RD Generator, v1.13. Search for inheritors of '" + Toplevel.class.getName() + "' and generate sources according generators: inheritors of '" + IGenerator.class.getName() + "'.";
    }

    @Override
    @NotNull
    public String getComments() {
        return "Generates RD Model from DSL ";
    }

    @NotNull
    public final Option.Flag getClearOutput() {
        return this.clearOutput;
    }

    @NotNull
    public final Option.Valued<String> getPackages() {
        return this.packages;
    }

    @NotNull
    public final Option.Valued<String> getFilter() {
        return this.filter;
    }

    @NotNull
    public final Option.Flag getVerbose() {
        return this.verbose;
    }

    @NotNull
    public final Option.Flag getNoLineNumbersInComments() {
        return this.noLineNumbersInComments;
    }

    @NotNull
    public final Option.Valued<String> getGeneratorsFile() {
        return this.generatorsFile;
    }

    @NotNull
    public final List<GenerationSpec> getGradleGenerationSpecs() {
        String path = (String)this.generatorsFile.getValue();
        return path == null ? CollectionsKt.emptyList() : GenerationSpec.Companion.loadFrom(new File(path));
    }

    private final void v(String msg) {
        if (this.verbose.getValue().booleanValue()) {
            System.out.println((Object)msg);
        }
    }

    private final boolean errorAndExit(String msg) {
        PrintStream printStream;
        PrintStream $this$errorAndExit_u24lambda_u240 = printStream = System.err;
        boolean bl = false;
        String string2 = msg;
        if (string2 == null) {
            string2 = this.getError();
        }
        $this$errorAndExit_u24lambda_u240.println(string2);
        $this$errorAndExit_u24lambda_u240.println();
        $this$errorAndExit_u24lambda_u240.println(this.help());
        return false;
    }

    static /* synthetic */ boolean errorAndExit$default(RdGen rdGen, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = null;
        }
        return rdGen.errorAndExit(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean run() {
        Regex regex;
        if (this.getError() != null) {
            return RdGen.errorAndExit$default(this, null, 1, null);
        }
        try {
            Regex regex2;
            String string2 = (String)this.filter.getValue();
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                regex2 = new Regex(it, RegexOption.IGNORE_CASE);
            } else {
                regex2 = null;
            }
            regex = regex2;
        }
        catch (Throwable e) {
            Object t = this.filter.getValue();
            String string3 = e.getMessage();
            if (string3 == null) {
                string3 = "no message";
            }
            return this.errorAndExit("Can't parse regex '" + t + ": " + string3 + "'");
        }
        Regex generatorFilter = regex;
        Object t = this.packages.getValue();
        Intrinsics.checkNotNull(t);
        char[] e = new char[]{',', ' ', ':', ';'};
        Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((CharSequence)t), (char[])e, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] pkgPrefixes = thisCollection$iv.toArray(new String[0]);
        System.out.println((Object)"Searching for models in classloader of RdGen class (current java process classpath).");
        System.out.println((Object)"To see parameters and usages invoke `rdgen -h`");
        ClassLoaderResource resource = new ClassLoaderResource(this.defaultClassloader, null, false);
        Closeable closeable = resource;
        Throwable throwable = null;
        try {
            ClassLoaderResource classLoaderResource = (ClassLoaderResource)closeable;
            boolean bl = false;
            ClassLoader classLoader = classLoaderResource.component1();
            if (classLoader == null) {
                boolean bl2 = RdGen.errorAndExit$default(this, null, 1, null);
                return bl2;
            }
            this.v("gradleGenerationSpecs=[" + CollectionsKt.joinToString$default((Iterable)this.getGradleGenerationSpecs(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "]");
            this.v("noLineNumbersInComments=" + this.noLineNumbersInComments.getValue());
            try {
                EnvUtilKt.usingSystemProperty("rdgen.line_numbers_in_comments", String.valueOf(this.noLineNumbersInComments.getValue() == false), (Function0)new Function0<Set<? extends File>>(classLoader, pkgPrefixes, this, generatorFilter){
                    final /* synthetic */ ClassLoader $classLoader;
                    final /* synthetic */ String[] $pkgPrefixes;
                    final /* synthetic */ RdGen this$0;
                    final /* synthetic */ Regex $generatorFilter;
                    {
                        this.$classLoader = $classLoader;
                        this.$pkgPrefixes = $pkgPrefixes;
                        this.this$0 = $receiver;
                        this.$generatorFilter = $generatorFilter;
                        super(0);
                    }

                    @NotNull
                    public final Set<File> invoke() {
                        return GenerateKt.generateRdModel(this.$classLoader, this.$pkgPrefixes, this.this$0.getVerbose().getValue(), this.$generatorFilter, this.this$0.getClearOutput().getValue(), this.this$0.getGradleGenerationSpecs());
                    }
                });
            }
            catch (Throwable e2) {
                e2.printStackTrace();
                boolean bl3 = false;
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                return bl3;
            }
            boolean bl4 = true;
            return bl4;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0007H\u00c6\u0003J+\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rd/generator/nova/RdGen$ClassLoaderResource;", "Ljava/io/Closeable;", "classLoader", "Ljava/lang/ClassLoader;", "tempDirectory", "Ljava/nio/file/Path;", "ownClassLoader", "", "(Ljava/lang/ClassLoader;Ljava/nio/file/Path;Z)V", "getClassLoader", "()Ljava/lang/ClassLoader;", "getOwnClassLoader", "()Z", "getTempDirectory", "()Ljava/nio/file/Path;", "close", "", "component1", "component2", "component3", "copy", "equals", "other", "", "hashCode", "", "toString", "", "rd-gen"})
    public static final class ClassLoaderResource
    implements Closeable {
        @Nullable
        private final ClassLoader classLoader;
        @Nullable
        private final Path tempDirectory;
        private final boolean ownClassLoader;

        public ClassLoaderResource(@Nullable ClassLoader classLoader, @Nullable Path tempDirectory, boolean ownClassLoader) {
            this.classLoader = classLoader;
            this.tempDirectory = tempDirectory;
            this.ownClassLoader = ownClassLoader;
        }

        public /* synthetic */ ClassLoaderResource(ClassLoader classLoader, Path path, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = true;
            }
            this(classLoader, path, bl);
        }

        @Nullable
        public final ClassLoader getClassLoader() {
            return this.classLoader;
        }

        @Nullable
        public final Path getTempDirectory() {
            return this.tempDirectory;
        }

        public final boolean getOwnClassLoader() {
            return this.ownClassLoader;
        }

        @Override
        public void close() {
            block1: {
                Comparable<Path> comparable;
                if (this.ownClassLoader && this.classLoader instanceof Closeable) {
                    ((Closeable)((Object)this.classLoader)).close();
                }
                if ((comparable = this.tempDirectory) == null || (comparable = comparable.toFile()) == null) break block1;
                FilesKt.deleteRecursively((File)comparable);
            }
        }

        @Nullable
        public final ClassLoader component1() {
            return this.classLoader;
        }

        @Nullable
        public final Path component2() {
            return this.tempDirectory;
        }

        public final boolean component3() {
            return this.ownClassLoader;
        }

        @NotNull
        public final ClassLoaderResource copy(@Nullable ClassLoader classLoader, @Nullable Path tempDirectory, boolean ownClassLoader) {
            return new ClassLoaderResource(classLoader, tempDirectory, ownClassLoader);
        }

        public static /* synthetic */ ClassLoaderResource copy$default(ClassLoaderResource classLoaderResource, ClassLoader classLoader, Path path, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                classLoader = classLoaderResource.classLoader;
            }
            if ((n & 2) != 0) {
                path = classLoaderResource.tempDirectory;
            }
            if ((n & 4) != 0) {
                bl = classLoaderResource.ownClassLoader;
            }
            return classLoaderResource.copy(classLoader, path, bl);
        }

        @NotNull
        public String toString() {
            return "ClassLoaderResource(classLoader=" + this.classLoader + ", tempDirectory=" + this.tempDirectory + ", ownClassLoader=" + this.ownClassLoader + ")";
        }

        public int hashCode() {
            int result = this.classLoader == null ? 0 : this.classLoader.hashCode();
            result = result * 31 + (this.tempDirectory == null ? 0 : ((Object)this.tempDirectory).hashCode());
            int n = this.ownClassLoader ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ClassLoaderResource)) {
                return false;
            }
            ClassLoaderResource classLoaderResource = (ClassLoaderResource)other;
            if (!Intrinsics.areEqual((Object)this.classLoader, (Object)classLoaderResource.classLoader)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.tempDirectory, (Object)classLoaderResource.tempDirectory)) {
                return false;
            }
            return this.ownClassLoader == classLoaderResource.ownClassLoader;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rd/generator/nova/RdGen$Companion;", "", "()V", "version", "", "rd-gen"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

