/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.fileClasses.ParsedJvmFileClassAnnotations;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.JvmStandardClassIds;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.ValueArgument;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\tH\u0007J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u0017J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001a\u001a\u00020\u0017R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/fileClasses/JvmFileClassUtil;", "", "<init>", "()V", "JVM_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_NAME_SHORT", "", "getJVM_NAME_SHORT", "()Ljava/lang/String;", "getFileClassInternalName", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "manglePartName", "facadeName", "fileName", "getFileClassInfoNoResolve", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "parseJvmNameOnFileNoResolve", "Lorg/jetbrains/kotlin/fileClasses/ParsedJvmFileClassAnnotations;", "findAnnotationEntryOnFileNoResolve", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "shortName", "getLiteralStringFromAnnotation", "annotation", "getLiteralStringEntryFromAnnotation", "Lorg/jetbrains/kotlin/psi/KtLiteralStringTemplateEntry;", "frontend.common.jvm"})
@SourceDebugExtension(value={"SMAP\nJvmFileClassUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmFileClassUtil.kt\norg/jetbrains/kotlin/fileClasses/JvmFileClassUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1#2:125\n296#3,2:126\n*S KotlinDebug\n*F\n+ 1 JvmFileClassUtil.kt\norg/jetbrains/kotlin/fileClasses/JvmFileClassUtil\n*L\n70#1:126,2\n*E\n"})
public final class JvmFileClassUtil {
    @NotNull
    public static final JvmFileClassUtil INSTANCE = new JvmFileClassUtil();
    @NotNull
    private static final FqName JVM_NAME = new FqName("kotlin.jvm.JvmName");
    @NotNull
    private static final String JVM_NAME_SHORT;

    private JvmFileClassUtil() {
    }

    @NotNull
    public final FqName getJVM_NAME() {
        return JVM_NAME;
    }

    @NotNull
    public final String getJVM_NAME_SHORT() {
        return JVM_NAME_SHORT;
    }

    @JvmStatic
    @NotNull
    public static final String getFileClassInternalName(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return JvmFileClassUtilKt.getInternalNameWithoutInnerClasses(JvmFileClassUtil.getFileClassInfoNoResolve(file).getFileClassFqName());
    }

    @JvmStatic
    @NotNull
    public static final String manglePartName(@NotNull String facadeName, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)facadeName, (String)"facadeName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return facadeName + "__" + PackagePartClassUtils.getFilePartShortName(fileName);
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getFileClassInfoNoResolve(@NotNull KtFile file) {
        JvmFileClassInfo jvmFileClassInfo;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ParsedJvmFileClassAnnotations parsedAnnotations = INSTANCE.parseJvmNameOnFileNoResolve(file);
        Object object = parsedAnnotations;
        if (object == null || (object = ((ParsedJvmFileClassAnnotations)object).getJvmPackageName()) == null) {
            object = file.getPackageFqName();
        }
        Object packageFqName = object;
        if (parsedAnnotations != null) {
            String string = parsedAnnotations.getJvmName();
            if (string == null) {
                String string2 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                string = PackagePartClassUtils.getFilePartShortName(string2);
            }
            String simpleName2 = string;
            Name name2 = Name.identifier(simpleName2);
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
            FqName facadeClassFqName = ((FqName)packageFqName).child(name2);
            if (parsedAnnotations.isMultifileClass()) {
                String string3 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
                Name name3 = Name.identifier(JvmFileClassUtil.manglePartName(simpleName2, string3));
                Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
                jvmFileClassInfo = new JvmMultifileClassPartInfo(((FqName)packageFqName).child(name3), facadeClassFqName);
            } else {
                jvmFileClassInfo = new JvmSimpleFileClassInfo(facadeClassFqName, true);
            }
        } else {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            jvmFileClassInfo = new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName((FqName)packageFqName, string), false);
        }
        return jvmFileClassInfo;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final ParsedJvmFileClassAnnotations parseJvmNameOnFileNoResolve(KtFile file) {
        jvmNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmFileClassUtil.JVM_NAME_SHORT);
        v0 /* !! */  = jvmNameAnnotation;
        if (v0 /* !! */  == null) ** GOTO lbl-1000
        p0 = v0 /* !! */ ;
        $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$1 = false;
        v1 = this.getLiteralStringFromAnnotation(p0);
        v0 /* !! */  = v1;
        if (v1 != null) {
            p0 = var5_6 /* !! */  = v0 /* !! */ ;
            $i$a$-takeIf-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmName$2 = false;
            v2 /* !! */  = Name.isValidIdentifier((String)p0) ? var5_6 /* !! */  : null;
        } else lbl-1000:
        // 2 sources

        {
            v2 /* !! */  = jvmName = null;
        }
        if ((v3 /* !! */  = (jvmPackageNameAnnotation = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JvmStandardClassIds.INSTANCE.getJVM_PACKAGE_NAME_SHORT()))) == null) ** GOTO lbl-1000
        p0 = v3 /* !! */ ;
        $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmPackageName$1 = false;
        v4 = this.getLiteralStringFromAnnotation(p0);
        v3 /* !! */  = v4;
        if (v4 != null) {
            p0 = v3 /* !! */ ;
            $i$a$-let-JvmFileClassUtil$parseJvmNameOnFileNoResolve$jvmPackageName$2 = false;
            v5 = new FqName((String)p0);
        } else lbl-1000:
        // 2 sources

        {
            v5 = jvmPackageName = null;
        }
        if (jvmName == null && jvmPackageName == null) {
            return null;
        }
        isMultifileClass = JvmFileClassUtilKt.isJvmMultifileClassFile(file);
        return new ParsedJvmFileClassAnnotations((String)jvmName, jvmPackageName, isMultifileClass);
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry findAnnotationEntryOnFileNoResolve(@NotNull KtFile file, @NotNull String shortName) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)shortName, (String)"shortName");
        Object object = file.getFileAnnotationList();
        if (object != null && (object = object.getAnnotationEntries()) != null) {
            Object v2;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
                    boolean bl = false;
                    KtConstructorCalleeExpression ktConstructorCalleeExpression = it.getCalleeExpression();
                    if (!Intrinsics.areEqual((Object)(ktConstructorCalleeExpression != null && (ktConstructorCalleeExpression = ktConstructorCalleeExpression.getConstructorReferenceExpression()) != null ? ktConstructorCalleeExpression.getReferencedName() : null), (Object)shortName)) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            ktAnnotationEntry = v2;
        } else {
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }

    @Nullable
    public final String getLiteralStringFromAnnotation(@NotNull KtAnnotationEntry annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = this.getLiteralStringEntryFromAnnotation(annotation);
        return ktLiteralStringTemplateEntry != null ? ktLiteralStringTemplateEntry.getText() : null;
    }

    @Nullable
    public final KtLiteralStringTemplateEntry getLiteralStringEntryFromAnnotation(@NotNull KtAnnotationEntry annotation) {
        ValueArgument valueArgument;
        block4: {
            block3: {
                KtExpression ktExpression;
                Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
                List list = annotation.getValueArguments();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueArguments(...)");
                valueArgument = (ValueArgument)CollectionsKt.firstOrNull((List)list);
                if (valueArgument == null) break block3;
                ValueArgument $this$getLiteralStringEntryFromAnnotation_u24lambda_u240 = valueArgument;
                boolean bl = false;
                Object object = $this$getLiteralStringEntryFromAnnotation_u24lambda_u240 instanceof KtValueArgument ? ((KtValueArgument)$this$getLiteralStringEntryFromAnnotation_u24lambda_u240).getStringTemplateExpression() : ((ktExpression = $this$getLiteralStringEntryFromAnnotation_u24lambda_u240.getArgumentExpression()) instanceof KtStringTemplateExpression ? (KtStringTemplateExpression)ktExpression : null);
                valueArgument = object;
                if (object != null) break block4;
            }
            return null;
        }
        ValueArgument stringTemplateExpression = valueArgument;
        KtStringTemplateEntry[] ktStringTemplateEntryArray = stringTemplateExpression.getEntries();
        Intrinsics.checkNotNullExpressionValue((Object)ktStringTemplateEntryArray, (String)"getEntries(...)");
        Object object = ArraysKt.singleOrNull((Object[])ktStringTemplateEntryArray);
        return object instanceof KtLiteralStringTemplateEntry ? (KtLiteralStringTemplateEntry)object : null;
    }

    static {
        String string = JVM_NAME.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        JVM_NAME_SHORT = string;
    }
}

