/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.problem;

import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.qodana.sarif.model.ArtifactLocation;
import com.jetbrains.qodana.sarif.model.Edge;
import com.jetbrains.qodana.sarif.model.Graph;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.LocationRelationship;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.Node;
import com.jetbrains.qodana.sarif.model.OriginalUriBaseIds;
import com.jetbrains.qodana.sarif.model.PhysicalLocation;
import com.jetbrains.qodana.sarif.model.Region;
import com.jetbrains.qodana.sarif.model.Result;
import com.jetbrains.qodana.sarif.model.Run;
import com.jetbrains.qodana.sarif.model.VersionControlDetails;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.problem.SarifProblem;
import org.jetbrains.qodana.problem.SarifProblemKt;
import org.jetbrains.qodana.problem.SarifTrace;
import org.jetbrains.qodana.staticAnalysis.sarif.QodanaSeverity;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifKt;
import org.jetbrains.qodana.staticAnalysis.sarif.fingerprints.CommonFingerprintsKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u0086\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001f\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\f\u0010\n\u001a\u00020\u0004*\u00020\u000bH\u0002\u001a\u0016\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0000\u001a<\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\b\u0010\u0018\u001a\u0004\u0018\u00010\u0004H\u0002\u001a*\u0010\u0019\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0004\u001a&\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00040 H\u0002\u001a \u0010!\u001a\u0004\u0018\u00010\u0004*\u00020\u00152\u0006\u0010\"\u001a\u00020#2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u001a4\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040%2\u0006\u0010&\u001a\u00020\u000e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002\u001a(\u0010)\u001a\u00020\u00042\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040+2\u0006\u0010,\u001a\u00020\r2\b\b\u0002\u0010-\u001a\u00020.H\u0002\u001aB\u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00150%0(2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u000b0(2\u0018\u00100\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150(01H\u0002\u001a*\u00102\u001a\b\u0012\u0004\u0012\u0002030(*\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0004H\u0002\u001a\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0004*\u00020\u0012H\u0007\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "buildDescription", "", "Lcom/intellij/openapi/util/NlsSafe;", "Lorg/jetbrains/qodana/problem/SarifProblem;", "useQodanaPrefix", "", "showSeverity", "buildProblemMessage", "Lcom/jetbrains/qodana/sarif/model/Result;", "findRelativeVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/project/Project;", "relativePath", "fromResultWithLocation", "run", "Lcom/jetbrains/qodana/sarif/model/Run;", "result", "location", "Lcom/jetbrains/qodana/sarif/model/Location;", "absolutePrefixToRemove", "relativePrefixToRemove", "revisionId", "getLocationWithoutPrefix", "originalUriBaseIds", "Lcom/jetbrains/qodana/sarif/model/OriginalUriBaseIds;", "resolveUriBaseId", "uriBaseId", "resolveUriBaseIdImpl", "visited", "", "stringPath", "macroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "getPrefixesToRemove", "Lkotlin/Pair;", "project", "reportResults", "", "findPrefixToRemove", "files", "", "contentRoot", "checkFilesCount", "", "getPossibleTaintAnalysisSinksResultsAndLocations", "resultsWithRelationshipsTaint", "", "buildTraces", "Lorg/jetbrains/qodana/problem/SarifTrace;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nSarifProblem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SarifProblem.kt\norg/jetbrains/qodana/problem/SarifProblemKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,355:1\n1#2:356\n1#2:371\n1#2:438\n1391#3:357\n1480#3,2:358\n1642#3,10:360\n1915#3:370\n1916#3:372\n1652#3:373\n1482#3,3:374\n777#3:377\n873#3,2:378\n777#3:380\n873#3,2:381\n1915#3:383\n742#3,9:384\n1916#3:395\n1391#3:396\n1480#3,2:397\n777#3:399\n873#3:400\n2792#3,3:401\n874#3:404\n1586#3:405\n1661#3,3:406\n1482#3,3:409\n672#3,4:412\n1807#3,3:416\n676#3,7:419\n1068#3:426\n1642#3,10:427\n1915#3:437\n1916#3:439\n1652#3:440\n37#4,2:393\n*S KotlinDebug\n*F\n+ 1 SarifProblem.kt\norg/jetbrains/qodana/problem/SarifProblemKt\n*L\n274#1:371\n335#1:438\n273#1:357\n273#1:358,2\n274#1:360,10\n274#1:370\n274#1:372\n274#1:373\n273#1:374,3\n276#1:377\n276#1:378,2\n277#1:380\n277#1:381,2\n291#1:383\n292#1:384,9\n291#1:395\n313#1:396\n313#1:397,2\n314#1:399\n314#1:400\n315#1:401,3\n314#1:404\n316#1:405\n316#1:406,3\n313#1:409,3\n321#1:412,4\n322#1:416,3\n321#1:419,7\n335#1:426\n335#1:427,10\n335#1:437\n335#1:439\n335#1:440\n292#1:393,2\n*E\n"})
public final class SarifProblemKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final String buildDescription(@NotNull SarifProblem $this$buildDescription, boolean useQodanaPrefix, boolean showSeverity) {
        String string;
        int useQodanaPrefixInt;
        Intrinsics.checkNotNullParameter((Object)$this$buildDescription, (String)"<this>");
        int n = useQodanaPrefixInt = useQodanaPrefix ? 1 : 0;
        if (showSeverity) {
            Object[] objectArray = new Object[]{$this$buildDescription.getQodanaSeverity(), useQodanaPrefixInt, $this$buildDescription.getMessage()};
            String string2 = QodanaBundle.message("qodana.problem.description.with.level", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            Object[] objectArray = new Object[]{useQodanaPrefixInt, $this$buildDescription.getMessage()};
            String string3 = QodanaBundle.message("qodana.problem.description.without.level", objectArray);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        return string;
    }

    private static final String buildProblemMessage(Result $this$buildProblemMessage) {
        Object object;
        block6: {
            block5: {
                String string;
                object = $this$buildProblemMessage.getMessage();
                if (object == null) break block5;
                Message it = object;
                boolean bl = false;
                String string2 = $this$buildProblemMessage.getMessage().getText();
                if (string2 != null) {
                    String text2 = string2;
                    boolean bl2 = false;
                    string = ProblemDescriptorUtil.unescapeTags((String)text2);
                } else {
                    string = null;
                }
                object = string;
                if (string != null) break block6;
            }
            String string = QodanaBundle.message("qodana.problem.default.message", new Object[0]);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        return object;
    }

    @Nullable
    public static final VirtualFile findRelativeVirtualFile(@NotNull Project $this$findRelativeVirtualFile, @NotNull String relativePath) {
        Intrinsics.checkNotNullParameter((Object)$this$findRelativeVirtualFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)$this$findRelativeVirtualFile);
        if (virtualFile == null || (virtualFile = virtualFile.findFileByRelativePath(relativePath)) == null) {
            String string = $this$findRelativeVirtualFile.getBasePath();
            if (string != null) {
                String it = string;
                boolean bl = false;
                String[] stringArray = new String[]{relativePath};
                virtualFile = VfsUtil.findFile((Path)Path.of(it, stringArray), (boolean)true);
            } else {
                virtualFile = null;
            }
        }
        return virtualFile;
    }

    private static final SarifProblem fromResultWithLocation(Run run2, Result result2, Location location, String absolutePrefixToRemove, String relativePrefixToRemove, String revisionId) {
        PhysicalLocation physicalLocation;
        if (result2.getBaselineState() == Result.BaselineState.ABSENT || result2.getRuleId() == null || ((physicalLocation = location.getPhysicalLocation()) != null && (physicalLocation = physicalLocation.getArtifactLocation()) != null ? physicalLocation.getUri() : null) == null) {
            return null;
        }
        OriginalUriBaseIds originalUriBaseIds = run2.getOriginalUriBaseIds();
        if (originalUriBaseIds == null) {
            originalUriBaseIds = new OriginalUriBaseIds();
        }
        OriginalUriBaseIds originalUriBaseIds2 = originalUriBaseIds;
        String string = SarifProblemKt.getLocationWithoutPrefix(location, originalUriBaseIds2, absolutePrefixToRemove, relativePrefixToRemove);
        if (string == null) {
            return null;
        }
        String fixedUri = string;
        Object object = location.getPhysicalLocation().getRegion();
        Integer n = object != null && (object = object.getStartLine()) != null ? Integer.valueOf((Integer)object - 1) : null;
        Object object2 = location.getPhysicalLocation().getRegion();
        Integer n2 = object2 != null && (object2 = object2.getStartColumn()) != null ? Integer.valueOf((Integer)object2 - 1) : null;
        Object object3 = location.getPhysicalLocation().getRegion();
        Integer n3 = object3 != null && (object3 = object3.getEndLine()) != null ? Integer.valueOf((Integer)object3 - 1) : null;
        Object object4 = location.getPhysicalLocation().getRegion();
        Integer n4 = object4 != null && (object4 = object4.getEndColumn()) != null ? Integer.valueOf((Integer)object4 - 1) : null;
        Region region = location.getPhysicalLocation().getRegion();
        Integer n5 = region != null ? region.getCharLength() : null;
        List<SarifTrace> list2 = SarifProblemKt.buildTraces(result2, originalUriBaseIds2, absolutePrefixToRemove, relativePrefixToRemove);
        String string2 = SarifProblemKt.buildProblemMessage(result2);
        QodanaSeverity qodanaSeverity = SarifKt.getQodanaSeverity(result2);
        String string3 = result2.getRuleId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getRuleId(...)");
        String string4 = string3;
        Result.BaselineState baselineState = result2.getBaselineState();
        if (baselineState == null) {
            baselineState = Result.BaselineState.NEW;
        }
        Result.BaselineState baselineState2 = baselineState;
        Region region2 = location.getPhysicalLocation().getRegion();
        String string5 = region2 != null && (region2 = region2.getSnippet()) != null ? region2.getText() : null;
        return new SarifProblem(n, n2, n3, n4, n5, fixedUri, (Collection<SarifTrace>)list2, string2, qodanaSeverity, string4, baselineState2, string5, revisionId);
    }

    private static final String getLocationWithoutPrefix(Location location, OriginalUriBaseIds originalUriBaseIds, String absolutePrefixToRemove, String relativePrefixToRemove) {
        String string;
        Object object;
        block9: {
            String uri;
            block8: {
                PhysicalLocation physicalLocation = location.getPhysicalLocation();
                String uriBaseId = physicalLocation != null && (physicalLocation = physicalLocation.getArtifactLocation()) != null ? physicalLocation.getUriBaseId() : null;
                PhysicalLocation physicalLocation2 = location.getPhysicalLocation();
                String string2 = physicalLocation2 != null && (physicalLocation2 = physicalLocation2.getArtifactLocation()) != null ? physicalLocation2.getUri() : (uri = null);
                if (uri == null) {
                    return null;
                }
                object = uriBaseId;
                if (object == null) break block8;
                String it = object;
                boolean bl = false;
                String string3 = SarifProblemKt.resolveUriBaseId(originalUriBaseIds, uriBaseId) + uri;
                object = string3;
                if (string3 != null) break block9;
            }
            object = uri;
        }
        String resolvedPath = object;
        try {
            String string4;
            Path $this$getLocationWithoutPrefix_u24lambda_u241 = Paths.get(resolvedPath, new String[0]);
            boolean bl = false;
            if ($this$getLocationWithoutPrefix_u24lambda_u241.isAbsolute()) {
                Intrinsics.checkNotNull((Object)$this$getLocationWithoutPrefix_u24lambda_u241);
                string4 = StringsKt.removePrefix((String)((Object)$this$getLocationWithoutPrefix_u24lambda_u241).toString(), (CharSequence)absolutePrefixToRemove);
            } else {
                Intrinsics.checkNotNull((Object)$this$getLocationWithoutPrefix_u24lambda_u241);
                string4 = StringsKt.removePrefix((String)((Object)$this$getLocationWithoutPrefix_u24lambda_u241).toString(), (CharSequence)relativePrefixToRemove);
            }
            string = string4;
        }
        catch (InvalidPathException invalidPathException) {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final String resolveUriBaseId(@NotNull OriginalUriBaseIds originalUriBaseIds, @NotNull String uriBaseId) {
        Intrinsics.checkNotNullParameter((Object)originalUriBaseIds, (String)"originalUriBaseIds");
        Intrinsics.checkNotNullParameter((Object)uriBaseId, (String)"uriBaseId");
        try {
            return SarifProblemKt.resolveUriBaseIdImpl(originalUriBaseIds, uriBaseId, new ArrayList());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Failed to resolve uriBaseId: " + uriBaseId, (Throwable)e);
            return "";
        }
    }

    private static final String resolveUriBaseIdImpl(OriginalUriBaseIds originalUriBaseIds, String uriBaseId, List<String> visited) {
        Object object;
        String parentUriBaseId;
        String uri;
        if (visited.contains(uriBaseId)) {
            visited.add(uriBaseId);
            throw new IllegalArgumentException("Cyclic uriBaseId resolution: " + CollectionsKt.joinToString$default((Iterable)visited, null, null, null, (int)0, null, null, (int)63, null));
        }
        visited.add(uriBaseId);
        ArtifactLocation artifactLocation = (ArtifactLocation)originalUriBaseIds.get((Object)uriBaseId);
        if (artifactLocation == null) {
            return "";
        }
        ArtifactLocation artifactLocation2 = artifactLocation;
        String string = artifactLocation2.getUri();
        if (string == null) {
            string = uri = "";
        }
        if ((parentUriBaseId = artifactLocation2.getUriBaseId()) != null) {
            String parentUri = SarifProblemKt.resolveUriBaseIdImpl(originalUriBaseIds, parentUriBaseId, visited);
            object = parentUri + uri;
        } else {
            object = uri;
        }
        String resultURI = object;
        return Intrinsics.areEqual((Object)resultURI, (Object)"") || StringsKt.endsWith$default((String)resultURI, (String)"/", (boolean)false, (int)2, null) ? resultURI : resultURI + "/";
    }

    private static final String stringPath(Location $this$stringPath, PathMacroManager macroManager, OriginalUriBaseIds originalUriBaseIds) {
        String string;
        Object object = $this$stringPath.getPhysicalLocation().getArtifactLocation();
        if (object == null || (object = object.getUri()) == null) {
            return null;
        }
        Object uriString = object;
        String uri = macroManager.expandPath((String)uriString);
        ArtifactLocation artifactLocation = $this$stringPath.getPhysicalLocation().getArtifactLocation();
        String uriBaseId = artifactLocation != null ? artifactLocation.getUriBaseId() : null;
        try {
            String string2;
            if (originalUriBaseIds == null || uriBaseId == null) {
                Path path = Paths.get(uri, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                string2 = ((Object)path).toString();
            } else {
                Path path = Paths.get(SarifProblemKt.resolveUriBaseId(originalUriBaseIds, uriBaseId) + uri, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                string2 = ((Object)path).toString();
            }
            string = string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static final Pair<String, String> getPrefixesToRemove(Project project, List<? extends Result> reportResults, OriginalUriBaseIds originalUriBaseIds) {
        void $this$filterTo$iv$iv;
        void $this$filterTo$iv$iv2;
        void $this$flatMapTo$iv$iv;
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)project);
        if (virtualFile == null) {
            return TuplesKt.to((Object)"", (Object)"");
        }
        VirtualFile projectDir = virtualFile;
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)project));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        PathMacroManager macroManager = pathMacroManager;
        Iterable $this$flatMap$iv = reportResults;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            List list2;
            Result result2 = (Result)element$iv$iv;
            boolean bl = false;
            List list3 = result2.getLocations();
            if (list3 != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = list3;
                boolean $i$f$mapNotNull = false;
                Iterable iterable2 = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    String it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv2 = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    Location it = (Location)element$iv$iv2;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (SarifProblemKt.stringPath(it, macroManager, originalUriBaseIds) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv2;
            } else {
                list2 = CollectionsKt.emptyList();
            }
            Iterable list$iv$iv = list2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List paths = (List)destination$iv$iv;
        Iterable $this$filter$iv = paths;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Iterable destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!Path.of(it, new String[0]).isAbsolute()) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        String absolutePrefixToRemove = SarifProblemKt.findPrefixToRemove$default(CollectionsKt.toSet((Iterable)((List)destination$iv$iv3)), projectDir, 0, 4, null);
        Iterable $this$filter$iv2 = paths;
        boolean $i$f$filter2 = false;
        destination$iv$iv3 = $this$filter$iv2;
        Collection destination$iv$iv4 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Path.of(it, new String[0]).isAbsolute())) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        String relativePrefixToRemove = SarifProblemKt.findPrefixToRemove$default(CollectionsKt.toSet((Iterable)((List)destination$iv$iv4)), projectDir, 0, 4, null);
        return TuplesKt.to((Object)absolutePrefixToRemove, (Object)relativePrefixToRemove);
    }

    /*
     * WARNING - void declaration
     */
    private static final String findPrefixToRemove(Set<String> files2, VirtualFile contentRoot, int checkFilesCount) {
        Comparator comparator2 = Comparator.comparingInt(findPrefixToRemove.comparator.1.INSTANCE);
        List list2 = ContainerUtil.reverse((List)ContainerUtil.sorted((Collection)files2, comparator2));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"reverse(...)");
        List sortedFiles = list2;
        Set possiblePrefixes = new LinkedHashSet();
        Iterable $this$forEach$iv = sortedFiles.subList(0, RangesKt.coerceAtMost((int)checkFilesCount, (int)sortedFiles.size()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$toTypedArray$iv;
            List list3;
            Collection $this$dropLastWhile$iv;
            String filePath = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)filePath);
            Object object = filePath;
            Regex regex = new Regex("/");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String part = (String)iterator$iv.previous();
                    boolean bl2 = false;
                    if (((CharSequence)part).length() == 0) continue;
                    list3 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list3 = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list3;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] pathParts = thisCollection$iv.toArray(new String[0]);
            Object possiblePrefix = "";
            for (String part : pathParts) {
                String relPath = StringUtil.substringAfter((String)filePath, (String)possiblePrefix);
                if (relPath != null && contentRoot.findFileByRelativePath(relPath) != null) {
                    possiblePrefixes.add(possiblePrefix);
                }
                possiblePrefix = (String)possiblePrefix + part + "/";
            }
        }
        return possiblePrefixes.size() == 1 ? (String)CollectionsKt.first((Iterable)possiblePrefixes) : "";
    }

    static /* synthetic */ String findPrefixToRemove$default(Set set, VirtualFile virtualFile, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 3;
        }
        return SarifProblemKt.findPrefixToRemove(set, virtualFile, n);
    }

    private static final List<Pair<Result, Location>> getPossibleTaintAnalysisSinksResultsAndLocations(List<? extends Result> reportResults, Map<Result, ? extends List<? extends Location>> resultsWithRelationshipsTaint) {
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)reportResults), SarifProblemKt::getPossibleTaintAnalysisSinksResultsAndLocations$lambda$0), SarifProblemKt::getPossibleTaintAnalysisSinksResultsAndLocations$lambda$1), arg_0 -> SarifProblemKt.getPossibleTaintAnalysisSinksResultsAndLocations$lambda$2(resultsWithRelationshipsTaint, arg_0)));
    }

    private static final List<SarifTrace> buildTraces(Result $this$buildTraces, OriginalUriBaseIds originalUriBaseIds, String absolutePrefixToRemove, String relativePrefixToRemove) {
        List list2;
        List $this$buildTraces_u24lambda_u240 = list2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        CommonFingerprintsKt.forEachNotNull($this$buildTraces.getGraphs(), arg_0 -> SarifProblemKt.buildTraces$lambda$0$0($this$buildTraces_u24lambda_u240, $this$buildTraces, originalUriBaseIds, absolutePrefixToRemove, relativePrefixToRemove, arg_0));
        return CollectionsKt.build((List)list2);
    }

    @VisibleForTesting
    @Nullable
    public static final String revisionId(@NotNull Run $this$revisionId) {
        Intrinsics.checkNotNullParameter((Object)$this$revisionId, (String)"<this>");
        Set set = $this$revisionId.getVersionControlProvenance();
        return set != null && (set = (VersionControlDetails)CollectionsKt.firstOrNull((Iterable)set)) != null ? set.getRevisionId() : null;
    }

    private static final boolean getPossibleTaintAnalysisSinksResultsAndLocations$lambda$0(Result it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getGraphs() != null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable getPossibleTaintAnalysisSinksResultsAndLocations$lambda$1(Result result2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Set set = result2.getGraphs();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getGraphs(...)");
        Iterable $this$flatMap$iv = set;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Node node;
            void $this$filterTo$iv$iv;
            Graph graph = (Graph)element$iv$iv;
            boolean bl = false;
            Set set2 = graph.getNodes();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"getNodes(...)");
            Iterable $this$filter$iv = set2;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                boolean bl2;
                block6: {
                    node = (Node)element$iv$iv2;
                    boolean bl3 = false;
                    Set set3 = graph.getEdges();
                    Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"getEdges(...)");
                    Iterable $this$none$iv = set3;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$none$iv) {
                            Edge it = (Edge)element$iv;
                            boolean bl4 = false;
                            if (!Intrinsics.areEqual((Object)it.getSourceNodeId(), (Object)node.getId())) continue;
                            bl2 = false;
                            break block6;
                        }
                        bl2 = true;
                    }
                }
                if (!bl2) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            $this$filter$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                node = (Node)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl5 = false;
                collection.add(TuplesKt.to((Object)result2, (Object)node));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Pair getPossibleTaintAnalysisSinksResultsAndLocations$lambda$2(Map $resultsWithRelationshipsTaint, Pair pair) {
        Pair pair2;
        Location location;
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        Result result2 = (Result)pair.component1();
        Node node = (Node)pair.component2();
        Location location2 = node.getLocation();
        if (location2 == null) {
            List list2 = (List)$resultsWithRelationshipsTaint.get(result2);
            if (list2 != null) {
                Object v6;
                block11: {
                    Iterable $this$singleOrNull$iv = list2;
                    boolean $i$f$singleOrNull = false;
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv : $this$singleOrNull$iv) {
                        boolean bl;
                        block10: {
                            Location location3 = (Location)element$iv;
                            boolean bl2 = false;
                            Set set = location3.getRelationships();
                            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getRelationships(...)");
                            Iterable $this$any$iv = set;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv) {
                                    LocationRelationship relationship = (LocationRelationship)element$iv2;
                                    boolean bl3 = false;
                                    Integer n = relationship.getTarget();
                                    String string = node.getId();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                                    int n2 = Integer.parseInt(string);
                                    if (!(n != null && n == n2)) continue;
                                    bl = true;
                                    break block10;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) continue;
                        if (found$iv) {
                            v6 = null;
                            break block11;
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    v6 = !found$iv ? null : single$iv;
                }
                location2 = v6;
            } else {
                location2 = null;
            }
        }
        Location location4 = location = location2;
        if (location4 != null) {
            Location it = location4;
            boolean bl = false;
            pair2 = TuplesKt.to((Object)result2, (Object)it);
        } else {
            pair2 = null;
        }
        return pair2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit buildTraces$lambda$0$0(List $this_buildList, Result $this_buildTraces, OriginalUriBaseIds $originalUriBaseIds, String $absolutePrefixToRemove, String $relativePrefixToRemove, Graph graph) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Set set = graph.getNodes();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getNodes(...)");
        Iterable $this$sortedBy$iv = set;
        boolean $i$f$sortedBy = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Node it = (Node)a;
                boolean bl = false;
                String string = it.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                it = (Node)b;
                Comparable comparable = StringsKt.toIntOrNull((String)string);
                bl = false;
                String string2 = it.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getId(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)StringsKt.toIntOrNull((String)string2));
            }
        });
        boolean $i$f$mapNotNull = false;
        void var9_8 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Node node = (Node)element$iv$iv;
            boolean bl2 = false;
            Integer n = node.getLocation().getPhysicalLocation().getRegion().getStartLine();
            Integer n2 = n != null ? Integer.valueOf(n - 1) : null;
            Integer n3 = node.getLocation().getPhysicalLocation().getRegion().getStartColumn();
            Integer n4 = n3 != null ? Integer.valueOf(n3 - 1) : null;
            Integer n5 = node.getLocation().getPhysicalLocation().getRegion().getCharLength();
            Location location = node.getLocation();
            Intrinsics.checkNotNullExpressionValue((Object)location, (String)"getLocation(...)");
            SarifTrace.Node it$iv$iv = new SarifTrace.Node(n2, n4, n5, SarifProblemKt.getLocationWithoutPrefix(location, $originalUriBaseIds, $absolutePrefixToRemove, $relativePrefixToRemove));
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List nodes = (List)destination$iv$iv;
        if (!((Collection)nodes).isEmpty()) {
            String string = $this_buildTraces.getMessage().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            $this_buildList.add(new SarifTrace(string, nodes));
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Pair access$getPrefixesToRemove(Project project, List reportResults, OriginalUriBaseIds originalUriBaseIds) {
        return SarifProblemKt.getPrefixesToRemove(project, reportResults, originalUriBaseIds);
    }

    public static final /* synthetic */ List access$getPossibleTaintAnalysisSinksResultsAndLocations(List reportResults, Map resultsWithRelationshipsTaint) {
        return SarifProblemKt.getPossibleTaintAnalysisSinksResultsAndLocations(reportResults, resultsWithRelationshipsTaint);
    }

    public static final /* synthetic */ SarifProblem access$fromResultWithLocation(Run run2, Result result2, Location location, String absolutePrefixToRemove, String relativePrefixToRemove, String revisionId) {
        return SarifProblemKt.fromResultWithLocation(run2, result2, location, absolutePrefixToRemove, relativePrefixToRemove, revisionId);
    }

    static {
        Logger logger = Logger.getInstance(SarifProblem.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

