/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.codeInspection.ex.EnabledInspectionsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.ContentManager;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.registry.QodanaRegistry;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.coverageData.CoverageStatisticsData;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionIncrementalContext;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaProfile;
import org.jetbrains.qodana.staticAnalysis.scopes.InspectionToolScopeExtender;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0018\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0012\u00a2\u0006\u0004\b\u0016\u0010\u0017J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014J\u0018\u0010$\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u0013H\u0002R#\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionIncrementalContext;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "project", "Lcom/intellij/openapi/project/Project;", "contentManager", "Lcom/intellij/openapi/util/NotNullLazyValue;", "Lcom/intellij/ui/content/ContentManager;", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "outputPath", "Ljava/nio/file/Path;", "profile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile;", "qodanaRunScope", "Lkotlinx/coroutines/CoroutineScope;", "coverageStatisticsData", "Lorg/jetbrains/qodana/staticAnalysis/inspections/coverageData/CoverageStatisticsData;", "scopeExtended", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/util/NotNullLazyValue;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;Ljava/nio/file/Path;Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaProfile;Lkotlinx/coroutines/CoroutineScope;Lorg/jetbrains/qodana/staticAnalysis/inspections/coverageData/CoverageStatisticsData;Ljava/util/Map;)V", "getScopeExtended", "()Ljava/util/Map;", "extenderCache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/qodana/staticAnalysis/scopes/InspectionToolScopeExtender;", "shouldSkip", "", "inspectionId", "file", "Lcom/intellij/psi/PsiFile;", "wrappers", "Lcom/intellij/codeInspection/ex/EnabledInspectionsProvider$ToolWrappers;", "isInExtendedScope", "intellij.qodana"})
public final class QodanaGlobalInspectionIncrementalContext
extends QodanaGlobalInspectionContext {
    @NotNull
    private final Map<VirtualFile, Set<String>> scopeExtended;
    @NotNull
    private final ConcurrentHashMap<String, InspectionToolScopeExtender> extenderCache;

    public QodanaGlobalInspectionIncrementalContext(@NotNull Project project, @NotNull NotNullLazyValue<? extends ContentManager> contentManager, @NotNull QodanaConfig config, @NotNull Path outputPath, @NotNull QodanaProfile profile2, @NotNull CoroutineScope qodanaRunScope, @NotNull CoverageStatisticsData coverageStatisticsData, @NotNull Map<VirtualFile, ? extends Set<String>> scopeExtended) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(contentManager, (String)"contentManager");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)profile2, (String)"profile");
        Intrinsics.checkNotNullParameter((Object)qodanaRunScope, (String)"qodanaRunScope");
        Intrinsics.checkNotNullParameter((Object)coverageStatisticsData, (String)"coverageStatisticsData");
        Intrinsics.checkNotNullParameter(scopeExtended, (String)"scopeExtended");
        super(project, contentManager, config, outputPath, profile2, qodanaRunScope, coverageStatisticsData);
        this.scopeExtended = scopeExtended;
        this.extenderCache = new ConcurrentHashMap();
    }

    @NotNull
    public final Map<VirtualFile, Set<String>> getScopeExtended() {
        return this.scopeExtended;
    }

    @Override
    protected boolean shouldSkip(@NotNull String inspectionId, @NotNull PsiFile file2, @NotNull EnabledInspectionsProvider.ToolWrappers wrappers) {
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)wrappers, (String)"wrappers");
        VirtualFile virtualFile = file2.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return !this.isInExtendedScope(inspectionId, virtualFile) && this.getProfileState().shouldSkip(inspectionId, file2, wrappers);
    }

    private final boolean isInExtendedScope(String inspectionId, VirtualFile file2) {
        if (!QodanaRegistry.INSTANCE.isScopeExtendingEnabled()) {
            return false;
        }
        InspectionToolScopeExtender inspectionToolScopeExtender = this.extenderCache.computeIfAbsent(inspectionId, isInExtendedScope.extender.1.INSTANCE);
        if (inspectionToolScopeExtender == null) {
            return false;
        }
        InspectionToolScopeExtender extender2 = inspectionToolScopeExtender;
        Set<String> set = this.scopeExtended.get(file2);
        if (set == null) {
            return false;
        }
        Set<String> fileExtenders = set;
        return fileExtenders.contains(extender2.getName());
    }
}

