/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.kubernetes.YamlUtilKt;
import com.intellij.kubernetes.helm.chart.Chart;
import com.intellij.kubernetes.helm.chart.ChartManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.psi.YAMLFile;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0010\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0019H\u0016J\u0010\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0019H\u0002J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!H\u0002J \u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J$\u0010'\u001a\u00020\u00102\b\u0010(\u001a\u0004\u0018\u00010!2\b\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\"\u001a\u00020!H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\"\u001a\u00020!H\u0002J\u001e\u0010-\u001a\u00020\u00102\b\u0010.\u001a\u0004\u0018\u00010,2\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010!H\u0002J\u0010\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020!H\u0002J\b\u00101\u001a\u00020\u0010H\u0002J\b\u0010-\u001a\u00020\u0010H\u0002J\u000e\u00102\u001a\u0004\u0018\u00010,*\u00020!H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00063"}, d2={"Lcom/intellij/kubernetes/helm/ChartsModificationListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "Lcom/intellij/psi/PsiTreeChangeAdapter;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "chartManager", "Lcom/intellij/kubernetes/helm/chart/ChartManager;", "valuesModificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "getValuesModificationTracker", "()Lcom/intellij/openapi/util/ModificationTracker;", "fileCreated", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "beforeFileDeletion", "fileMoved", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "propertyChanged", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "childAdded", "Lcom/intellij/psi/PsiTreeChangeEvent;", "childRemoved", "childReplaced", "childMoved", "childrenChanged", "processPsiTreeChange", "removed", "parent", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "fileName", "", "isDirectory", "", "created", "oldParent", "oldName", "", "createRelatedChart", "Lcom/intellij/kubernetes/helm/chart/Chart;", "invalidateHighlighting", "relatedChart", "reparseFilesInDir", "dir", "triggerModification", "chart", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nChartsModificationListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChartsModificationListener.kt\ncom/intellij/kubernetes/helm/ChartsModificationListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,219:1\n30#2,2:220\n1#3:222\n1#3:234\n12033#4,10:223\n14060#4:233\n14061#4:235\n12043#4:236\n1915#5,2:237\n*S KotlinDebug\n*F\n+ 1 ChartsModificationListener.kt\ncom/intellij/kubernetes/helm/ChartsModificationListener\n*L\n25#1:220,2\n139#1:234\n139#1:223,10\n139#1:233\n139#1:235\n139#1:236\n139#1:237,2\n*E\n"})
public final class ChartsModificationListener
extends PsiTreeChangeAdapter
implements VirtualFileListener {
    @NotNull
    private final Project project;
    @NotNull
    private final ChartManager chartManager;
    @NotNull
    private final ModificationTracker valuesModificationTracker;

    public ChartsModificationListener(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<ChartManager> serviceClass$iv = ChartManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        this.chartManager = (ChartManager)object;
        this.valuesModificationTracker = (ModificationTracker)new SimpleModificationTracker();
        PsiManager.getInstance((Project)this.project).addPsiTreeChangeListener((PsiTreeChangeListener)this, parentDisposable);
        MessageBusConnection connection = this.project.getMessageBus().connect(parentDisposable);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        connection.subscribe(topic, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)this));
    }

    @NotNull
    public final ModificationTracker getValuesModificationTracker() {
        return this.valuesModificationTracker;
    }

    public void fileCreated(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.created(null, null, virtualFile);
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getFile().getParent();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.removed(virtualFile, virtualFile2);
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile = event.getOldParent();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getOldParent(...)");
        VirtualFile virtualFile2 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"getFile(...)");
        this.removed(virtualFile, virtualFile2);
        VirtualFile virtualFile3 = event.getOldParent();
        VirtualFile virtualFile4 = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile4, (String)"getFile(...)");
        this.created(virtualFile3, null, virtualFile4);
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Intrinsics.areEqual((Object)event.getPropertyName(), (Object)"name") || Intrinsics.areEqual((Object)event.getOldValue(), (Object)event.getNewValue())) {
            return;
        }
        VirtualFile parent = event.getFile().getParent();
        Intrinsics.checkNotNull((Object)parent);
        Object object = event.getOldValue();
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            return;
        }
        this.removed(parent, string, event.getFile().isDirectory());
        Object object2 = event.getOldValue();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
        String string2 = (String)object2;
        VirtualFile virtualFile = event.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        this.created(parent, string2, virtualFile);
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.processPsiTreeChange(event);
    }

    public void childRemoved(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.processPsiTreeChange(event);
    }

    public void childReplaced(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.processPsiTreeChange(event);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.processPsiTreeChange(event);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.processPsiTreeChange(event);
    }

    private final void processPsiTreeChange(PsiTreeChangeEvent event) {
        block1: {
            PsiFile psiFile = event.getFile();
            YAMLFile yAMLFile = psiFile instanceof YAMLFile ? (YAMLFile)psiFile : null;
            if (yAMLFile == null) {
                return;
            }
            YAMLFile file = yAMLFile;
            VirtualFile virtualFile = YamlUtilKt.getVfsFile((PsiElement)((PsiElement)file));
            if (virtualFile == null) break block1;
            VirtualFile it = virtualFile;
            boolean bl = false;
            this.invalidateHighlighting(this.createRelatedChart(it), it);
        }
    }

    private final void removed(VirtualFile parent, VirtualFile file) {
        CharSequence charSequence = file.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        CharSequence fileName = charSequence;
        boolean isDirectory = file.isDirectory();
        this.removed(parent, fileName, isDirectory);
    }

    /*
     * WARNING - void declaration
     */
    private final void removed(VirtualFile parent, CharSequence fileName, boolean isDirectory) {
        VirtualFile parentParent = parent.getParent();
        if (isDirectory) {
            Chart chart;
            VirtualFile relatedChartBaseDir = Comparing.equal((CharSequence)parent.getNameSequence(), (CharSequence)"charts") ? parentParent : (Intrinsics.areEqual((Object)fileName, (Object)"charts") ? parent : null);
            ChartsModificationListener chartsModificationListener = this;
            VirtualFile virtualFile = relatedChartBaseDir;
            if (virtualFile != null) {
                void it;
                VirtualFile virtualFile2 = virtualFile;
                ChartsModificationListener chartsModificationListener2 = chartsModificationListener;
                boolean bl = false;
                chart = this.chartManager.findChartByBaseDir((VirtualFile)it);
                chartsModificationListener = chartsModificationListener2;
            } else {
                chart = null;
            }
            ChartsModificationListener.invalidateHighlighting$default(chartsModificationListener, chart, null, 2, null);
        } else if (Chart.Companion.isChartYamlName(fileName)) {
            Object object;
            VirtualFile virtualFile = parentParent;
            if (Comparing.equal((CharSequence)(virtualFile != null ? virtualFile.getNameSequence() : null), (CharSequence)"charts")) {
                Chart chart;
                ChartsModificationListener chartsModificationListener = this;
                VirtualFile virtualFile3 = parentParent;
                if (virtualFile3 != null && (virtualFile3 = virtualFile3.getParent()) != null) {
                    VirtualFile it = virtualFile3;
                    ChartsModificationListener chartsModificationListener3 = chartsModificationListener;
                    boolean bl = false;
                    chart = this.chartManager.findChartByBaseDir(it);
                    chartsModificationListener = chartsModificationListener3;
                } else {
                    chart = null;
                }
                ChartsModificationListener.invalidateHighlighting$default(chartsModificationListener, chart, null, 2, null);
            }
            if ((object = parent.findChild("templates")) != null) {
                VirtualFile virtualFile4;
                VirtualFile it = virtualFile4 = object;
                boolean bl = false;
                object = it.isDirectory() ? virtualFile4 : null;
                if (object != null) {
                    it = object;
                    boolean bl2 = false;
                    this.reparseFilesInDir(it);
                }
            }
        } else if (Chart.Companion.isRequirementsYamlName(fileName)) {
            ChartsModificationListener.invalidateHighlighting$default(this, this.chartManager.findChartByBaseDir(parent), null, 2, null);
        } else if (Chart.Companion.isValuesYamlName(fileName)) {
            Chart relatedChart = this.chartManager.findChartByBaseDir(parent);
            if (relatedChart != null) {
                ChartsModificationListener.invalidateHighlighting$default(this, relatedChart, null, 2, null);
            } else {
                ChartsModificationListener.invalidateHighlighting$default(this, this.chartManager.findChartByNonSpecialSubDir(parent), null, 2, null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void created(VirtualFile oldParent, String oldName, VirtualFile file) {
        block16: {
            VirtualFile parent;
            block14: {
                block17: {
                    block18: {
                        block15: {
                            parent = file.getParent();
                            if (!file.isDirectory()) break block14;
                            if (!Comparing.equal((CharSequence)file.getNameSequence(), (CharSequence)"charts") && !Intrinsics.areEqual((Object)oldName, (Object)"charts")) break block15;
                            VirtualFile virtualFile = parent;
                            if (virtualFile == null) {
                                return;
                            }
                            ChartsModificationListener.invalidateHighlighting$default(this, this.chartManager.findChartByBaseDir(virtualFile), null, 2, null);
                            if (Intrinsics.areEqual((Object)oldName, (Object)"charts")) {
                                void $this$forEach$iv;
                                void $this$mapNotNullTo$iv$iv;
                                VirtualFile[] virtualFileArray = file.getChildren();
                                Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                                Object $this$mapNotNull$iv = virtualFileArray;
                                boolean $i$f$mapNotNull = false;
                                Object[] objectArray = $this$mapNotNull$iv;
                                Collection destination$iv$iv = new ArrayList();
                                boolean $i$f$mapNotNullTo = false;
                                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                                boolean $i$f$forEach = false;
                                int n = ((void)$this$forEach$iv$iv$iv).length;
                                for (int i = 0; i < n; ++i) {
                                    Chart it$iv$iv;
                                    void element$iv$iv$iv;
                                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                                    boolean bl = false;
                                    VirtualFile it = (VirtualFile)element$iv$iv;
                                    boolean bl2 = false;
                                    Intrinsics.checkNotNull((Object)it);
                                    if (this.chartManager.findChartByBaseDir(it) == null) continue;
                                    boolean bl3 = false;
                                    destination$iv$iv.add(it$iv$iv);
                                }
                                $this$mapNotNull$iv = (List)destination$iv$iv;
                                boolean $i$f$forEach2 = false;
                                for (Object element$iv : $this$forEach$iv) {
                                    Chart it = (Chart)element$iv;
                                    boolean bl = false;
                                    ChartsModificationListener.invalidateHighlighting$default(this, it, null, 2, null);
                                }
                            }
                            break block16;
                        }
                        if (!Comparing.equal((CharSequence)file.getNameSequence(), (CharSequence)"templates") && !Intrinsics.areEqual((Object)oldName, (Object)"templates")) break block17;
                        VirtualFile virtualFile = oldParent;
                        if ((virtualFile != null ? this.chart(virtualFile) : null) != null) break block18;
                        VirtualFile virtualFile2 = parent;
                        if ((virtualFile2 != null ? this.chart(virtualFile2) : null) == null) break block16;
                    }
                    this.reparseFilesInDir(file);
                    break block16;
                }
                ChartsModificationListener.invalidateHighlighting$default(this, this.chartManager.findChartByBaseDir(file), null, 2, null);
                break block16;
            }
            if (parent != null) {
                if (Comparing.equal((CharSequence)parent.getNameSequence(), (CharSequence)"templates") && oldParent != null) {
                    ApplicationManager.getApplication().invokeLater(() -> ChartsModificationListener.created$lambda$2(this, file));
                } else {
                    Chart chart = this.chartManager.findChartByBaseDir(parent);
                    if (chart == null) {
                        return;
                    }
                    Chart chart2 = chart;
                    if (Intrinsics.areEqual((Object)file, (Object)chart2.getChartFile())) {
                        ChartsModificationListener.invalidateHighlighting$default(this, chart2, null, 2, null);
                        Object object = parent.findChild("templates");
                        if (object != null) {
                            VirtualFile virtualFile;
                            VirtualFile it = virtualFile = object;
                            boolean bl = false;
                            object = it.isDirectory() ? virtualFile : null;
                            if (object != null) {
                                it = object;
                                boolean bl4 = false;
                                this.reparseFilesInDir(it);
                            }
                        }
                    } else {
                        this.invalidateHighlighting(chart2, file);
                    }
                }
            }
        }
    }

    private final Chart createRelatedChart(VirtualFile file) {
        VirtualFile parent = file.getParent();
        return file.isDirectory() ? this.chartManager.findChartByBaseDir(file) : (parent != null ? this.chartManager.findChartByBaseDir(parent) : null);
    }

    private final void invalidateHighlighting(Chart relatedChart, VirtualFile file) {
        if (relatedChart == null) {
            return;
        }
        if (file == null || relatedChart.getAvailableValuesFiles().contains(file) || Intrinsics.areEqual((Object)file, (Object)relatedChart.getRequirementsFile())) {
            this.invalidateHighlighting();
            this.triggerModification();
        } else if (Intrinsics.areEqual((Object)file, (Object)relatedChart.getChartFile())) {
            this.triggerModification();
        }
    }

    static /* synthetic */ void invalidateHighlighting$default(ChartsModificationListener chartsModificationListener, Chart chart, VirtualFile virtualFile, int n, Object object) {
        if ((n & 2) != 0) {
            virtualFile = null;
        }
        chartsModificationListener.invalidateHighlighting(chart, virtualFile);
    }

    private final void reparseFilesInDir(VirtualFile dir) {
        Object object = dir.getChildren();
        if (object == null || (object = ArraysKt.toList((Object[])object)) == null) {
            return;
        }
        Object files = object;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ChartsModificationListener.reparseFilesInDir$reparse(this, (List<? extends VirtualFile>)files);
        } else {
            ApplicationManager.getApplication().invokeLater(() -> ChartsModificationListener.reparseFilesInDir$lambda$0(this, (List)files));
        }
        this.triggerModification();
    }

    private final void triggerModification() {
        ModificationTracker modificationTracker = this.valuesModificationTracker;
        Intrinsics.checkNotNull((Object)modificationTracker, (String)"null cannot be cast to non-null type com.intellij.openapi.util.SimpleModificationTracker");
        ((SimpleModificationTracker)modificationTracker).incModificationCount();
    }

    private final void invalidateHighlighting() {
        ApplicationManager.getApplication().invokeLater(() -> ChartsModificationListener.invalidateHighlighting$lambda$0(this), this.project.getDisposed());
    }

    private final Chart chart(VirtualFile $this$chart) {
        return this.chartManager.findChartByBaseDir($this$chart);
    }

    private static final void created$lambda$2(ChartsModificationListener this$0, VirtualFile $file) {
        PsiDocumentManager.getInstance((Project)this$0.project).reparseFiles((Collection)CollectionsKt.listOf((Object)$file), true);
    }

    private static final void reparseFilesInDir$reparse(ChartsModificationListener this$0, List<? extends VirtualFile> files) {
        PsiDocumentManager.getInstance((Project)this$0.project).reparseFiles((Collection)files, true);
    }

    private static final void reparseFilesInDir$lambda$0(ChartsModificationListener this$0, List $files) {
        ChartsModificationListener.reparseFilesInDir$reparse(this$0, $files);
    }

    private static final void invalidateHighlighting$lambda$0(ChartsModificationListener this$0) {
        DaemonCodeAnalyzer.getInstance((Project)this$0.project).restart((Object)"Charts Modification");
    }
}

