/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.helm.model;

import com.intellij.kubernetes.helm.model.HelmObject;
import com.intellij.kubernetes.helm.model.HelmResolverKt;
import com.intellij.kubernetes.helm.model.PathInChart;
import com.intellij.kubernetes.helm.model.SimpleSearchableObject;
import com.intellij.kubernetes.helm.model.spec.Definition;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0014\u0010\u0014\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000bR\u0014\u0010\u001b\u001a\u00020\u000fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010\u00a8\u0006\u001f"}, d2={"Lcom/intellij/kubernetes/helm/model/PredefinedHelmDataObject;", "Lcom/intellij/kubernetes/helm/model/SimpleSearchableObject;", "name", "", "pathInChart", "Lcom/intellij/kubernetes/helm/model/PathInChart;", "schema", "Lcom/intellij/kubernetes/helm/model/spec/Definition;", "<init>", "(Ljava/lang/String;Lcom/intellij/kubernetes/helm/model/PathInChart;Lcom/intellij/kubernetes/helm/model/spec/Definition;)V", "getName", "()Ljava/lang/String;", "getPathInChart", "()Lcom/intellij/kubernetes/helm/model/PathInChart;", "isFunction", "", "()Z", "isRequired", "isDeprecated", "isOverridable", "isRenameable", "names", "", "getNames", "()Ljava/util/Set;", "description", "getDescription", "mustHaveValueDefinition", "getMustHaveValueDefinition", "findChildObject", "Lcom/intellij/kubernetes/helm/model/HelmObject;", "intellij.clouds.kubernetes.backend"})
public class PredefinedHelmDataObject
extends SimpleSearchableObject {
    @NotNull
    private final String name;
    @NotNull
    private final PathInChart pathInChart;
    @NotNull
    private final Definition schema;
    private final boolean isFunction;
    private final boolean isRequired;
    private final boolean isDeprecated;
    private final boolean isOverridable;
    private final boolean isRenameable;
    @NotNull
    private final Set<String> names;
    @Nullable
    private final String description;
    private final boolean mustHaveValueDefinition;

    public PredefinedHelmDataObject(@NotNull String name, @NotNull PathInChart pathInChart, @NotNull Definition schema) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pathInChart, (String)"pathInChart");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        super(pathInChart);
        this.name = name;
        this.pathInChart = pathInChart;
        this.schema = schema;
        this.isFunction = this.schema.isFunction();
        this.isRequired = this.schema.getRequired();
        this.isDeprecated = this.schema.getDeprecated();
        this.isOverridable = this.schema.getOverridable();
        Map<String, Definition> map2 = this.schema.getDefinitions();
        if (map2 == null || (map2 = map2.keySet()) == null) {
            map2 = SetsKt.emptySet();
        }
        this.names = map2;
        this.description = this.schema.getDescription();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final PathInChart getPathInChart() {
        return this.pathInChart;
    }

    @Override
    public boolean isFunction() {
        return this.isFunction;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Override
    public boolean isOverridable() {
        return this.isOverridable;
    }

    @Override
    public boolean isRenameable() {
        return this.isRenameable;
    }

    @Override
    @NotNull
    public Set<String> getNames() {
        return this.names;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean getMustHaveValueDefinition() {
        return this.mustHaveValueDefinition;
    }

    @Override
    @Nullable
    public HelmObject findChildObject(@NotNull String name) {
        PredefinedHelmDataObject predefinedHelmDataObject;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, Definition> map2 = this.schema.getDefinitions();
        if (map2 != null && (map2 = map2.get(name)) != null) {
            Map<String, Definition> it = map2;
            boolean bl = false;
            predefinedHelmDataObject = new PredefinedHelmDataObject(((Definition)((Object)it)).getName(), HelmResolverKt.append(this.pathInChart, ((Definition)((Object)it)).getName()), (Definition)((Object)it));
        } else {
            predefinedHelmDataObject = null;
        }
        return predefinedHelmDataObject;
    }
}

