/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs;

import com.intellij.kubernetes.logs.ILogConsistentCache;
import com.intellij.kubernetes.logs.ILogItem;
import com.intellij.kubernetes.logs.ILogSource;
import com.intellij.kubernetes.logs.ILogSubscribableConsistentCache;
import com.intellij.kubernetes.logs.IdRange;
import com.intellij.kubernetes.logs.KubernetesLogsConsistentCachesKt;
import com.intellij.kubernetes.logs.LogConsistentCache;
import com.intellij.kubernetes.logs.LogSubscribableConsistentCache;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\u0014\b\u0001\u0010\u0003*\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u0002H\u00010\u0004*\b\b\u0002\u0010\u0005*\u00020\u00062\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\u00072\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0003\u0012\u0004\u0012\u0002H\u00050\bB\u001d\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010\fH\u0016J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00010\fH\u0016J\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00010\f2\u0006\u0010\"\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010#J\u001c\u0010$\u001a\u00020\u001c2\u0012\u0010%\u001a\u000e\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00020'0&H\u0016J\b\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020)H\u0002J \u0010+\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00130\fH\u0002J\u0017\u0010,\u001a\u00020)2\f\u0010-\u001a\b\u0012\u0004\u0012\u00028\u00010.H\u0096\u0002J\u0016\u0010/\u001a\u00020)2\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0016J$\u00101\u001a\u00020)2\f\u00102\u001a\b\u0012\u0004\u0012\u00028\u00000\u00182\f\u00103\u001a\b\u0012\u0004\u0012\u00028\u00020\fH\u0002J\"\u00104\u001a\u00020)2\u0018\u00105\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u000206H\u0016J\"\u00107\u001a\u00020)2\u0018\u00108\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u000206H\u0016J\b\u00109\u001a\u00020)H\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R,\u0010\u0011\u001a \u0012\u0004\u0012\u00028\u0002\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u00130\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0012\u0004\u0012\u00028\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006:"}, d2={"Lcom/intellij/kubernetes/logs/LogConsistentContainerListFlowBasedCache;", "Id", "", "L", "Lcom/intellij/kubernetes/logs/ILogItem;", "S", "Lcom/intellij/kubernetes/logs/ILogSource;", "Lcom/intellij/kubernetes/logs/ILogConsistentCache;", "Lcom/intellij/kubernetes/logs/ILogSubscribableConsistentCache;", "project", "Lcom/intellij/openapi/project/Project;", "containers", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "containersConsistentLogs", "Ljava/util/concurrent/ConcurrentSkipListMap;", "Lcom/intellij/kubernetes/logs/LogSubscribableConsistentCache;", "rebuildChangeMutex", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "_globalConsistentCache", "consistentLogsRange", "Lcom/intellij/kubernetes/logs/IdRange;", "getConsistentLogsRange", "()Lcom/intellij/kubernetes/logs/IdRange;", "size", "", "getSize", "()I", "getSnapshot", "takeLast", "getLogsAround", "timestamp", "(Ljava/lang/Comparable;)Ljava/util/List;", "indexOfFirst", "predicate", "Lkotlin/Function1;", "", "clear", "", "initializeContainersCaches", "getActiveContainerCaches", "plusAssign", "newLogs", "", "relaxConsistentLogsRange", "newSlice", "relaxContainersTimeRange", "newTimeSlice", "containersList", "addSubscriber", "anotherCache", "Lcom/intellij/kubernetes/logs/LogConsistentCache;", "removeSubscriber", "subscriber", "unrelaxConsistentLogsRangeByLogsArrayBounderies", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesLogsConsistentCaches.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogsConsistentCaches.kt\ncom/intellij/kubernetes/logs/LogConsistentContainerListFlowBasedCache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,249:1\n1642#2,10:250\n1915#2:260\n1916#2:262\n1652#2:263\n1642#2,10:265\n1915#2:275\n1916#2:277\n1652#2:278\n1915#2,2:280\n1586#2:282\n1661#2,2:283\n1663#2:288\n1915#2,2:289\n1586#2:291\n1661#2,2:292\n1663#2:297\n1586#2:301\n1661#2,3:302\n1915#2,2:305\n1915#2,2:307\n1642#2,10:309\n1915#2:319\n1916#2:321\n1652#2:322\n1642#2,10:324\n1915#2:334\n1916#2:336\n1652#2:337\n1#3:261\n1#3:264\n1#3:276\n1#3:279\n1#3:287\n1#3:296\n1#3:300\n1#3:320\n1#3:323\n1#3:335\n1#3:338\n72#4,2:285\n72#4,2:294\n72#4,2:298\n*S KotlinDebug\n*F\n+ 1 KubernetesLogsConsistentCaches.kt\ncom/intellij/kubernetes/logs/LogConsistentContainerListFlowBasedCache\n*L\n146#1:250,10\n146#1:260\n146#1:262\n146#1:263\n149#1:265,10\n149#1:275\n149#1:277\n149#1:278\n177#1:280,2\n185#1:282\n185#1:283,2\n185#1:288\n185#1:289,2\n191#1:291\n191#1:292,2\n191#1:297\n213#1:301\n213#1:302,3\n213#1:305,2\n239#1:307,2\n241#1:309,10\n241#1:319\n241#1:321\n241#1:322\n244#1:324,10\n244#1:334\n244#1:336\n244#1:337\n146#1:261\n149#1:276\n185#1:287\n192#1:296\n201#1:300\n241#1:320\n244#1:335\n185#1:285,2\n192#1:294,2\n201#1:298,2\n*E\n"})
public class LogConsistentContainerListFlowBasedCache<Id extends Comparable<? super Id>, L extends ILogItem<S, Id>, S extends ILogSource>
implements ILogConsistentCache<Id, L, S>,
ILogSubscribableConsistentCache<Id, L, S> {
    @NotNull
    private final Project project;
    @NotNull
    private final List<S> containers;
    @NotNull
    private ConcurrentSkipListMap<S, LogSubscribableConsistentCache<Id, L, S>> containersConsistentLogs;
    @NotNull
    private final ReentrantReadWriteLock rebuildChangeMutex;
    @NotNull
    private final LogSubscribableConsistentCache<Id, L, S> _globalConsistentCache;

    public LogConsistentContainerListFlowBasedCache(@NotNull Project project, @NotNull List<? extends S> containers) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(containers, (String)"containers");
        this.project = project;
        this.containers = containers;
        this.containersConsistentLogs = new ConcurrentSkipListMap();
        this.rebuildChangeMutex = new ReentrantReadWriteLock();
        this._globalConsistentCache = new LogSubscribableConsistentCache();
        this.initializeContainersCaches();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IdRange<Id> getConsistentLogsRange() {
        ReentrantReadWriteLock.ReadLock readLock = this.rebuildChangeMutex.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            Comparable comparable;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Comparable comparable2;
            void $this$mapNotNullTo$iv$iv2;
            void $this$mapNotNull$iv2;
            boolean bl = false;
            List<LogSubscribableConsistentCache<Id, L, S>> activeContainersCaches = this.getActiveContainerCaches();
            Iterable iterable = activeContainersCaches;
            boolean $i$f$mapNotNull22 = false;
            void var6_8 = $this$mapNotNull$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Comparable it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                LogSubscribableConsistentCache it = (LogSubscribableConsistentCache)element$iv$iv;
                boolean bl3 = false;
                if (it.getConsistentLogsRange().getBeginTime() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            Iterator $i$f$mapNotNull22 = ((Iterable)((List)destination$iv$iv)).iterator();
            if (!$i$f$mapNotNull22.hasNext()) {
                comparable2 = null;
            } else {
                Comparable it = (Comparable)$i$f$mapNotNull22.next();
                boolean bl5 = false;
                while ($i$f$mapNotNull22.hasNext()) {
                    Comparable it2 = (Comparable)$i$f$mapNotNull22.next();
                    $i$a$-maxOfOrNull-LogConsistentContainerListFlowBasedCache$consistentLogsRange$1$maxBeginTime$2 = false;
                    if (it.compareTo(it2) >= 0) continue;
                    it = it2;
                }
                comparable2 = it;
            }
            Comparable maxBeginTime = comparable2;
            $i$f$mapNotNull22 = activeContainersCaches;
            boolean $i$f$mapNotNull = false;
            Comparable it2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
            while (iterator2.hasNext()) {
                Comparable it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl6 = false;
                LogSubscribableConsistentCache it = (LogSubscribableConsistentCache)element$iv$iv;
                boolean bl7 = false;
                if (it.getConsistentLogsRange().getEndTime() == null) continue;
                boolean bl8 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            Iterator iterator3 = ((Iterable)((List)destination$iv$iv2)).iterator();
            if (!iterator3.hasNext()) {
                comparable = null;
            } else {
                it2 = (Comparable)iterator3.next();
                boolean bl9 = false;
                Comparable comparable3 = it2;
                while (iterator3.hasNext()) {
                    Comparable it = (Comparable)iterator3.next();
                    $i$a$-minOfOrNull-LogConsistentContainerListFlowBasedCache$consistentLogsRange$1$minEndTime$2 = false;
                    Comparable comparable4 = it;
                    if (comparable3.compareTo(comparable4) <= 0) continue;
                    comparable3 = comparable4;
                }
                comparable = comparable3;
            }
            Comparable minEndTime = comparable;
            IdRange idRange = new IdRange(maxBeginTime, minEndTime);
            return idRange;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public int getSize() {
        return this._globalConsistentCache.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<L> getSnapshot() {
        ReentrantReadWriteLock.ReadLock readLock = this.rebuildChangeMutex.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            List list = this._globalConsistentCache.getSnapshot();
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<L> takeLast() {
        List list;
        ReentrantReadWriteLock.ReadLock readLock = this.rebuildChangeMutex.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            list = this._globalConsistentCache.takeLast();
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<L> getLogsAround(@NotNull Id timestamp) {
        List list;
        Intrinsics.checkNotNullParameter(timestamp, (String)"timestamp");
        ReentrantReadWriteLock.ReadLock readLock = this.rebuildChangeMutex.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            list = this._globalConsistentCache.getLogsAround(timestamp);
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    @Override
    public int indexOfFirst(@NotNull Function1<? super L, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        return this._globalConsistentCache.indexOfFirst(arg_0 -> LogConsistentContainerListFlowBasedCache.indexOfFirst$lambda$0(predicate, arg_0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        ReentrantReadWriteLock.WriteLock writeLock = this.rebuildChangeMutex.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"writeLock(...)");
        Lock lock = writeLock;
        lock.lock();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = this.getActiveContainerCaches();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LogSubscribableConsistentCache upstream = (LogSubscribableConsistentCache)element$iv;
                boolean bl2 = false;
                upstream.clear();
            }
            this._globalConsistentCache.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initializeContainersCaches() {
        void $this$mapTo$iv$iv;
        if (this.containers.isEmpty()) {
            throw new IllegalStateException("Init empty cache".toString());
        }
        Iterable $this$map$iv = this.containers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$getOrPut$iv;
            void it;
            ILogSource iLogSource = (ILogSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConcurrentMap concurrentMap = this.containersConsistentLogs;
            void key$iv = it;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl2 = false;
                LogSubscribableConsistentCache default$iv = new LogSubscribableConsistentCache();
                boolean bl3 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            collection.add((LogSubscribableConsistentCache)object);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LogSubscribableConsistentCache it = (LogSubscribableConsistentCache)element$iv;
            boolean bl = false;
            it.addSubscriber(this._globalConsistentCache);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<LogSubscribableConsistentCache<Id, L, S>> getActiveContainerCaches() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.containers;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$getOrPut$iv;
            void it;
            ILogSource iLogSource = (ILogSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ConcurrentMap concurrentMap = this.containersConsistentLogs;
            void key$iv = it;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl2 = false;
                LogSubscribableConsistentCache default$iv = new LogSubscribableConsistentCache();
                boolean bl3 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            collection.add((LogSubscribableConsistentCache)object);
        }
        List containers = (List)destination$iv$iv;
        return containers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void plusAssign(@NotNull Collection<? extends L> newLogs) {
        Intrinsics.checkNotNullParameter(newLogs, (String)"newLogs");
        ReentrantReadWriteLock.ReadLock readLock = this.rebuildChangeMutex.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            for (ILogItem log : newLogs) {
                void $this$getOrPut$iv;
                ConcurrentMap concurrentMap = this.containersConsistentLogs;
                ILogSource key$iv = log.getSourceObject();
                boolean $i$f$getOrPut = false;
                Object object = $this$getOrPut$iv.get(key$iv);
                if (object == null) {
                    boolean bl2 = false;
                    LogSubscribableConsistentCache default$iv = new LogSubscribableConsistentCache();
                    boolean bl3 = false;
                    object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                    if (object == null) {
                        object = default$iv;
                    }
                }
                LogSubscribableConsistentCache containerLogs = (LogSubscribableConsistentCache)object;
                containerLogs.plusAssign(CollectionsKt.listOf((Object)log));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void relaxConsistentLogsRange(@NotNull IdRange<Id> newSlice) {
        Intrinsics.checkNotNullParameter(newSlice, (String)"newSlice");
        this.relaxContainersTimeRange(newSlice, this.containers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void relaxContainersTimeRange(IdRange<Id> newTimeSlice, List<? extends S> containersList) {
        ReentrantReadWriteLock.ReadLock readLock = this.rebuildChangeMutex.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            void $this$forEach$iv;
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = containersList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ILogSource iLogSource = (ILogSource)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(this.containersConsistentLogs.get(it));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LogSubscribableConsistentCache containerCache = (LogSubscribableConsistentCache)element$iv;
                boolean bl3 = false;
                if (containerCache == null) {
                    KubernetesLogsConsistentCachesKt.access$getLOG$p().error("Invalid relax call");
                    return;
                }
                containerCache.relaxConsistentLogsRange(newTimeSlice);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSubscriber(@NotNull LogConsistentCache<Id, L, S> anotherCache) {
        Intrinsics.checkNotNullParameter(anotherCache, (String)"anotherCache");
        ReentrantReadWriteLock.ReadLock readLock = this.rebuildChangeMutex.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            this._globalConsistentCache.addSubscriber(anotherCache);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeSubscriber(@NotNull LogConsistentCache<Id, L, S> subscriber) {
        Intrinsics.checkNotNullParameter(subscriber, (String)"subscriber");
        ReentrantReadWriteLock.ReadLock readLock = this.rebuildChangeMutex.readLock();
        Intrinsics.checkNotNullExpressionValue((Object)readLock, (String)"readLock(...)");
        Lock lock = readLock;
        lock.lock();
        try {
            boolean bl = false;
            this._globalConsistentCache.removeSubscriber(subscriber);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void unrelaxConsistentLogsRangeByLogsArrayBounderies() {
        Comparable comparable;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Comparable comparable2;
        void $this$mapNotNullTo$iv$iv2;
        Object element$iv2;
        List<LogSubscribableConsistentCache<Id, L, S>> activeContainersCaches = this.getActiveContainerCaches();
        Iterable $this$forEach$iv = activeContainersCaches;
        boolean $i$f$forEach = false;
        for (Object element$iv2 : $this$forEach$iv) {
            LogSubscribableConsistentCache it = (LogSubscribableConsistentCache)element$iv2;
            boolean bl = false;
            it.unrelaxConsistentLogsRangeByLogsArrayBounderies();
        }
        Iterable $this$mapNotNull$iv2 = activeContainersCaches;
        boolean $i$f$mapNotNull22 = false;
        element$iv2 = $this$mapNotNull$iv2;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach2 = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Comparable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            LogSubscribableConsistentCache it = (LogSubscribableConsistentCache)element$iv$iv;
            boolean bl2 = false;
            if (it.getConsistentLogsRange().getBeginTime() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterator $i$f$mapNotNull22 = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!$i$f$mapNotNull22.hasNext()) {
            comparable2 = null;
        } else {
            Comparable it = (Comparable)$i$f$mapNotNull22.next();
            boolean bl = false;
            while ($i$f$mapNotNull22.hasNext()) {
                Comparable it2 = (Comparable)$i$f$mapNotNull22.next();
                $i$a$-minOfOrNull-LogConsistentContainerListFlowBasedCache$unrelaxConsistentLogsRangeByLogsArrayBounderies$maxBeginTime$2 = false;
                if (it.compareTo(it2) <= 0) continue;
                it = it2;
            }
            comparable2 = it;
        }
        Comparable maxBeginTime = comparable2;
        $i$f$mapNotNull22 = activeContainersCaches;
        boolean $i$f$mapNotNull = false;
        Comparable it2 = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach3 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            Comparable it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            LogSubscribableConsistentCache it = (LogSubscribableConsistentCache)element$iv$iv;
            boolean bl4 = false;
            if (it.getConsistentLogsRange().getEndTime() == null) continue;
            boolean bl5 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Iterator iterator3 = ((Iterable)((List)destination$iv$iv2)).iterator();
        if (!iterator3.hasNext()) {
            comparable = null;
        } else {
            it2 = (Comparable)iterator3.next();
            boolean bl = false;
            Comparable comparable3 = it2;
            while (iterator3.hasNext()) {
                Comparable it = (Comparable)iterator3.next();
                $i$a$-maxOfOrNull-LogConsistentContainerListFlowBasedCache$unrelaxConsistentLogsRangeByLogsArrayBounderies$minEndTime$2 = false;
                Comparable comparable4 = it;
                if (comparable3.compareTo(comparable4) >= 0) continue;
                comparable3 = comparable4;
            }
            comparable = comparable3;
        }
        Comparable minEndTime = comparable;
        IdRange slice = new IdRange(maxBeginTime, minEndTime);
        this.relaxConsistentLogsRange(slice);
    }

    private static final boolean indexOfFirst$lambda$0(Function1 $predicate, ILogItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)$predicate.invoke((Object)it);
    }
}

