/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.ui.notifications;

import com.intellij.kubernetes.api.settings.KubeConfig;
import com.intellij.kubernetes.api.settings.KubernetesApiProjectSettings;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.JBColor;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/intellij/kubernetes/ui/notifications/KubeConfigNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createKubeConfigNotificationPanel", "Lcom/intellij/ui/EditorNotificationPanel;", "intellij.clouds.kubernetes.backend"})
public final class KubeConfigNotificationProvider
implements EditorNotificationProvider {
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (KubernetesApiProjectSettings.Companion.getInstance(project).isMarkedNonKubeConfig(file)) {
            return null;
        }
        if (KubeConfig.isKubeConfig((VirtualFile)file, (Project)project)) {
            return null;
        }
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        if (!KubeConfig.isLikeKubeConfig((Project)project, (VirtualFile)file)) {
            return null;
        }
        return arg_0 -> KubeConfigNotificationProvider.collectNotificationData$lambda$0(this, project, file, arg_0);
    }

    private final EditorNotificationPanel createKubeConfigNotificationPanel(Project project, VirtualFile file) {
        EditorNotificationPanel editorNotificationPanel;
        KubernetesApiProjectSettings k8sProjectSettings = KubernetesApiProjectSettings.Companion.getInstance(project);
        EditorNotificationPanel $this$createKubeConfigNotificationPanel_u24lambda_u240 = editorNotificationPanel = new EditorNotificationPanel(JBColor.PanelBackground, EditorNotificationPanel.Status.Info);
        boolean bl = false;
        $this$createKubeConfigNotificationPanel_u24lambda_u240.setText(KubernetesBundle.message((String)"KubeConfigNotificationProvider.message", (Object[])new Object[0]));
        $this$createKubeConfigNotificationPanel_u24lambda_u240.createActionLabel(KubernetesBundle.message((String)"KubeConfigNotificationProvider.set.as.kube.config.action.title", (Object[])new Object[0]), () -> KubeConfigNotificationProvider.createKubeConfigNotificationPanel$lambda$0$0(k8sProjectSettings, file));
        $this$createKubeConfigNotificationPanel_u24lambda_u240.createActionLabel(KubernetesBundle.message((String)"KubeConfigNotificationProvider.dismiss.action.title", (Object[])new Object[0]), () -> KubeConfigNotificationProvider.createKubeConfigNotificationPanel$lambda$0$1(k8sProjectSettings, file, project));
        return editorNotificationPanel;
    }

    private static final EditorNotificationPanel collectNotificationData$lambda$0(KubeConfigNotificationProvider this$0, Project $project, VirtualFile $file, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.createKubeConfigNotificationPanel($project, $file);
    }

    private static final void createKubeConfigNotificationPanel$lambda$0$0(KubernetesApiProjectSettings $k8sProjectSettings, VirtualFile $file) {
        $k8sProjectSettings.setConfigFiles(SetsKt.plus((Set)$k8sProjectSettings.getConfigFiles(), (Object)$file));
    }

    private static final void createKubeConfigNotificationPanel$lambda$0$1(KubernetesApiProjectSettings $k8sProjectSettings, VirtualFile $file, Project $project) {
        $k8sProjectSettings.markNonKubeConfig($file);
        EditorNotifications.getInstance((Project)$project).updateAllNotifications();
    }
}

