/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.settings;

import com.intellij.ide.IdeBundle;
import com.intellij.kubernetes.api.settings.KubernetesLogsSettingsKt;
import com.intellij.kubernetes.api.settings.LogHighlightingPattern;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.StartupUiUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\rH\u0016J\u0014\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010\u0011\u001a\u00020\rH\u0016J\"\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u000e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0014J\u000e\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\rJ\u0006\u0010!\u001a\u00020\u0019R \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0006\u00a8\u0006\""}, d2={"Lcom/intellij/kubernetes/view/ui/settings/KubernetesLogFormatTableModel;", "Ljavax/swing/table/AbstractTableModel;", "_logsHighlighters", "", "Lcom/intellij/kubernetes/api/settings/LogHighlightingPattern;", "<init>", "(Ljava/util/List;)V", "logsHighlighters", "", "getLogsHighlighters", "()Ljava/util/List;", "setLogsHighlighters", "getRowCount", "", "isCellEditable", "", "rowIndex", "columnIndex", "getColumnCount", "getColumnName", "", "column", "getColumnClass", "Ljava/lang/Class;", "setValueAt", "", "aValue", "", "getValueAt", "addItem", "item", "removeItem", "index", "restoreDefaults", "intellij.clouds.kubernetes.backend"})
public final class KubernetesLogFormatTableModel
extends AbstractTableModel {
    @NotNull
    private List<LogHighlightingPattern> logsHighlighters;

    public KubernetesLogFormatTableModel(@NotNull List<LogHighlightingPattern> _logsHighlighters) {
        Intrinsics.checkNotNullParameter(_logsHighlighters, (String)"_logsHighlighters");
        this.logsHighlighters = CollectionsKt.toMutableList((Collection)_logsHighlighters);
    }

    @NotNull
    public final List<LogHighlightingPattern> getLogsHighlighters() {
        return this.logsHighlighters;
    }

    public final void setLogsHighlighters(@NotNull List<LogHighlightingPattern> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.logsHighlighters = list;
    }

    @Override
    public int getRowCount() {
        return this.logsHighlighters.size();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        String string;
        switch (column) {
            case 0: {
                String string2 = IdeBundle.message((String)"plugins.configurable.enabled", (Object[])new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                break;
            }
            case 1: {
                String string3 = KubernetesBundle.message((String)"k8s.logs.regex.pattern", (Object[])new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                break;
            }
            case 2: {
                String string4 = ApplicationBundle.message((String)"checkbox.font.bold", (Object[])new Object[0]);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                break;
            }
            case 3: {
                String string5 = ApplicationBundle.message((String)"checkbox.font.italic", (Object[])new Object[0]);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                break;
            }
            case 4: {
                String string6 = IdeBundle.message((String)"settings.file.color.column.color", (Object[])new Object[0]);
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        return switch (columnIndex) {
            case 0, 2, 3 -> Boolean.class;
            case 1 -> String.class;
            case 4 -> JBColor.class;
            default -> LogHighlightingPattern.class;
        };
    }

    @Override
    public void setValueAt(@Nullable Object aValue, int rowIndex, int columnIndex) {
        LogHighlightingPattern item = this.logsHighlighters.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                Intrinsics.checkNotNull((Object)aValue, (String)"null cannot be cast to non-null type kotlin.Boolean");
                this.logsHighlighters.set(rowIndex, LogHighlightingPattern.copy$default((LogHighlightingPattern)item, (boolean)((Boolean)aValue), null, (int)0, (int)0, (boolean)false, (boolean)false, (int)62, null));
                break;
            }
            case 1: {
                Intrinsics.checkNotNull((Object)aValue, (String)"null cannot be cast to non-null type kotlin.String");
                this.logsHighlighters.set(rowIndex, LogHighlightingPattern.copy$default((LogHighlightingPattern)item, (boolean)false, (String)((String)aValue), (int)0, (int)0, (boolean)false, (boolean)false, (int)61, null));
                break;
            }
            case 2: {
                Intrinsics.checkNotNull((Object)aValue, (String)"null cannot be cast to non-null type kotlin.Boolean");
                this.logsHighlighters.set(rowIndex, LogHighlightingPattern.copy$default((LogHighlightingPattern)item, (boolean)false, null, (int)0, (int)0, (boolean)((Boolean)aValue), (boolean)false, (int)47, null));
                break;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)aValue, (String)"null cannot be cast to non-null type kotlin.Boolean");
                this.logsHighlighters.set(rowIndex, LogHighlightingPattern.copy$default((LogHighlightingPattern)item, (boolean)false, null, (int)0, (int)0, (boolean)false, (boolean)((Boolean)aValue), (int)31, null));
                break;
            }
            case 4: {
                Intrinsics.checkNotNull((Object)aValue, (String)"null cannot be cast to non-null type com.intellij.ui.JBColor");
                JBColor cfr_ignored_0 = (JBColor)aValue;
                this.logsHighlighters.set(rowIndex, StartupUiUtil.INSTANCE.isDarkTheme() ? LogHighlightingPattern.copy$default((LogHighlightingPattern)item, (boolean)false, null, (int)0, (int)((JBColor)aValue).getRGB(), (boolean)false, (boolean)false, (int)55, null) : LogHighlightingPattern.copy$default((LogHighlightingPattern)item, (boolean)false, null, (int)((JBColor)aValue).getRGB(), (int)0, (boolean)false, (boolean)false, (int)59, null));
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        LogHighlightingPattern value = this.logsHighlighters.get(rowIndex);
        return switch (columnIndex) {
            case 0 -> Boolean.valueOf(value.getEnabled());
            case 1 -> value.getPattern();
            case 2 -> Boolean.valueOf(value.getBold());
            case 3 -> Boolean.valueOf(value.getItalic());
            case 4 -> value;
            default -> null;
        };
    }

    public final void addItem(@NotNull String item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        this.logsHighlighters.add(new LogHighlightingPattern(true, item, JBColor.BLACK.getRGB(), 0, false, false, 8, null));
        int stateSize = this.logsHighlighters.size() - 1;
        this.fireTableRowsInserted(stateSize, stateSize);
    }

    public final void removeItem(int index) {
        boolean bl = 0 <= index ? index < this.logsHighlighters.size() : false;
        if (bl) {
            this.logsHighlighters.remove(index);
            this.fireTableRowsDeleted(index, index);
        }
    }

    public final void restoreDefaults() {
        this.logsHighlighters = CollectionsKt.toMutableList((Collection)KubernetesLogsSettingsKt.getKubernetesLogsHighlightingPatterns());
        this.fireTableDataChanged();
    }
}

